/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.util.UnitUtils;
import java.util.ArrayList;
import java.util.Random;
import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.MicroManager;
import undermind.micropacket.GoliathSquad;
import undermind.micropacket.MarineMovement;
import undermind.micropacket.MedicCombatMovement;
import undermind.micropacket.MicroUtil;
import undermind.micropacket.Squad;

public class DefensiveSquad
extends Squad {
    public Game mGame;
    public int lastSiege = 0;
    public Random rgen;
    public ArrayList<Unit> marines = new ArrayList();
    public ArrayList<Unit> medics = new ArrayList();
    MarineMovement mover;
    MedicCombatMovement medic_mover;

    public DefensiveSquad(MicroManager m, Position dp) {
        super(m);
        this.goal = dp;
        this.mGame = Game.getInstance();
        this.rgen = new Random();
        this.mover = new MarineMovement();
        this.medic_mover = new MedicCombatMovement();
    }

    @Override
    public void onFrame() {
        long starttime = System.currentTimeMillis();
        this.mover.setGoalPosition(new TilePosition(this.goal));
        ++this.lastSiege;
        Position ave = UnitUtils.avePos(this.myUnits);
        ROUnit closestE = UnitUtils.getClosest(ave, this.master.allVisibleEnemies);
        double closestD = Double.POSITIVE_INFINITY;
        if (closestE != null) {
            closestD = UnitUtils.pairDistance(this.myUnits, this.master.allVisibleEnemies);
        }
        for (ROUnit bldg : this.master.enemyBuildings) {
            double d = bldg.getDistance(ave);
            if (!bldg.isVisible() || !(d < closestD)) continue;
            closestD = d;
            closestE = bldg;
        }
        if (closestE == null || closestD > 150.0) {
            for (Unit unit : this.myUnits) {
                if (!unit.isIdle()) continue;
                unit.attackMove(this.goal);
            }
        } else {
            if (MicroUtil.shouldStimSimple(this.marines, this.medics, this.master.allVisibleEnemies)) {
                for (Unit u : this.marines) {
                    if (u.getHitPoints() < 30) continue;
                    u.useTech(TechType.STIM_PACKS);
                }
            } else {
                for (Unit u : this.marines) {
                    if (!u.isIdle()) continue;
                    u.attackMove(closestE.getPosition());
                }
                this.medic_mover.moveMedics(this.marines);
            }
            for (Unit unit : this.myUnits) {
                UnitType type = unit.getType();
                if (type == UnitType.TERRAN_MARINE || type == UnitType.TERRAN_MEDIC) continue;
                ROUnit closestEnemy = UnitUtils.getClosest(unit, this.master.allVisibleEnemies);
                if (closestEnemy != null && !closestEnemy.isDetected()) {
                    this.master.pleaseScanHere = closestEnemy.getPosition();
                }
                if (type != UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE && type != UnitType.TERRAN_SIEGE_TANK_TANK_MODE && type != UnitType.TERRAN_GOLIATH && type != UnitType.TERRAN_VULTURE) continue;
                this.defensiveMechMicro(unit, closestEnemy);
            }
        }
    }

    public void defensiveMechMicro(Unit unit, ROUnit closestEnemy) {
        Position p = unit.getPosition();
        double nearestDistance = Double.POSITIVE_INFINITY;
        double closestEnemyd = UnitUtils.getClosestDistance(unit, this.master.allVisibleEnemies);
        if (closestEnemy != null && !closestEnemy.isDetected()) {
            this.master.pleaseScanHere = closestEnemy.getPosition();
        }
        if (closestEnemy != null) {
            nearestDistance = unit.getTilePosition().getDistance(closestEnemy.getPosition());
        }
        if (unit.getType() == UnitType.TERRAN_VULTURE && this.master.allVisibleEnemies.size() != 0 && nearestDistance < 10.0) {
            TilePosition moveTo = null;
            if (nearestDistance < 4.5 || unit.isAttacking()) {
                TilePosition myPosition = unit.getTilePosition();
                int x = myPosition.x();
                int y = myPosition.y();
                double biggest = nearestDistance;
                for (int dx = -4; dx <= 4; ++dx) {
                    for (int dy = -4; dy <= 4; ++dy) {
                        boolean canWalk;
                        if (x + dx < 0 || x + dx >= this.mGame.getMapWidth() || y + dy >= this.mGame.getMapHeight() || y + dy < 0) continue;
                        TilePosition newPosition = new TilePosition(x + dx, y + dy);
                        double newDist = newPosition.getDistance(closestEnemy.getPosition());
                        Position center = Position.centerOfTile(newPosition);
                        int xl = center.x() / 8;
                        int yl = center.y() / 8;
                        int s = this.mGame.unitsOnTile(newPosition).size();
                        boolean bl = canWalk = this.mGame.isWalkable(xl, yl) && (s == 0 || this.mGame.unitsOnTile(newPosition).iterator().next().getID() == unit.getID());
                        if (!(newDist >= biggest) || !canWalk) continue;
                        biggest = newDist;
                        moveTo = newPosition;
                    }
                }
                if (moveTo == null) {
                    unit.attack(closestEnemy);
                } else {
                    unit.move(moveTo);
                }
            } else if (nearestDistance < 10.0) {
                unit.attack(closestEnemy);
            }
        } else if (unit.getType() == UnitType.TERRAN_VULTURE && (unit.getTargetPosition() != this.goal || unit.isIdle())) {
            if (unit.getTilePosition().getDistance(this.goal) > 8.0) {
                double dist = unit.getTilePosition().getDistance(this.master.medianpos);
                double d2 = unit.getTargetPosition().getDistance(this.master.medianpos);
                if (dist > 28.0) {
                    if (d2 > 500.0) {
                        unit.attackMove(this.master.medianpos);
                    }
                } else {
                    unit.attackMove(this.goal);
                }
            } else if (unit.getSpiderMineCount() != 0 && !unit.isMoving()) {
                Position minePlace = new Position(unit.getPosition().x() + this.rgen.nextInt(300) - 150, unit.getPosition().y() + this.rgen.nextInt(300) - 150);
                double nearestBase = Bwta.getInstance().getNearestBaseLocation(new TilePosition(minePlace)).getPosition().getDistance(minePlace);
                double d = this.goal.getDistance(minePlace);
                while (d < 100.0 && !this.mGame.isWalkable(minePlace.x() / 8, minePlace.y() / 8) && nearestBase < 180.0) {
                    minePlace = new Position(unit.getPosition().x() + this.rgen.nextInt(300) - 150, unit.getPosition().y() + this.rgen.nextInt(300) - 150);
                    d = this.goal.getDistance(minePlace);
                }
                unit.useTech(TechType.SPIDER_MINES, minePlace);
            }
        }
        if (unit.getType() == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || unit.getType() == UnitType.TERRAN_SIEGE_TANK_TANK_MODE) {
            boolean notjustair = false;
            for (ROUnit en : this.master.allVisibleEnemies) {
                if (en.isFlying() || !(unit.getTilePosition().getDistance(en.getTilePosition()) < 16.0)) continue;
                notjustair = true;
                break;
            }
            int siegeRange = 12;
            if (closestEnemy != null && (closestEnemy.getType() == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || closestEnemy.getType() == UnitType.TERRAN_SIEGE_TANK_TANK_MODE)) {
                siegeRange = 13;
            }
            if (this.master.allVisibleEnemies.size() != 0 && closestEnemy != null && (!closestEnemy.getType().isBuilding() && unit.getTilePosition().getDistance(closestEnemy.getPosition()) < (double)siegeRange || closestEnemy.getType().isBuilding() && (closestEnemy.getType().canAttack() || closestEnemy.getType() == UnitType.TERRAN_BUNKER || closestEnemy.getType().isSpellcaster()) && unit.getTilePosition().getDistance(closestEnemy.getPosition()) < 11.0) && notjustair) {
                if (!unit.isSieged()) {
                    unit.siege();
                }
                this.lastSiege = 0;
            } else if (unit.getTargetPosition() != this.goal && unit.getTilePosition().getDistance(this.goal) > 6.0 || unit.isIdle()) {
                if (unit.isSieged() && !unit.isAttacking() && unit.isIdle() && this.lastSiege >= 200 && unit.getTilePosition().getDistance(this.master.medianpos) >= 6.0) {
                    unit.unsiege();
                } else if (!unit.isSieged()) {
                    double dist = unit.getTilePosition().getDistance(this.master.medianpos);
                    double d2 = unit.getTargetPosition().getDistance(this.master.medianpos);
                    if (dist > 28.0) {
                        if (d2 > 800.0) {
                            unit.attackMove(this.master.medianpos);
                        }
                    } else if (dist < 6.0 && unit.isIdle()) {
                        unit.siege();
                    } else {
                        unit.attackMove(this.goal);
                    }
                }
            }
        }
        if (unit.getType() == UnitType.TERRAN_GOLIATH) {
            if (this.master.allVisibleEnemies.size() != 0 && closestEnemy != null && (!closestEnemy.getType().isBuilding() && unit.getTilePosition().getDistance(closestEnemy.getPosition()) < 16.0 || closestEnemy.getType().isBuilding() && (closestEnemy.getType().canAttack() || closestEnemy.getType() == UnitType.TERRAN_BUNKER) && unit.getTilePosition().getDistance(closestEnemy.getPosition()) < 12.0) && (closestEnemy.getType().canAttack() || closestEnemy.getType().isSpellcaster())) {
                ROUnit targ = null;
                int bestprio = -1000;
                for (ROUnit ue : this.master.allVisibleEnemies) {
                    if (ue.getDistance(unit) >= 450 + GoliathSquad.acquisitionBonus || this.master.getGPriority(ue, unit, false) <= bestprio || ue.getDistance(unit) >= 300 + GoliathSquad.acquisitionBonus) continue;
                    bestprio = this.master.getGPriority(ue, unit, false);
                    targ = ue;
                }
                for (ROUnit ue : this.master.enemyBuildings) {
                    if (ue.getDistance(unit) >= 550 || this.master.getGPriority(ue, unit, false) <= bestprio || ue.getDistance(unit) >= 300) continue;
                    bestprio = this.master.getGPriority(ue, unit, false);
                    targ = ue;
                }
                Unit k = unit.getTarget();
                if (targ != null && this.master.time % 20L == 0L && unit.getTarget() == null && unit.getOrderTarget() == null || targ != null && unit.getTarget() != null && unit.getTarget().getID() != targ.getID() && unit.getOrderTarget() != null && unit.getOrderTarget().getID() != targ.getID()) {
                    unit.rightClick(targ);
                } else if (targ == null && k == null && unit.getOrderTarget() == null && closestEnemyd > 280.0) {
                    unit.attackMove(this.goal);
                }
            } else {
                double dist = unit.getTilePosition().getDistance(this.master.medianpos);
                double d2 = unit.getTargetPosition().getDistance(this.master.medianpos);
                if (dist > 28.0) {
                    if (d2 > 800.0) {
                        unit.attackMove(this.master.medianpos);
                    }
                } else {
                    unit.attackMove(this.goal);
                }
            }
        }
    }

    @Override
    public void addUnit(Unit u) {
        this.mover.addMarine(u);
        this.myUnits.add(u);
        if (u.getType() == UnitType.TERRAN_MARINE) {
            this.marines.add(u);
            this.mover.addMarine(u);
        } else if (u.getType() == UnitType.TERRAN_MEDIC) {
            this.medics.add(u);
            this.medic_mover.addMedic(u);
        }
    }

    @Override
    public void removeUnit(Unit u) {
        Unit removeme = null;
        for (Unit unit : this.myUnits) {
            if (unit.getID() != u.getID()) continue;
            removeme = unit;
            break;
        }
        if (removeme != null) {
            this.myUnits.remove(removeme);
            this.marines.remove(removeme);
            this.medics.remove(removeme);
            this.mover.removeMarine(removeme);
        }
    }
}

