/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.util.Vector;
import org.bwapi.proxy.model.Position;
import undermind.micropacket.Particle;

public class BeaconParticle
extends Particle {
    Position mass_center = null;

    public void updateCenter(Position p) {
        this.mass_center = p;
    }

    @Override
    public Vector exertField(Particle particle) {
        Vector ret = Vector.ZERO;
        for (String func : this.fields) {
            if (func.equals("attract")) {
                ret = ret.add(this.exertAttractionField(particle));
            }
            if (func.equals("beacon")) {
                ret = ret.add(this.exertBeaconField(particle));
            }
            if (func.equals("jitter")) {
                ret = ret.add(this.exertJitterField(particle));
            }
            if (func.equals("sheep")) {
                ret = ret.add(this.exertSheepField(particle));
            }
            if (!func.equals("parallel")) continue;
            ret = ret.add(this.exertParallelField(particle));
        }
        return ret;
    }

    public void setParallelField() {
        this.fields.add("parallel");
    }

    public void unsetParallelField() {
        this.fields.remove("parallel");
    }

    public Vector exertParallelField(Particle particle) {
        double overall_strength = 300.0;
        double relative_point = 1.0;
        double relative_mass = 1.0;
        double mass_distance = new Vector(this.mass_center, this.location.toPosition()).length();
        Vector mass_direction = new Vector(this.mass_center, this.location.toPosition()).normalize();
        double point_distance = new Vector(particle.location.toPosition(), this.location.toPosition()).length();
        Vector point_direction = new Vector(particle.location.toPosition(), this.location.toPosition()).normalize();
        double difference = point_direction.dot(mass_direction);
        Vector adjusted_mass_v = mass_direction.scale(difference).scale(relative_mass);
        Vector adjusted_point_v = point_direction.scale(1.0 - Math.abs(difference)).scale(relative_point);
        return adjusted_mass_v.add(adjusted_point_v).scale(overall_strength);
    }
}

