/*
 * Decompiled with CFR 0.152.
 */
package undermind.macro;

import edu.berkeley.nlp.starcraft.AbstractCerebrate;
import edu.berkeley.nlp.starcraft.util.FastPriorityQueue;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import org.python.google.common.collect.ArrayListMultimap;
import undermind.WorkerStatus;
import undermind.macro.BuildingStatus;
import undermind.macro.MacroManager;

public class WorkerManager
extends AbstractCerebrate {
    public boolean scoutSent = false;
    public TilePosition enemyMain;
    List<TilePosition> enemyBaseTiles;
    private WorkerStatus myDefender;
    private WorkerStatus scout = null;
    private Player me;
    private Game mGame;
    private MacroManager macroManager;
    public final List<WorkerStatus> workerStatuses = new ArrayList<WorkerStatus>();
    public int workersCreated;
    protected HashMap<ROUnit, LinkedList<WorkerStatus>> mineralmap = new HashMap();
    protected ArrayListMultimap<ROUnit, WorkerStatus> refineryToGuys = ArrayListMultimap.create();

    public WorkerManager(MacroManager macroManager) {
        this.macroManager = macroManager;
    }

    @Override
    public void onStart() {
        this.mGame = Game.getInstance();
        this.me = this.mGame.self();
        for (ROUnit rOUnit : this.macroManager.myBaseLocation.getMinerals()) {
            this.mineralmap.put(rOUnit, new LinkedList());
        }
    }

    void assignNewWorker(Unit worker) {
        if (this.getWorkerStatus(worker) != null) {
            Thread.dumpStack();
            return;
        }
        if (worker.getType().isWorker()) {
            WorkerStatus workerStatus = new WorkerStatus(worker);
            this.workerStatuses.add(workerStatus);
            if (!this.saturatedGas()) {
                this.assignGasMiner(workerStatus);
            } else {
                this.assignMiner(workerStatus);
            }
        }
    }

    private void assignGasMiner(WorkerStatus workerStatus) {
        if (workerStatus.getState() == WorkerStatus.WorkerState.SCOUTING) {
            return;
        }
        Unit worker = workerStatus.unit;
        workerStatus.setState(WorkerStatus.WorkerState.REFINING);
        for (BuildingStatus bs : this.macroManager.myRefineries) {
            Unit refinery = bs.myUnit;
            if (this.refineryToGuys.get((Object)refinery).size() >= 3) continue;
            this.refineryToGuys.put((Object)refinery, (Object)workerStatus);
            workerStatus.target = refinery;
            if (refinery != null && refinery.getRemainingBuildTime() <= 0) continue;
        }
    }

    private void assignMiner(WorkerStatus workerStatus) {
        if (workerStatus.getState() == WorkerStatus.WorkerState.SCOUTING) {
            return;
        }
        Unit worker = workerStatus.unit;
        workerStatus.setState(WorkerStatus.WorkerState.MINING);
        ROUnit closestPatch = this.choosePatchForMiner(worker);
        this.assignWorkerToPatch(workerStatus, closestPatch);
        worker.rightClick(closestPatch);
    }

    private void assignWorkerToPatch(WorkerStatus worker, ROUnit closestPatch) {
        this.mineralmap.get(closestPatch).add(worker);
        worker.target = closestPatch;
    }

    private ROUnit choosePatchForMiner(Unit worker) {
        Position workerpos = worker.getPosition();
        FastPriorityQueue<ROUnit> minerals = new FastPriorityQueue<ROUnit>();
        for (Map.Entry<ROUnit, LinkedList<WorkerStatus>> min : this.mineralmap.entrySet()) {
            minerals.setPriority(min.getKey(), (double)((2 - min.getValue().size()) * 20000) + min.getKey().getDistance(workerpos));
        }
        return (ROUnit)minerals.getFirst();
    }

    private void reassignWorkers() {
        Object w;
        List<ROUnit> workeries = UnitUtils.getAllMy(UnitType.TERRAN_SCV);
        List<ROUnit> refineries = UnitUtils.getAllMy(UnitType.TERRAN_REFINERY);
        Iterator<WorkerStatus> witer = this.workerStatuses.iterator();
        while (witer.hasNext()) {
            if (witer.next().unit.exists()) continue;
            witer.remove();
        }
        for (ROUnit unit : workeries) {
            w = UnitUtils.assumeControl(unit);
            WorkerStatus workerStatus = this.getWorkerStatus((Unit)w);
            if (workerStatus == null) {
                this.assignNewWorker((Unit)w);
                continue;
            }
            if (workerStatus.idleCycles <= 100 || workerStatus.getState() == WorkerStatus.WorkerState.SCOUTING) continue;
            this.removeMiner(workerStatus);
            this.assignMiner(workerStatus);
        }
        for (ROUnit r : refineries) {
            if (this.refineryToGuys.keySet().contains(r) && this.refineryToGuys.get((Object)r).size() >= 3) continue;
            w = this.getWorker();
            this.removeMiner((WorkerStatus)w);
            this.assignGasMiner((WorkerStatus)w);
        }
        Iterator refineryIter = this.refineryToGuys.entries().iterator();
        while (refineryIter.hasNext()) {
            Map.Entry entry = (Map.Entry)refineryIter.next();
            ROUnit r = (ROUnit)entry.getKey();
            WorkerStatus ws = (WorkerStatus)entry.getValue();
            if (ws.target == null || ws.target.equals(r)) continue;
            refineryIter.remove();
        }
        LinkedList<WorkerStatus> extramin = new LinkedList<WorkerStatus>();
        for (LinkedList<WorkerStatus> miners : this.mineralmap.values()) {
            if (miners.size() <= 3) continue;
            int i = 0;
            Iterator mm = miners.iterator();
            while (mm.hasNext()) {
                WorkerStatus ws = (WorkerStatus)mm.next();
                if (++i <= 3) continue;
                extramin.add(ws);
                mm.remove();
            }
        }
        for (WorkerStatus ws : extramin) {
            this.assignMiner(ws);
        }
        if (!extramin.isEmpty()) {
            // empty if block
        }
    }

    protected void addBase(BaseLocation base) {
        boolean invalid = false;
        for (ROUnit rOUnit : base.getStaticMinerals()) {
            if (rOUnit.getPosition().equals(Position.INVALID)) {
                invalid = true;
                continue;
            }
            this.mineralmap.put(rOUnit, new LinkedList());
        }
        this.transferWorkers(base);
    }

    private void transferWorkers(BaseLocation base) {
        int unitsLeft = 7;
        Iterator<? extends ROUnit> iter = base.getMinerals().iterator();
        for (LinkedList<WorkerStatus> wStatuses : this.mineralmap.values()) {
            if (!wStatuses.isEmpty()) {
                ROUnit min;
                WorkerStatus ws = wStatuses.pop();
                --unitsLeft;
                if (!iter.hasNext()) {
                    iter = base.getMinerals().iterator();
                }
                if (this.mineralmap.get(min = iter.next()) != null && ws != null) {
                    this.mineralmap.get(min).add(ws);
                }
                ws.unit.rightClick(min);
            }
            if (unitsLeft > 0) continue;
            break;
        }
    }

    protected boolean saturatedGas() {
        int count = 0;
        for (BuildingStatus r : this.macroManager.myRefineries) {
            if (r.status != 2) continue;
            ++count;
        }
        return this.refineryToGuys.values().size() >= count * 3;
    }

    /*
     * WARNING - void declaration
     */
    public void workerManagement() {
        this.handleSparkies();
        this.doRepairs();
        this.workerBookkeeping();
        this.gasManagement();
        for (int i = 0; i < this.numWorkers(); ++i) {
            WorkerStatus currentworkerStatus = this.workerStatuses.get(i);
            Unit u = currentworkerStatus.unit;
            int id = u.getID();
            WorkerStatus.WorkerState state = currentworkerStatus.getState();
            if (this.isWorkerUnemployed(currentworkerStatus) && u.isCompleted()) {
                if (currentworkerStatus.getState() == WorkerStatus.WorkerState.BUILDING) {
                    // empty if block
                }
                currentworkerStatus.setState(WorkerStatus.WorkerState.MINING);
                ROUnit closestPatch = currentworkerStatus.target;
                if (closestPatch != null && currentworkerStatus.idleCycles >= 3) {
                    if (closestPatch.getPosition().equals(Position.INVALID)) {
                        u.rightClick(closestPatch.getLastKnownPosition());
                    } else {
                        u.rightClick(closestPatch);
                    }
                } else if (currentworkerStatus.idleCycles >= 3 && currentworkerStatus.unit.exists()) {
                    this.removeMiner(currentworkerStatus);
                    this.assignMiner(currentworkerStatus);
                } else if (!currentworkerStatus.unit.exists()) {
                    // empty if block
                }
            }
            if (state != WorkerStatus.WorkerState.SCOUTING) continue;
            this.scoutSent = true;
            boolean targetted = false;
            ArrayList<ROUnit> enemies = new ArrayList<ROUnit>();
            for (ROUnit rOUnit : this.mGame.getAllUnits()) {
                if (rOUnit.getPlayer() == this.me || rOUnit.getType() != UnitType.TERRAN_SCV && rOUnit.getType() != UnitType.ZERG_DRONE && rOUnit.getType() != UnitType.PROTOSS_PROBE) continue;
                enemies.add(rOUnit);
                if ((rOUnit.getTarget() == null || rOUnit.getTarget().getID() != u.getID()) && (rOUnit.getOrderTarget() == null || rOUnit.getOrderTarget().getID() != u.getID())) continue;
                targetted = true;
            }
            Object closestEnemy = UnitUtils.getClosest(currentworkerStatus.unit, enemies);
            if (closestEnemy != null && (closestEnemy.isAttacking() || targetted) && this.macroManager.eligibleEnemyStarts.size() == 1) {
                void var9_15;
                Object var9_14 = null;
                TilePosition myPosition = u.getTilePosition();
                int x = myPosition.x();
                int y = myPosition.y();
                double biggest = u.getTilePosition().getDistance(closestEnemy.getPosition());
                for (int dx = -16; dx <= 16; ++dx) {
                    for (int dy = -16; dy <= 16; ++dy) {
                        boolean canWalk;
                        if (x + dx < 0 || x + dx >= this.mGame.getMapWidth() || y + dy >= this.mGame.getMapHeight() || y + dy < 0) continue;
                        TilePosition newPosition = new TilePosition(x + dx, y + dy);
                        double newDist = newPosition.getDistance(UnitUtils.medianPos(enemies));
                        Position center = Position.centerOfTile(newPosition);
                        int xl = center.x() / 8;
                        int yl = center.y() / 8;
                        int s = this.mGame.unitsOnTile(newPosition).size();
                        boolean bl = canWalk = this.mGame.isWalkable(xl, yl) && (s == 0 || this.mGame.unitsOnTile(newPosition).iterator().next().getID() == u.getID());
                        if (!(newDist >= biggest) || !canWalk) continue;
                        biggest = newDist;
                        TilePosition tilePosition = newPosition;
                    }
                }
                if (var9_15 == null) {
                    u.move(new Position(1, 1));
                    continue;
                }
                u.move((TilePosition)var9_15);
                continue;
            }
            if (this.macroManager.eligibleEnemyStarts.size() == 1 && this.macroManager.enemyBaseRegion.contains(u.getPosition())) {
                if (this.enemyBaseTiles == null) {
                    this.enemyBaseTiles = new ArrayList<TilePosition>();
                    Object var9_17 = null;
                    for (Region r : this.macroManager.myBwta.getRegions()) {
                        if (!r.contains(this.macroManager.eligibleEnemyStarts.get(0))) continue;
                        Region region = r;
                        break;
                    }
                    TilePosition orig = this.macroManager.eligibleEnemyStarts.get(0);
                    for (int dx = -30; dx < 31; ++dx) {
                        for (int dy = -30; dy < 31; ++dy) {
                            void var9_19;
                            TilePosition tp = new TilePosition(orig.x() + dx, orig.y() + dy);
                            if (!this.mGame.isBuildable(tp.x(), tp.y()) || !Utils.isWalkable(tp) || !var9_19.contains(tp)) continue;
                            this.enemyBaseTiles.add(tp);
                        }
                    }
                } else {
                    ArrayList<TilePosition> arrayList = new ArrayList<TilePosition>();
                    for (TilePosition tp : this.enemyBaseTiles) {
                        if (!this.mGame.isVisible(tp)) continue;
                        arrayList.add(tp);
                    }
                    this.enemyBaseTiles.removeAll(arrayList);
                }
                if (this.enemyBaseTiles.size() != 0) {
                    currentworkerStatus.unit.move(this.enemyBaseTiles.get(0));
                    continue;
                }
                if (closestEnemy != null && this.enemyBaseTiles.size() == 0) {
                    currentworkerStatus.unit.attack((ROUnit)closestEnemy);
                    continue;
                }
                currentworkerStatus.unit.move(this.macroManager.eligibleEnemyStarts.get(0));
                continue;
            }
            if (this.macroManager.eligibleEnemyStarts.size() == 1) {
                Position position = Utils.nearestChoke(new Position(this.macroManager.eligibleEnemyStarts.get(0)));
                if (currentworkerStatus.unit.getDistance(position) < 500.0) {
                    currentworkerStatus.unit.rightClick(this.macroManager.eligibleEnemyStarts.get(0));
                    continue;
                }
                currentworkerStatus.unit.rightClick(position);
                continue;
            }
            Position position = Utils.nearestChoke(new Position(this.macroManager.target));
            if (currentworkerStatus.unit.getDistance(position) < 1200.0) {
                currentworkerStatus.unit.rightClick(this.macroManager.target);
                continue;
            }
            currentworkerStatus.unit.rightClick(position);
        }
        this.macroManager.scouting = this.numWorkers() >= 9;
        if (this.macroManager.scouting) {
            Set<TilePosition> positions = this.mGame.getStartLocations();
            for (TilePosition p : positions) {
                if (p.equals(this.macroManager.myHome) || this.mGame.isExplored(p)) continue;
                this.macroManager.target = p;
            }
            if (this.scout == null && !this.scoutSent) {
                this.scout = this.getWorker();
                this.scout.setState(WorkerStatus.WorkerState.SCOUTING);
            }
            if (!this.scoutSent && this.scout != null) {
                this.scout.unit.rightClick(Position.centerOfTile(this.macroManager.target));
            }
        }
    }

    private void gasManagement() {
        if (this.me.gas() < (this.me.minerals() + 30) * 2 || this.macroManager.mech && this.me.gas() < (this.me.minerals() + 30) * 3) {
            for (BuildingStatus r : this.macroManager.myRefineries) {
                if (r.status != 2 || this.numWorkers() == 0) continue;
                for (WorkerStatus ws : this.refineryToGuys.get((Object)r.myUnit)) {
                    Unit worker = ws.unit;
                    if (worker.isCarryingGas() || worker.isGatheringGas() || worker.isCarryingMinerals()) continue;
                    worker.rightClick(r.myUnit);
                }
            }
        } else {
            for (WorkerStatus ws : this.refineryToGuys.values()) {
                ROUnit closest;
                Unit u = ws.unit;
                if (u.isCarryingGas() || u.isCarryingMinerals() || u.isGatheringMinerals() || (closest = UnitUtils.getClosest(u, this.mGame.getMinerals())) == null) continue;
                u.rightClick(closest);
            }
        }
    }

    private void workerBookkeeping() {
        for (int i = 0; i < this.numWorkers(); ++i) {
            Unit unit;
            WorkerStatus workerStatus = this.workerStatuses.get(i);
            Unit w = unit = workerStatus.unit;
            int id = w.getID();
            if (w.isConstructing()) {
                workerStatus.setState(WorkerStatus.WorkerState.BUILDING);
            }
            if (w.isGatheringMinerals() && workerStatus.getState() != WorkerStatus.WorkerState.BUILDING && workerStatus.getState() != WorkerStatus.WorkerState.REFINING) {
                workerStatus.setState(WorkerStatus.WorkerState.MINING);
            }
            if (w.isGatheringGas() && workerStatus.getState() != WorkerStatus.WorkerState.BUILDING) {
                workerStatus.setState(WorkerStatus.WorkerState.REFINING);
                Unit r = w.getTarget();
                if (!this.refineryToGuys.containsEntry(r, workerStatus)) {
                    this.refineryToGuys.put((Object)r, (Object)workerStatus);
                }
            }
            if (workerStatus.idleCycles > 5 && workerStatus.getState() != WorkerStatus.WorkerState.SCOUTING && workerStatus.getState() != WorkerStatus.WorkerState.BUILDING && w.isCompleted()) {
                workerStatus.setState(WorkerStatus.WorkerState.NONE);
            }
            if (this.macroManager.defense != 0 && i < this.macroManager.defense) {
                if (workerStatus.getState() == WorkerStatus.WorkerState.SCOUTING) continue;
                ArrayList<ROUnit> en = new ArrayList<ROUnit>();
                ArrayList<ROUnit> enbldg = new ArrayList<ROUnit>();
                List<ROUnit> bunkers = UnitUtils.getAllMy(UnitType.TERRAN_BUNKER);
                Region baseRegion = null;
                for (Region region : this.macroManager.myBwta.getRegions()) {
                    if (!region.contains(this.macroManager.myHome)) continue;
                    baseRegion = region;
                    break;
                }
                for (ROUnit rOUnit : this.mGame.getAllUnits()) {
                    double p = rOUnit.getDistance(Position.centerOfTile(this.macroManager.myHome));
                    if (!rOUnit.getPlayer().isEnemy(this.me)) continue;
                    double bunkdist = Double.POSITIVE_INFINITY;
                    for (ROUnit bunk : bunkers) {
                        if (!((double)rOUnit.getDistance(bunk) < bunkdist)) continue;
                        bunkdist = rOUnit.getDistance(bunk);
                    }
                    if (baseRegion.contains(rOUnit.getPosition()) && (rOUnit.getType() == UnitType.PROTOSS_PYLON || rOUnit.getType() == UnitType.TERRAN_BUNKER)) {
                        enbldg.add(rOUnit);
                        continue;
                    }
                    if (!baseRegion.contains(rOUnit.getPosition()) && !(bunkdist < 200.0) && rOUnit.getDistance(unit) >= 100 || !rOUnit.getType().canAttack()) continue;
                    en.add(rOUnit);
                }
                workerStatus.setState(WorkerStatus.WorkerState.FIGHTING);
                if (unit.getTarget() == null || unit.isGatheringMinerals()) {
                    ROUnit closeBunker = null;
                    double d = Double.POSITIVE_INFINITY;
                    for (ROUnit bunka : bunkers) {
                        if (!((double)unit.getDistance(bunka) < d) || bunka.getLoadedUnits().size() == 0) continue;
                        d = unit.getDistance(bunka);
                        closeBunker = bunka;
                    }
                    if (i % 2 == 0 && closeBunker != null && closeBunker.getDistance(unit) < 100 && closeBunker.getHitPoints() < closeBunker.getType().maxHitPoints() && closeBunker.getHitPoints() > 0) {
                        unit.repair(closeBunker);
                    } else if (!baseRegion.contains(unit.getPosition())) {
                        unit.move(baseRegion.getCenter());
                    } else if ((i % 2 == 0 || enbldg.size() == 0) && en.size() != 0) {
                        unit.attack((ROUnit)UnitUtils.getClosest(unit, en));
                    } else if (UnitUtils.getClosest(unit, enbldg) != null) {
                        unit.attack((ROUnit)UnitUtils.getClosest(unit, enbldg));
                    } else {
                        unit.move(this.macroManager.natChoke.getCenter());
                    }
                }
            } else if (workerStatus.getState() == WorkerStatus.WorkerState.FIGHTING) {
                if (unit.isStopped()) {
                    workerStatus.setState(WorkerStatus.WorkerState.NONE);
                } else {
                    unit.stop();
                }
            }
            if (this.macroManager.defense == 0 && workerStatus.getState() == WorkerStatus.WorkerState.FIGHTING && this.myDefender != workerStatus) {
                workerStatus.setState(WorkerStatus.WorkerState.NONE);
            }
            if (!this.macroManager.debug) continue;
            this.mGame.drawTextMap(new Position(w.getPosition().x(), w.getPosition().y() + 30), (Object)((Object)workerStatus.getState()) + "");
            this.mGame.drawTextMap(new Position(w.getPosition().x(), w.getPosition().y()), unit.getID() + "");
        }
        Iterator iter = this.refineryToGuys.keySet().iterator();
        while (iter.hasNext()) {
            ROUnit r = (ROUnit)iter.next();
            if (r != null && r.getType().equals(UnitType.TERRAN_REFINERY)) continue;
            iter.remove();
        }
    }

    private void doRepairs() {
        for (BuildingStatus c : this.macroManager.myBuildings) {
            WorkerStatus w2;
            if (c.myUnit == null || !c.myUnit.isCompleted() || c.myUnit.getHitPoints() >= c.myUnit.getType().maxHitPoints() || c.myUnit.getHitPoints() <= 0 || c.myUnit.getType() == UnitType.TERRAN_ENGINEERING_BAY && c.myUnit.isLifted()) continue;
            WorkerStatus w = this.getWorker(c.spot);
            if (w != null && w.unit != null && (w.unit.isIdle() || w.unit.isGatheringMinerals())) {
                w.setState(WorkerStatus.WorkerState.FIGHTING);
                w.unit.repair(c.myUnit);
            }
            if (c.type != UnitType.TERRAN_BUNKER || (w2 = this.getWorker(c.spot)) == null || w2.unit == null || !w2.unit.isIdle() && !w2.unit.isGatheringMinerals()) continue;
            w2.setState(WorkerStatus.WorkerState.FIGHTING);
            w2.unit.repair(c.myUnit);
        }
    }

    private void handleSparkies() {
        if (this.macroManager.enemySparky != null) {
            if (this.myDefender == null || this.myDefender.getState() == WorkerStatus.WorkerState.BUILDING) {
                this.myDefender = this.getWorker();
                this.myDefender.setState(WorkerStatus.WorkerState.FIGHTING);
            } else {
                this.myDefender.unit.attack(this.macroManager.enemySparky);
            }
        } else if (this.myDefender != null) {
            this.myDefender.setState(WorkerStatus.WorkerState.NONE);
            this.myDefender.unit.stop();
            if (this.myDefender.unit.isStopped()) {
                this.myDefender = null;
            }
        }
    }

    private boolean isWorkerUnemployed(WorkerStatus workerStatus) {
        Unit u = workerStatus.unit;
        return (u.isIdle() || u.isStopped() || workerStatus.getState() == WorkerStatus.WorkerState.NONE || workerStatus.getState() == WorkerStatus.WorkerState.MINING && !u.isCarryingMinerals() && u.getTarget() == null && u.getOrderTarget() == null) && workerStatus.getState() != WorkerStatus.WorkerState.BUILDING && workerStatus.getState() != WorkerStatus.WorkerState.SCOUTING && workerStatus.getState() != WorkerStatus.WorkerState.FIGHTING;
    }

    @Override
    public void onUnitShow(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        if (unit.getType().isWorker() && unit.getPlayer() == this.me) {
            ++this.workersCreated;
            this.assignNewWorker(UnitUtils.assumeControl(unit));
            BuildingStatus best = this.closestBuilding(unit);
            if (best != null) {
                ++best.unitsproduced;
            }
        }
    }

    private BuildingStatus closestBuilding(ROUnit unit) {
        double closest = Double.POSITIVE_INFINITY;
        BuildingStatus best = null;
        for (BuildingStatus cc : this.macroManager.getMyCCs()) {
            double d;
            if (cc.myUnit == null || !((d = unit.getLastKnownPosition().getDistance(cc.myUnit.getLastKnownPosition())) < closest)) continue;
            closest = d;
            best = cc;
        }
        return best;
    }

    @Override
    public void onUnitDestroy(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        int id = unit.getID();
        if (unit.getPlayer() == this.me && unit.getType() == UnitType.TERRAN_SCV) {
            WorkerStatus ws = null;
            for (int i = 0; i < this.numWorkers(); ++i) {
                if (id != this.workerStatuses.get((int)i).unit.getID()) continue;
                ws = this.workerStatuses.remove(i);
                if (this.myDefender == null || id != this.myDefender.unit.getID()) break;
                this.myDefender = null;
                break;
            }
            if (this.scout != null && this.scout.unit != null && this.scout.unit.getID() == unit.getID()) {
                this.scout = null;
            }
            double closest = Double.POSITIVE_INFINITY;
            BuildingStatus best = null;
            for (BuildingStatus cc : this.macroManager.getMyCCs()) {
                double d;
                if (cc.myUnit == null || !((d = unit.getLastKnownPosition().getDistance(cc.myUnit.getLastKnownPosition())) < closest)) continue;
                closest = d;
                best = cc;
            }
            if (best != null) {
                --best.unitsproduced;
            }
            this.removeMiner(ws);
            this.refineryToGuys.remove(ws.target, ws);
        } else if (unit.getType().equals(UnitType.RESOURCE_MINERAL_FIELD)) {
            LinkedList<WorkerStatus> bums = this.mineralmap.get(unit);
            this.mineralmap.remove(unit);
            if (bums != null) {
                for (WorkerStatus worker : bums) {
                    this.assignWorkerToPatch(worker, this.choosePatchForMiner(worker.unit));
                }
            }
        }
    }

    protected int numWorkers() {
        return this.workerStatuses.size();
    }

    protected WorkerStatus getWorker() {
        if (this.numWorkers() == 0) {
            return null;
        }
        WorkerStatus worker = this.workerStatuses.get(0);
        for (int z = 0; z < this.numWorkers(); ++z) {
            WorkerStatus workerStats = this.workerStatuses.get(z);
            if (workerStats.unit != null && this.workerBuilding(workerStats.unit) || workerStats.getState() != WorkerStatus.WorkerState.MINING || !workerStats.unit.isCompleted()) continue;
            worker = workerStats;
            break;
        }
        return worker;
    }

    WorkerStatus getWorker(TilePosition p) {
        if (this.numWorkers() == 0) {
            return null;
        }
        WorkerStatus bestworker = this.workerStatuses.get(0);
        double bestdistance = Double.POSITIVE_INFINITY;
        for (int z = 0; z < this.numWorkers(); ++z) {
            WorkerStatus workerStats = this.workerStatuses.get(z);
            if (workerStats.unit != null && this.workerBuilding(workerStats.unit) || workerStats.getState() != WorkerStatus.WorkerState.MINING || !workerStats.unit.isCompleted()) continue;
            if (p == null) {
                return workerStats;
            }
            if (!(workerStats.unit.getPosition().getDistance(Position.centerOfTile(p)) < bestdistance)) continue;
            bestdistance = workerStats.unit.getPosition().getDistance(Position.centerOfTile(p));
            bestworker = workerStats;
        }
        return bestworker;
    }

    public boolean workerBuilding(Unit worker) {
        for (BuildingStatus bs : this.macroManager.myBuildings) {
            if (bs.status != 0 && bs.status != 1 || bs.myBuilder == null || bs.myBuilder.getID() != worker.getID()) continue;
            return true;
        }
        return false;
    }

    protected void drawDiagnostics() {
        for (Map.Entry<ROUnit, LinkedList<WorkerStatus>> entry : this.mineralmap.entrySet()) {
            ROUnit min = entry.getKey();
            for (WorkerStatus workerStatus : entry.getValue()) {
                this.mGame.drawLineMap(new Position(min.getLastKnownTilePosition()), workerStatus.getPosition(), Color.PURPLE);
                this.mGame.drawTextMap(workerStatus.getPosition(), String.valueOf(workerStatus.getID()));
                this.mGame.drawTextMap(workerStatus.getPosition().add(-10, -10), "M " + (Object)((Object)workerStatus.getState()));
            }
            String t = "";
            if (min.getPosition().equals(Position.INVALID)) {
                t = " I";
            }
            this.mGame.drawTextMap(min.getLastKnownPosition(), "M " + entry.getValue().size() + t);
        }
        for (Map.Entry<ROUnit, LinkedList<WorkerStatus>> entry : this.refineryToGuys.entries()) {
            ROUnit r = entry.getKey();
            WorkerStatus ws = (WorkerStatus)((Object)entry.getValue());
            Unit unit = ws.unit;
            this.mGame.drawTextMap(unit.getPosition().add(-10, -10), "G " + (Object)((Object)ws.getState()));
            if (unit == null || r == null) continue;
            this.mGame.drawLineMap(r.getPosition(), unit.getPosition(), Color.GREEN);
        }
        this.mGame.drawTextScreen(500, 100, "AvgMiners: " + String.format("%.2f", this.mineralSaturation()));
        this.mGame.drawTextScreen(500, 120, "AvgGas: " + String.format("%.2f", this.gasSaturation()));
    }

    @Override
    public void onFrame() {
        this.idleTracking();
        this.workerManagement();
        this.drawDiagnostics();
        if (this.mGame.getFrameCount() % 1000 == 0) {
            this.reassignWorkers();
        }
    }

    private void idleTracking() {
        for (WorkerStatus ws : this.workerStatuses) {
            if (ws.unit.isIdle()) {
                ++ws.idleCycles;
                continue;
            }
            ws.idleCycles = 0;
        }
    }

    void removeMiner(WorkerStatus worker) {
        ROUnit patch = worker.target;
        if (patch != null && this.mineralmap.get(patch) != null) {
            this.mineralmap.get(patch).remove(worker);
        }
        if (!(patch != null && patch.getType().equals(UnitType.TERRAN_REFINERY) || patch != null)) {
            for (LinkedList<WorkerStatus> miners : this.mineralmap.values()) {
                miners.remove(worker);
            }
        }
        worker.target = null;
    }

    private WorkerStatus getWorkerStatus(Unit worker) {
        for (WorkerStatus ws : this.workerStatuses) {
            if (!ws.unit.equals(worker)) continue;
            return ws;
        }
        return null;
    }

    public double mineralSaturation() {
        double avg = 0.0;
        for (LinkedList<WorkerStatus> miners : this.mineralmap.values()) {
            avg += (double)miners.size();
        }
        return avg /= (double)this.mineralmap.size();
    }

    public double gasSaturation() {
        return (double)this.refineryToGuys.values().size() / (double)this.refineryToGuys.keySet().size();
    }
}

