/*
 * Decompiled with CFR 0.152.
 */
package undermind.macro;

import edu.berkeley.nlp.starcraft.AbstractCerebrate;
import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.Strategy;
import edu.berkeley.nlp.starcraft.scripting.Command;
import edu.berkeley.nlp.starcraft.scripting.JythonInterpreter;
import edu.berkeley.nlp.starcraft.scripting.Thunk;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Chokepoint;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Race;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.model.UpgradeType;
import undermind.AStarSearch;
import undermind.ValuedUnitType;
import undermind.WorkerStatus;
import undermind.macro.Block;
import undermind.macro.BuildingPlacer;
import undermind.macro.BuildingStatus;
import undermind.macro.WorkerManager;

public class MacroManager
extends AbstractCerebrate
implements Strategy {
    public boolean lurkers = false;
    ArrayList<ROUnit> basestr = new ArrayList();
    public boolean wantsToLift = false;
    public Unit wallDoor;
    public Region natRegion;
    public List<TilePosition> chokeBuffer;
    public Region baseRegion;
    public Region enemyBaseRegion = null;
    public List<TilePosition> wall;
    public long lastInject = -10000L;
    public List<TilePosition> eligibleEnemyStarts;
    public List<ROUnit> enemyBuildings;
    public boolean mech;
    public ArrayList<ROUnit> unitsBeingCreated = new ArrayList();
    ROUnit enemySparky;
    public int mins;
    public int gas;
    int defense = 0;
    boolean AAinject = false;
    boolean ASinject = false;
    boolean rushinject = false;
    boolean FEinject = false;
    boolean GSinject = false;
    public int lastsched = 0;
    JythonInterpreter jython = new JythonInterpreter();
    public TilePosition myStart;
    public TilePosition myHome;
    private Unit myBase;
    TilePosition expansionLoc;
    BuildingPlacer buildingPlacer;
    public PriorityQueue<ValuedUnitType> unitPriorities;
    public final ArrayList<BuildingStatus> myBuildings = new ArrayList();
    public final ArrayList<BuildingStatus> myRefineries = new ArrayList();
    public final ArrayList<BuildingStatus> myCCs = new ArrayList();
    public final ArrayList<BaseLocation> myBases = new ArrayList();
    public int height;
    public int width;
    public TilePosition corner = new TilePosition(1, 1);
    public final ArrayList<TilePosition> expansionLocs = new ArrayList();
    int lastscan = 0;
    protected Player me;
    protected TilePosition target;
    public List<ROUnit> enemyBases;
    public List<UnitType> buildOrder;
    protected boolean scouting = true;
    private int CCs;
    protected int refineries;
    public Player enemyPlayer;
    public boolean debug = false;
    List<TilePosition> path;
    int time = 0;
    int scoutcountdown = 3000;
    Unit sc = null;
    Hashtable<UnitType, Integer> bldgCounts;
    Random rgenerator = new Random();
    Bwta myBwta;
    Set<Region> regions;
    Set<Chokepoint> chokepoints;
    public Chokepoint baseChoke;
    public Chokepoint natChoke;
    protected Game mGame;
    public AStarSearch pathfinder;
    public Set<BaseLocation> bls;
    public int[] bldists;
    public List<TilePosition>[] blpaths;
    WorkerManager workerManager;
    public LinkedList<Unit> extractors = new LinkedList();
    protected BaseLocation myBaseLocation;

    public MacroManager() {
        this.buildOrder = new ArrayList<UnitType>();
        this.mGame = Game.getInstance();
        this.height = this.mGame.mapHeight() - 1;
        this.width = this.mGame.mapWidth() - 1;
        this.enemyBases = new ArrayList<ROUnit>();
        this.pathfinder = new AStarSearch();
    }

    @Override
    public List<Cerebrate> getTopLevelCerebrates() {
        return null;
    }

    public void setWorkerManager(WorkerManager workerManager) {
        this.workerManager = workerManager;
    }

    @Override
    public void onFrame() {
        long starttime = System.currentTimeMillis();
        this.mGame.drawTextScreen(0, 290, "starts: " + this.eligibleEnemyStarts.toString());
        this.mGame.drawTextScreen(300, 320, "CCs in bo: " + this.BOCount(UnitType.TERRAN_COMMAND_CENTER));
        if (this.debug) {
            this.mGame.drawTextScreen(10, 30, "next:" + this.nextBldg());
        }
        if (this.debug) {
            for (BaseLocation b : this.bls) {
                this.mGame.drawTextMap(b.getPosition(), b.getTilePosition().x() + "," + b.getTilePosition().y());
            }
        }
        super.onFrame();
        if (this.debug) {
            this.mGame.drawTextMap(this.baseChoke.getCenter(), "base choke");
        }
        if (this.debug) {
            this.mGame.drawTextMap(this.natChoke.getCenter(), "nat choke");
        }
        for (BuildingStatus bs : this.myBuildings) {
            if (bs.status == 0) {
                WorkerStatus w;
                this.mGame.drawTextMap(Position.centerOfTile(bs.spot), bs.type.toString());
                this.mGame.drawLineMap(Position.centerOfTile(bs.spot), bs.myBuilder.getPosition(), Color.WHITE);
                if (bs.myBuilder.getPosition() == Position.INVALID && (w = this.workerManager.getWorker(bs.spot)) != null) {
                    bs.myBuilder = w;
                }
            }
            if (bs.status != 3 || !this.debug) continue;
            this.mGame.drawTextMap(Position.centerOfTile(bs.spot), "dead" + bs.type.toString());
        }
        ArrayList<ROUnit> tr = new ArrayList<ROUnit>();
        for (ROUnit u : this.unitsBeingCreated) {
            if (!u.isCompleted()) continue;
            this.onUnitSpawn(u);
            tr.add(u);
        }
        for (ROUnit removeMe : tr) {
            this.unitsBeingCreated.remove(removeMe);
        }
        --this.lastsched;
        ++this.time;
        if (this.lastscan != 0) {
            --this.lastscan;
        }
        if (this.myCCs.size() != 0 && this.myCCs.get((int)(this.myCCs.size() - 1)).status == 2) {
            this.myHome = this.myBuildings.size() < 15 ? this.myCCs.get((int)0).myUnit.getTilePosition() : this.myCCs.get((int)(this.myCCs.size() - 1)).myUnit.getTilePosition();
        }
        ArrayList<TilePosition> turrets = new ArrayList<TilePosition>();
        for (BuildingStatus bs : this.myBuildings) {
            if (bs.type != UnitType.TERRAN_MISSILE_TURRET || bs.status == 3) continue;
            turrets.add(bs.spot);
        }
        if (this.time % 100 == 0) {
            for (BuildingStatus cc : this.myCCs) {
                if (!cc.turreted) continue;
                TilePosition centerpos = new TilePosition(cc.spot.x() + 2, cc.spot.y() + 1);
                boolean reallyTurreted = false;
                for (TilePosition t : turrets) {
                    if (!(t.getDistance(cc.spot) <= 6.0)) continue;
                    reallyTurreted = true;
                }
                if (reallyTurreted) continue;
                cc.turreted = false;
            }
        }
        if (this.time % 6000 == 0 && this.time > 8000) {
            for (BuildingStatus cc : this.myCCs) {
                if (cc.turreted || !this.AAinject && !this.ASinject || this.BOIncoming(UnitType.TERRAN_MISSILE_TURRET)) continue;
                this.mGame.printf("Unturreted cc -- turreting!", new Object[0]);
                this.BOInject(UnitType.TERRAN_MISSILE_TURRET);
            }
        }
        if (this.me.minerals() > 300) {
            if (!this.mech) {
                if (this.nextBldg() != UnitType.TERRAN_BARRACKS && this.nextBldg() != UnitType.TERRAN_COMMAND_CENTER && !this.beingConstructed(UnitType.TERRAN_BARRACKS) && !this.BOIncoming(UnitType.TERRAN_BARRACKS) && UnitUtils.getAllMy(UnitType.TERRAN_BARRACKS).size() < 12) {
                    this.BOInject(UnitType.TERRAN_BARRACKS);
                }
            } else if (this.nextBldg() != UnitType.TERRAN_FACTORY && this.nextBldg() != UnitType.TERRAN_COMMAND_CENTER && this.me.gas() > 90 && this.me.minerals() > 400 && !this.beingConstructed(UnitType.TERRAN_FACTORY) && !this.BOIncoming(UnitType.TERRAN_FACTORY) && UnitUtils.getAllMy(UnitType.TERRAN_FACTORY).size() <= 10) {
                this.BOInject(UnitType.TERRAN_FACTORY);
            }
        }
        this.buildingBookkeeping();
        this.unitProduction();
        this.research();
        this.buildingPlacer.drawBuildingStuffs();
        this.buildingPlacer.getChokeDots(this.baseChoke);
        this.drawMacroIndicators();
        this.handleDoor();
        this.enemyStartStuff();
    }

    @Override
    public void onStart() {
        int dy;
        int dx;
        this.mGame = Game.getInstance();
        this.myBwta = Bwta.getInstance();
        this.regions = this.myBwta.getRegions();
        this.chokepoints = this.myBwta.getChokepoints();
        this.me = this.mGame.self();
        System.out.println("This map is " + this.mGame.getMapHash());
        for (Player p : this.mGame.getPlayers()) {
            if (p == this.me) continue;
            this.enemyPlayer = p;
            break;
        }
        this.myHome = this.mGame.self().getStartLocation();
        this.myStart = this.mGame.self().getStartLocation();
        for (Region region : this.myBwta.getRegions()) {
            if (!region.contains(this.myHome)) continue;
            this.baseRegion = region;
        }
        for (ROUnit rOUnit : this.mGame.self().getUnits()) {
            if (rOUnit.getType().isResourceDepot()) {
                this.myBase = UnitUtils.assumeControl(rOUnit);
            }
            if (!this.isTerranBldg(rOUnit) || rOUnit.getPlayer() != this.me) continue;
            this.myBuildings.add(new BuildingStatus(2, UnitUtils.assumeControl(rOUnit)));
            if (rOUnit.getType() != UnitType.TERRAN_COMMAND_CENTER) continue;
            this.myCCs.add(new BuildingStatus(2, UnitUtils.assumeControl(rOUnit)));
        }
        this.eligibleEnemyStarts = new ArrayList<TilePosition>();
        for (TilePosition tilePosition : this.mGame.getStartLocations()) {
            if (tilePosition.equals(this.myHome)) continue;
            this.eligibleEnemyStarts.add(tilePosition);
        }
        this.bls = this.myBwta.getBaseLocations();
        this.bldists = new int[this.bls.size()];
        this.blpaths = new List[this.bls.size()];
        int i = 0;
        for (BaseLocation b : this.bls) {
            int d;
            if (this.myHome.equals(b.getTilePosition())) {
                this.myBaseLocation = b;
                this.myBases.add(b);
            }
            List<TilePosition> path = this.pathfinder.getPath(this.myHome, b.getTilePosition());
            this.blpaths[i] = path;
            this.bldists[i] = path != null ? (d = path.size()) : 9999999;
            ++i;
        }
        this.expansionLoc = this.nextExpansion(false);
        for (Region r : this.regions) {
            if (!r.contains(this.myHome)) continue;
            Iterator<Chokepoint> it = r.getChokepoints().iterator();
            double smallestDistance = Double.POSITIVE_INFINITY;
            while (it.hasNext()) {
                Chokepoint c = it.next();
                double d = this.myHome.getDistance(c.getCenter());
                if (!(d < smallestDistance) || !c.getRegions().getKey().contains(this.expansionLoc) && !c.getRegions().getValue().contains(this.expansionLoc)) continue;
                smallestDistance = d;
                this.baseChoke = c;
            }
            break block5;
        }
        this.natRegion = null;
        Map.Entry<Region, Region> baseAndNat = this.baseChoke.getRegions();
        if (baseAndNat.getKey().contains(this.myHome)) {
            this.natRegion = baseAndNat.getValue();
        } else if (baseAndNat.getValue().contains(this.myHome)) {
            this.natRegion = baseAndNat.getKey();
        }
        Set<Chokepoint> natchokes = this.natRegion.getChokepoints();
        double biggestwidth = 0.0;
        for (Chokepoint c : natchokes) {
            if (!(biggestwidth < c.getWidth()) || c.equals(this.baseChoke)) continue;
            biggestwidth = c.getWidth();
            this.natChoke = c;
        }
        if (this.debug) {
            System.out.println("My Home: " + this.myHome.x() + ", " + this.myHome.y());
        }
        if (this.debug) {
            System.out.println("Map: " + this.mGame.getMapHash());
        }
        this.buildingPlacer = new BuildingPlacer(this.mGame, this);
        this.unitPriorities = new PriorityQueue<ValuedUnitType>(16, new Comparator<ValuedUnitType>(){

            @Override
            public int compare(ValuedUnitType t1, ValuedUnitType t2) {
                if (t2.value == t1.value) {
                    return 0;
                }
                if (t1.value < t2.value) {
                    return -1;
                }
                return 1;
            }
        });
        ArrayList<Block> blocks = new ArrayList<Block>();
        int startwidth = 4;
        int startheight = 3;
        blocks.add(new Block(startwidth, startheight));
        blocks.add(new Block(3, 2));
        blocks.add(new Block(3, 2));
        ArrayList<Block> blocks2 = new ArrayList<Block>();
        blocks2.add(new Block(startwidth, startheight));
        blocks2.add(new Block(3, 2));
        ArrayList<TilePosition> eligible = new ArrayList<TilePosition>();
        int spread = 7;
        TilePosition seed = new TilePosition(this.baseChoke.getCenter());
        HashSet<TilePosition> grid = new HashSet<TilePosition>();
        this.buildingPlacer.basicEligible = new ArrayList<TilePosition>();
        for (int dx2 = -spread; dx2 < spread; ++dx2) {
            block9: for (int dy2 = -spread; dy2 < spread; ++dy2) {
                TilePosition newpos = new TilePosition(seed.x() + dx2, seed.y() + dy2);
                if (!this.baseRegion.contains(newpos)) continue;
                for (int shiftx = 0; shiftx < startwidth; ++shiftx) {
                    for (int shifty = 0; shifty < startheight; ++shifty) {
                        if (!this.mGame.isBuildable(newpos.x() + shiftx, newpos.y() + shifty)) continue block9;
                    }
                }
                eligible.add(newpos);
                this.buildingPlacer.basicEligible.add(newpos);
            }
        }
        int otherwidth = 3;
        int otherheight = 2;
        for (dx = -spread; dx < spread; ++dx) {
            block13: for (dy = -spread; dy < spread; ++dy) {
                TilePosition newpos = new TilePosition(seed.x() + dx, seed.y() + dy);
                if (!this.baseRegion.contains(newpos)) continue;
                for (int shiftx = 0; shiftx < otherwidth; ++shiftx) {
                    for (int shifty = 0; shifty < otherheight; ++shifty) {
                        if (!this.mGame.isBuildable(newpos.x() + shiftx, newpos.y() + shifty)) continue block13;
                    }
                }
                if (this.buildingPlacer.basicEligible.contains(newpos)) continue;
                this.buildingPlacer.basicEligible.add(newpos);
            }
        }
        for (dx = -(spread += 9); dx < spread; ++dx) {
            for (dy = -spread; dy < spread; ++dy) {
                TilePosition newpos = new TilePosition(seed.x() + dx, seed.y() + dy);
                grid.add(newpos);
            }
        }
        this.pathfinder.grid = grid;
        double closest = Double.POSITIVE_INFINITY;
        TilePosition best = null;
        for (TilePosition tp : grid) {
            double d = tp.getDistance(this.myHome);
            if (!(d < closest) || !this.baseRegion.contains(tp) || !this.mGame.isBuildable(tp.x(), tp.y())) continue;
            best = tp;
            closest = d;
        }
        this.chokeBuffer = new ArrayList<TilePosition>();
        TilePosition choke = new TilePosition(this.baseChoke.getCenter());
        for (int dx3 = -1; dx3 <= 1; ++dx3) {
            for (int dy3 = -1; dy3 <= 1; ++dy3) {
                TilePosition newpos = new TilePosition(choke.x() + dx3, choke.y() + dy3);
                this.chokeBuffer.add(newpos);
            }
        }
        for (TilePosition tp : this.chokeBuffer) {
            this.mGame.drawCircleMap(new Position(tp), 6, Color.YELLOW, false);
        }
        this.buildingPlacer.wallPathStart = best;
        this.pathfinder.chokeBuffer = this.chokeBuffer;
        this.wall = null;
        int tol = -1;
        while (this.wall == null && tol < 12) {
            this.pathfinder.walkableTolerance = ++tol;
            if (this.mGame.getMapHash().equals("6f8da3c3cc8d08d9cf882700efa049280aedca8c") || this.mGame.getMapHash().equals("cb39a180c36de73e887e8430c5f32197c52c18ba")) {
                this.buildingPlacer.doWall(new TilePosition(this.baseChoke.getCenter()), blocks, eligible, new ArrayList<TilePosition>());
                if (this.wall != null) continue;
                this.wall = this.buildingPlacer.doWall(new TilePosition(this.baseChoke.getCenter()), blocks2, eligible, new ArrayList<TilePosition>());
                continue;
            }
            this.wall = this.buildingPlacer.doWall(new TilePosition(this.baseChoke.getCenter()), blocks2, eligible, new ArrayList<TilePosition>());
            if (this.wall != null) continue;
            this.buildingPlacer.doWall(new TilePosition(this.baseChoke.getCenter()), blocks, eligible, new ArrayList<TilePosition>());
        }
    }

    @Override
    public void onUnitCreate(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
    }

    @Override
    public void onUnitDestroy(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        int id = unit.getID();
        if (unit.getPlayer() != this.me && this.isMainBldg(unit)) {
            for (int i = 0; i < this.enemyBases.size(); ++i) {
                if (this.enemyBases.get(i).getID() != id) continue;
                this.enemyBases.remove(i);
                break;
            }
        } else if (this.isMainBldg(unit) && unit.getPlayer() == this.me) {
            for (int i = 0; i < this.myCCs.size(); ++i) {
                if (this.myCCs.get(i) == null || id != this.myCCs.get((int)i).myUnit.getID()) continue;
                this.myCCs.remove(i);
                for (int j = 0; j < this.myBuildings.size(); ++j) {
                    BuildingStatus bldg = this.myBuildings.get(j);
                    if (bldg.myUnit == null || id != bldg.myUnit.getID()) continue;
                    this.myBuildings.remove(j);
                }
            }
        } else if (unit.getPlayer() == this.me && unit.getType().isBuilding()) {
            for (int i = 0; i < this.myBuildings.size(); ++i) {
                BuildingStatus bldg = this.myBuildings.get(i);
                if (bldg.myUnit == null || id != bldg.myUnit.getID()) continue;
                if (bldg.type == UnitType.TERRAN_FACTORY && bldg.myUnit.getAddon() != null) {
                    for (int z = 0; z < this.myBuildings.size(); ++z) {
                        if (this.myBuildings.get((int)z).myUnit == null || this.myBuildings.get((int)z).myUnit.getID() != bldg.myUnit.getAddon().getID()) continue;
                        this.myBuildings.remove(z);
                        break;
                    }
                }
                this.myBuildings.remove(i);
                if (unit.getType() != UnitType.TERRAN_REFINERY) break;
                int ref = -1;
                for (int z = 0; z < this.myRefineries.size(); ++z) {
                    if (this.myRefineries.get((int)z).myUnit == null || this.myRefineries.get((int)z).myUnit.getID() != id) continue;
                    ref = z;
                }
                if (ref == -1) break;
                this.myRefineries.remove(ref);
                break;
            }
            if (this.wallDoor != null && this.wallDoor.getID() == unit.getID()) {
                this.wallDoor = null;
            }
        }
    }

    @Override
    public void onUnitHide(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
    }

    @Override
    public void onUnitMorph(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        if (unit.getType() == UnitType.TERRAN_REFINERY && unit.getPlayer() == this.me) {
            for (BuildingStatus r : this.myRefineries) {
                if (r.myUnit == null || r.myUnit.getID() != unit.getID()) continue;
                this.myRefineries.remove(r);
                break;
            }
            for (BuildingStatus r : this.myRefineries) {
                if (r.myUnit != null) continue;
                r.status = 1;
                r.myUnit = UnitUtils.assumeControl(unit);
                break;
            }
        }
    }

    @Override
    public void onUnitRenegade(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        super.onUnitRenegade(unit);
        this.onUnitDestroy(unit);
    }

    @Override
    public void onUnitShow(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        if (unit.getPlayer().equals(this.me)) {
            this.unitsBeingCreated.add(unit);
            if (this.isTerranBldg(unit)) {
                boolean found = false;
                for (BuildingStatus buildingStatus : this.myBuildings) {
                    if (buildingStatus.myUnit != null || buildingStatus.type != unit.getType()) continue;
                    buildingStatus.myUnit = UnitUtils.assumeControl(unit);
                    buildingStatus.status = 1;
                    found = true;
                    break;
                }
                if (!found && this.isTerranAddon(unit)) {
                    this.myBuildings.add(new BuildingStatus(1, UnitUtils.assumeControl(unit)));
                }
            }
        }
        if (unit.getPlayer() != this.me && this.isMainBldg(unit)) {
            ROUnit closest = UnitUtils.getClosest(unit, this.enemyBases);
            if (!(this.enemyBases.contains(unit) || closest != null && closest.getDistance(unit) <= 180)) {
                this.enemyBases.add(unit);
                if (this.enemyBases.size() == 1) {
                    TilePosition[] eligible = new TilePosition[]{new TilePosition(1, 1), new TilePosition(1, this.height), new TilePosition(this.width, this.height), new TilePosition(this.width, 1)};
                    double d = Double.POSITIVE_INFINITY;
                    for (int i = 0; i < 4; ++i) {
                        if (!(eligible[i].getDistance(unit.getTilePosition()) < d)) continue;
                        d = eligible[i].getDistance(unit.getTilePosition());
                        this.corner = eligible[i];
                    }
                }
            }
        }
        ArrayList<ROUnit> tr = new ArrayList<ROUnit>();
        for (ROUnit rOUnit : this.basestr) {
            if (rOUnit.getID() != unit.getID()) continue;
            tr.add(rOUnit);
        }
        this.basestr.removeAll(tr);
    }

    public void onUnitSpawn(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        if (unit.getType().equals(UnitType.TERRAN_COMMAND_CENTER) && unit.getPlayer() == this.me) {
            for (BaseLocation b : this.bls) {
                if (!b.getRegion().contains(unit.getPosition()) || this.myBases.contains(b)) continue;
                this.addBase(b);
                break;
            }
        }
    }

    @Override
    public void onEnd(boolean isWinnerFlag) {
    }

    protected void initializeJython() {
        this.jython.bindFields(this);
        this.jython.bind("game", this.mGame);
        this.jython.bindIntCommand("speed", new Command<Integer>(){

            @Override
            public void call(Integer arg) {
                MacroManager.this.mGame.printf("Setting speed to %d", arg);
                MacroManager.this.mGame.setLocalSpeed(arg);
            }
        });
        this.jython.bindThunk("debug", new Thunk(){

            @Override
            public void call() {
                MacroManager.this.debug = !MacroManager.this.debug;
            }
        });
        this.jython.bindThunk("reset", new Thunk(){

            @Override
            public void call() {
                MacroManager.this.initializeJython();
            }
        });
    }

    public void unitProduction() {
        int mineralsReserved = 0;
        int gasReserved = 0;
        for (BuildingStatus b : this.myBuildings) {
            if (b.status != 0) continue;
            this.construct(b);
            mineralsReserved += b.type.mineralPrice();
            gasReserved += b.type.gasPrice();
        }
        this.refineries = this.myRefineries.size();
        long starttime = System.currentTimeMillis();
        this.mins = this.mGame.self().minerals() - mineralsReserved;
        this.gas = this.mGame.self().gas() - gasReserved;
        for (int i = 0; i < this.myCCs.size(); ++i) {
            if (!this.shouldIBuildSCV(i)) continue;
            this.myCCs.get((int)i).myUnit.train(UnitType.TERRAN_SCV);
            this.mins += -50;
        }
        if (this.shouldISupplyDepot()) {
            this.scheduleBuild(UnitType.TERRAN_SUPPLY_DEPOT);
            this.mins += -100;
        }
        ArrayList bldgs = (ArrayList)this.myBuildings.clone();
        for (int i = 0; i < this.buildOrder.size(); ++i) {
            UnitType next = this.buildOrder.get(i);
            boolean found = false;
            for (BuildingStatus b : bldgs) {
                if (!b.type.equals(next) || b.status != 1 && b.status != 2 && b.status != 0) continue;
                bldgs.remove(b);
                found = true;
                break;
            }
            if (found) continue;
            if (this.mins < next.mineralPrice() || this.gas < next.gasPrice() || this.lastsched > 0) break;
            this.scheduleBuild(next);
            if (!this.nextBldg().canProduce() && this.nextBldg() != UnitType.TERRAN_BUNKER && this.nextBldg() != UnitType.TERRAN_MISSILE_TURRET && this.nextBldg() != UnitType.TERRAN_COMMAND_CENTER && (long)this.time - this.lastInject > 800L) {
                this.lastsched = 800;
            }
            if (this.nextBldg() == UnitType.TERRAN_STARPORT) {
                this.lastsched = 1500;
            }
            this.mins += -next.mineralPrice();
            this.gas += -next.gasPrice();
            break;
        }
        if (this.nextBldg() == UnitType.TERRAN_COMMAND_CENTER) {
            this.mins -= 400;
        }
        this.CCs = 0;
        for (BuildingStatus cc : this.myCCs) {
            if (cc.status != 2) continue;
            ++this.CCs;
        }
        if (this.mins >= 100 && this.refineries < this.CCs && (this.myCCs.size() > 1 || this.me.supplyUsed() >= 24 && this.mech || this.me.supplyUsed() >= 32 && !this.mech) && this.nextRefinery() != TilePosition.INVALID) {
            this.scheduleBuild(UnitType.TERRAN_REFINERY);
            this.mins += -100;
        }
        Object[] a = new ValuedUnitType[1];
        a = this.unitPriorities.toArray(a);
        Arrays.sort(a);
        for (BuildingStatus b : this.myBuildings) {
            if (b.status == 2 && b.type == UnitType.TERRAN_FACTORY && b.myUnit.getTrainingQueue().size() < 1 && b.myUnit.getAddon() == null && (this.mech || this.lurkers)) {
                b.myUnit.buildAddon(UnitType.TERRAN_MACHINE_SHOP);
            }
            if (b.status == 2 && b.type == UnitType.TERRAN_STARPORT && b.myUnit.getTrainingQueue().size() < 1 && b.myUnit.getAddon() == null) {
                b.myUnit.buildAddon(UnitType.TERRAN_CONTROL_TOWER);
            }
            b.orderqueued = false;
        }
        for (Object v : a) {
            if (v == null) continue;
            this.makeUnit(((ValuedUnitType)v).type);
        }
        for (BuildingStatus b : this.myBuildings) {
            b.orderqueued = false;
        }
    }

    private boolean shouldISupplyDepot() {
        return this.mins >= 100 && (this.me.supplyTotal() - this.me.supplyUsed() < 8 || this.me.supplyTotal() - this.me.supplyUsed() < 16 && this.me.supplyTotal() > 120 || this.me.supplyTotal() - this.me.supplyUsed() < 12 && this.me.supplyTotal() > 50) && !this.beingConstructed(UnitType.TERRAN_SUPPLY_DEPOT) && this.me.supplyTotal() < 400;
    }

    private boolean shouldIBuildSCV(int i) {
        return this.time % 10 == 0 && this.mins >= 50 && this.workerManager.numWorkers() < 80 && this.myCCs.get((int)i).status == 2 && (this.myCCs.get((int)i).unitsproduced < 28 || this.workerManager.numWorkers() < 28 * this.myCCs.size()) && this.myCCs.get((int)i).myUnit.getTrainingQueue().size() < 1;
    }

    public void research() {
        for (BuildingStatus b : this.myBuildings) {
            if (b.myUnit != null && b.myUnit.getType() == UnitType.TERRAN_ACADEMY && !this.mech) {
                b.myUnit.research(TechType.STIM_PACKS);
                b.myUnit.upgrade(UpgradeType.U_238_SHELLS);
            }
            if (b.myUnit != null && b.myUnit.getType() == UnitType.TERRAN_ENGINEERING_BAY && !this.mech) {
                b.myUnit.upgrade(UpgradeType.TERRAN_INFANTRY_WEAPONS);
                b.myUnit.upgrade(UpgradeType.TERRAN_INFANTRY_ARMOR);
            }
            if (b.myUnit != null && b.myUnit.getType() == UnitType.TERRAN_ARMORY) {
                b.myUnit.upgrade(UpgradeType.TERRAN_VEHICLE_WEAPONS);
                b.myUnit.upgrade(UpgradeType.TERRAN_VEHICLE_PLATING);
            }
            if (b.myUnit != null && b.myUnit.getType() == UnitType.TERRAN_FACTORY && b.myUnit.getAddon() != null && b.myUnit.getAddon().isCompleted()) {
                Unit machineshop = UnitUtils.assumeControl(b.myUnit.getAddon());
                if (this.mech || this.lurkers) {
                    machineshop.research(TechType.TANK_SIEGE_MODE);
                }
                if (this.mech) {
                    if (UnitUtils.getAllMy(UnitType.TERRAN_VULTURE).size() > 3 && this.me.hasResearched(TechType.TANK_SIEGE_MODE)) {
                        machineshop.research(TechType.SPIDER_MINES);
                    }
                    if (UnitUtils.getAllMy(UnitType.TERRAN_VULTURE).size() > 3 && this.me.hasResearched(TechType.TANK_SIEGE_MODE)) {
                        machineshop.upgrade(UpgradeType.ION_THRUSTERS);
                    }
                    machineshop.upgrade(UpgradeType.CHARON_BOOSTER);
                }
            }
            if (b.myUnit == null || b.myUnit.getType() != UnitType.TERRAN_SCIENCE_FACILITY) continue;
            if (UnitUtils.getAllMy(UnitType.TERRAN_SCIENCE_VESSEL).size() >= 2 && !this.mech) {
                UnitUtils.assumeControl(b.myUnit).research(TechType.IRRADIATE);
            } else if (UnitUtils.getAllMy(UnitType.TERRAN_SCIENCE_VESSEL).size() >= 2 && this.mech) {
                UnitUtils.assumeControl(b.myUnit).research(TechType.EMP_SHOCKWAVE);
            }
            if (this.mins <= 1000 || this.gas <= 800) continue;
            UnitUtils.assumeControl(b.myUnit).upgrade(UpgradeType.TITAN_REACTOR);
        }
    }

    public void makeUnit(UnitType u) {
        if (this.time % 10 != 0) {
            return;
        }
        for (BuildingStatus b : this.myBuildings) {
            if (this.mins < u.mineralPrice() || this.gas < u.gasPrice() || b.status != 2 || b.myUnit == null || b.myUnit.getTrainingQueue().size() >= 1 || !this.mGame.canMake(b.myUnit, u) && (b.type != UnitType.TERRAN_STARPORT || b.myUnit.getAddon() == null || !b.myUnit.getAddon().exists() || !u.equals(UnitType.TERRAN_DROPSHIP) && !u.equals(UnitType.TERRAN_SCIENCE_VESSEL)) && (b.type != UnitType.TERRAN_FACTORY || u != UnitType.TERRAN_SIEGE_TANK_TANK_MODE) || b.orderqueued || this.wallDoor != null && u.getID() == this.wallDoor.getID() && this.wantsToLift) continue;
            b.myUnit.train(u);
            this.mins -= u.mineralPrice();
            this.gas -= u.gasPrice();
            b.orderqueued = true;
        }
    }

    public void buildingBookkeeping() {
        ArrayList<TilePosition> toRemove = new ArrayList<TilePosition>();
        ArrayList<BuildingStatus> toRemove2 = new ArrayList<BuildingStatus>();
        for (BuildingStatus buildingStatus : this.myBuildings) {
            if (buildingStatus.status == 1 && buildingStatus.myUnit.isCompleted()) {
                buildingStatus.status = 2;
                if (!this.isTerranAddon(buildingStatus.myUnit)) {
                    buildingStatus.myBuilder.setState(WorkerStatus.WorkerState.NONE);
                }
            }
            if (buildingStatus.status == 1 && !buildingStatus.myUnit.isBeingConstructed()) {
                WorkerStatus worker = this.workerManager.getWorker(buildingStatus.spot);
                worker.unit.rightClick(buildingStatus.myUnit);
                worker.setState(WorkerStatus.WorkerState.BUILDING);
            }
            if (buildingStatus.type == UnitType.TERRAN_COMMAND_CENTER && buildingStatus.status == 2 && this.me.minerals() > 50 && this.me.gas() > 50) {
                buildingStatus.myUnit.buildAddon(UnitType.TERRAN_COMSAT_STATION);
            }
            if (buildingStatus.status == 0) {
                ++buildingStatus.age;
            }
            if ((buildingStatus.age <= 1100 || buildingStatus.type == UnitType.TERRAN_COMMAND_CENTER) && buildingStatus.age <= 2500) continue;
            toRemove.add(buildingStatus.spot);
            buildingStatus.myBuilder.setState(WorkerStatus.WorkerState.NONE);
            if (buildingStatus.type == UnitType.TERRAN_REFINERY) {
                this.myRefineries.remove(buildingStatus);
            }
            if (buildingStatus.type == UnitType.TERRAN_COMMAND_CENTER) {
                this.myCCs.remove(buildingStatus);
            }
            toRemove2.add(buildingStatus);
        }
        for (BuildingStatus buildingStatus : toRemove2) {
            this.myBuildings.remove(buildingStatus);
        }
        for (ROUnit rOUnit : this.basestr) {
            this.enemyBases.remove(rOUnit);
        }
        this.basestr = new ArrayList();
        for (ROUnit rOUnit : this.enemyBases) {
            if (!Utils.fullVisible(rOUnit.getLastKnownTilePosition(), UnitType.PROTOSS_NEXUS) || rOUnit.isVisible()) continue;
            this.basestr.add(rOUnit);
        }
    }

    private void scheduleBuild(UnitType bldg) {
        BuildingStatus b;
        if (bldg == UnitType.TERRAN_REFINERY) {
            TilePosition buildpos = this.nextRefinery();
            if (buildpos == TilePosition.INVALID) {
                return;
            }
            WorkerStatus builder = this.workerManager.getWorker(buildpos);
            builder.setState(WorkerStatus.WorkerState.BUILDING);
            b = new BuildingStatus(builder, bldg, buildpos);
            this.workerManager.refineryToGuys.put((Object)b.myUnit, (Object)builder);
            builder.target = b.myUnit;
            this.workerManager.removeMiner(builder);
        } else {
            TilePosition spot = this.buildingPlacer.placeBuilding(bldg);
            WorkerStatus builder = this.workerManager.getWorker(spot);
            b = new BuildingStatus(builder, bldg, spot);
        }
        if (b.spot != TilePosition.INVALID) {
            this.myBuildings.add(b);
            if (bldg == UnitType.TERRAN_REFINERY) {
                this.myRefineries.add(b);
            }
            if (bldg == UnitType.TERRAN_COMMAND_CENTER) {
                this.myCCs.add(b);
            }
        }
    }

    TilePosition nextRefinery() {
        TilePosition buildpos = TilePosition.INVALID;
        Set<? extends ROUnit> g = this.mGame.getGeysers();
        block0: for (BuildingStatus cc : this.myCCs) {
            for (ROUnit rOUnit : g) {
                if (!this.mGame.isVisible(rOUnit.getTilePosition()) || !(cc.spot.getDistance(rOUnit.getLastKnownTilePosition()) < 10.0)) continue;
                buildpos = rOUnit.getLastKnownTilePosition();
                break block0;
            }
        }
        return buildpos;
    }

    private void construct(BuildingStatus bldg) {
        if (this.debug) {
            this.mGame.drawCircleMap(Position.centerOfTile(bldg.spot), 5, Color.RED, true);
        }
        Unit builder = bldg.myBuilder.unit;
        bldg.myBuilder.setState(WorkerStatus.WorkerState.BUILDING);
        boolean tries = false;
        double clb = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.myBuildings.size() && this.myBuildings.get((int)i).spot != bldg.spot; ++i) {
            if (this.myBuildings.get((int)i).spot == null) {
                if (this.debug) {
                    this.mGame.printf("null thing", new Object[0]);
                }
                this.myBuildings.get((int)i).spot = this.buildingPlacer.placeBuilding(this.myBuildings.get((int)i).type);
            }
            if (bldg.spot == null) {
                bldg.spot = this.buildingPlacer.placeBuilding(this.myBuildings.get((int)i).type);
            }
            if (this.myBuildings.get((int)i).spot == null || bldg.spot == null || !(this.myBuildings.get((int)i).spot.getDistance(bldg.spot) < clb)) continue;
            clb = this.myBuildings.get((int)i).spot.getDistance(bldg.spot);
        }
        if (!Utils.fullVisible(bldg.spot, bldg.type)) {
            if (this.time % 5 == 0) {
                bldg.myBuilder.setState(WorkerStatus.WorkerState.BUILDING);
                this.pathfinder.makeUnitPath(builder, bldg.spot);
            }
        } else {
            double closestBldg = Double.POSITIVE_INFINITY;
            for (int i = 0; i < this.myBuildings.size(); ++i) {
                if (this.myBuildings.get((int)i).spot == null || bldg.spot == null || !(this.myBuildings.get((int)i).spot.getDistance(bldg.spot) < closestBldg)) continue;
                closestBldg = this.myBuildings.get((int)i).spot.getDistance(bldg.spot);
            }
            if ((builder.canBuildHere(bldg.spot, bldg.type) || bldg.type == UnitType.TERRAN_REFINERY) && (closestBldg >= 3.0 || closestBldg == 0.0)) {
                builder.build(bldg.spot, bldg.type);
            } else if (bldg.type != UnitType.TERRAN_COMMAND_CENTER) {
                bldg.spot = this.buildingPlacer.placeBuilding(bldg.type);
            }
        }
    }

    private boolean beingConstructed(UnitType bldg) {
        if (bldg == UnitType.TERRAN_SUPPLY_DEPOT) {
            if (UnitUtils.getAllMy(UnitType.TERRAN_SUPPLY_DEPOT).size() > 5 && UnitUtils.getAllMy(UnitType.TERRAN_SUPPLY_DEPOT).size() <= 10) {
                int dcount = 0;
                for (int i = 0; i < this.myBuildings.size(); ++i) {
                    if (this.myBuildings.get((int)i).status != 0 && this.myBuildings.get((int)i).status != 1 || this.myBuildings.get((int)i).type != bldg) continue;
                    ++dcount;
                }
                return dcount > 2;
            }
            if (UnitUtils.getAllMy(UnitType.TERRAN_SUPPLY_DEPOT).size() > 10) {
                int dcount = 0;
                for (int i = 0; i < this.myBuildings.size(); ++i) {
                    if (this.myBuildings.get((int)i).status != 0 && this.myBuildings.get((int)i).status != 1 || this.myBuildings.get((int)i).type != bldg) continue;
                    ++dcount;
                }
                return dcount > 4;
            }
        }
        for (int i = 0; i < this.myBuildings.size(); ++i) {
            if (this.myBuildings.get((int)i).status != 0 && this.myBuildings.get((int)i).status != 1 || this.myBuildings.get((int)i).type != bldg) continue;
            return true;
        }
        return false;
    }

    private boolean isScheduled(UnitType bldg) {
        for (int i = 0; i < this.myBuildings.size(); ++i) {
            if (this.myBuildings.get((int)i).status != 0 || this.myBuildings.get((int)i).type != bldg) continue;
            return true;
        }
        return false;
    }

    public void resetBuildOrder() {
        this.buildOrder = new ArrayList<UnitType>();
    }

    public void BOInject(UnitType bldg) {
        int j = -1;
        ArrayList bldgs = (ArrayList)this.myBuildings.clone();
        block0: for (int i = 0; i < this.buildOrder.size(); ++i) {
            UnitType next = this.buildOrder.get(i);
            for (BuildingStatus b : bldgs) {
                if (!b.type.equals(next)) continue;
                bldgs.remove(b);
                j = i + 1;
                continue block0;
            }
        }
        if (j == -1) {
            this.buildOrder.add(bldg);
        } else {
            this.buildOrder.add(j, bldg);
        }
        this.lastInject = this.time;
    }

    public void BOset(List<UnitType> order) {
        this.buildOrder = order;
    }

    public void BORemove(UnitType bldg) {
        ArrayList bldgs = (ArrayList)this.myBuildings.clone();
        int farthest = 0;
        int i = 0;
        while (i < this.buildOrder.size()) {
            UnitType next = this.buildOrder.get(i);
            boolean found = false;
            for (BuildingStatus b : bldgs) {
                if (!b.type.equals(next) || b.status != 1 && b.status != 2 && b.status != 0) continue;
                bldgs.remove(b);
                found = true;
                break;
            }
            farthest = i++;
            if (!found) break;
        }
        int remove = -1;
        for (int i2 = farthest; i2 < this.buildOrder.size(); ++i2) {
            if (this.buildOrder.get(i2) != bldg) continue;
            remove = i2;
            break;
        }
        if (remove != -1) {
            this.buildOrder.remove(remove);
        }
    }

    public int BOCount(UnitType bldg) {
        int c = 0;
        for (int i = 0; i < this.buildOrder.size(); ++i) {
            if (!this.buildOrder.get(i).equals(bldg)) continue;
            ++c;
        }
        return c;
    }

    public boolean BOIncoming(UnitType bldg) {
        ArrayList bldgs = (ArrayList)this.myBuildings.clone();
        int farthest = 0;
        int i = 0;
        while (i < this.buildOrder.size()) {
            UnitType next = this.buildOrder.get(i);
            boolean found = false;
            for (BuildingStatus b : bldgs) {
                if (!b.type.equals(next) || b.status != 1 && b.status != 2 && b.status != 0) continue;
                bldgs.remove(b);
                found = true;
                break;
            }
            farthest = i++;
            if (!found) break;
        }
        for (i = farthest; i < this.buildOrder.size(); ++i) {
            if (this.buildOrder.get(i) != bldg) continue;
            return true;
        }
        return false;
    }

    public int bcount(UnitType bldg) {
        int c = 0;
        for (int i = 0; i < this.myBuildings.size(); ++i) {
            if (!this.myBuildings.get((int)i).type.equals(bldg)) continue;
            ++c;
        }
        return c;
    }

    public UnitType nextBldg() {
        ArrayList bldgs = (ArrayList)this.myBuildings.clone();
        for (int i = 0; i < this.buildOrder.size(); ++i) {
            UnitType next = this.buildOrder.get(i);
            boolean found = false;
            for (BuildingStatus b : bldgs) {
                if (!b.type.equals(next) || b.status != 1 && b.status != 2 && b.status != 0) continue;
                bldgs.remove(b);
                found = true;
                break;
            }
            if (found) continue;
            return next;
        }
        return UnitType.TERRAN_PHYSICS_LAB;
    }

    public void makeBuilding(UnitType bldg) {
        this.scheduleBuild(bldg);
    }

    public void stealthResponse() {
        if (!this.ASinject) {
            this.mGame.printf("Potential stealth units detected -- Engineering bay, turrets, and comsats on the way!", new Object[0]);
            this.BORemove(UnitType.TERRAN_MISSILE_TURRET);
            this.BOInject(UnitType.TERRAN_MISSILE_TURRET);
            this.BOInject(UnitType.TERRAN_MISSILE_TURRET);
            if (this.bcount(UnitType.TERRAN_ACADEMY) == 0 && this.nextBldg() != UnitType.TERRAN_ACADEMY) {
                this.BORemove(UnitType.TERRAN_ACADEMY);
                this.BOInject(UnitType.TERRAN_ACADEMY);
            }
            this.BOInject(UnitType.TERRAN_MISSILE_TURRET);
            if (this.bcount(UnitType.TERRAN_ENGINEERING_BAY) == 0 && this.nextBldg() != UnitType.TERRAN_ENGINEERING_BAY) {
                this.BORemove(UnitType.TERRAN_ENGINEERING_BAY);
                this.BOInject(UnitType.TERRAN_ENGINEERING_BAY);
            }
            this.ASinject = true;
        }
    }

    public void airResponse() {
        if (!this.AAinject) {
            this.mGame.printf("Air units suspected: building turrets!", new Object[0]);
            if (this.mech && !this.ihavetech(UnitType.TERRAN_ARMORY)) {
                this.BORemove(UnitType.TERRAN_ARMORY);
                this.BOInject(UnitType.TERRAN_ARMORY);
            }
            this.BORemove(UnitType.TERRAN_MISSILE_TURRET);
            this.BOInject(UnitType.TERRAN_MISSILE_TURRET);
            this.BOInject(UnitType.TERRAN_MISSILE_TURRET);
            if (this.bcount(UnitType.TERRAN_ENGINEERING_BAY) == 0 && this.nextBldg() != UnitType.TERRAN_ENGINEERING_BAY) {
                this.BORemove(UnitType.TERRAN_ENGINEERING_BAY);
                this.BOInject(UnitType.TERRAN_ENGINEERING_BAY);
            }
            this.AAinject = true;
        }
    }

    public void gasStealResponse() {
        if (!this.GSinject) {
            this.BOInject(UnitType.TERRAN_BARRACKS);
            this.GSinject = true;
        }
    }

    public void rushResponse() {
        if (!this.rushinject && this.bcount(UnitType.TERRAN_BUNKER) == 0 && this.nextBldg() != UnitType.TERRAN_BUNKER) {
            if (this.enemyPlayer.getRace() == Race.PROTOSS) {
                this.mGame.printf("Early gateway rush suspected -- Adding a bunker.", new Object[0]);
                this.BOInject(UnitType.TERRAN_BUNKER);
            } else if (this.enemyPlayer.getRace() == Race.ZERG) {
                this.mGame.printf("Early zergling rush suspected -- Adding a bunker.", new Object[0]);
                this.BOInject(UnitType.TERRAN_BUNKER);
            } else if (this.enemyPlayer.getRace() == Race.TERRAN) {
                this.mGame.printf("Early marine rush suspected -- Adding a bunker", new Object[0]);
                this.BOInject(UnitType.TERRAN_BUNKER);
            }
            this.rushinject = true;
        }
    }

    public void FEresponse() {
        if (!this.FEinject && this.myCCs.size() < 2 && this.nextBldg() != UnitType.TERRAN_COMMAND_CENTER) {
            this.BORemove(UnitType.TERRAN_BUNKER);
            this.FEinject = true;
        }
    }

    public void debugging() {
        if (this.debug) {
            for (BuildingStatus b : this.myCCs) {
                this.mGame.drawCircleMap(Position.centerOfTile(b.spot), 6, Color.YELLOW, false);
            }
            for (List<TilePosition> pth : this.blpaths) {
                if (pth == null) continue;
                for (TilePosition tp : pth) {
                    this.mGame.drawCircleMap(Position.centerOfTile(tp), 3, Color.WHITE, true);
                    this.mGame.drawTextMap(Position.centerOfTile(tp), "" + tp.x() + " " + tp.y());
                }
                this.mGame.drawTextMap(Position.centerOfTile(pth.get(pth.size() - 1)), "" + pth.size());
            }
        }
        if (this.debug) {
            this.mGame.drawCircleMap(Position.centerOfTile(this.expansionLoc), 5, Color.PURPLE, true);
        }
    }

    public void scan(Position p) {
        if (this.lastscan != 0) {
            return;
        }
        ROUnit best = null;
        int bestE = 0;
        for (BuildingStatus b : this.myCCs) {
            if (b.status != 2 || b.myUnit.getAddon() == null || b.myUnit.getAddon().getType() != UnitType.TERRAN_COMSAT_STATION || !b.myUnit.getAddon().isCompleted() || b.myUnit.getAddon().getEnergy() < bestE) continue;
            bestE = b.myUnit.getAddon().getEnergy();
            best = b.myUnit.getAddon();
        }
        if (best != null && bestE > 50) {
            UnitUtils.assumeControl(best).useTech(TechType.SCANNER_SWEEP, p);
            this.lastscan = 200;
        }
    }

    public boolean isMainBldg(ROUnit unit) {
        return unit.getType() == UnitType.PROTOSS_NEXUS || unit.getType() == UnitType.ZERG_HATCHERY || unit.getType() == UnitType.ZERG_LAIR || unit.getType() == UnitType.ZERG_HIVE || unit.getType() == UnitType.TERRAN_COMMAND_CENTER;
    }

    public boolean isTerranBldg(ROUnit unit) {
        UnitType t = unit.getType();
        return t == UnitType.TERRAN_ACADEMY || t == UnitType.TERRAN_ARMORY || t == UnitType.TERRAN_BARRACKS || t == UnitType.TERRAN_BUNKER || t == UnitType.TERRAN_COMMAND_CENTER || t == UnitType.TERRAN_COMSAT_STATION || t == UnitType.TERRAN_CONTROL_TOWER || t == UnitType.TERRAN_COVERT_OPS || t == UnitType.TERRAN_ENGINEERING_BAY || t == UnitType.TERRAN_FACTORY || t == UnitType.TERRAN_MACHINE_SHOP || t == UnitType.TERRAN_MISSILE_TURRET || t == UnitType.TERRAN_NUCLEAR_SILO || t == UnitType.TERRAN_PHYSICS_LAB || t == UnitType.TERRAN_REFINERY || t == UnitType.TERRAN_SCIENCE_FACILITY || t == UnitType.TERRAN_STARPORT || t == UnitType.TERRAN_SUPPLY_DEPOT;
    }

    public boolean isTerranAddon(ROUnit unit) {
        UnitType t = unit.getType();
        return t == UnitType.TERRAN_COMSAT_STATION || t == UnitType.TERRAN_CONTROL_TOWER || t == UnitType.TERRAN_COVERT_OPS || t == UnitType.TERRAN_MACHINE_SHOP || t == UnitType.TERRAN_NUCLEAR_SILO || t == UnitType.TERRAN_PHYSICS_LAB;
    }

    public void defend(int value) {
        this.defense = value;
    }

    public void stopDefend() {
        this.defense = 0;
    }

    public void antisparky(ROUnit value) {
        this.enemySparky = value;
    }

    public boolean ihavetech(UnitType bldg) {
        for (BuildingStatus b : this.myBuildings) {
            if (b.myUnit == null || !b.myUnit.getType().equals(bldg) || !b.myUnit.isCompleted()) continue;
            return true;
        }
        return false;
    }

    public int buildingCount(UnitType bldg) {
        int count = 0;
        for (BuildingStatus b : this.myBuildings) {
            if (b.myUnit == null || !b.myUnit.getType().equals(bldg) || !b.myUnit.isCompleted()) continue;
            ++count;
        }
        return count;
    }

    public void expand() {
        if (this.nextBldg() != UnitType.TERRAN_COMMAND_CENTER && !this.BOIncoming(UnitType.TERRAN_COMMAND_CENTER) && !this.beingConstructed(UnitType.TERRAN_COMMAND_CENTER)) {
            this.BOInject(UnitType.TERRAN_COMMAND_CENTER);
            this.mGame.printf("Expansion injected into build", new Object[0]);
        }
    }

    public void cancelExpand() {
        if (this.myCCs.size() == 0) {
            return;
        }
        if (this.BOIncoming(UnitType.TERRAN_COMMAND_CENTER)) {
            int removeIndex = -1;
            for (int x = this.buildOrder.size() - 1; x >= 0; --x) {
                if (this.buildOrder.get(x) != UnitType.TERRAN_COMMAND_CENTER) continue;
                removeIndex = x;
                break;
            }
            if (removeIndex != -1) {
                this.buildOrder.remove(removeIndex);
            }
        }
        if (!this.isScheduled(UnitType.TERRAN_COMMAND_CENTER) && !this.beingConstructed(UnitType.TERRAN_COMMAND_CENTER)) {
            return;
        }
        this.mGame.printf("CANCELLING scheduled expansion...", new Object[0]);
        ArrayList<BuildingStatus> tr = new ArrayList<BuildingStatus>();
        for (BuildingStatus bs : this.myBuildings) {
            if (bs.type != UnitType.TERRAN_COMMAND_CENTER || bs.status != 0 && bs.status != 1) continue;
            tr.add(bs);
            if (bs.status != 1) continue;
            bs.myUnit.cancelConstruction();
        }
        this.myBuildings.removeAll(tr);
        tr = new ArrayList();
        for (BuildingStatus cc : this.myCCs) {
            if (cc.status != 0 && cc.status != 1) continue;
            tr.add(cc);
        }
        this.myCCs.removeAll(tr);
        if (this.BOIncoming(UnitType.TERRAN_COMMAND_CENTER)) {
            int removeIndex = -1;
            for (int x = this.buildOrder.size() - 1; x >= 0; --x) {
                if (this.buildOrder.get(x) != UnitType.TERRAN_COMMAND_CENTER) continue;
                removeIndex = x;
                break;
            }
            if (removeIndex != -1) {
                this.buildOrder.remove(removeIndex);
            }
        }
    }

    public void safeExpand() {
        if (!(this.nextBldg() == UnitType.TERRAN_COMMAND_CENTER || this.nextBldg() == UnitType.TERRAN_BUNKER || this.BOIncoming(UnitType.TERRAN_COMMAND_CENTER) || this.beingConstructed(UnitType.TERRAN_COMMAND_CENTER) || this.BOIncoming(UnitType.TERRAN_BUNKER) || this.beingConstructed(UnitType.TERRAN_BUNKER))) {
            this.BOInject(UnitType.TERRAN_BUNKER);
            this.BOInject(UnitType.TERRAN_COMMAND_CENTER);
            this.mGame.printf("Safe Expansion injected into build", new Object[0]);
        }
    }

    public TilePosition nextExpansion(boolean withGas) {
        long start = System.currentTimeMillis();
        TilePosition best = null;
        double min = Double.POSITIVE_INFINITY;
        int j = -1;
        for (BaseLocation b : this.bls) {
            boolean skip = false;
            ++j;
            if (this.mGame.getMapHash().equals("6f8da3c3cc8d08d9cf882700efa049280aedca8c") && b.getTilePosition().x() == 19) {
                skip = true;
            }
            if (b.isIsland()) {
                skip = true;
            }
            TilePosition tp = b.getTilePosition();
            for (BuildingStatus bs : this.myCCs) {
                if (!bs.spot.equals(tp) && !(bs.spot.getDistance(tp) < 10.0) || bs.status == 0 || bs.status == 3) continue;
                skip = true;
            }
            boolean hasGeyser = false;
            for (ROUnit rOUnit : this.mGame.getStaticGeysers()) {
                if (!(rOUnit.getDistance(b.getPosition()) < 320.0)) continue;
                hasGeyser = true;
                break;
            }
            if (!hasGeyser && withGas) {
                skip = true;
            }
            for (TilePosition tilePosition : TilePosition.getTilePositions(b.getTilePosition(), 4, 3)) {
                for (ROUnit rOUnit : this.mGame.unitsOnTile(tilePosition)) {
                    if (!rOUnit.getType().isBuilding() && rOUnit.getType() != UnitType.TERRAN_VULTURE_SPIDER_MINE) continue;
                    skip = true;
                }
                if (this.enemyBuildings == null) continue;
                for (ROUnit rOUnit : this.enemyBuildings) {
                    if (!(rOUnit.getLastKnownTilePosition().getDistance(b.getTilePosition()) < 7.0)) continue;
                    skip = true;
                }
            }
            if (skip || !((double)this.bldists[j] <= min)) continue;
            min = this.bldists[j];
            best = b.getTilePosition();
        }
        if (best != null) {
            this.mGame.drawCircleMap(Position.centerOfTile(best), 2, Color.GREEN, true);
        }
        if (best == null && withGas) {
            return this.nextExpansion(false);
        }
        return best;
    }

    public int numWorkers() {
        return this.workerManager.numWorkers();
    }

    public WorkerStatus getWorker() {
        return this.workerManager.getWorker();
    }

    protected ArrayList<BuildingStatus> getMyCCs() {
        return this.myCCs;
    }

    public void addBase(BaseLocation base) {
        System.out.println("Added a base");
        this.workerManager.addBase(base);
        this.myBases.add(base);
        this.buildingPlacer.addBase(base);
    }

    public boolean minedOutAllBases() {
        for (BaseLocation b : this.myBases) {
            if (b.getMinerals().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int idleBuildings() {
        int i = 0;
        for (BuildingStatus bs : this.myBuildings) {
            if (bs.myUnit == null || !bs.myUnit.getType().canProduce() || bs.status != 2 || bs.myUnit.isTraining()) continue;
            ++i;
        }
        return i;
    }

    public void drawMacroIndicators() {
        if (this.debug) {
            this.mGame.drawTextScreen(20, 40, "Idle buildings: " + this.idleBuildings());
        }
    }

    public void handleDoor() {
        if (this.wall != null) {
            block0: for (int i = 0; i < this.wall.size(); ++i) {
                TilePosition tp = this.wall.get(i);
                if (i == 0) {
                    this.mGame.drawCircleMap(new Position(tp), 2, Color.ORANGE, true);
                }
                if (i == 1) {
                    this.mGame.drawCircleMap(new Position(tp), 2, Color.GREEN, true);
                }
                if (i == 2) {
                    this.mGame.drawCircleMap(new Position(tp), 2, Color.BLUE, true);
                }
                if (this.wallDoor != null) continue;
                for (BuildingStatus bs : this.myBuildings) {
                    if (!this.wall.get(0).equals(bs.spot)) continue;
                    this.wallDoor = bs.myUnit;
                    continue block0;
                }
            }
        }
        if (this.wallDoor != null) {
            if (this.BOCount(UnitType.TERRAN_COMMAND_CENTER) > 1 || this.me.supplyUsed() > 95) {
                if (!this.wallDoor.isLifted() && this.wallDoor.getTilePosition().getDistance(this.wall.get(0)) < 3.0) {
                    this.wallDoor.lift();
                    this.wantsToLift = true;
                } else if (this.wallDoor.isIdle() && this.wallDoor.isLifted()) {
                    this.wallDoor.land(this.buildingPlacer.placeBuilding(UnitType.TERRAN_FACTORY));
                    this.wantsToLift = false;
                }
            }
            if (this.BOCount(UnitType.TERRAN_COMMAND_CENTER) == 1 && !this.wallDoor.getTilePosition().equals(this.wall.get(0))) {
                if (!this.wallDoor.isLifted()) {
                    this.wallDoor.lift();
                    this.wantsToLift = true;
                } else if (this.wallDoor.isIdle()) {
                    this.wallDoor.land(this.wall.get(0));
                    this.wantsToLift = false;
                }
            }
        }
    }

    public void enemyStartStuff() {
        if (this.eligibleEnemyStarts.size() != 1 && this.enemyBuildings != null) {
            TilePosition confirmedStart = null;
            block0: for (ROUnit bldg : this.enemyBuildings) {
                for (TilePosition tilePosition : this.eligibleEnemyStarts) {
                    if (!(tilePosition.getDistance(bldg.getPosition()) < 10.0)) continue;
                    confirmedStart = tilePosition;
                    break block0;
                }
            }
            if (confirmedStart != null) {
                this.eligibleEnemyStarts = new ArrayList<TilePosition>();
                this.eligibleEnemyStarts.add(confirmedStart);
            }
        }
        if (this.eligibleEnemyStarts.size() != 1) {
            ArrayList<TilePosition> tr = new ArrayList<TilePosition>();
            block2: for (TilePosition tp : this.eligibleEnemyStarts) {
                if (!this.mGame.isVisible(tp)) continue;
                for (ROUnit rOUnit : this.mGame.unitsOnTile(tp)) {
                    if (!rOUnit.getType().isResourceDepot()) continue;
                    this.eligibleEnemyStarts = new ArrayList<TilePosition>();
                    this.eligibleEnemyStarts.add(tp);
                    break block2;
                }
                tr.add(tp);
            }
            this.eligibleEnemyStarts.removeAll(tr);
        }
        if (this.eligibleEnemyStarts.size() == 1 && this.enemyBaseRegion == null) {
            for (Region r : this.myBwta.getRegions()) {
                if (!r.contains(this.eligibleEnemyStarts.get(0))) continue;
                this.enemyBaseRegion = r;
            }
        }
    }
}

