/*
 * Decompiled with CFR 0.152.
 */
package undermind.macro;

import edu.berkeley.nlp.starcraft.util.ConvexHull;
import edu.berkeley.nlp.starcraft.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Chokepoint;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.macro.Block;
import undermind.macro.BuildTilesState;
import undermind.macro.BuildingStatus;
import undermind.macro.ExtendedTerrainAnalyzer;
import undermind.macro.MacroManager;

public class BuildingPlacer {
    public TilePosition wallPathStart;
    Game mGame;
    MacroManager master;
    TilePosition buildSpot1;
    private List<ConvexHull> noBuildies = new LinkedList<ConvexHull>();
    BuildTilesState bt_state;
    public List<TilePosition> wtf;
    public List<TilePosition> basicEligible;

    public BuildingPlacer(Game g, MacroManager m) {
        this.master = m;
        this.mGame = g;
        this.buildSpot1 = ExtendedTerrainAnalyzer.inFrontOfCC(this.master.myBaseLocation);
        this.bt_state = new BuildTilesState(m);
    }

    public void addBase(BaseLocation b) {
    }

    public TilePosition placeBuilding(UnitType bldg) {
        TilePosition spot;
        if (this.master.numWorkers() == 0) {
            return new TilePosition(1, 1);
        }
        Unit builder = this.master.getWorker().unit;
        long starttime = System.currentTimeMillis();
        if (bldg == UnitType.TERRAN_REFINERY) {
            return this.master.nextRefinery();
        }
        if (bldg == UnitType.TERRAN_COMMAND_CENTER) {
            return this.placeCC();
        }
        if (bldg == UnitType.TERRAN_BUNKER) {
            return this.placeBunker(builder);
        }
        if (bldg == UnitType.TERRAN_MISSILE_TURRET) {
            return this.placeTurret(builder);
        }
        if (this.master.wall != null && this.master.time < 10000) {
            int s = this.master.wall.size();
            TilePosition rax = this.master.wall.get(0);
            if (this.master.wallDoor == null && bldg == UnitType.TERRAN_BARRACKS && (!Utils.fullVisible(rax, bldg) || this.mGame.canBuildHere(builder, rax, bldg))) {
                return rax;
            }
            if (bldg == UnitType.TERRAN_SUPPLY_DEPOT && s > 1) {
                if (!Utils.fullVisible(this.master.wall.get(1), bldg) || this.mGame.canBuildHere(builder, this.master.wall.get(1), bldg)) {
                    return this.master.wall.get(1);
                }
                if (s > 2 && (!Utils.fullVisible(this.master.wall.get(2), bldg) || this.mGame.canBuildHere(builder, this.master.wall.get(2), bldg))) {
                    return this.master.wall.get(2);
                }
            }
        }
        if ((spot = this.bt_state.place(bldg, new HashSet<TilePosition>())) != null) {
            return spot;
        }
        System.out.println("DERP");
        return null;
    }

    private TilePosition placeTurret(Unit builder) {
        UnitType bldg = UnitType.TERRAN_MISSILE_TURRET;
        for (int i = this.master.myCCs.size() - 1; i >= 0; --i) {
            BuildingStatus cc = this.master.myCCs.get(i);
            if (cc.turreted) continue;
            TilePosition ccpos = cc.spot;
            ROUnit closestPatch = null;
            for (BaseLocation bl : this.master.myBases) {
                if (!bl.getTilePosition().equals(ccpos)) continue;
                double closestDistance = Double.POSITIVE_INFINITY;
                Set<? extends ROUnit> patches = bl.getMinerals();
                if (patches.size() == 0) break;
                for (ROUnit rOUnit : patches) {
                    if (!(rOUnit.getDistance(bl.getPosition()) < closestDistance)) continue;
                    closestDistance = rOUnit.getDistance(bl.getPosition());
                    closestPatch = rOUnit;
                }
            }
            if (closestPatch == null) {
                return this.placeBuilding(UnitType.TERRAN_COMSAT_STATION);
            }
            double best = Double.POSITIVE_INFINITY;
            TilePosition bestpos = null;
            TilePosition centerpos = new TilePosition(ccpos.x() + 2, ccpos.y() + 1);
            for (int dx = -5; dx < 5; ++dx) {
                for (int dy = -5; dy < 5; ++dy) {
                    TilePosition tilePosition = new TilePosition(closestPatch.getTilePosition().x() + dx, closestPatch.getTilePosition().y() + dy);
                    double distance = tilePosition.getDistance(centerpos);
                    if (distance < 3.0 || distance > 6.0 || !(distance < best) || !builder.canBuildHere(tilePosition, bldg)) continue;
                    best = distance;
                    bestpos = tilePosition;
                }
            }
            if (bestpos == null) continue;
            cc.turreted = true;
            return bestpos;
        }
        return this.bt_state.placeTurret(UnitType.TERRAN_MISSILE_TURRET, new HashSet<TilePosition>());
    }

    private TilePosition placeBunker(Unit builder) {
        double d;
        double closestBldg;
        TilePosition newpos2;
        int j;
        int i;
        Region r;
        TilePosition ccSpot;
        TilePosition choke;
        UnitType bldg = UnitType.TERRAN_BUNKER;
        Unit cc = null;
        if (this.master.myCCs.size() > 0) {
            cc = this.master.myCCs.get((int)(this.master.myCCs.size() - 1)).myUnit;
        }
        if (cc == null) {
            return this.placeBuilding(UnitType.TERRAN_ARMORY);
        }
        TilePosition pos = cc.getTilePosition();
        TilePosition newpos = new TilePosition(pos.x() - 3, pos.y());
        boolean wall = false;
        if (this.master.myCCs.size() == 0) {
            return this.placeBuilding(UnitType.TERRAN_ARMORY);
        }
        if (this.master.myCCs.size() == 1 && !this.master.BOIncoming(UnitType.TERRAN_COMMAND_CENTER)) {
            if (this.master.wall != null && this.master.wallDoor != null && !this.master.wallDoor.isLifted() && this.master.wallDoor.getTilePosition().equals(this.master.wall.get(0))) {
                choke = this.master.wall.get(0);
                wall = true;
            } else {
                choke = new TilePosition(this.master.baseChoke.getCenter());
            }
            ccSpot = this.master.myCCs.get((int)0).spot;
            r = this.master.baseRegion;
        } else {
            ccSpot = this.master.myCCs.size() > 1 ? this.master.myCCs.get((int)1).spot : this.master.nextExpansion(true);
            choke = new TilePosition(this.master.natChoke.getCenter());
            r = this.master.natRegion;
        }
        double bestDistance = Double.POSITIVE_INFINITY;
        TilePosition bestpos = null;
        int tolerance = 4;
        if (wall) {
            tolerance = 7;
        }
        for (i = -tolerance; i < tolerance; ++i) {
            for (j = -tolerance; j < tolerance; ++j) {
                newpos2 = new TilePosition(choke.x() + i, choke.y() + j);
                closestBldg = Double.POSITIVE_INFINITY;
                for (BaseLocation b : this.master.bls) {
                    if (!(b.getTilePosition().getDistance(newpos2) < 4.0)) continue;
                }
                d = ccSpot.getDistance(newpos2);
                if (!wall) {
                    for (int v = 0; v < this.master.myBuildings.size(); ++v) {
                        if (this.master.wall == null || !this.master.wall.contains(newpos2) || !(this.master.myBuildings.get((int)v).spot.getDistance(newpos2) < closestBldg)) continue;
                        closestBldg = this.master.myBuildings.get((int)v).spot.getDistance(newpos2);
                    }
                    if (!(closestBldg > 3.0) || Utils.fullVisible(newpos2, bldg) && !builder.canBuildHere(newpos2, bldg) || !this.fitbuildable(newpos2, UnitType.TERRAN_BUNKER) || !(d < bestDistance) || !(choke.getDistance(newpos2) > 3.0) || !r.contains(newpos2)) continue;
                    bestpos = newpos2;
                    bestDistance = d;
                    continue;
                }
                double choked = newpos2.getDistance(this.master.baseChoke.getCenter());
                if (this.mGame.getMapHash().equals("de2ada75fbc741cfa261ee467bf6416b10f9e301") && newpos2.y() > 123 || !(choked > 5.0) || !(choked < bestDistance) || Utils.fullVisible(newpos2, bldg) && !builder.canBuildHere(newpos2, bldg) || !this.fitbuildable(newpos2, UnitType.TERRAN_BUNKER) || !r.contains(newpos2)) continue;
                bestpos = newpos2;
                bestDistance = choked;
            }
        }
        if (bestpos != null) {
            return bestpos;
        }
        for (i = -7; i < 7; ++i) {
            for (j = -7; j < 7; ++j) {
                newpos2 = new TilePosition(choke.x() + i, choke.y() + j);
                closestBldg = Double.POSITIVE_INFINITY;
                for (int v = 0; v < this.master.myBuildings.size(); ++v) {
                    if (!(this.master.myBuildings.get((int)v).spot.getDistance(newpos2) < closestBldg)) continue;
                    closestBldg = this.master.myBuildings.get((int)v).spot.getDistance(newpos2);
                }
                d = ccSpot.getDistance(newpos2);
                if (!(closestBldg > 5.0) || Utils.fullVisible(newpos2, bldg) && !builder.canBuildHere(newpos2, bldg) || !this.fitbuildable(newpos2, UnitType.TERRAN_BUNKER) || !(d < bestDistance)) continue;
                bestpos = newpos2;
                bestDistance = d;
            }
        }
        if (bestpos != null) {
            return bestpos;
        }
        if (builder.canBuildHere(newpos, bldg)) {
            return newpos;
        }
        newpos = new TilePosition(pos.x() + 4, pos.y() - 1);
        if (builder.canBuildHere(newpos, bldg)) {
            return newpos;
        }
        newpos = new TilePosition(pos.x() - 7, pos.y());
        if (builder.canBuildHere(newpos, bldg)) {
            return newpos;
        }
        newpos = new TilePosition(pos.x() + 7, pos.y());
        if (builder.canBuildHere(newpos, bldg)) {
            return newpos;
        }
        return this.placeBuilding(UnitType.TERRAN_ARMORY);
    }

    private TilePosition placeCC() {
        TilePosition best = this.master.mech && !this.mGame.getMapHash().equals("1e983eb6bcfa02ef7d75bd572cb59ad3aab49285") ? this.master.nextExpansion(true) : this.master.nextExpansion(false);
        if (best != null) {
            return best;
        }
        this.master.cancelExpand();
        this.mGame.printf("uh oh... no more expansions?", new Object[0]);
        return new TilePosition(5, 5);
    }

    public boolean superbuildable(TilePosition p) {
        int x = p.x();
        int y = p.y();
        if (x < 3 || x > this.master.width - 5) {
            return false;
        }
        if (y < 3 || y > this.master.height - 4) {
            return false;
        }
        return this.mGame.isBuildable(x, y) && this.mGame.isBuildable(x + 1, y) && this.mGame.isBuildable(x, y + 1) && this.mGame.isBuildable(x + 1, y + 1) && this.mGame.unitsOnTile(x, y).size() == 0 && this.mGame.unitsOnTile(x + 1, y).size() == 0 && this.mGame.unitsOnTile(x, y + 1).size() == 0 && this.mGame.unitsOnTile(x + 1, y + 1).size() == 0;
    }

    public boolean fitbuildable(TilePosition p, UnitType bldg) {
        for (int i = 0; i < bldg.tileWidth(); ++i) {
            for (int j = 0; j < bldg.tileHeight(); ++j) {
                if (this.mGame.isBuildable(p.x() + i, p.y() + j)) continue;
                return false;
            }
        }
        return true;
    }

    public List<TilePosition> getTilesAround(Unit bldg) {
        ArrayList<TilePosition> surrounding = new ArrayList<TilePosition>();
        int height = bldg.getType().tileHeight();
        int width = bldg.getType().tileWidth();
        int x = bldg.getTilePosition().x();
        int y = bldg.getTilePosition().y();
        for (int dx = -1; dx < width + 1; ++dx) {
            surrounding.add(new TilePosition(x + dx, y - 1));
            surrounding.add(new TilePosition(x + dx, y + height));
        }
        for (int dy = 0; dy < height; ++dy) {
            surrounding.add(new TilePosition(x - 1, y + dy));
            surrounding.add(new TilePosition(x + width, y + dy));
        }
        return surrounding;
    }

    public List<TilePosition> getTurretTiles(ROUnit bldg) {
        ArrayList<TilePosition> surrounding = new ArrayList<TilePosition>();
        int height = bldg.getType().tileHeight();
        int width = bldg.getType().tileWidth();
        int x = bldg.getTilePosition().x();
        int y = bldg.getTilePosition().y();
        for (int dx = -1; dx < width + 1; ++dx) {
            surrounding.add(new TilePosition(x + dx, y - 2));
            surrounding.add(new TilePosition(x + dx, y + height));
        }
        for (int dy = 0; dy < height; ++dy) {
            surrounding.add(new TilePosition(x - 2, y + dy));
            surrounding.add(new TilePosition(x + width, y + dy));
        }
        return surrounding;
    }

    public ArrayList<TilePosition> getOffsetTiles(ROUnit bldg, int widthNeeded, int heightNeeded) {
        int dy;
        TilePosition tilePosition;
        int dx;
        ArrayList<TilePosition> surrounding = new ArrayList<TilePosition>();
        int height = bldg.getType().tileHeight();
        int width = bldg.getType().tileWidth();
        int x = bldg.getTilePosition().x();
        int y = bldg.getTilePosition().y();
        for (dx = 1 - widthNeeded; dx < width + 1; ++dx) {
            tilePosition = new TilePosition(x + dx, y + height);
            if (!this.canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) continue;
            surrounding.add(tilePosition);
        }
        for (dy = 1 - heightNeeded; dy < height; ++dy) {
            tilePosition = new TilePosition(x + width, y + dy);
            if (!this.canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) continue;
            surrounding.add(tilePosition);
        }
        for (dx = -widthNeeded; dx < width + 1; ++dx) {
            tilePosition = new TilePosition(x + dx, y - heightNeeded);
            if (!this.canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) continue;
            surrounding.add(tilePosition);
        }
        for (dy = -heightNeeded; dy < height + 1; ++dy) {
            tilePosition = new TilePosition(x - widthNeeded, y + dy);
            if (!this.canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) continue;
            surrounding.add(tilePosition);
        }
        return surrounding;
    }

    public ArrayList<TilePosition> getOffsetTiles(int x, int y, int width, int height, int widthNeeded, int heightNeeded) {
        int dy;
        TilePosition tilePosition;
        int dx;
        ArrayList<TilePosition> surrounding = new ArrayList<TilePosition>();
        for (dx = 1 - widthNeeded; dx < width + 1; ++dx) {
            tilePosition = new TilePosition(x + dx, y + height);
            if (!this.canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) continue;
            surrounding.add(tilePosition);
        }
        for (dy = 1 - heightNeeded; dy < height; ++dy) {
            tilePosition = new TilePosition(x + width, y + dy);
            if (!this.canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) continue;
            surrounding.add(tilePosition);
        }
        for (dx = -widthNeeded; dx < width + 1; ++dx) {
            tilePosition = new TilePosition(x + dx, y - heightNeeded);
            if (!this.canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) continue;
            surrounding.add(tilePosition);
        }
        for (dy = -heightNeeded; dy < height + 1; ++dy) {
            tilePosition = new TilePosition(x - widthNeeded, y + dy);
            if (!this.canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) continue;
            surrounding.add(tilePosition);
        }
        return surrounding;
    }

    public boolean canBuildRaw(int x, int y, int width, int height) {
        for (int dx = 0; dx < width; ++dx) {
            for (int dy = 0; dy < height; ++dy) {
                if (this.mGame.isBuildable(x + dx, y + dy)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean eligibleBuildSpot(Position p) {
        for (ConvexHull c : this.noBuildies) {
            if (!c.withinHull(p)) continue;
            return false;
        }
        return true;
    }

    public void addNoBuildZone(ConvexHull zone) {
        this.noBuildies.add(zone);
    }

    public void drawBuildingStuffs() {
    }

    public void getChokeDots(Chokepoint c) {
        TilePosition center = new TilePosition(c.getCenter());
        this.mGame.drawCircleMap(Position.centerOfTile(center), 3, Color.RED, true);
        int tolerance = 6;
        for (int dx = -tolerance; dx < tolerance; ++dx) {
            for (int dy = -tolerance; dy < tolerance; ++dy) {
                TilePosition newpos = new TilePosition(center.x() + dx, center.y() + dy);
            }
        }
    }

    public List<TilePosition> doWall(TilePosition seed, ArrayList<Block> blocks, ArrayList<TilePosition> eligible, ArrayList<TilePosition> occupied) {
        ArrayList<Block> myBlocks = new ArrayList<Block>(blocks);
        TilePosition start = this.wallPathStart;
        Block b = myBlocks.remove(0);
        int depotDist = 3;
        if (this.mGame.getMapHash().equals("9bfc271360fa5bab3707a29e1326b84d0ff58911") || this.mGame.getMapHash().equals("6f8da3c3cc8d08d9cf882700efa049280aedca8c")) {
            depotDist = 4;
        }
        for (TilePosition tp : eligible) {
            ArrayList<TilePosition> newEligible;
            List<TilePosition> subsolution;
            if (tp.getDistance(seed) < (double)depotDist && b.width == 3 || !this.master.baseRegion.contains(tp) || !this.basicEligible.contains(tp)) continue;
            ArrayList<TilePosition> blocked = new ArrayList<TilePosition>(occupied);
            for (int shiftx = 0; shiftx < b.width; ++shiftx) {
                for (int shifty = 0; shifty < b.height; ++shifty) {
                    TilePosition newpos = new TilePosition(tp.x() + shiftx, tp.y() + shifty);
                    if (blocked.contains(newpos)) continue;
                    blocked.add(newpos);
                }
            }
            if (blocked.contains(seed)) continue;
            if (this.master.pathfinder.getPath(start, seed, blocked) == null) {
                this.wtf = new ArrayList<TilePosition>(blocked);
                ArrayList<TilePosition> ret = new ArrayList<TilePosition>();
                ret.add(tp);
                return ret;
            }
            if (myBlocks.size() == 0 || (subsolution = this.doWall(seed, myBlocks, newEligible = this.getOffsetTiles(tp.x(), tp.y(), b.width, b.height, myBlocks.get((int)0).width, myBlocks.get((int)0).height), blocked)) == null) continue;
            subsolution.add(0, tp);
            return subsolution;
        }
        return null;
    }
}

