/*
 * Decompiled with CFR 0.152.
 */
package undermind.macro;

import edu.berkeley.nlp.starcraft.util.Utils;
import edu.berkeley.nlp.starcraft.util.Vector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Chokepoint;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.UnitType;
import undermind.macro.BuildingStatus;
import undermind.macro.MacroManager;

public class BuildTilesState {
    List<BaseLocation> extraBLs;
    MacroManager master;
    ArrayList<Region> buildable_regions;
    List<TilePosition> growTiles;
    Set<TilePosition> banned;
    int growsThisFrame;
    Region growRegion;

    public BuildTilesState(MacroManager master) {
        this.master = master;
        this.buildable_regions = new ArrayList();
        this.growTiles = new ArrayList<TilePosition>();
        this.growRegion = master.natChoke.getRegions().getKey().getChokepoints().contains(master.baseChoke) ? master.natChoke.getRegions().getValue() : master.natChoke.getRegions().getKey();
        this.extraBLs = new ArrayList<BaseLocation>();
    }

    public void grow() {
        Game.getInstance().printf("GROWING!!", new Object[0]);
        if (this.buildable_regions.contains(this.growRegion)) {
            ArrayList<Region> eligible = new ArrayList<Region>();
            for (Chokepoint c : this.growRegion.getChokepoints()) {
                Region r1 = c.getRegions().getKey();
                Region r2 = c.getRegions().getValue();
                if (!this.buildable_regions.contains(r1)) {
                    eligible.add(r1);
                }
                if (this.buildable_regions.contains(r2)) continue;
                eligible.add(r2);
            }
            Region best = null;
            double bestDist = Double.POSITIVE_INFINITY;
            for (Region r : eligible) {
                double d = r.getCenter().getDistance(new Position(this.master.myHome));
                if (!(d < bestDist)) continue;
                bestDist = d;
                best = r;
            }
            this.growRegion = best;
        }
        if (this.growRegion != null) {
            this.buildable_regions.add(this.growRegion);
            for (BaseLocation bl : this.master.myBwta.getBaseLocations()) {
                if (!this.growRegion.contains(bl.getPosition())) continue;
                this.extraBLs.add(bl);
            }
        }
    }

    public void ban_tile(TilePosition tp) {
        this.banned.add(tp);
    }

    public void un_ban_tile(TilePosition tp) {
        if (this.banned.contains(tp)) {
            this.banned.remove(tp);
        }
    }

    public Set<TilePosition> myBaseTiles() {
        block0: for (BaseLocation bl : this.master.myBases) {
            for (Region r : this.master.myBwta.getRegions()) {
                if (!r.contains(bl.getPosition()) || this.buildable_regions.contains(r)) continue;
                this.buildable_regions.add(r);
                continue block0;
            }
        }
        ArrayList<Region> regions = this.buildable_regions;
        if (this.buildable_regions.size() >= 3) {
            regions = new ArrayList();
            for (int i = 2; i < this.buildable_regions.size(); ++i) {
                regions.add(this.buildable_regions.get(i));
            }
        }
        HashSet<TilePosition> tps = new HashSet<TilePosition>();
        for (Region b : regions) {
            LinkedList<TilePosition> q = new LinkedList<TilePosition>();
            q.add(new TilePosition(b.getCenter()));
            while (!q.isEmpty()) {
                TilePosition tp = (TilePosition)q.poll();
                tps.add(tp);
                for (TilePosition succ : Arrays.asList(tp.add(0, 1), tp.add(1, 0), tp.add(0, -1), tp.add(-1, 0))) {
                    if (tps.contains(succ) || q.contains(succ) || !b.contains(succ)) continue;
                    q.add(succ);
                }
            }
        }
        ArrayList<TilePosition> tr = new ArrayList<TilePosition>();
        for (TilePosition tp : tps) {
            if (this.master.mGame.isBuildable(tp.x(), tp.y()) && !(tp.getDistance(this.master.myHome) > 42.0)) continue;
            tr.add(tp);
        }
        tps.removeAll(tr);
        return tps;
    }

    public Set<TilePosition> banTiles(Set<TilePosition> raw_tiles) {
        HashSet<TilePosition> fresh_banned = new HashSet<TilePosition>();
        Set<TilePosition> building_buffer = this.get_building_buffer();
        for (TilePosition tp : raw_tiles) {
            this.filter_out_unwalkable_with_buffer(tp, fresh_banned);
            if (!this.filter_out_min_gas(tp) && !this.filter_out_choke(tp) && !this.filter_out_building_with_buffer(tp, building_buffer)) continue;
            fresh_banned.add(tp);
        }
        this.banned = fresh_banned;
        return fresh_banned;
    }

    private boolean filter_out_unwalkable_with_buffer(TilePosition tp, Set<TilePosition> fresh_banned) {
        if (!Utils.isWalkable(tp)) {
            fresh_banned.add(tp.add(-1, -1));
            fresh_banned.add(tp.add(-1, 0));
            fresh_banned.add(tp.add(-1, 1));
            fresh_banned.add(tp.add(0, -1));
            fresh_banned.add(tp.add(0, 0));
            fresh_banned.add(tp.add(0, 1));
            fresh_banned.add(tp.add(1, -1));
            fresh_banned.add(tp.add(1, 0));
            fresh_banned.add(tp.add(1, 1));
        }
        return false;
    }

    public TilePosition place(UnitType buildingtype, Collection<TilePosition> additional_ban) {
        Set<TilePosition> all_inbase_tiles = this.myBaseTiles();
        int k = all_inbase_tiles.size();
        Set<TilePosition> banned_tiles = this.banTiles(all_inbase_tiles);
        HashSet<TilePosition> after_ban1 = new HashSet<TilePosition>();
        for (TilePosition tp : all_inbase_tiles) {
            boolean _ban = false;
            if (banned_tiles.contains(tp)) {
                _ban = true;
            }
            if (additional_ban.contains(tp)) {
                _ban = true;
            }
            if (_ban) continue;
            after_ban1.add(tp);
        }
        HashSet<TilePosition> after_ban2 = new HashSet<TilePosition>();
        for (TilePosition tp1 : after_ban1) {
            if (this.filter_out_via_type(tp1, buildingtype, banned_tiles)) continue;
            after_ban2.add(tp1);
        }
        if (after_ban2.size() == 0) {
            if (this.growsThisFrame == 0) {
                this.grow();
                ++this.growsThisFrame;
                return this.place(buildingtype, additional_ban);
            }
            this.growsThisFrame = 0;
            Game.getInstance().printf("UH OH... no spot to build", new Object[0]);
            return TilePosition.INVALID;
        }
        this.growsThisFrame = 0;
        return this.find_closest_squared(after_ban2, this.get_building_buffer());
    }

    TilePosition find_closest_squared(Set<TilePosition> candidate, Set<TilePosition> stay_close_to_these) {
        TilePosition ret = null;
        double best = 2.147483647E9;
        for (TilePosition tp : candidate) {
            double score = 0.0;
            for (TilePosition close : stay_close_to_these) {
                score += tp.getDistance(close) * tp.getDistance(close);
            }
            if (!(score < best)) continue;
            best = score;
            ret = tp;
        }
        return ret;
    }

    TilePosition find_closest_squared(Set<TilePosition> candidate, List<TilePosition> stay_close_to_these) {
        TilePosition ret = null;
        double best = 2.147483647E9;
        for (TilePosition tp : candidate) {
            double score = 0.0;
            for (TilePosition close : stay_close_to_these) {
                score += tp.getDistance(close) * tp.getDistance(close);
            }
            if (!(score < best)) continue;
            best = score;
            ret = tp;
        }
        return ret;
    }

    public boolean filter_out_min_gas(TilePosition tp) {
        ArrayList<BaseLocation> bls = new ArrayList<BaseLocation>();
        bls.addAll(this.master.myBases);
        bls.addAll(this.extraBLs);
        for (BaseLocation bl : bls) {
            if (tp.getDistance(bl.getTilePosition()) < 3.5) {
                return true;
            }
            HashSet<? extends ROUnit> min_gas = new HashSet<ROUnit>();
            min_gas.addAll(bl.getGeysers());
            for (ROUnit rOUnit : bl.getMinerals()) {
                if (rOUnit.getResources() <= 0) continue;
                min_gas.add(rOUnit);
            }
            TilePosition cc_tp = bl.getTilePosition();
            for (ROUnit rOUnit : min_gas) {
                Vector mg_to_tp;
                Position mg_pos = rOUnit.getLastKnownPosition();
                Position cc_pos = new Position(cc_tp);
                double d = rOUnit.getDistance(cc_pos);
                if (rOUnit.getDistance(cc_pos) > 300.0 || mg_pos == Position.INVALID || cc_pos == Position.INVALID) continue;
                Position tp_pos = new Position(tp);
                Vector cc_to_tp = new Vector(cc_pos, tp_pos).normalize();
                if (cc_to_tp.dot(mg_to_tp = new Vector(mg_pos, tp_pos).normalize()) < -0.75) {
                    return true;
                }
                Position position = new Position(tp);
                if (!(position.getDistance(mg_pos) < 50.0)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean filter_out_choke(TilePosition tp) {
        for (BaseLocation bl : this.master.myBases) {
            Set<Chokepoint> chokepoints = bl.getRegion().getChokepoints();
            for (Chokepoint cp : chokepoints) {
                Position position = new Position(tp);
                if (!(cp.getCenter().getDistance(position) < 200.0)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<TilePosition> get_building_buffer() {
        HashSet<TilePosition> ret = new HashSet<TilePosition>(30);
        for (BuildingStatus bs : this.master.myBuildings) {
            if (bs.spot == null) {
                Game.getInstance().printf("Something is wrong... a " + bs.type + "is null...", new Object[0]);
                return ret;
            }
            int hight1 = bs.type.tileHeight() + 1;
            int width1 = bs.type.tileWidth() + 1;
            if (bs.type.equals(UnitType.TERRAN_COMMAND_CENTER) || bs.type.equals(UnitType.TERRAN_FACTORY) || bs.type.equals(UnitType.TERRAN_STARPORT)) {
                width1 += 2;
            }
            TilePosition spot = bs.spot;
            for (int x = 0; x < width1; ++x) {
                for (int y = 0; y < hight1; ++y) {
                    TilePosition toadd = new TilePosition(spot.x() + x, spot.y() + y);
                    ret.add(toadd);
                }
            }
        }
        return ret;
    }

    private boolean filter_out_building_with_buffer(TilePosition tp, Set<TilePosition> building_buffer) {
        return building_buffer.contains(tp);
    }

    private boolean filter_out_via_type(TilePosition tp, UnitType buildingtype, Set<TilePosition> banned_tiles) {
        if (this.master.mGame.isVisible(tp) && !this.master.getWorker().unit.canBuildHere(tp, buildingtype)) {
            return true;
        }
        if (buildingtype.equals(UnitType.TERRAN_FACTORY) || buildingtype.equals(UnitType.TERRAN_STARPORT)) {
            TilePosition shifted_right = new TilePosition(tp.x() + 2, tp.y());
            if (this.master.mGame.isVisible(tp) && !this.master.getWorker().unit.canBuildHere(shifted_right, buildingtype)) {
                return true;
            }
        }
        TilePosition[] required = new TilePosition[4];
        int width = buildingtype.tileWidth();
        int hight = buildingtype.tileHeight();
        if (buildingtype.equals(UnitType.TERRAN_COMMAND_CENTER) || buildingtype.equals(UnitType.TERRAN_FACTORY) || buildingtype.equals(UnitType.TERRAN_STARPORT)) {
            width += 2;
        }
        required[0] = tp;
        required[1] = new TilePosition(tp.x() + width, tp.y());
        required[2] = new TilePosition(tp.x(), tp.y() + hight);
        required[3] = new TilePosition(tp.x() + width, tp.y() + hight);
        for (TilePosition tp_req : required) {
            if (tp_req.x() < 0 || tp_req.y() < 0 || tp_req.x() > this.master.width - 1 || tp_req.y() > this.master.height - 1) {
                return true;
            }
            if (!banned_tiles.contains(tp_req)) continue;
            return true;
        }
        return false;
    }

    public void test() {
        Set<TilePosition> raw_tiles = this.myBaseTiles();
        Set<TilePosition> building_buffer = this.get_building_buffer();
        for (TilePosition tp : raw_tiles) {
            if (!(this.filter_out_min_gas(tp) || this.filter_out_choke(tp) || this.filter_out_building_with_buffer(tp, building_buffer))) {
                Game.getInstance().drawCircleMap(new Position(tp), 2, Color.GREEN, false);
            }
            if (!this.filter_out_min_gas(tp)) continue;
            Game.getInstance().drawCircleMap(new Position(tp), 5, Color.BLUE, false);
        }
    }

    public TilePosition placeTurret(UnitType buildingtype, Collection<TilePosition> additional_ban) {
        Set<TilePosition> all_inbase_tiles = this.myBaseTiles();
        int k = all_inbase_tiles.size();
        Set<TilePosition> banned_tiles = this.banTiles(all_inbase_tiles);
        HashSet<TilePosition> after_ban1 = new HashSet<TilePosition>();
        for (TilePosition tp : all_inbase_tiles) {
            boolean _ban = false;
            if (banned_tiles.contains(tp)) {
                _ban = true;
            }
            if (additional_ban.contains(tp)) {
                _ban = true;
            }
            if (_ban) continue;
            after_ban1.add(tp);
        }
        HashSet<TilePosition> after_ban2 = new HashSet<TilePosition>();
        for (TilePosition tp1 : after_ban1) {
            if (this.filter_out_via_type(tp1, buildingtype, banned_tiles)) continue;
            after_ban2.add(tp1);
        }
        HashSet<TilePosition> after_ban3 = new HashSet<TilePosition>();
        ArrayList<TilePosition> turrets = new ArrayList<TilePosition>();
        for (BuildingStatus bs : this.master.myBuildings) {
            if (bs.type != UnitType.TERRAN_MISSILE_TURRET || bs.status == 3) continue;
            turrets.add(bs.spot);
        }
        block3: for (TilePosition tp2 : after_ban2) {
            for (TilePosition turr : turrets) {
                if (!(turr.getDistance(tp2) < 6.0)) continue;
                continue block3;
            }
            after_ban3.add(tp2);
        }
        if (after_ban3.size() == 0) {
            after_ban3 = new HashSet();
            for (TilePosition tp2 : after_ban2) {
                TilePosition turr;
                Iterator i$ = turrets.iterator();
                while (i$.hasNext() && !((turr = (TilePosition)i$.next()).getDistance(tp2) < 3.0)) {
                    after_ban3.add(tp2);
                }
            }
        }
        if (after_ban3.size() == 0) {
            after_ban3 = after_ban2;
        }
        if (after_ban3.size() == 0) {
            if (this.growsThisFrame == 0) {
                this.grow();
                ++this.growsThisFrame;
                return this.place(buildingtype, additional_ban);
            }
            this.growsThisFrame = 0;
            Game.getInstance().printf("UH OH... no spot to build", new Object[0]);
            return TilePosition.INVALID;
        }
        this.growsThisFrame = 0;
        return this.find_closest_squared(after_ban3, this.get_building_buffer());
    }
}

