/*
 * Decompiled with CFR 0.152.
 */
package undermind.intelligence;

import edu.berkeley.nlp.starcraft.AbstractCerebrate;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.UnitType;
import undermind.GameEvaluator;
import undermind.intelligence.BaseStatus;
import undermind.intelligence.Hotspot;
import undermind.intelligence.RegionStatus;

public class IntelManager
extends AbstractCerebrate {
    public Random rgen = new Random();
    public Game mGame;
    public Player me;
    public Bwta bwta;
    public List<RegionStatus> regions;
    public List<Hotspot> hotspots;
    public List<BaseStatus> baseStatuses;
    public GameEvaluator master;

    public IntelManager(GameEvaluator m) {
        this.master = m;
        this.baseStatuses = new ArrayList<BaseStatus>();
    }

    @Override
    public void onFrame() {
        super.onFrame();
        for (RegionStatus rs : this.regions) {
            ++rs.age;
            rs.updateUnits();
            if (this.mGame.isVisible(new TilePosition(rs.region.getCenter()))) {
                rs.age = 0;
            }
            for (ROUnit u : rs.enemies) {
                this.mGame.drawTextMap(u.getLastKnownPosition(), u.getType().toString());
            }
        }
        this.computeHotspots();
        this.computeBaseStatus();
        for (BaseStatus bs : this.baseStatuses) {
            this.mGame.drawTextMap(bs.base.getPosition(), "" + bs.taken);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        this.mGame = Game.getInstance();
        this.me = this.mGame.self();
        this.bwta = Bwta.getInstance();
        this.regions = new ArrayList<RegionStatus>();
        this.hotspots = new ArrayList<Hotspot>();
        for (Region r : this.bwta.getRegions()) {
            this.regions.add(new RegionStatus(r));
        }
        for (BaseLocation bl : this.bwta.getBaseLocations()) {
            this.baseStatuses.add(new BaseStatus(bl));
        }
    }

    @Override
    public void onUnitDestroy(ROUnit unit) {
        super.onUnitDestroy(unit);
        if (unit.getPlayer() == this.me) {
            return;
        }
        for (RegionStatus rs : this.regions) {
            rs.removeUnit(unit);
        }
    }

    @Override
    public void onUnitShow(ROUnit unit) {
        super.onUnitShow(unit);
        if (unit.getPlayer().isEnemy(this.me)) {
            for (RegionStatus rs : this.regions) {
                if (!rs.region.contains(unit.getPosition())) continue;
                if (unit.getType().isWorker() || !unit.isVisible() && unit.isFlying() || !unit.getType().canAttack() && !unit.getType().equals(UnitType.TERRAN_BUNKER) && !unit.getType().isSpellcaster()) break;
                rs.addUnit(unit);
                break;
            }
        }
    }

    public void computeHotspots() {
        this.hotspots.clear();
        for (RegionStatus rs : this.regions) {
            if (rs.enemies.size() < 5) continue;
            Hotspot h = new Hotspot(UnitUtils.medianPos(rs.enemies), Utils.getValueRO(rs.enemies));
            h.region_status = rs;
            this.hotspots.add(h);
        }
    }

    public void computeBaseStatus() {
        for (BaseStatus bs : this.baseStatuses) {
            if (this.mGame.isVisible(bs.base.getTilePosition())) {
                bs.age = 0;
                bs.taken = 0;
                for (ROUnit rOUnit : this.mGame.unitsOnTile(bs.base.getTilePosition())) {
                    if (!rOUnit.getType().isResourceDepot()) continue;
                    if (rOUnit.getPlayer() == this.me) {
                        bs.taken = 1;
                        continue;
                    }
                    if (!rOUnit.getPlayer().isEnemy(this.me)) continue;
                    bs.taken = -1;
                }
            } else {
                ++bs.age;
            }
            for (ROUnit rOUnit : this.master.myMicro.enemyBuildings) {
                if (rOUnit.getType() != UnitType.TERRAN_BUNKER && !rOUnit.getType().canAttack() || !(rOUnit.getLastKnownPosition().getDistance(bs.base.getPosition()) < 500.0)) continue;
                bs.taken = -1;
            }
        }
    }

    public BaseLocation oldestBase() {
        int oldest = -1;
        BaseLocation ret = null;
        for (BaseStatus bs : this.baseStatuses) {
            if (this.mGame.getMapHash().equals("83320e505f35c65324e93510ce2eafbaa71c9aa1")) {
                int x = bs.base.getTilePosition().x();
                int y = bs.base.getTilePosition().y();
                if (x == 7 && y == 7 || x == 117 && y == 7 || x == 117 && y == 118 || x == 7 && y == 118) continue;
            }
            if (bs.age <= oldest || bs.base.isIsland() || bs.taken != 0) continue;
            oldest = bs.age;
            ret = bs.base;
        }
        return ret;
    }

    public TilePosition possibleEnemyExpo() {
        if (this.master.myMacro.enemyBases.size() == 0) {
            return null;
        }
        ArrayList<TilePosition> candidates = new ArrayList<TilePosition>();
        for (BaseStatus bs : this.baseStatuses) {
            if (bs.age <= 4000 || bs.taken != 0 || this.mGame.isVisible(bs.base.getTilePosition())) continue;
            candidates.add(bs.base.getTilePosition());
        }
        TilePosition chosenbase = this.master.myMacro.enemyBases.get(this.rgen.nextInt(this.master.myMacro.enemyBases.size())).getLastKnownTilePosition();
        TilePosition best = null;
        double bestd = Double.POSITIVE_INFINITY;
        for (TilePosition tp : candidates) {
            double d = tp.getDistance(chosenbase);
            if (!(d < bestd)) continue;
            bestd = d;
            best = tp;
        }
        return best;
    }

    public BaseLocation oldestBaseWithIslands() {
        int oldest = -1;
        BaseLocation ret = null;
        for (BaseStatus bs : this.baseStatuses) {
            if (bs.age <= oldest || bs.taken != 0) continue;
            oldest = bs.age;
            ret = bs.base;
        }
        return ret;
    }
}

