/*
 * Decompiled with CFR 0.152.
 */
package undermind.intelligence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TilePosition;
import undermind.AStarSearch;

public class Convoy {
    public AStarSearch pathfinder = new AStarSearch();
    public List<TilePosition> pathToGoal;
    public Set<ROUnit> enemies = new HashSet<ROUnit>();
    public TilePosition lastEnd;

    public void setConvoy(Position start, Position end) {
        TilePosition s = new TilePosition(start);
        TilePosition t = new TilePosition(end);
        this.lastEnd = new TilePosition(end);
        this.pathToGoal = this.pathfinder.getPath(s, t);
    }

    public void register(ROUnit rou) {
        Position p = rou.isVisible() ? rou.getPosition() : rou.getLastKnownPosition();
        double dist = this.getClosest(new TilePosition(p), this.pathToGoal);
        if (dist < 12.0) {
            this.enemies.add(rou);
        }
    }

    public double getClosest(TilePosition tp, Collection<TilePosition> tps) {
        double dist = 2.147483647E9;
        for (TilePosition tp2 : tps) {
            if (!(tp.getDistance(tp2) < dist)) continue;
            dist = tp.getDistance(tp2);
        }
        return dist;
    }

    private Set<ROUnit> migrate(List<TilePosition> pathToGoal2, Set<ROUnit> old_enemies) {
        for (ROUnit rou : old_enemies) {
            this.register(rou);
        }
        return null;
    }

    public void addUnit(ROUnit u) {
        if (!this.enemies.contains(u)) {
            this.enemies.add(u);
        }
    }

    public void removeUnit(ROUnit u) {
        ROUnit tr = null;
        for (ROUnit u2 : this.enemies) {
            if (u.getID() != u2.getID()) continue;
            tr = u2;
        }
        if (tr != null) {
            this.enemies.remove(tr);
        }
    }

    public void updateUnits() {
        ArrayList<ROUnit> tr = new ArrayList<ROUnit>();
        for (ROUnit u : this.enemies) {
            if (!Game.getInstance().isVisible(u.getLastKnownTilePosition()) || u.isVisible()) continue;
            tr.add(u);
        }
        this.enemies.removeAll(tr);
    }

    public void onFrame() {
        this.updateUnits();
    }
}

