/*
 * Decompiled with CFR 0.152.
 */
package undermind;

import java.util.ArrayList;
import java.util.List;
import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.AStarSearch;
import undermind.MicroManager;
import undermind.micropacket.DefensiveSquad;
import undermind.micropacket.Squad;

public class ScoutingManager {
    public List<Unit> scouts = new ArrayList<Unit>();
    public MicroManager master;
    public BaseLocation nextBL;
    long time = 0L;
    long lastDeath = 0L;
    public AStarSearch pathfinder = new AStarSearch();

    public ScoutingManager(MicroManager m) {
        this.master = m;
    }

    public void onFrame() {
        ++this.time;
        if (this.nextBL != null) {
            this.master.mGame.drawTextMap(this.nextBL.getPosition(), "scout next");
        }
        if (this.scouts.size() == 0 && this.master.allArmy.size() > 16 && this.master.time % 500L < 3L && this.time - this.lastDeath > 5000L) {
            this.newScout();
        }
        this.doScouting();
    }

    public void doScouting() {
        for (Unit s : this.scouts) {
            if (this.master.time % 5L != 0L) {
                return;
            }
            this.master.mGame.drawCircleMap(s.getPosition(), 12, Color.PURPLE, false);
            ROUnit harassTarget = null;
            for (ROUnit e : this.master.allVisibleEnemies) {
                if (e.getType().isBuilding() && harassTarget == null) {
                    harassTarget = e;
                    continue;
                }
                if (e.getDistance(s) < 200 && (e.getType().isWorker() || e.getType() == UnitType.ZERG_OVERLORD && s.getType() == UnitType.TERRAN_MARINE)) {
                    harassTarget = e;
                    continue;
                }
                if (e.getDistance(s) >= 300 || !e.getType().canAttack() || e.getType().isWorker()) continue;
                harassTarget = null;
                break;
            }
            boolean mine = true;
            if (this.master.posseexp != null && this.master.posseexp != TilePosition.INVALID) {
                for (ROUnit rOUnit : this.master.mGame.unitsOnTile(this.master.posseexp)) {
                    if (!rOUnit.getType().isBuilding()) continue;
                    mine = false;
                }
            }
            if (this.master.posseexp != null && this.master.posseexp != TilePosition.INVALID && this.master.posseexp.getDistance(s.getTilePosition()) < 7.0 && s.getType() == UnitType.TERRAN_VULTURE && s.getSpiderMineCount() != 0 && mine) {
                s.useTech(TechType.SPIDER_MINES, Position.centerOfTile(this.master.posseexp));
                continue;
            }
            if (harassTarget != null) {
                if (this.master.time % 50L != 0L) continue;
                s.attack(harassTarget);
                continue;
            }
            this.pathfinder.makeUnitPath(s, this.nextBL.getTilePosition());
        }
    }

    public void newScout() {
        System.out.println("got new scout");
        int a = -1;
        for (int i = this.master.allArmy.size() - 1; i >= 0; --i) {
            Unit u = this.master.allArmy.get(i);
            if (u.getType() != UnitType.TERRAN_MARINE && u.getType() != UnitType.TERRAN_VULTURE) continue;
            for (Squad s : this.master.squads) {
                s.removeUnit(u);
            }
            for (DefensiveSquad ds : this.master.dSquads) {
                ds.removeUnit(u);
            }
            this.scouts.add(u);
            a = i;
            break;
        }
        if (a != -1) {
            this.master.allArmy.remove(a);
        }
    }

    public void removeScout(ROUnit s) {
        Unit tr = null;
        for (Unit sc : this.scouts) {
            if (s.getID() != sc.getID()) continue;
            tr = sc;
        }
        if (tr != null) {
            this.scouts.remove(tr);
            this.lastDeath = this.time;
        }
    }
}

