/*
 * Decompiled with CFR 0.152.
 */
package undermind;

import edu.berkeley.nlp.starcraft.AbstractCerebrate;
import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.Strategy;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.model.WeaponType;
import org.bwapi.proxy.util.Pair;
import undermind.DropSearch;
import undermind.ScoutingManager;
import undermind.intelligence.Hotspot;
import undermind.intelligence.RegionStatus;
import undermind.micropacket.DefensiveSquad;
import undermind.micropacket.DropSquad;
import undermind.micropacket.DroppedUnits;
import undermind.micropacket.M3chSquad;
import undermind.micropacket.MarineSquad;
import undermind.micropacket.Squad;

public class MicroManager
extends AbstractCerebrate
implements Strategy {
    public double confidence;
    public boolean lurkers;
    public UnitType dropType = UnitType.TERRAN_VULTURE;
    public int dropQuantity = 4;
    public List<Unit> freeGuys = new ArrayList<Unit>();
    public TilePosition suggestedDropSpot = null;
    public List<Unit> idleDropships = new ArrayList<Unit>();
    public Set<ROUnit> reinforcementThreat;
    public Position pleaseEbayHere;
    ScoutingManager scouter;
    public boolean mechStrat;
    public ArrayList<ROUnit> unitsBeingCreated = new ArrayList();
    final List<ROUnit> armyList = new ArrayList<ROUnit>();
    List<Unit> allArmy = new ArrayList<Unit>();
    public final List<ROUnit> allVisibleEnemies = new ArrayList<ROUnit>();
    public final List<ROUnit> enemyBuildings;
    final List<Unit> wraiths = new ArrayList<Unit>();
    final List<Unit> vessels = new ArrayList<Unit>();
    final ArrayList<Squad> squads = new ArrayList();
    final ArrayList<DefensiveSquad> dSquads = new ArrayList();
    public Game mGame;
    public boolean debug;
    Unit dbldg;
    public int boccs = 0;
    public TilePosition posseexp;
    public boolean retreating = false;
    public List<DropSquad> droppers = new ArrayList<DropSquad>();
    public DropSearch dropSearch;
    public boolean fightWithTurret = false;
    public int attackersValue;
    public Unit ebay;
    public int ebaytargetted = 30;
    public int ebayoldhp;
    private Player me;
    public Position medianpos;
    Position focalPoint;
    Position defensiveFocalPoint;
    Random rgen = new Random();
    boolean defend = false;
    double defendDistance = 800.0;
    boolean aird;
    public long time;
    public boolean stolegas = false;
    public Hotspot hotspot;
    public List<RegionStatus> regionStatuses;
    Position dposition;
    public Position pleaseScanHere;
    int defensivesiege;
    int failsafe = 0;
    int whenattack;
    int wao = this.whenattack = 30;
    public Unit myBunker = null;

    @Override
    public List<Cerebrate> getTopLevelCerebrates() {
        return null;
    }

    public MicroManager() {
        this.enemyBuildings = new ArrayList<ROUnit>();
        this.scouter = new ScoutingManager(this);
        this.dropSearch = new DropSearch(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFrame() {
        if (this.boccs >= 2 && this.time % 100L == 0L) {
            for (ROUnit bunk : UnitUtils.getAllMy(UnitType.TERRAN_BUNKER)) {
                for (ROUnit rOUnit : bunk.getLoadedUnits()) {
                    this.assignSquad(UnitUtils.assumeControl(rOUnit));
                }
                UnitUtils.assumeControl(bunk).unloadAll();
            }
        }
        if (this.hotspot != null && this.hotspot.pos != null) {
            this.mGame.drawCircleMap(this.hotspot.pos, 10, Color.YELLOW, false);
        }
        ArrayList<ROUnit> tr = new ArrayList<ROUnit>();
        for (ROUnit rOUnit : this.unitsBeingCreated) {
            if (!rOUnit.isCompleted()) continue;
            this.onUnitSpawn(rOUnit);
            tr.add(rOUnit);
        }
        for (ROUnit rOUnit : tr) {
            this.unitsBeingCreated.remove(rOUnit);
        }
        if (this.debug) {
            int i;
            for (DefensiveSquad defensiveSquad : this.dSquads) {
                this.mGame.drawCircleMap(defensiveSquad.goal, 8, Color.YELLOW, true);
            }
            for (i = 0; i < this.squads.size(); ++i) {
                this.mGame.drawTextScreen(0, 100 + i * 15, this.squads.get((int)i).myUnits.toString());
            }
            for (i = 0; i < this.dSquads.size(); ++i) {
                this.mGame.drawTextScreen(0, 200 + i * 15, this.dSquads.get((int)i).myUnits.toString());
            }
        }
        this.squadManagement();
        this.setupDrops();
        ++this.time;
        if (this.debug && this.dposition != null) {
            this.mGame.drawTextMap(this.dposition, "dpos");
        }
        this.bookkeeping();
        this.computeMedianPosition();
        this.setParameters();
        this.scouter.onFrame();
        if (this.focalPoint == null || this.focalPoint.x() == -1) {
            ++this.failsafe;
            for (Unit unit : this.allArmy) {
                if (unit.isSieged()) {
                    unit.unsiege();
                }
                if (this.failsafe > 1000) {
                    unit.stop();
                    continue;
                }
                if (!unit.getTargetPosition().equals(this.focalPoint) && !unit.isStopped()) continue;
                this.failsafe = 0;
                int n = this.rgen.nextInt(this.mGame.getMapWidth() * 32);
                int y = this.rgen.nextInt(this.mGame.getMapHeight() * 32);
                unit.move(new Position(n, y));
                if (!(UnitUtils.getClosestDistance(unit, this.allArmy) > 300.0)) continue;
                this.pleaseScanHere = new Position(n, y);
            }
        } else {
            for (Unit unit : this.allArmy) {
                Unit unit2 = unit;
                ROUnit closestEnemy = UnitUtils.getClosest(unit2, this.allVisibleEnemies);
                if (closestEnemy == null || closestEnemy.isDetected()) continue;
                this.pleaseScanHere = closestEnemy.getPosition();
            }
        }
        this.attackersValue = 0;
        this.aird = false;
        if (this.dbldg == null || this.dbldg.getLastKnownPosition().x() == -1) {
            DefensiveSquad removeMe = null;
            for (DefensiveSquad defensiveSquad : this.dSquads) {
                ROUnit closestE = UnitUtils.getClosest(defensiveSquad.goal, this.allVisibleEnemies);
                if (closestE != null && !(closestE.getDistance(defensiveSquad.goal) > 300.0)) continue;
                removeMe = defensiveSquad;
            }
            if (removeMe != null) {
                for (Unit unit : removeMe.myUnits) {
                    this.assignSquad(unit);
                }
                this.dSquads.remove(removeMe);
            }
        } else if (this.allArmy.size() != 0) {
            void var3_22;
            this.dposition = this.dbldg.getLastKnownPosition();
            DefensiveSquad defendingSquad = null;
            boolean bl = false;
            this.fightWithTurret = false;
            double d = 0.0;
            double stealthValue = 0.0;
            for (ROUnit u : this.allVisibleEnemies) {
                if (u.getDistance(this.dposition) < 450.0) {
                    ++var3_22;
                    if (u.getType() == UnitType.ZERG_MUTALISK) {
                        this.attackersValue += 150;
                        d += 150.0;
                    } else {
                        if (u.getType().isFlyer() && u.getType().canAttack()) {
                            d += (double)u.getType().mineralPrice();
                            d += (double)(u.getType().gasPrice() * 2);
                        }
                        if (u.isCloaked() && u.getType().canAttack()) {
                            stealthValue += (double)u.getType().mineralPrice();
                            stealthValue += (double)(u.getType().gasPrice() * 2);
                        }
                        this.attackersValue += u.getType().mineralPrice();
                        this.attackersValue += u.getType().gasPrice() * 2;
                        if (this.dbldg.getType() == UnitType.TERRAN_COMMAND_CENTER) {
                            this.attackersValue += 250;
                        }
                    }
                }
                if ((u.getType().canAttack() || u.getType().isSpellcaster()) && u.getType().isFlyer()) {
                    this.aird = true;
                }
                if (!(stealthValue >= (double)this.attackersValue / 3.0) || UnitUtils.getAllMy(UnitType.TERRAN_COMSAT_STATION).size() != 0) continue;
                this.fightWithTurret = true;
            }
            List<ROUnit> turrets = UnitUtils.getAllMy(UnitType.TERRAN_MISSILE_TURRET);
            if (turrets.size() != 0 && this.fightWithTurret) {
                this.dbldg = UnitUtils.assumeControl(UnitUtils.getClosest(this.dposition, turrets));
                this.dposition = this.dbldg.getLastKnownPosition();
            }
            for (DefensiveSquad ds : this.dSquads) {
                ROUnit closestE = UnitUtils.getClosest(ds.goal, this.allVisibleEnemies);
                if (closestE != null && !(closestE.getDistance(ds.goal) > 300.0)) continue;
                ds.setGoal(this.dposition);
            }
            for (DefensiveSquad ds : this.dSquads) {
                if (!ds.goal.equals(this.dposition) && !(this.dposition.getDistance(ds.goal) < 450.0)) continue;
                defendingSquad = ds;
                defendingSquad.setGoal(this.dposition);
                break;
            }
            if (defendingSquad == null) {
                System.out.println("new defensive squad");
                defendingSquad = new DefensiveSquad(this, this.dposition);
                this.dSquads.add(defendingSquad);
            }
            for (int i = this.allArmy.size() - 1; i >= 0; --i) {
                boolean skip = false;
                int dValue = 0;
                Unit unit = this.allArmy.get(i);
                if (unit.getDistance(defendingSquad.goal) > 800.0) {
                    skip = true;
                }
                for (DefensiveSquad ds : this.dSquads) {
                    if (ds.hasUnit(unit)) {
                        skip = true;
                    }
                    dValue = (int)((double)dValue + this.getValue(ds.myUnits));
                }
                if (var3_22 > 8 && (double)dValue >= 1.3 * (double)this.attackersValue || var3_22 <= 8 && (defendingSquad.myUnits.size() >= 16 || this.getValue(defendingSquad.myUnits) >= 600.0)) break;
                if (skip || unit.isLoaded() || defendingSquad.hasUnit(unit) || unit.getDistance(this.dposition) > 1200.0 || unit.getType().airWeapon().equals(WeaponType.NONE) && d >= (double)this.attackersValue * 0.85) continue;
                defendingSquad.addUnit(unit);
                for (Squad s : this.squads) {
                    s.removeUnit(unit);
                }
            }
        }
        long starttime = System.currentTimeMillis();
        for (DefensiveSquad ds : this.dSquads) {
            ds.onFrame();
        }
        this.ebayMicro();
    }

    public void setParameters() {
        ArrayList<Unit> nearHotspot = new ArrayList<Unit>();
        for (Unit u : this.allArmy) {
            if (!(u.getDistance(this.hotspot.pos) < 700.0)) continue;
            nearHotspot.add(u);
        }
    }

    public void ebayMicro() {
        --this.ebaytargetted;
        if (this.ebay != null) {
            if (this.ebay.getTargetPosition() != null) {
                this.mGame.drawLineMap(this.ebay.getPosition(), this.ebay.getTargetPosition(), Color.WHITE);
            }
            if (this.ebay.isLifted() && this.hotspot != null && this.hotspot.pos != Position.INVALID) {
                Position pos = Position.INVALID;
                for (Squad s : this.squads) {
                    if (!s.unitTypes.contains(UnitType.TERRAN_SIEGE_TANK_TANK_MODE) || !s.locked || s.myUnits.size() <= 1) continue;
                    pos = UnitUtils.medianPos(s.myUnits);
                    break;
                }
                if (pos == Position.INVALID) {
                    for (Squad s : this.squads) {
                        if (!s.unitTypes.contains(UnitType.TERRAN_SIEGE_TANK_TANK_MODE) || s.myUnits.size() <= 1) continue;
                        pos = UnitUtils.medianPos(s.myUnits);
                        break;
                    }
                }
                if (pos == Position.INVALID) {
                    this.ebay.move(this.defensiveFocalPoint);
                } else {
                    for (ROUnit un : this.allVisibleEnemies) {
                        if (!(un.getTarget() != null && un.getTarget().getID() == this.ebay.getID() || un.getOrderTarget() != null && un.getOrderTarget().getID() == this.ebay.getID()) && this.ebayoldhp <= this.ebay.getHitPoints() + 2) continue;
                        this.ebaytargetted = 30;
                    }
                    if (this.ebay.getDistance(pos) > 400.0 || this.ebaytargetted > 0) {
                        this.ebay.move(pos);
                    } else {
                        Position target = Position.midPoint(new Pair<Position, Position>(pos, this.hotspot.pos));
                        if (this.pleaseEbayHere != null && this.pleaseEbayHere != Position.INVALID) {
                            target = this.pleaseEbayHere;
                        }
                        this.ebay.move(target);
                    }
                }
            } else if ((this.allArmy.size() >= 5 || this.ebay.getHitPoints() < 450) && UnitUtils.getAllMy(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE).size() > 2 && this.mechStrat) {
                this.ebay.lift();
            }
            this.ebayoldhp = this.ebay.getHitPoints();
        }
    }

    public void squadManagement() {
        long starttime = System.currentTimeMillis();
        DropSquad r = null;
        for (DropSquad d : this.droppers) {
            if ((!d.beenfull || d.squad.size() != 0) && d.droptime <= 3000) continue;
            r = d;
            break;
        }
        if (r != null) {
            this.droppers.remove(r);
        }
        Squad tr = null;
        for (Squad s : this.squads) {
            if (!s.locked || s.myUnits.size() != 0) continue;
            tr = s;
        }
        if (tr != null) {
            this.squads.remove(tr);
        }
        DefensiveSquad tr2 = null;
        for (DefensiveSquad s : this.dSquads) {
            if (!s.locked || s.myUnits.size() != 0) continue;
            tr2 = s;
        }
        if (tr2 != null) {
            this.dSquads.remove(tr2);
        }
        if (this.time % 10L == 0L && !this.stolegas && this.boccs < 2) {
            block3: for (ROUnit bunker : UnitUtils.getAllMy(UnitType.TERRAN_BUNKER)) {
                if (bunker.getLoadedUnits().size() == 4 || !bunker.isCompleted()) continue;
                int alreadyGoing = 0;
                for (Unit u : this.allArmy) {
                    if ((u.getTarget() == null || u.getTarget().getID() != bunker.getID()) && (u.getOrderTarget() == null || u.getOrderTarget().getID() != bunker.getID())) continue;
                    ++alreadyGoing;
                }
                if (alreadyGoing >= 4 - bunker.getLoadedUnits().size()) continue;
                for (Squad s : this.squads) {
                    boolean gotMarine = false;
                    if (!s.acceptsType(UnitType.TERRAN_MARINE)) continue;
                    for (Unit u : s.myUnits) {
                        if (u.getType() != UnitType.TERRAN_MARINE || !u.isCompleted() || u.isLoaded()) continue;
                        u.load(bunker);
                        s.removeUnit(u);
                        gotMarine = true;
                        break;
                    }
                    if (!gotMarine) continue;
                    continue block3;
                }
            }
        }
        for (int a = 0; a < this.squads.size(); ++a) {
            for (int b = 0; b < this.squads.size(); ++b) {
                if (a >= this.squads.size() || b >= this.squads.size()) continue;
                Squad s1 = this.squads.get(a);
                Squad s2 = this.squads.get(b);
                Position m1 = UnitUtils.medianPos(s1.myUnits);
                Position m2 = UnitUtils.medianPos(s2.myUnits);
                if (s1 == s2 || m1 == null || m2 == null || m1 == Position.INVALID || m2 == Position.INVALID || !(m1.getDistance(m2) < 300.0) || !s1.type.equals(s2.type) || s1.size() + s2.size() >= 50) continue;
                this.merge(a, b);
            }
        }
        if (this.time % 3L == 0L) {
            for (Squad s : this.squads) {
                if (!s.locked && this.dbldg != null && this.dbldg.getLastKnownTilePosition().x() != -1) {
                    s.setGoal(this.dbldg.getLastKnownPosition());
                } else {
                    boolean k = false;
                    if (this.focalPoint != null && this.focalPoint != Position.INVALID && s.locked) {
                        s.setGoal(Utils.nearestWalkablePosition(new TilePosition(this.focalPoint)));
                        this.mGame.drawTextMap(this.focalPoint, "FOCAL");
                    } else if (this.defensiveFocalPoint != null) {
                        s.setGoal(Utils.nearestWalkablePosition(new TilePosition(this.defensiveFocalPoint)));
                    }
                }
                s.onFrame();
            }
        }
        for (DropSquad d : this.droppers) {
            d.onFrame();
        }
        for (int i = 0; i < this.squads.size(); ++i) {
            Squad s = this.squads.get(i);
            if (s.locked || !this.shouldLock(i)) continue;
            s.locked = true;
            System.out.println("locked squad " + i);
        }
    }

    public void assignSquad(Unit u) {
        boolean added = false;
        UnitType type = u.getType();
        for (int i = 0; i < this.squads.size(); ++i) {
            Squad s = this.squads.get(i);
            if (!s.acceptsType(type) || u.getType() == UnitType.TERRAN_SIEGE_TANK_TANK_MODE && !s.type.equals("mech")) continue;
            s.addUnit(u);
            added = true;
            break;
        }
        if (!added) {
            System.out.println("new O squad");
            if (type == UnitType.TERRAN_MARINE || type == UnitType.TERRAN_MEDIC || (type == UnitType.TERRAN_SIEGE_TANK_TANK_MODE || type == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) && this.lurkers) {
                MarineSquad ms = new MarineSquad(this);
                ms.addUnit(u);
                this.squads.add(ms);
            } else if ((type == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || type == UnitType.TERRAN_SIEGE_TANK_TANK_MODE || type == UnitType.TERRAN_GOLIATH || type == UnitType.TERRAN_VULTURE) && this.mechStrat) {
                M3chSquad ms = new M3chSquad(this);
                ms.addUnit(u);
                this.squads.add(ms);
            }
            if (type == UnitType.TERRAN_SCIENCE_VESSEL) {
                if (this.mechStrat) {
                    M3chSquad ms = new M3chSquad(this);
                    ms.addUnit(u);
                    this.squads.add(ms);
                } else {
                    MarineSquad ms = new MarineSquad(this);
                    ms.addUnit(u);
                    this.squads.add(ms);
                }
            }
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        this.mGame = Game.getInstance();
        this.me = this.mGame.self();
    }

    @Override
    public void onUnitCreate(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        super.onUnitCreate(unit);
    }

    @Override
    public void onUnitRenegade(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        super.onUnitRenegade(unit);
        this.onUnitDestroy(unit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUnitDestroy(ROUnit unit) {
        Unit toRem;
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        super.onUnitDestroy(unit);
        UnitType t = unit.getType();
        Unit tr = null;
        if (t == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || t == UnitType.TERRAN_SIEGE_TANK_TANK_MODE || t == UnitType.TERRAN_VULTURE || t == UnitType.TERRAN_MARINE || t == UnitType.TERRAN_GOLIATH || t == UnitType.TERRAN_MEDIC || t == UnitType.TERRAN_SCIENCE_VESSEL) {
            for (Unit unit2 : this.allArmy) {
                if (unit.getID() != unit2.getID()) continue;
                tr = unit2;
                break;
            }
            this.scouter.removeScout(unit);
            for (DropSquad dropSquad : this.droppers) {
                Unit rem = null;
                for (Unit u : dropSquad.squad.myUnits) {
                    if (u.getID() != unit.getID()) continue;
                    rem = u;
                    break;
                }
                if (rem == null) continue;
                dropSquad.squad.removeUnit(rem);
            }
        }
        if (tr != null) {
            this.allArmy.remove(tr);
            this.armyList.remove(tr);
            for (Squad squad : this.squads) {
                squad.removeUnit(tr);
            }
            for (DefensiveSquad defensiveSquad : this.dSquads) {
                defensiveSquad.removeUnit(tr);
            }
        }
        if (t == UnitType.TERRAN_WRAITH && unit.getPlayer() == this.me) {
            toRem = null;
            for (Unit s : this.wraiths) {
                if (s.getID() != unit.getID()) continue;
                toRem = s;
            }
            if (toRem != null) {
                this.wraiths.remove(toRem);
            }
        }
        if (t == UnitType.TERRAN_SCIENCE_VESSEL && unit.getPlayer() == this.me) {
            toRem = null;
            for (Unit s : this.vessels) {
                if (s.getID() != unit.getID()) continue;
                toRem = s;
            }
            if (toRem != null) {
                this.vessels.remove(toRem);
            }
        }
        if (unit.getPlayer() == this.me && t == UnitType.TERRAN_DROPSHIP) {
            void var5_19;
            DropSquad r = null;
            for (DropSquad d : this.droppers) {
                if (d.dropship.getID() != unit.getID()) continue;
                r = d;
                break;
            }
            if (r != null) {
                this.droppers.remove(r);
            }
            Object var5_17 = null;
            for (Unit d : this.idleDropships) {
                if (d.getID() != unit.getID()) continue;
                Unit unit3 = d;
                break;
            }
            if (var5_19 != null) {
                this.idleDropships.remove(var5_19);
            }
        }
        if (t == UnitType.TERRAN_ENGINEERING_BAY && unit.getPlayer() == this.me && this.ebay != null && unit.getID() == this.ebay.getID()) {
            this.ebay = null;
        }
        if (unit.getPlayer() != this.me) {
            for (ROUnit rOUnit : this.allVisibleEnemies) {
                if (unit.getID() != rOUnit.getID()) continue;
                this.allVisibleEnemies.remove(rOUnit);
                break;
            }
            for (ROUnit rOUnit : this.enemyBuildings) {
                if (unit.getID() != rOUnit.getID()) continue;
                this.enemyBuildings.remove(rOUnit);
                break;
            }
        }
    }

    @Override
    public void onUnitHide(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        UnitType t = unit.getType();
        if (unit.getPlayer() != this.me && t.canAttack()) {
            this.allVisibleEnemies.remove(unit);
        }
    }

    @Override
    public void onUnitMorph(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        UnitType t = unit.getType();
        if (unit.getPlayer() != this.me && t.isBuilding() && !this.enemyBuildings.contains(unit) && !t.isNeutral() && t != UnitType.SPECIAL_PROTOSS_TEMPLE) {
            this.enemyBuildings.add(unit);
        }
    }

    @Override
    public void onUnitShow(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        if (unit.getPlayer().equals(this.me)) {
            this.unitsBeingCreated.add(unit);
        }
        UnitType t = unit.getType();
        if (unit.getPlayer() == this.me && t == UnitType.TERRAN_BUNKER) {
            this.myBunker = UnitUtils.assumeControl(unit);
        }
        if (unit.getPlayer() != this.me && (t.canAttack() || t == UnitType.PROTOSS_SHUTTLE || t == UnitType.TERRAN_DROPSHIP || t.isSpellcaster() && !t.isBuilding() || t == UnitType.TERRAN_BUNKER)) {
            boolean a = true;
            for (ROUnit u : this.allVisibleEnemies) {
                if (u.getID() != unit.getID()) continue;
                a = false;
            }
            if (a) {
                this.allVisibleEnemies.add(unit);
            }
        }
        if (unit.getPlayer() != this.me && t.isBuilding() && !this.enemyBuildings.contains(unit) && !t.isNeutral() && t != UnitType.SPECIAL_PROTOSS_TEMPLE) {
            this.enemyBuildings.add(unit);
        }
        if (unit.getPlayer() == this.me && t == UnitType.TERRAN_WRAITH) {
            this.wraiths.add(UnitUtils.assumeControl(unit));
        }
        if (unit.getPlayer() == this.me && t == UnitType.TERRAN_SCIENCE_VESSEL) {
            this.vessels.add(UnitUtils.assumeControl(unit));
        }
    }

    public void onUnitSpawn(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        UnitType t = unit.getType();
        if (unit.getPlayer() == this.me && (t == UnitType.TERRAN_SIEGE_TANK_TANK_MODE || t == UnitType.TERRAN_VULTURE || t == UnitType.TERRAN_MARINE || t == UnitType.TERRAN_GOLIATH || t == UnitType.TERRAN_MEDIC || t == UnitType.TERRAN_SCIENCE_VESSEL)) {
            Unit u = UnitUtils.assumeControl(unit);
            this.allArmy.add(u);
            this.armyList.add(unit);
            this.assignSquad(u);
        }
        if (unit.getPlayer() == this.me && t == UnitType.TERRAN_DROPSHIP) {
            this.idleDropships.add(UnitUtils.assumeControl(unit));
        }
        if (unit.getPlayer() == this.me && t == UnitType.TERRAN_ENGINEERING_BAY && (this.ebay == null || this.ebay.getPosition().x() != -1)) {
            this.ebay = UnitUtils.assumeControl(unit);
        }
    }

    public void bookkeeping() {
        --this.defensivesiege;
        if (this.allVisibleEnemies.size() <= 3 && this.defensivesiege <= -100) {
            this.defensivesiege = 400;
        }
        ROUnit tre = null;
        for (ROUnit u : this.allVisibleEnemies) {
            if (u.getPosition().x() != -1) continue;
            tre = u;
            break;
        }
        if (tre != null) {
            this.allVisibleEnemies.remove(tre);
        }
        ROUnit tr2 = null;
        for (ROUnit u : this.enemyBuildings) {
            if (u.getType() != UnitType.RESOURCE_VESPENE_GEYSER) continue;
            tr2 = u;
            break;
        }
        if (tr2 != null) {
            this.enemyBuildings.remove(tr2);
        }
        Unit removeMe = null;
        this.failsafe = 0;
        for (Unit u : this.allArmy) {
            Position p = u.getPosition();
            if (p.x() != -1) continue;
            removeMe = u;
        }
        if (removeMe != null) {
            this.allArmy.remove(removeMe);
        }
        ArrayList<ROUnit> toRemove = new ArrayList<ROUnit>();
        for (ROUnit b : this.enemyBuildings) {
            if (!this.mGame.isVisible(new TilePosition(b.getLastKnownPosition())) || b.getPosition().x() != -1) continue;
            toRemove.add(b);
        }
        for (ROUnit u : toRemove) {
            this.enemyBuildings.remove(u);
        }
    }

    public void computeMedianPosition() {
        this.medianpos = null;
        ArrayList<Unit> alist = new ArrayList<Unit>();
        for (Unit u : this.allArmy) {
            if (this.debug) {
                this.mGame.drawTextMap(u.getPosition(), u.getID() + "");
            }
            for (int i = 0; i < this.squads.size(); ++i) {
                Squad s = this.squads.get(i);
                if (!s.myUnits.contains(u)) continue;
                if (s.locked) {
                    this.mGame.drawCircleMap(u.getPosition(), 3, Color.RED, false);
                } else {
                    this.mGame.drawCircleMap(u.getPosition(), 3, Color.GREEN, false);
                }
                this.mGame.drawTextMap(u.getPosition(), i + "");
            }
            if (u.isLoaded()) continue;
            alist.add(u);
        }
        if (alist.size() > 1) {
            this.medianpos = UnitUtils.medianPos(alist);
        }
        if (this.focalPoint != null && this.debug) {
            this.mGame.drawCircleMap(this.focalPoint, 5, Color.GREEN, true);
        }
        int spec = 0;
        for (Unit uz : this.allArmy) {
            if (uz.getType() == UnitType.TERRAN_MARINE && uz.isLoaded()) continue;
            ++spec;
        }
        if (spec < 2) {
            this.medianpos = Position.centerOfTile(this.mGame.self().getStartLocation());
        }
    }

    public int getPriority(ROUnit u, Unit me, boolean harass) {
        UnitType t = u.getType();
        int bonus = 0;
        if (u.getHitPoints() < u.getType().maxHitPoints() / 2) {
            bonus = 1;
        }
        if (harass) {
            if (t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE || t == UnitType.PROTOSS_PROBE || t == UnitType.PROTOSS_OBSERVER) {
                return 10;
            }
            return 2 + bonus;
        }
        if (t == UnitType.PROTOSS_INTERCEPTOR) {
            return -10;
        }
        if (t == UnitType.ZERG_SPORE_COLONY || t == UnitType.PROTOSS_PHOTON_CANNON || t == UnitType.TERRAN_BUNKER || t == UnitType.TERRAN_MISSILE_TURRET) {
            return -1;
        }
        if (t.isFlyer()) {
            if (t.canAttack()) {
                return 8 + bonus;
            }
            return 5 + bonus;
        }
        if (t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE || t == UnitType.PROTOSS_PROBE) {
            return 2 + bonus;
        }
        if (u.canAttack(me)) {
            return 4 + bonus;
        }
        if (t.canAttack() || t.isSpellcaster()) {
            return 2 + bonus;
        }
        return 0;
    }

    public int getGPriority(ROUnit u, Unit me, boolean harass) {
        int bonus = 0;
        bonus = (int)((double)bonus + 1.0 / (double)(u.getHitPoints() + 2));
        UnitType t = u.getType();
        if (harass) {
            if (t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE || t == UnitType.PROTOSS_PROBE) {
                return 1;
            }
            return 0 + bonus;
        }
        if (t == UnitType.PROTOSS_INTERCEPTOR) {
            return -10;
        }
        if (t == UnitType.ZERG_SUNKEN_COLONY || t == UnitType.PROTOSS_PHOTON_CANNON || t == UnitType.TERRAN_BUNKER || t == UnitType.TERRAN_MISSILE_TURRET) {
            return 1 + bonus;
        }
        if (t.isFlyer()) {
            if (t.canAttack()) {
                return 8 + bonus;
            }
            return 5 + bonus;
        }
        if (t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE || t == UnitType.PROTOSS_PROBE) {
            return 2;
        }
        if (u.canAttack(me)) {
            return 4 + bonus;
        }
        if (t.canAttack() || t.isSpellcaster()) {
            return 2 + bonus;
        }
        if (t.isBuilding()) {
            return 1;
        }
        return 0 + bonus;
    }

    public double getValue(List<Unit> army) {
        int minval = 1;
        int gasval = 0;
        for (Unit e : army) {
            minval += e.getType().mineralPrice();
            gasval += e.getType().gasPrice();
        }
        return minval + gasval * 2;
    }

    public void setHotspot(Hotspot h) {
        this.hotspot = h;
    }

    public void setFocal(Position p) {
        this.focalPoint = p;
    }

    public void setDFocal(Position p) {
        this.defensiveFocalPoint = p;
    }

    public void setDbldg(Unit d) {
        this.dbldg = d;
    }

    public void merge(int a, int b) {
        if (a > b) {
            int temp = b;
            b = a;
            a = temp;
        }
        System.out.println("Merging squad " + a + " and " + b);
        Squad s1 = this.squads.get(a);
        Squad s2 = this.squads.get(b);
        Squad newSquad = s1.type == "mech" ? new M3chSquad(this) : new MarineSquad(this);
        for (Unit u : s1.myUnits) {
            newSquad.addUnit(u);
        }
        s1.myUnits.clear();
        for (Unit u : s2.myUnits) {
            newSquad.addUnit(u);
        }
        s2.myUnits.clear();
        this.squads.remove(s1);
        this.squads.remove(s2);
        this.squads.add(a, newSquad);
        if (this.shouldLock(a)) {
            newSquad.locked = true;
        }
    }

    public boolean shouldLock(int a) {
        Squad s = this.squads.get(a);
        boolean first = false;
        for (int i = 0; !(i >= this.squads.size() || s.type.equals(this.squads.get((int)i).type) && i < a); ++i) {
            if (i != a) continue;
            first = true;
            break;
        }
        if (this.mechStrat && s.type.equals("bio")) {
            return s.myUnits.size() > Squad.lockThreshold + 10;
        }
        if (!(!first || this.mechStrat && s.type.equals("bio"))) {
            return s.myUnits.size() >= Squad.lockThreshold;
        }
        long starttime = System.currentTimeMillis();
        if (s.myUnits.size() >= Squad.lockThreshold) {
            return true;
        }
        int totvalue = 0;
        int aavalue = 0;
        int enemyvalue = 0;
        int enemyairvalue = 0;
        for (ROUnit enemy : this.reinforcementThreat) {
            enemyvalue += enemy.getType().mineralPrice();
            enemyvalue += 2 * enemy.getType().gasPrice();
            if (!enemy.getType().isFlyer()) continue;
            enemyairvalue += enemy.getType().mineralPrice();
            enemyairvalue += 2 * enemy.getType().gasPrice();
        }
        boolean hasTank = false;
        for (Unit u : s.myUnits) {
            if (u.getType() == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || u.getType() == UnitType.TERRAN_SIEGE_TANK_TANK_MODE) {
                hasTank = true;
            }
            totvalue += u.getType().mineralPrice();
            totvalue += 2 * u.getType().gasPrice();
            if (u.getType() != UnitType.TERRAN_MARINE && u.getType() != UnitType.TERRAN_GOLIATH && (!u.getType().isFlyer() || !u.getType().canAttack())) continue;
            aavalue += u.getType().mineralPrice();
            aavalue += 2 * u.getType().gasPrice();
        }
        if (s.myUnits.size() > 13) {
            hasTank = true;
        }
        if (!hasTank && !this.mechStrat) {
            return false;
        }
        int limit = 0;
        if (s.myUnits.size() < 5 && s.type.equals("bio")) {
            limit = 5;
        }
        return s.myUnits.size() > limit && (double)totvalue >= (double)enemyvalue * 0.8 && (double)aavalue >= (double)enemyairvalue * 0.8;
    }

    public void setupDrops() {
        ArrayList<Unit> rem = new ArrayList<Unit>();
        for (Unit u : this.freeGuys) {
            if (u.isLoaded()) {
                rem.add(u);
                continue;
            }
            if (u.isSieged()) {
                u.unsiege();
                continue;
            }
            if (this.idleDropships.size() == 0) continue;
            u.rightClick(this.idleDropships.get(0));
        }
        this.freeGuys.removeAll(rem);
        if (this.suggestedDropSpot == null) {
            return;
        }
        if (this.dropType == UnitType.TERRAN_VULTURE) {
            this.dropQuantity = 4;
        }
        if (this.dropType == UnitType.TERRAN_MARINE) {
            this.dropQuantity = 8;
        }
        if (this.dropType == UnitType.TERRAN_SIEGE_TANK_TANK_MODE || this.dropType == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) {
            this.dropQuantity = 2;
        }
        int medics = 0;
        ArrayList<Unit> tr = new ArrayList<Unit>();
        for (Unit dship : this.idleDropships) {
            Squad s = null;
            if (this.timeToDrop()) {
                ArrayList<Unit> expendables = new ArrayList<Unit>();
                for (int i = this.allArmy.size() - 1; i >= 0 && expendables.size() < this.dropQuantity; --i) {
                    Unit u = this.allArmy.get(i);
                    if (u.isLoaded() || u.getType() != this.dropType && (u.getType() != UnitType.TERRAN_MEDIC || this.dropType != UnitType.TERRAN_MARINE || medics >= 2)) continue;
                    expendables.add(u);
                    if (u.getType() != UnitType.TERRAN_MEDIC) continue;
                    ++medics;
                }
                if (expendables.size() == this.dropQuantity) {
                    this.allArmy.removeAll(expendables);
                    s = new DroppedUnits(this, dship);
                    for (Unit u : expendables) {
                        this.freeGuys.add(u);
                        s.addUnit(u);
                        for (Squad squad : this.squads) {
                            squad.removeUnit(u);
                        }
                        for (DefensiveSquad defensiveSquad : this.dSquads) {
                            ((Squad)defensiveSquad).removeUnit(u);
                        }
                        u.rightClick(dship);
                    }
                }
            }
            if (s == null) continue;
            TilePosition dropGoal = this.suggestedDropSpot;
            DropSquad d = new DropSquad(dship, this, s);
            d.dropsize = this.dropQuantity;
            d.setDropSpot(dropGoal);
            s.setGoal(Position.centerOfTile(dropGoal));
            this.droppers.add(d);
            tr.add(dship);
        }
        this.idleDropships.removeAll(tr);
    }

    public boolean timeToDrop() {
        int locked = 0;
        for (Squad s : this.squads) {
            if (!s.locked || this.retreating) continue;
            locked += s.myUnits.size();
        }
        return this.allArmy.size() > 25 || locked > 15;
    }

    public boolean shouldforceFlee(List<Unit> squad) {
        double ourValue = this.getValue(squad);
        double enemyValue = 0.0;
        double enemyMobileValue = 0.0;
        double staticValue = 0.0;
        Position p = UnitUtils.medianPos(squad);
        if (p == Position.INVALID) {
            return false;
        }
        for (ROUnit u : this.allVisibleEnemies) {
            if (!(u.getDistance(p) < 600.0) || !u.getType().canAttack()) continue;
            enemyValue += (double)u.getType().mineralPrice();
            enemyValue += (double)(2 * u.getType().gasPrice());
            if (!(u.getType().topSpeed() > 1.2 * UnitType.TERRAN_MEDIC.topSpeed())) continue;
            enemyMobileValue += (double)u.getType().mineralPrice();
            enemyMobileValue += (double)(2 * u.getType().gasPrice());
        }
        for (ROUnit u : this.enemyBuildings) {
            if (!(u.getDistance(p) < 500.0) || !u.getType().canAttack() && u.getType() != UnitType.TERRAN_BUNKER) continue;
            staticValue += 200.0;
        }
        if (!this.retreating) {
            return false;
        }
        if (staticValue > 0.0) {
            return true;
        }
        if (enemyMobileValue > 0.5 * ourValue) {
            return false;
        }
        return enemyValue > 1.3 * ourValue;
    }
}

