/*
 * Decompiled with CFR 0.152.
 */
package undermind;

import edu.berkeley.nlp.starcraft.AbstractCerebrate;
import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.Strategy;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Race;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.model.WeaponType;
import undermind.EnemyUnitStatus;
import undermind.MicroManager;
import undermind.ValuedUnitType;
import undermind.intelligence.Convoy;
import undermind.intelligence.Hotspot;
import undermind.intelligence.IntelManager;
import undermind.intelligence.IntelligenceUtil;
import undermind.intelligence.RegionStatus;
import undermind.macro.BuildingStatus;
import undermind.macro.MacroManager;
import undermind.micropacket.GoliathSquad;
import undermind.micropacket.Squad;

public class GameEvaluator
extends AbstractCerebrate
implements Strategy {
    public boolean needTanks;
    public ArrayList<ROUnit> unitsBeingCreated = new ArrayList();
    public int oldExpoHP = 0;
    static final int TERRAN_MAXSQUAD = 13;
    static final int PROTOSS_MAXSQUAD = 22;
    static final int ZERG_MAXSQUAD = 20;
    public List<TilePosition> attackpath;
    public double confidence = 1.0;
    final double RETREAT_PROPORTION = 0.7;
    final double ATTACK_PROPORTION = 1.1;
    public boolean retreating = false;
    public Position previousFocal;
    Convoy myConvoy;
    public int defenseMemory;
    public IntelManager myIntel;
    Bwta myBwta = Bwta.getInstance();
    Set<BaseLocation> bases = this.myBwta.getBaseLocations();
    public Random rgenerator = new Random();
    public int mostRecentAttack = 1000000;
    public Unit mostRecentDBldg;
    public boolean mechStrat;
    public MacroManager myMacro;
    public MicroManager myMicro;
    public int workersKilled = 0;
    public int workersLost = 0;
    private Player me;
    private Player enemy;
    public Game mGame;
    public List<ROUnit> enemyBuildings;
    List<EnemyUnitStatus> knownEnemies;
    List<ROUnit> myArmy;
    boolean heavyAir = false;
    public double producedArmy;
    public double valueKilled;
    boolean needAA;
    double AAproportion;
    boolean needAS;
    double ASproportion;
    boolean earlyRush;
    boolean rushindicator;
    boolean gasStolen;
    public ROUnit stealingRefinery;
    boolean FE;
    boolean feindicator;
    long time = 0L;
    long lastReaction = -100000L;
    int dropswanted;

    public GameEvaluator(MacroManager b, MicroManager m) {
        this.myMacro = b;
        this.myMicro = m;
        this.enemyBuildings = this.myMicro.enemyBuildings;
        this.knownEnemies = new ArrayList<EnemyUnitStatus>();
        this.myArmy = new ArrayList<ROUnit>();
        this.dropswanted = 1;
        this.myConvoy = new Convoy();
    }

    @Override
    public void onStart() {
        this.mGame = Game.getInstance();
        this.me = this.mGame.self();
        Set<Player> players = this.mGame.getPlayers();
        for (Player p : players) {
            if (!p.isEnemy(this.me)) continue;
            this.enemy = p;
            break;
        }
        this.myMacro.mech = this.mechStrat = this.enemy.getRace() != Race.ZERG;
    }

    @Override
    public void onUnitRenegade(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        super.onUnitRenegade(unit);
        this.onUnitDestroy(unit);
    }

    public void onUnitSpawn(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        if (unit.getPlayer() == this.me && !unit.getType().isWorker() && !unit.getType().isBuilding() && (unit.getType().canAttack() || unit.getType().isSpellcaster() || unit.getType() == UnitType.TERRAN_DROPSHIP)) {
            this.myArmy.add(unit);
            this.producedArmy += (double)unit.getType().mineralPrice();
            this.producedArmy += (double)(unit.getType().gasPrice() * 2);
        }
    }

    @Override
    public void onUnitShow(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        if (unit.getPlayer().equals(this.me)) {
            this.unitsBeingCreated.add(unit);
        }
        if (unit.getPlayer() != this.me && !unit.getType().isWorker() && (unit.getType().canAttack() || unit.getType().isSpellcaster() && !unit.getType().isBuilding())) {
            for (EnemyUnitStatus u : this.knownEnemies) {
                if (u.unit.getID() != unit.getID() && unit.getType() != UnitType.PROTOSS_INTERCEPTOR) continue;
                return;
            }
            if (this.myConvoy.pathToGoal != null) {
                this.myConvoy.register(unit);
            }
            this.knownEnemies.add(new EnemyUnitStatus(unit));
        }
        if (!this.gasStolen && this.time < 4000L && unit.getPlayer() != this.me && (unit.getType() == UnitType.ZERG_EXTRACTOR || unit.getType() == UnitType.TERRAN_REFINERY || unit.getType() == UnitType.PROTOSS_ASSIMILATOR) && unit.getLastKnownPosition().getDistance(Position.centerOfTile(this.myMacro.myHome)) < 384.0) {
            this.gasStolen = true;
            this.stealingRefinery = unit;
        }
    }

    @Override
    public void onFrame() {
        if (this.enemy.getRace() == Race.PROTOSS && this.heavyAir) {
            GoliathSquad.acquisitionBonus = 100;
        }
        this.mGame.drawTextScreen(0, 100, "squadlock: " + this.computeLockThreshold());
        long starttime = System.currentTimeMillis();
        ++this.time;
        ArrayList<ROUnit> tr = new ArrayList<ROUnit>();
        for (ROUnit u : this.unitsBeingCreated) {
            if (!u.isCompleted()) continue;
            this.onUnitSpawn(u);
            tr.add(u);
        }
        for (ROUnit removeMe : tr) {
            this.unitsBeingCreated.remove(removeMe);
        }
        if ((this.time % 300L == 0L || this.attackpath == null) && this.myMacro.enemyBases.size() != 0) {
            this.attackpath = this.myMacro.pathfinder.getPath(new TilePosition(this.myMacro.natChoke.getCenter()), new TilePosition(this.previousFocal));
        }
        this.mGame.drawTextScreen(0, 250, "Confidence : " + this.confidence);
        for (Squad s : this.myMicro.squads) {
            if (!s.locked || s.myUnits.size() <= 1 || this.time % 100L != 0L || this.myConvoy.lastEnd == new TilePosition(UnitUtils.medianPos(s.myUnits))) continue;
            this.myConvoy.setConvoy(Position.centerOfTile(this.myMacro.myHome), UnitUtils.medianPos(s.myUnits));
        }
        this.myConvoy.updateUnits();
        if (this.earlyRush) {
            this.rushindicator = true;
        }
        if (this.FE) {
            this.feindicator = true;
        }
        int airunits = 0;
        for (EnemyUnitStatus u : this.knownEnemies) {
            if (!u.unit.isFlying() || !u.unit.getType().canAttack()) continue;
            ++airunits;
        }
        if (airunits > 1 || this.hehastech(UnitType.ZERG_SPIRE) || this.hehastech(UnitType.TERRAN_STARPORT) || this.hehastech(UnitType.PROTOSS_FLEET_BEACON) || this.hehastech(UnitType.PROTOSS_ARBITER_TRIBUNAL) || this.hehastech(UnitType.PROTOSS_STARGATE) || this.hehasunit(UnitType.PROTOSS_SHUTTLE) || this.hehasunit(UnitType.PROTOSS_REAVER)) {
            this.needAA = true;
        }
        if (!this.heavyAir && (this.hehastech(UnitType.ZERG_GREATER_SPIRE) || this.hehastech(UnitType.TERRAN_PHYSICS_LAB) || this.hehastech(UnitType.PROTOSS_FLEET_BEACON) || this.hehasunit(UnitType.TERRAN_BATTLECRUISER) || this.hehasunit(UnitType.ZERG_GUARDIAN) || this.hehasunit(UnitType.PROTOSS_CARRIER))) {
            this.heavyAir = true;
            this.mGame.printf("Tier 3 air detected", new Object[0]);
            this.myMacro.BOInject(UnitType.TERRAN_MISSILE_TURRET);
            this.myMacro.BOInject(UnitType.TERRAN_MISSILE_TURRET);
            this.myMacro.BOInject(UnitType.TERRAN_MISSILE_TURRET);
            this.myMacro.BOInject(UnitType.TERRAN_MISSILE_TURRET);
            this.needAA = true;
        }
        if (this.hehastech(UnitType.PROTOSS_TEMPLAR_ARCHIVES) || this.hehastech(UnitType.PROTOSS_CITADEL_OF_ADUN) || this.hehastech(UnitType.TERRAN_COVERT_OPS) || this.hehastech(UnitType.TERRAN_CONTROL_TOWER) || this.hehastech(UnitType.TERRAN_NUCLEAR_SILO) || this.hehasunit(UnitType.PROTOSS_DARK_TEMPLAR) || this.hehasunit(UnitType.ZERG_LURKER) || this.hehasunit(UnitType.TERRAN_GHOST) || this.hehasunit(UnitType.TERRAN_WRAITH)) {
            this.needAS = true;
        }
        if (!(this.earlyRush || this.time >= 4800L || this.enemyCount(UnitType.TERRAN_COMMAND_CENTER) < 2 && this.enemyCount(UnitType.ZERG_HATCHERY) < 2 && this.enemyCount(UnitType.PROTOSS_NEXUS) < 2 && this.staticgroundd() <= 1)) {
            this.FE = true;
        }
        if (this.time < 9000L && this.defenseNeeded() != 0) {
            this.earlyRush = true;
        }
        if (this.time < 5000L && this.enemyCount(UnitType.PROTOSS_ZEALOT) >= 2) {
            this.earlyRush = true;
        }
        if (this.time < 4000L && this.enemyCount(UnitType.PROTOSS_ZEALOT) >= 1) {
            this.earlyRush = true;
        }
        if (!this.FE && this.time < 4800L && (this.enemyCount(UnitType.TERRAN_BARRACKS) >= 2 || this.enemyCount(UnitType.PROTOSS_GATEWAY) >= 2 || this.getValue(this.knownEnemies, false) > 400.0)) {
            this.earlyRush = true;
        }
        if (!this.FE && this.time < 4000L && this.hehascompletedtech(UnitType.ZERG_SPAWNING_POOL)) {
            this.earlyRush = true;
        }
        if (!this.FE && this.time < 4800L && this.myMicro.defend) {
            this.earlyRush = true;
        }
        if (this.myMacro.debug) {
            this.mGame.drawTextScreen(5, 0, "AP: " + this.airproportion(this.knownEnemies));
            this.mGame.drawTextScreen(5, 40, "enemy bldgs " + this.myMicro.enemyBuildings);
            this.mGame.drawTextScreen(5, 60, "enemy units " + this.knownEnemies.toString());
            this.mGame.drawTextScreen(5, 80, "Evaluation: " + this.evaluate());
            this.mGame.drawTextScreen(5, 90, "A Evaluation: " + this.armyEval());
            this.mGame.drawTextScreen(300, 0, "Frame: " + this.time);
            this.mGame.drawTextScreen(500, 20, "Gas Stolen: " + this.gasStolen);
            this.mGame.drawTextScreen(500, 30, "Early rush: " + this.rushindicator);
            this.mGame.drawTextScreen(500, 90, "Early expand: " + this.feindicator);
            this.mGame.drawTextScreen(500, 50, "Possible Stealth: " + this.needAS);
            this.mGame.drawTextScreen(500, 60, "Possible Air: " + this.needAA);
        }
        ArrayList<EnemyUnitStatus> toRemove = new ArrayList<EnemyUnitStatus>();
        double airvalue = 0.0;
        for (EnemyUnitStatus u : this.knownEnemies) {
            UnitType type;
            ++u.age;
            if (u.age >= 10000) {
                toRemove.add(u);
            }
            if (!(type = u.unit.getType()).isFlyer() || !type.canAttack()) continue;
            airvalue += (double)type.mineralPrice();
            airvalue += (double)type.gasPrice();
        }
        if (this.myBldgCount(UnitType.TERRAN_MISSILE_TURRET) < 10 && (double)this.myBldgCount(UnitType.TERRAN_MISSILE_TURRET) < airvalue / 700.0 && this.time % 800L == 0L) {
            this.myMacro.BOInject(UnitType.TERRAN_MISSILE_TURRET);
        }
        for (EnemyUnitStatus u : toRemove) {
            this.knownEnemies.remove(u);
        }
        this.updateConfidence();
    }

    @Override
    public List<Cerebrate> getTopLevelCerebrates() {
        return null;
    }

    @Override
    public void onUnitDestroy(ROUnit unit) {
        int i;
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        if (unit.getType().isWorker()) {
            if (unit.getPlayer() == this.me) {
                ++this.workersLost;
            } else {
                ++this.workersKilled;
            }
        }
        if (unit.getPlayer() != this.me && !unit.getType().isWorker() && (unit.getType().canAttack() || unit.getType().isSpellcaster())) {
            i = 0;
            while (i != this.knownEnemies.size()) {
                if (unit.getID() == this.knownEnemies.get((int)i).unit.getID()) {
                    this.knownEnemies.remove(i);
                    i = 0;
                    continue;
                }
                ++i;
            }
            this.valueKilled += (double)(unit.getType().gasPrice() * 2);
            this.valueKilled += (double)unit.getType().mineralPrice();
        }
        if (unit.getPlayer() == this.me && !unit.getType().isWorker() && (unit.getType().canAttack() || unit.getType().isSpellcaster() || unit.getType() == UnitType.TERRAN_DROPSHIP)) {
            i = 0;
            while (i != this.myArmy.size()) {
                if (unit.getID() == this.myArmy.get(i).getID()) {
                    this.myArmy.remove(i);
                    i = 0;
                    continue;
                }
                ++i;
            }
        }
        if (this.gasStolen && unit.getPlayer() != this.me && (unit.getType() == UnitType.ZERG_EXTRACTOR || unit.getType() == UnitType.TERRAN_REFINERY || unit.getType() == UnitType.PROTOSS_ASSIMILATOR) && unit.getLastKnownPosition().getDistance(Position.centerOfTile(this.myMacro.myHome)) < 384.0) {
            this.gasStolen = false;
            this.stealingRefinery = null;
        }
    }

    @Override
    public void onUnitMorph(ROUnit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getType() == null) {
            return;
        }
        if (this.time < 4000L && unit.getPlayer() != this.me && (unit.getType() == UnitType.ZERG_EXTRACTOR || unit.getType() == UnitType.TERRAN_REFINERY || unit.getType() == UnitType.PROTOSS_ASSIMILATOR) && unit.getLastKnownPosition().getDistance(Position.centerOfTile(this.myMacro.myHome)) < 384.0) {
            this.gasStolen = true;
            this.stealingRefinery = unit;
        }
    }

    public double evaluate() {
        double myBases = this.myMacro.myCCs.size();
        double enemyBases = 0.0;
        for (ROUnit e : this.enemyBuildings) {
            if (!this.isMainBldg(e)) continue;
            enemyBases += 1.0;
            if (e.getType() != UnitType.ZERG_HATCHERY) continue;
            enemyBases -= 0.25;
        }
        double baseAdvantage = 0.0;
        if (myBases >= enemyBases + 1.0) {
            baseAdvantage = 0.5;
        } else if (myBases <= enemyBases - 1.0) {
            baseAdvantage = -0.5;
        }
        double workerAdvantage = (double)(this.workersKilled - this.workersLost) / ((double)this.workersKilled + 20.0);
        if (workerAdvantage < 0.0 && workerAdvantage < -1.0) {
            workerAdvantage = -1.0;
        }
        if (workerAdvantage > 0.0 && workerAdvantage > 1.0) {
            workerAdvantage = 1.0;
        }
        if (this.workersKilled <= 3 && this.workersLost <= 3) {
            workerAdvantage = 0.0;
        }
        return workerAdvantage + baseAdvantage + (this.getValueRO(this.myArmy) - this.getValue(this.knownEnemies, false)) / this.getValueRO(this.myArmy);
    }

    public List<UnitType> initialBuildOrder() {
        ArrayList<UnitType> BO = new ArrayList<UnitType>();
        if (!this.mechStrat) {
            BO.add(UnitType.TERRAN_COMMAND_CENTER);
            BO.add(UnitType.TERRAN_BARRACKS);
            BO.add(UnitType.TERRAN_BARRACKS);
            BO.add(UnitType.TERRAN_ACADEMY);
            BO.add(UnitType.TERRAN_BARRACKS);
            BO.add(UnitType.TERRAN_ENGINEERING_BAY);
            BO.add(UnitType.TERRAN_BARRACKS);
            BO.add(UnitType.TERRAN_BARRACKS);
            BO.add(UnitType.TERRAN_FACTORY);
            BO.add(UnitType.TERRAN_STARPORT);
            BO.add(UnitType.TERRAN_SCIENCE_FACILITY);
            BO.add(UnitType.TERRAN_BARRACKS);
            BO.add(UnitType.TERRAN_ENGINEERING_BAY);
            BO.add(UnitType.TERRAN_BARRACKS);
            BO.add(UnitType.TERRAN_BARRACKS);
        } else if (this.enemy.getRace() == Race.TERRAN) {
            BO.add(UnitType.TERRAN_COMMAND_CENTER);
            BO.add(UnitType.TERRAN_BARRACKS);
            BO.add(UnitType.TERRAN_FACTORY);
            BO.add(UnitType.TERRAN_FACTORY);
            BO.add(UnitType.TERRAN_FACTORY);
            BO.add(UnitType.TERRAN_ENGINEERING_BAY);
            BO.add(UnitType.TERRAN_ACADEMY);
            BO.add(UnitType.TERRAN_MISSILE_TURRET);
            BO.add(UnitType.TERRAN_ARMORY);
            BO.add(UnitType.TERRAN_FACTORY);
            BO.add(UnitType.TERRAN_STARPORT);
            BO.add(UnitType.TERRAN_FACTORY);
            BO.add(UnitType.TERRAN_SCIENCE_FACILITY);
            BO.add(UnitType.TERRAN_ARMORY);
            BO.add(UnitType.TERRAN_FACTORY);
            BO.add(UnitType.TERRAN_FACTORY);
        } else {
            BO.add(UnitType.TERRAN_COMMAND_CENTER);
            BO.add(UnitType.TERRAN_BARRACKS);
            BO.add(UnitType.TERRAN_FACTORY);
            BO.add(UnitType.TERRAN_FACTORY);
            BO.add(UnitType.TERRAN_BUNKER);
            BO.add(UnitType.TERRAN_ENGINEERING_BAY);
            BO.add(UnitType.TERRAN_MISSILE_TURRET);
            BO.add(UnitType.TERRAN_MISSILE_TURRET);
            BO.add(UnitType.TERRAN_ACADEMY);
            BO.add(UnitType.TERRAN_FACTORY);
            BO.add(UnitType.TERRAN_ARMORY);
            BO.add(UnitType.TERRAN_MISSILE_TURRET);
            BO.add(UnitType.TERRAN_FACTORY);
            BO.add(UnitType.TERRAN_STARPORT);
            BO.add(UnitType.TERRAN_FACTORY);
            BO.add(UnitType.TERRAN_FACTORY);
            BO.add(UnitType.TERRAN_SCIENCE_FACILITY);
            BO.add(UnitType.TERRAN_ARMORY);
            BO.add(UnitType.TERRAN_FACTORY);
            BO.add(UnitType.TERRAN_FACTORY);
        }
        return BO;
    }

    public void setProductionPriorities() {
        this.myMacro.unitPriorities.clear();
        if (!this.mechStrat) {
            this.myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_MARINE, 1.0));
            this.myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_MEDIC, 4 * UnitUtils.getAllMy(UnitType.TERRAN_MEDIC).size() / (UnitUtils.getAllMy(UnitType.TERRAN_MARINE).size() + 1)));
            if (this.myMacro.ihavetech(UnitType.TERRAN_CONTROL_TOWER) && this.needMoreDrops()) {
                this.myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_DROPSHIP, 1.0));
            }
            if (this.needTanks()) {
                this.myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_SIEGE_TANK_TANK_MODE, 2.0));
            }
        } else {
            int mcu = this.myCountUnloaded(UnitType.TERRAN_MARINE);
            if (mcu < 2 || !this.ihavetech(UnitType.TERRAN_ARMORY) && mcu < 6 && this.needAA || this.gasStolen && mcu < 12 || this.myMacro.mins > 700 && mcu < 15) {
                this.myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_MARINE, 2.0));
            }
            if (mcu > 5 && (double)this.myCountUnloaded(UnitType.TERRAN_MEDIC) < (double)mcu / 4.0 && this.time > 23000L) {
                this.myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_MEDIC, 2.0));
            }
            double goliaths = UnitUtils.getAllMy(UnitType.TERRAN_GOLIATH).size();
            double tanks = UnitUtils.getAllMy(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE).size() + UnitUtils.getAllMy(UnitType.TERRAN_SIEGE_TANK_TANK_MODE).size();
            double k = goliaths / (goliaths + tanks);
            if (this.myMacro.ihavetech(UnitType.TERRAN_CONTROL_TOWER) && this.needMoreDrops()) {
                this.myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_DROPSHIP, 1.0));
            }
            if (k < this.airproportion(this.knownEnemies) && this.ihavetech(UnitType.TERRAN_ARMORY)) {
                this.myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_GOLIATH, 1.0));
            } else {
                this.myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_SIEGE_TANK_TANK_MODE, 1.0));
            }
            if (this.recommendVultures() || this.myMacro.gas < 80) {
                this.myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_VULTURE, 3.0));
            }
        }
        if (this.myMacro.gas > 200 && (!this.mechStrat || this.needAS) && UnitUtils.getAllMy(UnitType.TERRAN_SCIENCE_VESSEL).size() < 5) {
            this.myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_SCIENCE_VESSEL, 3.0));
        }
    }

    public boolean needMoreDrops() {
        return this.myMicro.droppers.size() + this.myMicro.idleDropships.size() < this.dropswanted && !this.retreating;
    }

    public Position scanPos() {
        TilePosition possexp = this.myIntel.possibleEnemyExpo();
        if (possexp != null) {
            this.mGame.drawTextMap(new Position(possexp), "POSSEXP");
        }
        int energyToScan = 115;
        if (!this.needAS && this.getValueES(this.knownEnemies) < 1000.0 && this.myMacro.myCCs.size() > 1) {
            energyToScan = 90;
        }
        for (BuildingStatus b : this.myMacro.myBuildings) {
            if (b.status != 2 || b.type != UnitType.TERRAN_COMSAT_STATION) continue;
            if (b.myUnit.getEnergy() > energyToScan && (this.myMacro.enemyBases.size() != 0 || this.myMicro.enemyBuildings.size() != 0)) {
                int r1 = this.rgenerator.nextInt(3);
                if (this.myMacro.enemyBases.size() != 0 && r1 == 0) {
                    int r = this.rgenerator.nextInt(this.myMacro.enemyBases.size());
                    if (this.myMacro.enemyBases.get(r).getPosition().x() != -1) continue;
                    return this.myMacro.enemyBases.get(r).getLastKnownPosition();
                }
                if (this.myMicro.enemyBuildings.size() != 0 && r1 == 1) {
                    return this.myMicro.enemyBuildings.get(this.rgenerator.nextInt(this.myMicro.enemyBuildings.size())).getLastKnownPosition();
                }
                if (possexp == null) continue;
                return new Position(possexp);
            }
            if (b.myUnit.getEnergy() <= 105 || this.myMacro.enemyBases.size() != 0 || this.myMicro.enemyBuildings.size() != 0) continue;
            return this.myIntel.oldestBase().getPosition();
        }
        return Position.INVALID;
    }

    public void orderdrops(int more) {
        this.dropswanted += more;
    }

    public double airproportion(List<EnemyUnitStatus> army) {
        double totval = 1.0;
        double airval = 1.0;
        for (EnemyUnitStatus en : army) {
            ROUnit e = en.unit;
            totval += (double)e.getType().mineralPrice();
            totval += (double)(2 * e.getType().gasPrice());
            if (!e.getType().isFlyer()) continue;
            airval += (double)e.getType().mineralPrice();
            airval += (double)(2 * e.getType().gasPrice());
            if (e.getType() != UnitType.TERRAN_SCIENCE_VESSEL && e.getType().groundWeapon() != WeaponType.NONE) continue;
            airval -= (double)e.getType().gasPrice();
            totval -= (double)e.getType().gasPrice();
        }
        if (totval < 2000.0) {
            if (this.heavyAir) {
                return 0.35;
            }
            return 0.2;
        }
        double r = airval / totval;
        if (r > 0.8) {
            return 0.8;
        }
        if (this.heavyAir && r < 0.5) {
            return 0.5;
        }
        if (r > 0.2) {
            return r;
        }
        return 0.2;
    }

    public int defenseNeeded() {
        if (this.time % 200L == 0L) {
            this.defenseMemory = 0;
        }
        int defense = 0;
        Region baseRegion = null;
        for (Region r : this.myBwta.getRegions()) {
            if (!r.contains(this.myMacro.myHome)) continue;
            baseRegion = r;
            break;
        }
        if (this.myMicro.allArmy.size() > 15) {
            return 0;
        }
        double aval = 0.0;
        double enemyval = 0.0;
        for (Unit u : this.myMicro.allArmy) {
            if (u.isLoaded() || !u.isCompleted()) continue;
            aval += (double)u.getType().mineralPrice();
            aval += 1.5 * (double)u.getType().gasPrice();
        }
        if (aval < 1500.0) {
            int w = 0;
            for (ROUnit rOUnit : this.mGame.getAllUnits()) {
                if (!rOUnit.isVisible() || !rOUnit.getPlayer().isEnemy(this.me)) continue;
                double bunkdist = Double.POSITIVE_INFINITY;
                for (ROUnit bunk : UnitUtils.getAllMy(UnitType.TERRAN_BUNKER)) {
                    if (!((double)rOUnit.getDistance(bunk) < bunkdist)) continue;
                    bunkdist = rOUnit.getDistance(bunk);
                }
                if (!baseRegion.contains(rOUnit.getPosition())) continue;
                if (rOUnit.getType() == UnitType.PROTOSS_PYLON || rOUnit.getType() == UnitType.TERRAN_BUNKER) {
                    defense += 10;
                } else if (rOUnit.getType().canAttack() && !rOUnit.getType().isFlyer() && !rOUnit.isCloaked()) {
                    enemyval += (double)rOUnit.getType().mineralPrice();
                    enemyval += (double)rOUnit.getType().gasPrice();
                    if (rOUnit.getType() == UnitType.PROTOSS_ZEALOT) {
                        enemyval += 50.0;
                    }
                    if (rOUnit.getDistance(Position.centerOfTile(this.myMacro.myHome)) < 250.0 && !rOUnit.getType().isWorker()) {
                        enemyval += 200.0;
                    }
                }
                if (rOUnit.getPlayer() == this.me || rOUnit.getType() != UnitType.ZERG_DRONE && rOUnit.getType() != UnitType.TERRAN_SCV && rOUnit.getType() != UnitType.PROTOSS_PROBE) continue;
                ++w;
            }
            if (enemyval > aval && enemyval > 100.0) {
                defense = (int)((double)defense + (enemyval - aval) / 50.0);
                if (aval < 150.0) {
                    defense += 3;
                }
            }
        }
        if (defense > this.defenseMemory) {
            this.defenseMemory = defense;
        }
        return this.defenseMemory;
    }

    public ROUnit antisparky() {
        double nearestDistance = Double.POSITIVE_INFINITY;
        ROUnit closestEnemy = null;
        if (this.myMacro.myCCs.size() != 0 && this.myMacro.myCCs.get(0) != null && (closestEnemy = UnitUtils.getClosest(this.myMacro.myCCs.get((int)0).myUnit, this.myMicro.allVisibleEnemies)) != null) {
            nearestDistance = this.myMacro.myCCs.get((int)0).myUnit.getTilePosition().getDistance(closestEnemy.getPosition());
        }
        if (this.myMicro.allArmy.size() == 0 && nearestDistance < 21.0 && this.myMacro.numWorkers() != 0) {
            return closestEnemy;
        }
        return null;
    }

    public Position computeFocalPoint() {
        Position focalPoint = Position.INVALID;
        if (this.confidence < 0.7) {
            this.retreating = true;
        }
        if (this.confidence >= 1.1) {
            this.retreating = false;
        }
        if (this.retreating) {
            this.previousFocal = this.computeDefensiveFocalPoint();
            return this.previousFocal;
        }
        if (!this.retreating) {
            ROUnit proxybldg = null;
            for (ROUnit bldg : this.enemyBuildings) {
                if (bldg.getLastKnownPosition() == Position.INVALID || bldg.getLastKnownPosition() == null || !this.myMacro.baseRegion.contains(bldg.getLastKnownPosition()) && !this.myMacro.natRegion.contains(bldg.getLastKnownPosition())) continue;
                proxybldg = bldg;
                break;
            }
            if (proxybldg != null) {
                focalPoint = proxybldg.getLastKnownPosition();
            } else if (this.myMacro.enemyBases.size() != 0) {
                focalPoint = this.myMacro.enemyBases.get(this.myMacro.enemyBases.size() - 1).getLastKnownPosition();
                this.myMicro.whenattack = this.myMicro.wao / 3;
            } else if (this.enemyBuildings.size() != 0) {
                focalPoint = this.enemyBuildings.get(0).getLastKnownPosition();
                for (int i = 1; this.enemyBuildings.size() > i && focalPoint.x() == -1; ++i) {
                    focalPoint = this.enemyBuildings.get(i).getLastKnownPosition();
                }
            }
            this.retreating = false;
        }
        this.previousFocal = focalPoint;
        return focalPoint;
    }

    public Position computeDefensiveFocalPoint() {
        ++this.mostRecentAttack;
        Position focalPoint = null;
        TilePosition nextExp = this.myMacro.nextExpansion(true);
        if (this.myMicro.dbldg != null && (this.myMicro.attackersValue > 700 || Utils.getValue(this.myMicro.allArmy) < (double)this.myMicro.attackersValue * 1.3)) {
            this.mostRecentAttack = 0;
            this.mostRecentDBldg = this.myMicro.dbldg;
        }
        if (this.mostRecentDBldg != null && this.mostRecentAttack < 1000) {
            focalPoint = this.expandNeeded() > 0 && nextExp != null ? Position.centerOfTile(nextExp) : this.mostRecentDBldg.getLastKnownPosition();
        } else if (this.myMacro.myCCs.size() != 0) {
            ArrayList<TilePosition> bases2 = new ArrayList<TilePosition>();
            for (int a = 1; a < this.myMacro.myCCs.size(); ++a) {
                bases2.add(this.myMacro.myCCs.get((int)a).spot);
            }
            this.myMicro.whenattack = this.myMicro.wao;
            if (this.expandNeeded() > 0 && nextExp != null) {
                bases2.add(nextExp);
                focalPoint = this.attackpath != null ? new Position(IntelligenceUtil.get_defend_position(this.attackpath, bases2)) : this.myMacro.natChoke.getCenter();
            } else {
                for (int i = this.myMacro.myCCs.size() - 1; i >= 0; --i) {
                    if (this.gasStolen && this.stealingRefinery != null) {
                        focalPoint = this.stealingRefinery.getPosition();
                    } else {
                        if (this.myMacro.myCCs.get((int)i).status == 3) continue;
                        focalPoint = i == 0 ? (this.myMacro.wall != null ? new Position(Utils.closestTile(TilePosition.getTilePositions(this.myMacro.wall.get(0), 4, 3), this.myMacro.myCCs.get((int)0).spot)) : this.myMacro.baseChoke.getCenter()) : (i == 1 ? this.myMacro.natChoke.getCenter() : (this.attackpath != null ? new Position(IntelligenceUtil.get_defend_position(this.attackpath, bases2)) : this.myMacro.natChoke.getCenter()));
                    }
                    break;
                }
            }
        } else {
            focalPoint = new Position(this.myMacro.myHome);
        }
        return focalPoint;
    }

    public Hotspot getHotspot() {
        Hotspot ret = null;
        double bestDistance = Double.POSITIVE_INFINITY;
        Position pos = Position.INVALID;
        for (Squad s : this.myMicro.squads) {
            if (!s.acceptsType(UnitType.TERRAN_SIEGE_TANK_TANK_MODE) || !s.locked || s.myUnits.size() <= 1) continue;
            pos = UnitUtils.medianPos(s.myUnits);
            break;
        }
        if (pos == Position.INVALID) {
            pos = this.computeDefensiveFocalPoint();
        }
        for (Hotspot h : this.myIntel.hotspots) {
            double distance = h.pos.getDistance(pos);
            if (!(bestDistance > distance)) continue;
            bestDistance = distance;
            ret = h;
        }
        if (ret == null) {
            return new Hotspot(this.computeFocalPoint(), 0.0);
        }
        return ret;
    }

    public boolean shouldCancelExpansion() {
        for (int i = 0; i < this.myMacro.myBuildings.size(); ++i) {
            if (this.myMacro.myBuildings.get((int)i).status == 0 && this.myMacro.myBuildings.get((int)i).type == UnitType.TERRAN_COMMAND_CENTER) {
                for (ROUnit u : this.enemyBuildings) {
                    if (!(u.getLastKnownTilePosition().getDistance(this.myMacro.myBuildings.get((int)i).spot) < 7.0) || !u.getType().isResourceDepot() && !u.getType().canAttack() && !u.getType().canProduce() && u.getType() != UnitType.TERRAN_BUNKER) continue;
                    return true;
                }
            }
            if (this.myMacro.myBuildings.get((int)i).status != 1 || this.myMacro.myBuildings.get((int)i).type != UnitType.TERRAN_COMMAND_CENTER || this.myMacro.myBuildings.get((int)i).myUnit.getHitPoints() >= 100) continue;
            return true;
        }
        return this.mostRecentAttack <= 500 && (this.confidence < 0.9 || (double)this.myMicro.attackersValue > this.getValueRO(this.myArmy));
    }

    public Unit getBuildingToDefend() {
        int toldist = 450;
        double bd = Double.POSITIVE_INFINITY;
        Unit dbldg = null;
        double best = 0.0;
        for (BuildingStatus b : this.myMacro.myBuildings) {
            double value = 0.0;
            for (ROUnit e : this.myMicro.allVisibleEnemies) {
                if (b.myUnit == null || !e.isInRange(b.myUnit) && b.myUnit.getDistance(e) >= 128) continue;
                value += (double)e.getType().mineralPrice();
                value += (double)(2 * e.getType().gasPrice());
            }
            if (!(value > best)) continue;
            best = value;
            dbldg = b.myUnit;
        }
        return dbldg;
    }

    public int expandNeeded() {
        if (this.myMacro.nextExpansion(true) == null && this.time - this.myMacro.lastInject < 1000L) {
            return 0;
        }
        int baseMinerals = 0;
        block0: for (ROUnit rOUnit : this.mGame.getMinerals()) {
            for (BuildingStatus cc : this.myMacro.myCCs) {
                if (cc.myUnit == null || cc.myUnit.getDistance(rOUnit) >= 350) continue;
                baseMinerals += rOUnit.getResources();
                continue block0;
            }
        }
        double a = this.getValueRO(this.myArmy);
        double b = this.getValue(this.knownEnemies, false);
        if (this.myMicro.dbldg != null) {
            return 0;
        }
        if (baseMinerals < 6000) {
            this.mGame.drawTextScreen(200, 300, "Expansion requested based on baseMinerals = " + baseMinerals);
            return 1;
        }
        int currentMinerals = this.mGame.self().minerals();
        if (a > 1.5 * b && b > 1500.0 && currentMinerals > 700) {
            this.mGame.drawTextScreen(200, 300, "Expansion requested based on army values: mine is " + a + " versus " + b);
            return 1;
        }
        int numCCs = this.myMacro.myCCs.size();
        if (numCCs > 1 && (!this.mechStrat && a > (double)(1200 * numCCs) || this.mechStrat && a > (double)(1800 * numCCs))) {
            this.mGame.drawTextScreen(200, 300, "Expansion requested based on army value: mine is " + a + " for " + numCCs + " bases");
            return 1;
        }
        if (numCCs > 2 && (this.myMacro.enemyBases.size() >= numCCs + 1 && this.enemy.getRace() == Race.TERRAN || this.myMacro.enemyBases.size() >= numCCs + 2 && this.enemy.getRace() == Race.PROTOSS)) {
            this.mGame.drawTextScreen(200, 300, "Expansion requested based on bases: I have " + numCCs + " versus " + this.myMacro.enemyBases.size());
            return 1;
        }
        if ((this.myBldgCount(UnitType.TERRAN_BARRACKS) >= 2 || this.myBldgCount(UnitType.TERRAN_FACTORY) >= 2) && numCCs == 1 && (this.mGame.self().supplyUsed() > 80 && (this.enemy.getRace() != Race.PROTOSS || !this.earlyRush) || this.mGame.self().supplyUsed() > 95 || this.mGame.self().supplyUsed() > 50 && this.FE && this.enemy.getRace() != Race.ZERG)) {
            this.mGame.drawTextScreen(200, 300, "2 rax/facts are up, natural expansion requested.");
            return 1;
        }
        if (this.myMacro.mins > 800) {
            this.mGame.drawTextScreen(200, 300, "Expand because we have so much money");
            return 1;
        }
        return 0;
    }

    public boolean canExpand() {
        return this.mostRecentAttack > 1000 || this.myMicro.allArmy.size() > 20;
    }

    public int computeLockThreshold() {
        int totalAttack = 0;
        double proportion = this.producedArmy > 1000.0 ? Math.max(this.producedArmy - this.valueKilled, this.getValueES(this.knownEnemies)) / this.getValueRO(this.myArmy) : 1.0;
        if (proportion > 1.0) {
            proportion = 1.0;
        }
        if (proportion < 0.4) {
            proportion = 0.4;
        }
        for (Squad s : this.myMicro.squads) {
            if (!s.locked) continue;
            totalAttack += s.myUnits.size();
        }
        if (totalAttack >= 12 || this.enemy.getRace() == Race.TERRAN && totalAttack >= 4) {
            return 5;
        }
        if (this.mechStrat) {
            if (this.enemy.getRace() == Race.PROTOSS) {
                return (int)Math.ceil(proportion * 22.0);
            }
            if (this.time < 10000L) {
                if (!this.earlyRush) {
                    return 6;
                }
                return 10;
            }
            return (int)Math.ceil(proportion * 13.0);
        }
        return (int)Math.ceil(proportion * 20.0);
    }

    public double armyEval() {
        double a = this.getValueRO(this.myArmy);
        double b = this.getValue(this.knownEnemies, false);
        double ret = (a - b) / a;
        return ret;
    }

    public double getValueRO(List<ROUnit> army) {
        int minval = 1;
        int gasval = 0;
        for (ROUnit e : army) {
            minval += e.getType().mineralPrice();
            gasval += e.getType().gasPrice();
        }
        return minval + gasval * 2;
    }

    public double getValueES(List<EnemyUnitStatus> army) {
        int minval = 1;
        int gasval = 0;
        for (EnemyUnitStatus e : army) {
            minval += e.unit.getType().mineralPrice();
            gasval += e.unit.getType().gasPrice();
        }
        return minval + gasval * 2;
    }

    public double getValue(List<Unit> army) {
        int minval = 1;
        int gasval = 0;
        for (Unit e : army) {
            minval += e.getType().mineralPrice();
            gasval += e.getType().gasPrice();
        }
        return minval + gasval * 2;
    }

    public List<RegionStatus> getRegionStatuses() {
        return this.myIntel.regions;
    }

    public double getValue(List<EnemyUnitStatus> army, boolean worstWorkaroundEver) {
        int minval = 1;
        int gasval = 0;
        for (EnemyUnitStatus e : army) {
            minval += e.unit.getType().mineralPrice();
            gasval += e.unit.getType().gasPrice();
        }
        return minval + gasval * 2;
    }

    public double getWeightedValue(List<EnemyUnitStatus> army) {
        int minval = 1;
        int gasval = 0;
        for (EnemyUnitStatus e : army) {
            if (e.unit.getType() == UnitType.ZERG_MUTALISK) {
                minval += 150;
                continue;
            }
            minval += e.unit.getType().mineralPrice();
            gasval += e.unit.getType().gasPrice();
        }
        return minval + gasval * 2;
    }

    public boolean isMainBldg(ROUnit unit) {
        return unit.getType() == UnitType.PROTOSS_NEXUS || unit.getType() == UnitType.ZERG_HATCHERY || unit.getType() == UnitType.ZERG_LAIR || unit.getType() == UnitType.ZERG_HIVE || unit.getType() == UnitType.TERRAN_COMMAND_CENTER;
    }

    public boolean hehastech(UnitType bldg) {
        for (ROUnit u : this.enemyBuildings) {
            if (!u.getType().equals(bldg)) continue;
            return true;
        }
        return false;
    }

    public boolean ihavetech(UnitType bldg) {
        for (BuildingStatus b : this.myMacro.myBuildings) {
            if (b.myUnit == null || !b.myUnit.getType().equals(bldg) || !b.myUnit.isCompleted()) continue;
            return true;
        }
        return false;
    }

    public boolean hehascompletedtech(UnitType bldg) {
        for (ROUnit u : this.enemyBuildings) {
            if (!u.getType().equals(bldg) || !u.isCompleted()) continue;
            return true;
        }
        return false;
    }

    public boolean hehasunit(UnitType un) {
        for (EnemyUnitStatus u : this.knownEnemies) {
            if (u.unit.getType() != un) continue;
            return true;
        }
        return false;
    }

    public int enemyCount(UnitType unit) {
        int c = 0;
        for (ROUnit u : this.enemyBuildings) {
            if (!u.getType().equals(unit) || !(u.getDistance(Position.centerOfTile(this.myMacro.myHome)) > 600.0)) continue;
            ++c;
        }
        for (EnemyUnitStatus es : this.knownEnemies) {
            if (!es.unit.getType().equals(unit)) continue;
            ++c;
        }
        return c;
    }

    public int staticgroundd() {
        return Math.max(this.enemyCount(UnitType.TERRAN_BUNKER), Math.max(this.enemyCount(UnitType.PROTOSS_PHOTON_CANNON), this.enemyCount(UnitType.ZERG_SUNKEN_COLONY)));
    }

    public int myCount(UnitType ut) {
        int c = 0;
        for (ROUnit u : this.myArmy) {
            if (!u.getType().equals(ut)) continue;
            ++c;
        }
        return c;
    }

    public int myCountUnloaded(UnitType ut) {
        int c = 0;
        for (ROUnit u : this.myArmy) {
            if (!u.getType().equals(ut) || u.isLoaded()) continue;
            ++c;
        }
        return c;
    }

    public int myBldgCount(UnitType ut) {
        int c = 0;
        for (BuildingStatus b : this.myMacro.myBuildings) {
            if (!b.type.equals(ut)) continue;
            ++c;
        }
        return c;
    }

    public void setIntelManager(IntelManager im) {
        this.myIntel = im;
    }

    public void updateConfidence() {
        double myVal = this.getValue(this.myMicro.allArmy);
        double enemyVal = this.getWeightedValue(this.knownEnemies);
        double alpha = 0.01;
        int sunkens = 0;
        int closeSunkens = 0;
        if (this.previousFocal != null && this.previousFocal != Position.INVALID) {
            block0: for (ROUnit bldg : this.myMicro.enemyBuildings) {
                if (bldg.getType() != UnitType.ZERG_SUNKEN_COLONY) continue;
                TilePosition tp = bldg.getLastKnownTilePosition();
                if (this.attackpath == null) continue;
                for (TilePosition tp2 : this.attackpath) {
                    if (!(tp.getDistance(tp2) < 8.0)) continue;
                    ++sunkens;
                    if (!(UnitUtils.getClosestDistance(bldg, this.myMicro.allArmy) < 500.0)) continue block0;
                    ++closeSunkens;
                    continue block0;
                }
            }
        }
        if (sunkens > 3) {
            sunkens = 3;
        }
        if (closeSunkens > 3) {
            closeSunkens = 3;
        }
        this.confidence = (alpha += 0.008 * (double)closeSunkens) * (myVal / ((enemyVal += (double)(sunkens * 200)) + 0.1)) + (1.0 - alpha) * this.confidence;
        if (this.confidence > 3.0) {
            this.confidence = 3.0;
        }
        if (this.me.supplyUsed() > 360) {
            this.confidence = 3.0;
        }
    }

    public boolean recommendVultures() {
        int vultures = UnitUtils.getAllMy(UnitType.TERRAN_VULTURE).size();
        int tanks = UnitUtils.getAllMy(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE).size() + UnitUtils.getAllMy(UnitType.TERRAN_SIEGE_TANK_TANK_MODE).size();
        int smalls = 0;
        int v = 0;
        for (EnemyUnitStatus es : this.knownEnemies) {
            if (es.unit.getType() != UnitType.PROTOSS_ZEALOT) continue;
            ++smalls;
        }
        if (this.enemy.getRace() == Race.PROTOSS) {
            if (vultures < tanks) {
                return true;
            }
            if (smalls > vultures) {
                return true;
            }
            v = (double)(smalls + tanks) < (double)tanks * 1.5 ? smalls + tanks : smalls + tanks;
        } else if (this.enemy.getRace() == Race.TERRAN && (double)vultures < (double)tanks / 3.0) {
            return true;
        }
        return false;
    }

    public TilePosition bestDropSpot() {
        TilePosition best = null;
        if (this.myMacro.enemyBases.size() != 0) {
            ArrayList<TilePosition> eligibles = new ArrayList<TilePosition>();
            for (ROUnit base : this.myMacro.enemyBases) {
                eligibles.add(base.getLastKnownTilePosition());
            }
            double bestThreat = Double.POSITIVE_INFINITY;
            for (TilePosition tp : eligibles) {
                double t = this.dropThreat(tp);
                if (!(t < bestThreat)) continue;
                bestThreat = t;
                best = tp;
            }
        } else if (this.myMacro.enemyBuildings.size() != 0) {
            best = this.myMacro.enemyBuildings.get(0).getLastKnownTilePosition();
        }
        return best;
    }

    public double dropThreat(TilePosition tp) {
        double threat = 0.0;
        for (ROUnit bldg : this.myMacro.enemyBuildings) {
            if (!bldg.getType().canAttack() && bldg.getType() != UnitType.TERRAN_BUNKER) continue;
            threat += 15.0 / (1.0 + bldg.getLastKnownTilePosition().getDistance(tp));
        }
        for (RegionStatus rs : this.myMicro.regionStatuses) {
            for (ROUnit en : rs.enemies) {
                if (!en.getType().canAttack() || en.getType().isWorker()) continue;
                threat += 15.0 / (1.0 + en.getLastKnownTilePosition().getDistance(tp));
            }
        }
        return threat;
    }

    public UnitType getDropType() {
        if (!this.mechStrat) {
            if (this.airproportion(this.knownEnemies) < 0.3) {
                return UnitType.TERRAN_MARINE;
            }
            return UnitType.TERRAN_NUCLEAR_MISSILE;
        }
        if (this.myCountUnloaded(UnitType.TERRAN_MARINE) > 5) {
            return UnitType.TERRAN_MARINE;
        }
        if (this.myCountUnloaded(UnitType.TERRAN_VULTURE) > 8) {
            return UnitType.TERRAN_VULTURE;
        }
        return UnitType.TERRAN_MARINE;
    }

    public boolean needTanks() {
        if (this.mechStrat) {
            return false;
        }
        if (this.enemyCount(UnitType.ZERG_LURKER) > 3 && !this.needTanks) {
            this.needTanks = true;
            this.myMacro.BORemove(UnitType.TERRAN_FACTORY);
            this.myMacro.BOInject(UnitType.TERRAN_FACTORY);
            this.myMacro.buildOrder.add(UnitType.TERRAN_FACTORY);
        }
        return this.needTanks;
    }
}

