/*
 * Decompiled with CFR 0.152.
 */
package undermind;

import edu.berkeley.nlp.starcraft.util.Counter;
import edu.berkeley.nlp.starcraft.util.FastPriorityQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.model.WeaponType;
import undermind.MicroManager;
import undermind.intelligence.RegionStatus;

public class DropSearch {
    Counter<TilePosition> banned;
    MicroManager master;
    long time1 = 0L;
    Game mGame = Game.getInstance();
    int mapheight = this.mGame.getMapHeight();
    int mapwidth = this.mGame.getMapWidth();
    Map<TilePosition, Integer> ttdm = new HashMap<TilePosition, Integer>();

    public DropSearch(MicroManager m) {
        this.master = m;
    }

    public List<TilePosition> getPath(TilePosition start, TilePosition end) {
        this.time1 = System.currentTimeMillis();
        Node node = this.search(start, end);
        if (node == null) {
            return null;
        }
        ArrayList<TilePosition> path = new ArrayList<TilePosition>();
        while (node != null) {
            path.add(node.state);
            node = node.parent;
        }
        Collections.reverse(path);
        return path;
    }

    private void computeBanned() {
        this.banned = new Counter();
        int tolerance = 9;
        for (ROUnit bldg : this.master.enemyBuildings) {
            if (bldg.getType() != UnitType.TERRAN_MISSILE_TURRET && bldg.getType() != UnitType.TERRAN_BUNKER && bldg.getType() != UnitType.ZERG_SPORE_COLONY && bldg.getType() != UnitType.PROTOSS_PHOTON_CANNON) continue;
            for (int dx = -tolerance - 1; dx < tolerance + 1; ++dx) {
                for (int dy = -tolerance - 1; dy < tolerance + 1; ++dy) {
                    TilePosition tilePosition = bldg.getLastKnownTilePosition();
                    TilePosition newtp = new TilePosition(tilePosition.x() + dx, tilePosition.y() + dy);
                    this.banned.incrementCount(newtp, 230.0 / (1.0 + tilePosition.getDistance(newtp)));
                }
            }
        }
        for (RegionStatus rs : this.master.regionStatuses) {
            for (ROUnit en : rs.enemies) {
                if (en.getType().airWeapon().equals(WeaponType.NONE)) continue;
                for (int dx = -tolerance; dx < tolerance; ++dx) {
                    for (int dy = -tolerance; dy < tolerance; ++dy) {
                        TilePosition tilePosition = en.getLastKnownTilePosition();
                        TilePosition newtp = new TilePosition(tilePosition.x() + dx, tilePosition.y() + dy);
                        this.banned.incrementCount(newtp, 25.0 / (1.0 + tilePosition.getDistance(newtp)));
                    }
                }
            }
        }
    }

    private Node search(TilePosition start, TilePosition end) {
        this.computeBanned();
        FastPriorityQueue<Node> fringe = new FastPriorityQueue<Node>();
        byte[][] gridArray = new byte[Game.getInstance().getMapWidth()][Game.getInstance().getMapHeight()];
        Node startNode = new Node(null, start, 0.0, this.computeHeuristic(start, end));
        this.enqueueNode(startNode, fringe);
        int endx = end.x();
        int endy = end.y();
        while (!fringe.isEmpty()) {
            TilePosition[] successors;
            int y;
            long time2 = System.currentTimeMillis();
            if (time2 - this.time1 > 2000L) {
                return null;
            }
            Node node = fringe.next();
            TilePosition state = node.state;
            int x = state.x();
            if (gridArray[x][y = state.y()] != 0) continue;
            if (x == endx && y == endy) {
                return node;
            }
            gridArray[x][y] = 1;
            for (TilePosition pos : successors = this.fastSuccessors(state)) {
                int y2;
                int x2;
                if (pos == null || gridArray[x2 = pos.x()][y2 = pos.y()] != 0) continue;
                Node childNode = new Node(node, pos, node.backCost + this.transitionCost(state, pos), this.computeHeuristic(pos, end));
                fringe.setPriority(childNode, -(childNode.backCost * 1.0 + childNode.heuristic));
            }
        }
        return null;
    }

    private void enqueueNode(Node node, FastPriorityQueue<Node> fringe) {
        fringe.setPriority(node, -(node.backCost * 1.0 + node.heuristic));
    }

    private double computeHeuristic(TilePosition state, TilePosition end) {
        int yd;
        int xd = state.x() - end.x();
        if (xd < 0) {
            xd = -xd;
        }
        if ((yd = state.y() - end.y()) < 0) {
            yd = -yd;
        }
        double r = (double)(xd + yd) * 0.75;
        return r;
    }

    public double transitionCost(TilePosition state, TilePosition pos) {
        double cost = 0.0;
        if (state.x() == pos.x()) {
            if (state.y() != pos.y()) {
                cost += 1.0;
            }
        } else {
            cost = state.y() == pos.y() ? (cost += 1.0) : (cost += 1.5);
        }
        return cost += this.banned.getCount(pos);
    }

    public TilePosition[] fastSuccessors(TilePosition state) {
        TilePosition[] res = new TilePosition[8];
        int k = 0;
        int x = state.x();
        int y = state.y();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                if (dx == 0 && dy == 0) continue;
                TilePosition newpos = new TilePosition(x + dx, y + dy);
                if (this.isWalkable(newpos)) {
                    res[k] = newpos;
                }
                ++k;
            }
        }
        return res;
    }

    public double getGroundDistance(TilePosition s, TilePosition g) {
        return this.getPath(s, g).size();
    }

    public void drawPath(List<TilePosition> path) {
        for (TilePosition tp : path) {
            this.mGame.drawCircleMap(Position.centerOfTile(tp), 3, Color.CYAN, true);
        }
    }

    public void drawttdm() {
        for (Map.Entry<TilePosition, Integer> ti : this.ttdm.entrySet()) {
            this.mGame.drawTextMap(Position.centerOfTile(ti.getKey()), ti.getValue().toString());
        }
    }

    public boolean isWalkable(TilePosition tp) {
        if (tp.x() < 0 || tp.x() > this.mapwidth - 1) {
            return false;
        }
        return tp.y() >= 0 && tp.y() <= this.mapheight - 1;
    }

    class Node {
        Node parent;
        TilePosition state;
        double backCost;
        double heuristic;

        public Node(Node parent, TilePosition state, double backCost, double heuristic) {
            this.parent = parent;
            this.state = state;
            this.backCost = backCost;
            this.heuristic = heuristic;
        }
    }
}

