/*
 * Decompiled with CFR 0.152.
 */
package undermind;

import edu.berkeley.nlp.starcraft.AbstractCerebrate;
import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.Strategy;
import edu.berkeley.nlp.starcraft.scripting.Command;
import edu.berkeley.nlp.starcraft.scripting.JythonInterpreter;
import edu.berkeley.nlp.starcraft.scripting.Thunk;
import java.util.Arrays;
import java.util.List;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.UnitType;
import undermind.GameEvaluator;
import undermind.MicroManager;
import undermind.intelligence.IntelManager;
import undermind.macro.MacroManager;
import undermind.macro.WorkerManager;
import undermind.micropacket.Squad;

public class Dispatcher
extends AbstractCerebrate
implements Strategy {
    public int lastScan = 0;
    JythonInterpreter jython = new JythonInterpreter();
    public MacroManager myMacro;
    public MicroManager myMicro;
    public GameEvaluator myEval;
    public WorkerManager workerManager;
    public IntelManager intelManager;
    public Game mGame = Game.getInstance();
    public long frame;

    @Override
    public List<Cerebrate> getTopLevelCerebrates() {
        this.initializeJython();
        this.myMacro = new MacroManager();
        this.myMicro = new MicroManager();
        this.myEval = new GameEvaluator(this.myMacro, this.myMicro);
        this.workerManager = new WorkerManager(this.myMacro);
        this.intelManager = new IntelManager(this.myEval);
        this.myMacro.setWorkerManager(this.workerManager);
        this.myEval.setIntelManager(this.intelManager);
        return Arrays.asList(this.jython, this.myEval, this.myMicro, this.myMacro, this.workerManager, this.intelManager, this);
    }

    protected void initializeJython() {
        this.jython.bindFields(this);
        this.jython.bind("game", this.mGame);
        this.jython.bindIntCommand("speed", new Command<Integer>(){

            @Override
            public void call(Integer arg) {
                Dispatcher.this.mGame.printf("Setting speed to %d", arg);
                Dispatcher.this.mGame.setLocalSpeed(arg);
            }
        });
        this.jython.bindThunk("debug", new Thunk(){

            @Override
            public void call() {
                Dispatcher.this.myMacro.debug = !Dispatcher.this.myMacro.debug;
                Dispatcher.this.myMicro.debug = !Dispatcher.this.myMicro.debug;
            }
        });
        this.jython.bindThunk("reset", new Thunk(){

            @Override
            public void call() {
                Dispatcher.this.initializeJython();
            }
        });
        this.jython.bindThunk("freeze", new Thunk(){

            @Override
            public void call() {
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() - start < 20000L) {
                }
            }
        });
        this.jython.bindIntCommand("goto", new Command<Integer>(){

            @Override
            public void call(Integer arg) {
                int id = arg;
                for (ROUnit rOUnit : Dispatcher.this.mGame.getAllUnits()) {
                    if (rOUnit.getID() != id) continue;
                    Dispatcher.this.mGame.setScreenPosition(rOUnit.getLastKnownPosition());
                    Dispatcher.this.mGame.drawCircleMap(rOUnit.getLastKnownPosition(), 5, Color.RED, false);
                    return;
                }
                Dispatcher.this.mGame.printf("Couldn't find unit id %d", id);
            }
        });
    }

    @Override
    public void onStart() {
        this.mGame.setDrawing(false);
        this.myMacro.BOset(this.myEval.initialBuildOrder());
    }

    @Override
    public void onFrame() {
        Position scanPos;
        ++this.frame;
        --this.lastScan;
        this.myEval.setProductionPriorities();
        int defense = this.myEval.defenseNeeded();
        if (defense != 0) {
            this.myMacro.defend(defense);
        } else {
            this.myMacro.stopDefend();
        }
        this.myMacro.antisparky(this.myEval.antisparky());
        this.myMicro.setFocal(this.myEval.computeFocalPoint());
        this.myMicro.setDFocal(this.myEval.computeDefensiveFocalPoint());
        this.myMicro.setDbldg(this.myEval.getBuildingToDefend());
        this.myMicro.setHotspot(this.myEval.getHotspot());
        if (this.myEval.myMicro.pleaseScanHere != null) {
            this.myMacro.scan(this.myEval.myMicro.pleaseScanHere);
            this.myEval.myMicro.pleaseScanHere = null;
        }
        if (this.myEval.needAS) {
            this.myMacro.stealthResponse();
        }
        if (this.myEval.needAA) {
            this.myMacro.airResponse();
        }
        if (this.myEval.gasStolen) {
            this.myMacro.gasStealResponse();
        }
        if (this.myEval.earlyRush) {
            this.myMacro.rushResponse();
        }
        if (this.myEval.FE) {
            this.myMacro.FEresponse();
        }
        if (this.frame % 100L == 0L && this.myEval.canExpand()) {
            int expand = this.myEval.expandNeeded();
            if (expand == 1) {
                this.mGame.printf("expanding...", new Object[0]);
                this.myMacro.expand();
            } else if (expand == 2) {
                this.mGame.printf("expanding...", new Object[0]);
                this.myMacro.safeExpand();
            }
        }
        if (this.myEval.shouldCancelExpansion()) {
            this.myMacro.cancelExpand();
        }
        if ((scanPos = this.myEval.scanPos()) != Position.INVALID && this.lastScan < 0) {
            this.myMacro.scan(scanPos);
            this.lastScan = 700;
        }
        Squad.lockThreshold = this.myEval.computeLockThreshold();
        this.myMacro.enemyBuildings = this.myMicro.enemyBuildings;
        this.myMicro.regionStatuses = this.myEval.getRegionStatuses();
        this.myMicro.mechStrat = this.myEval.mechStrat;
        this.myMicro.scouter.nextBL = this.myEval.myIntel.oldestBase();
        this.myMicro.reinforcementThreat = this.myEval.myConvoy.enemies;
        this.myMicro.suggestedDropSpot = this.myEval.bestDropSpot();
        this.myMicro.retreating = this.myEval.retreating;
        this.myMicro.stolegas = this.myEval.gasStolen;
        this.myMicro.confidence = this.myEval.confidence;
        this.myMicro.dropType = this.myEval.getDropType();
        this.myMacro.lurkers = this.myEval.needTanks();
        this.myMicro.lurkers = this.myEval.needTanks();
        this.myMicro.posseexp = this.myEval.myIntel.possibleEnemyExpo();
        this.myMicro.boccs = this.myMacro.BOCount(UnitType.TERRAN_COMMAND_CENTER);
    }
}

