/*
 * Decompiled with CFR 0.152.
 */
package undermind;

import edu.berkeley.nlp.starcraft.util.FastPriorityQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;

public class AStarSearch {
    public List<TilePosition> chokeBuffer;
    long time1 = 0L;
    Game mGame = Game.getInstance();
    int mapheight = this.mGame.getMapHeight();
    int mapwidth = this.mGame.getMapWidth();
    static final double edgePenalty = 10.0;
    public Set<TilePosition> grid;
    public int walkableTolerance = 4;
    Map<TilePosition, Integer> ttdm = new HashMap<TilePosition, Integer>();

    public AStarSearch() {
        this.preprocessMap();
    }

    public void preprocessMap() {
        HashSet<TilePosition> seenTile = new HashSet<TilePosition>();
        LinkedList<TilePosition> fringe = new LinkedList<TilePosition>();
        for (int x = 0; x < this.mapwidth; ++x) {
            for (int y = 0; y < this.mapheight; ++y) {
                TilePosition newpos = new TilePosition(x, y);
                if (this.isWalkable(newpos)) continue;
                fringe.add(newpos);
                seenTile.add(newpos);
            }
        }
        for (TilePosition tp : fringe) {
            this.ttdm.put(tp, 0);
        }
        while (!fringe.isEmpty()) {
            TilePosition[] successors;
            TilePosition tp = (TilePosition)fringe.removeFirst();
            for (TilePosition succ : successors = this.fastSuccessors(tp)) {
                if (succ == null || seenTile.contains(succ)) continue;
                seenTile.add(succ);
                fringe.add(succ);
                this.ttdm.put(succ, 1 + this.ttdm.get(tp));
            }
        }
    }

    public List<TilePosition> getPath(TilePosition start, TilePosition end) {
        this.time1 = System.currentTimeMillis();
        Node node = this.search(start, end);
        if (node == null) {
            return null;
        }
        ArrayList<TilePosition> path = new ArrayList<TilePosition>();
        while (node != null) {
            path.add(node.state);
            node = node.parent;
        }
        Collections.reverse(path);
        return path;
    }

    public List<TilePosition> getPath2(TilePosition start, TilePosition end) {
        this.time1 = System.currentTimeMillis();
        Node node = this.search2(start, end);
        if (node == null) {
            return null;
        }
        ArrayList<TilePosition> path = new ArrayList<TilePosition>();
        while (node != null) {
            path.add(node.state);
            node = node.parent;
        }
        Collections.reverse(path);
        return path;
    }

    private Node search(TilePosition start, TilePosition end) {
        FastPriorityQueue<Node> fringe = new FastPriorityQueue<Node>();
        byte[][] gridArray = new byte[Game.getInstance().getMapWidth()][Game.getInstance().getMapHeight()];
        Node startNode = new Node(null, start, 0.0, this.computeHeuristic(start, end));
        this.enqueueNode(startNode, fringe);
        int endx = end.x();
        int endy = end.y();
        while (!fringe.isEmpty()) {
            TilePosition[] successors;
            int y;
            long time2 = System.currentTimeMillis();
            if (time2 - this.time1 > 2000L) {
                return null;
            }
            Node node = fringe.next();
            TilePosition state = node.state;
            int x = state.x();
            if (gridArray[x][y = state.y()] != 0) continue;
            if (x == endx && y == endy) {
                return node;
            }
            gridArray[x][y] = 1;
            for (TilePosition pos : successors = this.fastSuccessors(state)) {
                int y2;
                int x2;
                if (pos == null || gridArray[x2 = pos.x()][y2 = pos.y()] != 0) continue;
                Node childNode = new Node(node, pos, node.backCost + this.transitionCost(state, pos), this.computeHeuristic(pos, end));
                fringe.setPriority(childNode, -(childNode.backCost * 1.0 + childNode.heuristic));
            }
        }
        return null;
    }

    private Node search2(TilePosition start, TilePosition end) {
        FastPriorityQueue<Node> fringe = new FastPriorityQueue<Node>();
        byte[][] gridArray = new byte[Game.getInstance().getMapWidth()][Game.getInstance().getMapHeight()];
        Node startNode = new Node(null, start, 0.0, this.computeHeuristic(start, end));
        this.enqueueNode(startNode, fringe);
        int endx = end.x();
        int endy = end.y();
        while (!fringe.isEmpty()) {
            TilePosition[] successors;
            int y;
            long time2 = System.currentTimeMillis();
            if (time2 - this.time1 > 2000L) {
                return null;
            }
            Node node = fringe.next();
            TilePosition state = node.state;
            int x = state.x();
            if (gridArray[x][y = state.y()] != 0) continue;
            if (x == endx && y == endy) {
                return node;
            }
            gridArray[x][y] = 1;
            for (TilePosition pos : successors = this.fastSuccessors2(state)) {
                int y2;
                int x2;
                if (pos == null || gridArray[x2 = pos.x()][y2 = pos.y()] != 0) continue;
                Node childNode = new Node(node, pos, node.backCost + this.transitionCost(state, pos), this.computeHeuristic(pos, end));
                fringe.setPriority(childNode, -(childNode.backCost * 1.0 + childNode.heuristic));
            }
        }
        return null;
    }

    private void enqueueNode(Node node, FastPriorityQueue<Node> fringe) {
        fringe.setPriority(node, -(node.backCost * 1.0 + node.heuristic));
    }

    private double computeHeuristic(TilePosition state, TilePosition end) {
        int yd;
        int xd = state.x() - end.x();
        if (xd < 0) {
            xd = -xd;
        }
        if ((yd = state.y() - end.y()) < 0) {
            yd = -yd;
        }
        double r = (double)(xd + yd) * 0.75;
        return r;
    }

    public double transitionCost(TilePosition state, TilePosition pos) {
        double cost = 0.0;
        if (state.x() == pos.x()) {
            if (state.y() != pos.y()) {
                cost += 1.0;
            }
        } else {
            cost = state.y() == pos.y() ? (cost += 1.0) : (cost += 1.5);
        }
        return cost += 10.0 / (double)this.ttdm.get(pos).intValue();
    }

    public TilePosition[] fastSuccessors(TilePosition state) {
        TilePosition[] res = new TilePosition[8];
        int k = 0;
        int x = state.x();
        int y = state.y();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                if (dx == 0 && dy == 0) continue;
                TilePosition newpos = new TilePosition(x + dx, y + dy);
                if (this.isWalkable(newpos)) {
                    res[k] = newpos;
                }
                ++k;
            }
        }
        return res;
    }

    public TilePosition[] fastSuccessors2(TilePosition state) {
        TilePosition[] res = new TilePosition[8];
        int k = 0;
        int x = state.x();
        int y = state.y();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                if (dx == 0 && dy == 0) continue;
                TilePosition newpos = new TilePosition(x + dx, y + dy);
                int count = 0;
                for (ROUnit rOUnit : this.mGame.unitsOnTile(newpos)) {
                    ++count;
                    if (!rOUnit.getType().isBuilding()) continue;
                    count += 1000;
                }
                if (count > 2) continue;
                if (this.isWalkable(newpos)) {
                    res[k] = newpos;
                }
                ++k;
            }
        }
        return res;
    }

    public double getGroundDistance(TilePosition s, TilePosition g) {
        return this.getPath(s, g).size();
    }

    public void drawPath(List<TilePosition> path) {
        for (TilePosition tp : path) {
            this.mGame.drawCircleMap(Position.centerOfTile(tp), 3, Color.WHITE, true);
        }
    }

    public void drawttdm() {
        for (Map.Entry<TilePosition, Integer> ti : this.ttdm.entrySet()) {
            this.mGame.drawTextMap(Position.centerOfTile(ti.getKey()), ti.getValue().toString());
        }
    }

    public boolean isWalkable(TilePosition tp) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (Game.getInstance().isWalkable(tp.x() * 4 + i, tp.y() * 4 + j)) continue;
                return false;
            }
        }
        if (tp.x() < 0 || tp.x() > this.mapwidth - 1) {
            return false;
        }
        return tp.y() >= 0 && tp.y() <= this.mapheight - 1;
    }

    public List<TilePosition> getPath(TilePosition start, TilePosition end, List<TilePosition> banned) {
        this.time1 = System.currentTimeMillis();
        Node node = this.search(start, end, banned);
        if (node == null) {
            return null;
        }
        ArrayList<TilePosition> path = new ArrayList<TilePosition>();
        while (node != null) {
            path.add(node.state);
            node = node.parent;
        }
        Collections.reverse(path);
        return path;
    }

    private Node search(TilePosition start, TilePosition end, List<TilePosition> banned) {
        FastPriorityQueue<Node> fringe = new FastPriorityQueue<Node>();
        byte[][] gridArray = new byte[Game.getInstance().getMapWidth()][Game.getInstance().getMapHeight()];
        Node startNode = new Node(null, start, 0.0, this.computeHeuristic(start, end));
        this.enqueueNode(startNode, fringe);
        int endx = end.x();
        int endy = end.y();
        while (!fringe.isEmpty()) {
            TilePosition[] successors;
            int y;
            long time2 = System.currentTimeMillis();
            Node node = fringe.next();
            TilePosition state = node.state;
            int x = state.x();
            if (gridArray[x][y = state.y()] != 0) continue;
            if (x == endx && y == endy) {
                return node;
            }
            gridArray[x][y] = 1;
            for (TilePosition pos : successors = this.fastSuccessors(state, banned)) {
                int y2;
                int x2;
                if (pos == null || gridArray[x2 = pos.x()][y2 = pos.y()] != 0) continue;
                Node childNode = new Node(node, pos, node.backCost + this.transitionCost(state, pos), this.computeHeuristic(pos, end));
                fringe.setPriority(childNode, -(childNode.backCost * 1.0 + childNode.heuristic));
            }
        }
        return null;
    }

    public TilePosition[] fastSuccessors(TilePosition state, List<TilePosition> banned) {
        TilePosition[] res = new TilePosition[4];
        int k = 0;
        int x = state.x();
        int y = state.y();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                TilePosition newpos;
                if (dx == 0 && dy == 0 || dx != 0 && dy != 0 || banned.contains(newpos = new TilePosition(x + dx, y + dy)) || !this.grid.contains(newpos)) continue;
                if (this.isSuperWalkable(newpos)) {
                    res[k] = newpos;
                }
                ++k;
            }
        }
        return res;
    }

    public boolean isSuperWalkable(TilePosition tp) {
        if (this.chokeBuffer.contains(tp)) {
            return true;
        }
        for (int i = -this.walkableTolerance; i < this.walkableTolerance + 4; ++i) {
            for (int j = -this.walkableTolerance; j < this.walkableTolerance + 4; ++j) {
                if (Game.getInstance().isWalkable(tp.x() * 4 + i, tp.y() * 4 + j)) continue;
                return false;
            }
        }
        if (tp.x() < 0 || tp.x() > this.mapwidth - 1) {
            return false;
        }
        return tp.y() >= 0 && tp.y() <= this.mapheight - 1;
    }

    public void makeUnitPath(Unit u, TilePosition goal) {
        List<TilePosition> path = this.getPath2(u.getTilePosition(), goal);
        if (path != null) {
            if (path.size() > 3) {
                u.move(path.get(3));
            } else if (path.size() > 1) {
                u.move(path.get(1));
            }
            this.drawPath(path);
        } else {
            u.move(goal);
        }
    }

    class Node {
        Node parent;
        TilePosition state;
        double backCost;
        double heuristic;

        public Node(Node parent, TilePosition state, double backCost, double heuristic) {
            this.parent = parent;
            this.state = state;
            this.backCost = backCost;
            this.heuristic = heuristic;
        }
    }
}

