/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.test.windows.trayicon;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.misc.NOTIFYICONDATA;
import org.xvolks.jnative.misc.WindowsVersion;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.util.Callback;
import org.xvolks.jnative.util.Shell32;
import org.xvolks.jnative.util.User32;
import org.xvolks.jnative.util.windows.WindowsUtils;
import org.xvolks.test.windows.trayicon.BalloonTooltipListener;
import org.xvolks.test.windows.trayicon.TrayIconCallback;

public final class TrayIcon {
    private final MouseListener m_mouseListener = new TrayIconMouseListener();
    private MouseListener mouseListener = null;
    private NOTIFYICONDATA iconData = new NOTIFYICONDATA();
    private Frame owner = null;
    private JPopupMenu pMenu = null;
    private boolean leftMouseDoubleClick = false;
    private ImageIcon img = null;
    private String toolTip = "";
    private boolean isVisible = false;
    private HWND hWnd;
    private int prevWindowProc;
    private Window dummyWindow = null;
    private int trayIconId;
    private Callback callback = new TrayIconCallback(this);
    private BalloonTooltipListener balloonTooltipListener = null;
    private boolean disposed = false;
    private LONG hImage = null;
    private static int CUSTOM_CALLBACK_MSG = 100;

    private TrayIcon() {
    }

    public TrayIcon(ImageIcon img) {
        this(null, img, null, false);
    }

    public TrayIcon(LONG hImage) {
        this(null, hImage, null, false);
    }

    public TrayIcon(Frame owner, ImageIcon img) {
        this(owner, img, null, true);
    }

    public TrayIcon(Frame owner, LONG hImage) {
        this(owner, hImage, null, true);
    }

    public TrayIcon(Frame owner, LONG hImage, String toolTip, boolean addDefaultMouseListener) {
        if (hImage == null || hImage.getValue() == 0) {
            throw new RuntimeException("Image handle must not be null!");
        }
        this.trayIconId = new Random().nextInt();
        this.dummyWindow = new Window(new Frame(this.getMsgWindowTitle()));
        this.dummyWindow.setVisible(true);
        try {
            this.hWnd = User32.FindWindow(null, this.getMsgWindowTitle());
        }
        catch (Exception ex) {
            throw new RuntimeException("Error creating TrayIcon: " + ex);
        }
        if (addDefaultMouseListener) {
            this.setMouseListener(this.m_mouseListener);
        }
        this.owner = owner;
        this.hImage = hImage;
        this.toolTip = toolTip;
        this.pMenu = new JPopupMenu();
        this.pMenu.setLightWeightPopupEnabled(false);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    TrayIcon.this.dispose();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public TrayIcon(Frame owner, ImageIcon img, String toolTip, boolean addDefaultMouseListener) {
        if (img == null) {
            throw new RuntimeException("Icon-image must not be null!");
        }
        this.trayIconId = new Random().nextInt();
        this.dummyWindow = new Window(new Frame(this.getMsgWindowTitle()));
        this.dummyWindow.setVisible(true);
        try {
            this.hWnd = User32.FindWindow(null, this.getMsgWindowTitle());
        }
        catch (Exception ex) {
            throw new RuntimeException("Error creating TrayIcon: " + ex);
        }
        if (addDefaultMouseListener) {
            this.setMouseListener(this.m_mouseListener);
        }
        this.owner = owner;
        this.img = img;
        this.toolTip = toolTip;
        this.pMenu = new JPopupMenu();
        this.pMenu.setLightWeightPopupEnabled(false);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    TrayIcon.this.dispose();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public int getPrevWindowProc() {
        return this.prevWindowProc;
    }

    public HWND getHwnd() {
        return this.hWnd;
    }

    public int getTrayIconId() {
        return this.trayIconId;
    }

    public Window getMsgWindow() {
        return this.dummyWindow;
    }

    public String getMsgWindowTitle() {
        return "Trayicon_invisible_frame_" + this.trayIconId;
    }

    public void dispose() throws Throwable {
        if (this.disposed) {
            return;
        }
        this.setVisible(false);
        this.dummyWindow.dispose();
        if (this.callback != null) {
            JNative.releaseCallback(this.callback);
        }
        this.disposed = true;
    }

    public NOTIFYICONDATA getIconData() {
        return this.iconData;
    }

    public void setVisible(boolean enable) throws Throwable {
        if (this.disposed) {
            JNative.getLogger().log(JNativeLogger.SEVERITY.WARN, "TrayIcon is already disposed!!");
            return;
        }
        if (enable) {
            this.iconData.hWnd = (Integer)this.hWnd.getValue();
            this.iconData.uID = this.trayIconId;
            this.iconData.szTip = this.toolTip;
            this.iconData.uFlags = 23;
            this.iconData.uCallbackMessage = 1024 + CUSTOM_CALLBACK_MSG++;
            this.iconData.hIcon = this.img != null ? WindowsUtils.CreateIcon(new LONG(this.iconData.hWnd), 4, 8, this.img).getValue().intValue() : this.hImage.getValue().intValue();
            if (Shell32.Shell_NotifyIcon(0, this.iconData)) {
                this.isVisible = true;
                if (WindowsVersion.supportsNewVersion()) {
                    this.iconData.uTimeOutOrVersion = 3;
                    Shell32.Shell_NotifyIcon(4, this.iconData);
                }
                this.prevWindowProc = User32.SetWindowLong(this.hWnd, -4, new LONG(this.callback.getCallbackAddress()));
            } else {
                JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, "Error while creating TrayIcon " + this.getTrayIconId() + "!");
            }
        } else if (this.isVisible) {
            if (Shell32.Shell_NotifyIcon(2, this.iconData)) {
                this.isVisible = false;
                User32.DestroyIcon(new LONG(this.iconData.hIcon));
                if (this.prevWindowProc != 0) {
                    User32.SetWindowLong(this.hWnd, -4, new LONG(this.prevWindowProc));
                }
            } else {
                JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, "Error while removing TrayIcon " + this.getTrayIconId() + "!");
            }
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setToolTip(String toolTip) {
        this.iconData.szTip = toolTip;
        this.iconData.uFlags = 7;
        this.updateTrayIcon();
    }

    public void setBalloonTooltip(String title, String message, NOTIFYICONDATA.ICON_TYPE icon, int timeOut) {
        this.iconData.szInfo = message;
        this.iconData.szInfoTitle = title;
        this.iconData.dwInfoFlags = icon.ordinal();
        this.iconData.uFlags = 16;
        this.iconData.uTimeOutOrVersion = timeOut;
        this.updateTrayIcon();
    }

    public void updateTrayIcon() {
        if (this.isVisible()) {
            try {
                Shell32.Shell_NotifyIcon(1, this.iconData);
            }
            catch (Throwable e) {
                JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, e);
            }
        }
    }

    public int getCallbackMsg() {
        return this.iconData.uCallbackMessage;
    }

    public ImageIcon getIconImage() {
        return this.img;
    }

    public LONG getImageHandle() {
        return this.hImage;
    }

    public void setIconImage(ImageIcon img) throws InterruptedException, NativeException, IllegalAccessException {
        this.img = img;
        this.hImage = null;
        this.iconData.uFlags = 2;
        this.iconData.hIcon = WindowsUtils.CreateIcon(new LONG(this.iconData.hWnd), 4, 8, img).getValue();
        this.updateTrayIcon();
    }

    public void setIconImage(LONG hImage) {
        this.hImage = hImage;
        this.img = null;
        this.iconData.uFlags = 2;
        this.iconData.hIcon = hImage.getValue();
        this.updateTrayIcon();
    }

    public boolean isMenuVisible() {
        if (this.pMenu != null) {
            return this.pMenu.isVisible();
        }
        return false;
    }

    public void setPopupMenu(JPopupMenu pMenu) {
        this.pMenu = pMenu;
    }

    public void addMenuItem(JMenuItem menuItem) {
        if (this.pMenu != null && menuItem != null) {
            this.pMenu.add(menuItem);
        }
    }

    public void addSeperator() {
        if (this.pMenu != null) {
            this.pMenu.addSeparator();
        }
    }

    public void removeMenuItem(JMenuItem menuItem) {
        if (this.pMenu != null && menuItem != null) {
            this.pMenu.remove(menuItem);
        }
    }

    public void setLeftMouseDoubleClick(boolean b) {
        this.leftMouseDoubleClick = b;
    }

    public boolean isLeftMouseDoubleClick() {
        return this.leftMouseDoubleClick;
    }

    public MouseListener removeMouseListener() {
        MouseListener ml = this.mouseListener;
        this.mouseListener = null;
        return ml;
    }

    public MouseListener setMouseListener(MouseListener mouseListener) {
        MouseListener ml = mouseListener;
        this.mouseListener = mouseListener;
        return ml;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public boolean hasMouseListener() {
        return this.mouseListener != null;
    }

    public BalloonTooltipListener removeBalloonTooltipListener() {
        BalloonTooltipListener ml = this.balloonTooltipListener;
        this.balloonTooltipListener = null;
        return this.balloonTooltipListener;
    }

    public BalloonTooltipListener setBallonTooltipListener(BalloonTooltipListener balloonTooltipListener) {
        BalloonTooltipListener ml = balloonTooltipListener;
        this.balloonTooltipListener = balloonTooltipListener;
        return ml;
    }

    public BalloonTooltipListener getBallonTooltipListener() {
        return this.balloonTooltipListener;
    }

    public boolean hasBallonTooltipListener() {
        return this.balloonTooltipListener != null;
    }

    public void updateUI() {
        if (this.pMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.pMenu);
        }
    }

    public void setMenuVisible(boolean b, int x, int y) {
        if (!b) {
            if (this.pMenu != null) {
                this.pMenu.setVisible(false);
            }
        } else if (this.pMenu != null && this.pMenu.getSubElements().length > 0) {
            try {
                WindowsUtils.SetForegroundWindowEx(this.hWnd);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, ex);
            }
            this.pMenu.pack();
            this.pMenu.show(this.dummyWindow, x, y);
        }
    }

    final class TrayIconMouseListener
    extends MouseAdapter {
        TrayIconMouseListener() {
        }

        public final void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                TrayIcon.this.setMenuVisible(false, e.getX(), e.getY());
                if ((TrayIcon.this.isLeftMouseDoubleClick() && e.getClickCount() > 1 || !TrayIcon.this.isLeftMouseDoubleClick()) && TrayIcon.this.owner != null) {
                    TrayIcon.this.owner.setVisible(!TrayIcon.this.owner.isVisible());
                    if (TrayIcon.this.owner.isVisible()) {
                        TrayIcon.this.owner.setExtendedState(0);
                        TrayIcon.this.owner.toFront();
                        TrayIcon.this.owner.requestFocus();
                    }
                }
            } else if (e.getButton() == 3) {
                String javaVersion = System.getProperty("java.version");
                if (System.getProperty("java.class.version").equals("50.0") && Integer.parseInt(javaVersion.substring(javaVersion.lastIndexOf("_") + 1)) >= 10) {
                    if (TrayIcon.this.pMenu.getHeight() != 0) {
                        TrayIcon.this.setMenuVisible(true, e.getX(), e.getY() - TrayIcon.this.pMenu.getHeight());
                    } else {
                        TrayIcon.this.setMenuVisible(true, e.getX(), e.getY() - TrayIcon.this.pMenu.getSubElements().length * 20);
                    }
                } else {
                    TrayIcon.this.setMenuVisible(true, e.getX(), e.getY());
                }
            }
        }
    }
}

