/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util.constants;

import org.xvolks.jnative.com.utils.ByRef;

public class COM {
    public static final int LOCALE_SYSTEM_DEFAULT = 1024;
    public static final int LOCALE_USER_DEFAULT = 2048;
    public static final short VT_BOOL = 11;
    public static final short VT_BSTR = 8;
    public static final short VT_BYREF = 16384;
    public static final short VT_CY = 6;
    public static final short VT_DATE = 7;
    public static final short VT_DISPATCH = 9;
    public static final short VT_EMPTY = 0;
    public static final short VT_ERROR = 10;
    public static final short VT_I2 = 2;
    public static final short VT_I4 = 3;
    public static final short VT_NULL = 1;
    public static final short VT_R4 = 4;
    public static final short VT_R8 = 5;
    public static final short VT_UI1 = 17;
    public static final short VT_UI4 = 19;
    public static final short VT_UNKNOWN = 13;
    public static final short VT_VARIANT = 12;
    public static final short VT_PTR = 26;
    public static final short VT_USERDEFINED = 29;
    public static final short VT_HRESULT = 25;
    public static final short VT_DECIMAL = 14;
    public static final short VT_I1 = 16;
    public static final short VT_UI2 = 18;
    public static final short VT_I8 = 20;
    public static final short VT_UI8 = 21;
    public static final short VT_INT = 22;
    public static final short VT_UINT = 23;
    public static final short VT_VOID = 24;
    public static final short VT_SAFEARRAY = 27;
    public static final short VT_CARRAY = 28;
    public static final short VT_LPSTR = 30;
    public static final short VT_LPWSTR = 31;
    public static final short VT_RECORD = 36;
    public static final short VT_FILETIME = 64;
    public static final short VT_BLOB = 65;
    public static final short VT_STREAM = 66;
    public static final short VT_STORAGE = 67;
    public static final short VT_STREAMED_OBJECT = 68;
    public static final short VT_STORED_OBJECT = 69;
    public static final short VT_BLOB_OBJECT = 70;
    public static final short VT_CF = 71;
    public static final short VT_CLSID = 72;
    public static final short VT_VERSIONED_STREAM = 73;
    public static final short VT_BSTR_BLOB = 4095;
    public static final short VT_VECTOR = 4096;
    public static final short VT_ARRAY = 8192;

    public static void main(String[] args) {
        for (VARENUM e : VARENUM.values()) {
            int val = e.ordinal();
            if (e.ordinal() >= 34) {
                val = e.ordinal() + 30;
            } else if (e.ordinal() >= 31) {
                val = e.ordinal() + 5;
            } else if (val >= 15) {
                ++val;
            }
            System.err.println(e.name() + "\t\t(" + val + "),");
        }
    }

    public static String getTypeName(VARENUM type) {
        return COM.getTypeName(type.getValue());
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 11: {
                return "Boolean";
            }
            case 4: {
                return "Float";
            }
            case 5: {
                return "Double";
            }
            case 3: {
                return "Integer";
            }
            case 9: {
                return "IDispatch";
            }
            case 13: {
                return "IUnknown";
            }
            case 2: {
                return "Short";
            }
            case 8: {
                return "String";
            }
            case 12: {
                return "Variant";
            }
            case 6: {
                return "Currency";
            }
            case 7: {
                return "Date";
            }
            case 17: {
                return "/*uchar*/ Byte";
            }
            case 19: {
                return "/*uint32*/ Integer";
            }
            case 29: {
                return "Integer";
            }
            case 25: {
                return "Integer";
            }
            case 24: {
                return "void";
            }
            case 16395: {
                return ByRef.class.getName() + "<Boolean>";
            }
            case 16388: {
                return ByRef.class.getName() + "<Float>";
            }
            case 16389: {
                return ByRef.class.getName() + "<Double>";
            }
            case 16387: {
                return ByRef.class.getName() + "<Integer>";
            }
            case 16386: {
                return ByRef.class.getName() + "<Short>";
            }
            case 16401: {
                return ByRef.class.getName() + "<Byte>";
            }
            case 16403: {
                return ByRef.class.getName() + "<Integer>";
            }
            case 16392: {
                return ByRef.class.getName() + "<String>";
            }
            case 16390: 
            case 16391: 
            case 16393: 
            case 16396: 
            case 16397: 
            case 16413: {
                return ByRef.class.getName() + "<Object>";
            }
        }
        return "unknown " + type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VARENUM {
        VT_EMPTY(0),
        VT_NULL(1),
        VT_I2(2),
        VT_I4(3),
        VT_R4(4),
        VT_R8(5),
        VT_CY(6),
        VT_DATE(7),
        VT_BSTR(8),
        VT_DISPATCH(9),
        VT_ERROR(10),
        VT_BOOL(11),
        VT_VARIANT(12),
        VT_UNKNOWN(13),
        VT_DECIMAL(14),
        VT_I1(16),
        VT_UI1(17),
        VT_UI2(18),
        VT_UI4(19),
        VT_I8(20),
        VT_UI8(21),
        VT_INT(22),
        VT_UINT(23),
        VT_VOID(24),
        VT_HRESULT(25),
        VT_PTR(26),
        VT_SAFEARRAY(27),
        VT_CARRAY(28),
        VT_USERDEFINED(29),
        VT_LPSTR(30),
        VT_LPWSTR(31),
        VT_RECORD(36),
        VT_INT_PTR(37),
        VT_UINT_PTR(38),
        VT_FILETIME(64),
        VT_BLOB(65),
        VT_STREAM(66),
        VT_STORAGE(67),
        VT_STREAMED_OBJECT(68),
        VT_STORED_OBJECT(69),
        VT_BLOB_OBJECT(70),
        VT_CF(71),
        VT_CLSID(72),
        VT_VERSIONED_STREAM(73),
        VT_BSTR_BLOB(4095),
        VT_VECTOR(4096),
        VT_ARRAY(8192),
        VT_BYREF(16384),
        VT_RESERVED(32768),
        VT_ILLEGAL(65535),
        VT_ILLEGALMASKED(4095),
        VT_TYPEMASK(4095);

        private final int value;

        private VARENUM(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static VARENUM fromInt(int value) {
            for (VARENUM vare : VARENUM.values()) {
                if (vare.getValue() != value) continue;
                return vare;
            }
            throw new IllegalArgumentException(value + " is not a value VARENUM value");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IDLFLAG {
        IDLFLAG_NONE(0),
        IDLFLAG_FIN(1),
        IDLFLAG_FOUT(2),
        IDLFLAG_FLCID(4),
        IDLFLAG_FRETVAL(8);

        private final int value;

        private IDLFLAG(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static IDLFLAG fromInt(int value) {
            for (IDLFLAG flag : IDLFLAG.values()) {
                if (flag.value != value) continue;
                return flag;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DISPATCH_TYPE {
        DISPATCH_METHOD(1),
        DISPATCH_PROPERTYGET(2),
        DISPATCH_PROPERTYPUT(4),
        DISPATCH_PROPERTYPUTREF(8);

        private final int value;

        private DISPATCH_TYPE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

