/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util;

public class StructConverter {
    private StructConverter() {
    }

    public static long parseLong(String val) {
        return StructConverter.parseHex(val, 16);
    }

    public static int parseInt(String val) {
        return (int)StructConverter.parseHex(val, 8);
    }

    public static short parseShort(String val) {
        return (short)StructConverter.parseHex(val, 4);
    }

    private static long parseHex(String val, int maxChars) {
        int length = val.length();
        if (length > maxChars) {
            throw new NumberFormatException("unable to parse: '" + val + "' (too many digits)");
        }
        int shift = 0;
        long res = 0L;
        for (int i = length - 1; i >= 0; --i) {
            int digit = Character.digit(val.charAt(i), 16);
            if (digit < 0) {
                throw new NumberFormatException("unable to parse: '" + val + "' (invalid char at pos: " + i + ")");
            }
            res += (long)digit << shift;
            shift += 4;
        }
        return res;
    }

    public static long bytesIntoLong(byte[] bytes, int offset) {
        int nLo = StructConverter.bytesIntoInt(bytes, offset);
        int nHi = StructConverter.bytesIntoInt(bytes, offset + 4);
        return ((long)nHi << 32) + ((long)nLo & 0xFFFFFFFFL);
    }

    public static double bytesIntoDouble(byte[] bytes, int offset) {
        double d = Double.longBitsToDouble(StructConverter.bytesIntoLong(bytes, offset));
        return d;
    }

    public static float bytesIntoFloat(byte[] bytes, int offset) {
        float f = Float.intBitsToFloat(StructConverter.bytesIntoInt(bytes, offset));
        return f;
    }

    public static boolean bytesIntoBoolean(byte[] bytes, int offset) {
        return bytes[offset] != 0;
    }

    public static int bytesIntoInt(byte[] bytes, int offset) {
        int l = bytes[offset + 0] & 0xFF | (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 24;
        return l;
    }

    public static short bytesIntoShort(byte[] bytes, int offset) {
        int l = bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8;
        return (short)l;
    }

    public static int longIntoBytes(long data, byte[] bytes, int start) {
        bytes[start++] = (byte)data;
        bytes[start++] = (byte)(data >>> 8);
        bytes[start++] = (byte)(data >>> 16);
        bytes[start++] = (byte)(data >>> 24);
        bytes[start++] = (byte)(data >>> 32);
        bytes[start++] = (byte)(data >>> 40);
        bytes[start++] = (byte)(data >>> 48);
        bytes[start++] = (byte)(data >>> 56);
        return start;
    }

    public static int floatIntoBytes(float f, byte[] bytes, int start) {
        int data = Float.floatToIntBits(f);
        bytes[start++] = (byte)data;
        bytes[start++] = (byte)(data >>> 8);
        bytes[start++] = (byte)(data >>> 16);
        bytes[start++] = (byte)(data >>> 24);
        return start;
    }

    public static int doubleIntoBytes(double d, byte[] bytes, int start) {
        long data = Double.doubleToLongBits(d);
        bytes[start++] = (byte)data;
        bytes[start++] = (byte)(data >>> 8);
        bytes[start++] = (byte)(data >>> 16);
        bytes[start++] = (byte)(data >>> 24);
        bytes[start++] = (byte)(data >>> 32);
        bytes[start++] = (byte)(data >>> 40);
        bytes[start++] = (byte)(data >>> 48);
        bytes[start++] = (byte)(data >>> 56);
        return start;
    }

    public static int intIntoBytes(int data, byte[] bytes, int start) {
        bytes[start++] = (byte)data;
        bytes[start++] = (byte)(data >>> 8);
        bytes[start++] = (byte)(data >>> 16);
        bytes[start++] = (byte)(data >>> 24);
        return start;
    }

    public static final byte[] getBytes(int value) {
        byte[] x = new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
        return x;
    }

    public static int shortIntoBytes(short data, byte[] bytes, int start) {
        bytes[start++] = (byte)data;
        bytes[start++] = (byte)(data >>> 8);
        return start;
    }

    public static int byteArrayIntoBytes(byte[] src, byte[] dest, int start) {
        System.arraycopy(src, 0, dest, start, src.length);
        return start + src.length;
    }

    public static short swapShort(short x) {
        return (short)((x & 0xFF) << 8 | (x & 0xFF00) >>> 8);
    }

    public static int swapInt(int i) {
        int byte0 = i & 0xFF;
        int byte1 = i >> 8 & 0xFF;
        int byte2 = i >> 16 & 0xFF;
        int byte3 = i >> 24 & 0xFF;
        return byte0 << 24 | byte1 << 16 | byte2 << 8 | byte3;
    }
}

