/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.pointers.memory;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.AbstractMemoryBlock;
import org.xvolks.jnative.util.Kernel32;

public class GlobalMemoryBlock
extends AbstractMemoryBlock {
    public static final int GMEM_FIXED = 0;
    public static final int GMEM_ZEROINIT = 64;
    public static final int GPTR = 64;
    public static final int GMEM_MOVEABLE = 2;
    public static final int GHND = 66;
    private int type;

    public GlobalMemoryBlock(int size) throws NativeException {
        this(size, 64);
    }

    public GlobalMemoryBlock(int size, int type) throws NativeException {
        super(size);
        this.type = type;
        this.reserveMemory(size);
    }

    public int reserveMemory(int size) throws NativeException {
        this.setSize(size);
        if (this.getPointer() != null) {
            this.dispose();
        }
        try {
            this.setPointer(Kernel32.GlobalAlloc(size, this.type));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        return this.getPointer();
    }

    public void dispose() throws NativeException {
        try {
            if (this.getPointer() != null) {
                if (Kernel32.GlobalFree(this.getPointer()) != 0) {
                    throw new NativeException("Memory not freed !");
                }
                this.setPointer(null);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public int globalLock() throws NativeException, IllegalAccessException {
        return Kernel32.GlobalLock(this.getPointer());
    }

    public boolean globalUnlock() throws NativeException, IllegalAccessException {
        return Kernel32.GlobalUnlock(this.getPointer());
    }

    public boolean copyMemory(Pointer fromPointer) throws NativeException, IllegalAccessException {
        int destPointer = this.globalLock();
        if (destPointer != 0) {
            Kernel32.RtlMoveMemory(destPointer, fromPointer.getPointer(), fromPointer.getSize());
        }
        return destPointer != 0 && this.globalUnlock();
    }

    public boolean copyMemory(Pointer fromPointer, int size) throws NativeException, IllegalAccessException {
        int destPointer = this.globalLock();
        if (destPointer != 0) {
            Kernel32.RtlMoveMemory(destPointer, fromPointer.getPointer(), size);
        }
        return destPointer != 0 && this.globalUnlock();
    }
}

