/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc.basicStructures;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.machine.Machine;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UINT
extends AbstractBasicData<Integer> {
    public UINT(int value) {
        super(value);
        try {
            this.createPointer();
        }
        catch (NativeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public UINT(short value) {
        this((int)value);
    }

    @Override
    public int getSizeOf() {
        return UINT.sizeOf();
    }

    @Override
    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(UINT.sizeOf()));
        this.pointer.setIntAt(0, (Integer)this.mValue);
        return this.pointer;
    }

    @Override
    public Integer getValueFromPointer() throws NativeException {
        this.mValue = new Integer(this.pointer.getAsInt(0));
        return (Integer)this.mValue;
    }

    public void setValue(Integer lValue) throws NativeException {
        this.mValue = lValue;
        this.pointer.setIntAt(0, (Integer)this.mValue);
    }

    @Override
    public Integer getValue() {
        try {
            return this.getValueFromPointer();
        }
        catch (NativeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Short getValueAsShort() {
        try {
            return this.getValueFromPointer().shortValue();
        }
        catch (NativeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static int sizeOf() {
        return Machine.SIZE * 4;
    }
}

