/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.logging;

import java.text.SimpleDateFormat;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.logging.AbstractLogger;
import org.xvolks.jnative.logging.JNativeLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleLogger
extends AbstractLogger {
    private ConsoleLogger(Integer logLevel) {
        super(logLevel);
    }

    public static JNativeLogger getInstance(Class<?> clazz) {
        return ConsoleLogger.getInstance(clazz.getName());
    }

    public static JNativeLogger getInstance(String name) {
        JNativeLogger logger = null;
        if (!loggers.containsKey(name)) {
            logger = new ConsoleLogger(ConsoleLogger.getSystemLogLevel());
            logger.setName(name);
            loggers.put(name, logger);
        } else {
            logger = (JNativeLogger)loggers.get(name);
        }
        return logger;
    }

    @Override
    public void log(JNativeLogger.SEVERITY severity, Object message) {
        String[] str;
        if (!JNative.isLogginEnabled() || severity.ordinal() > this.getLoggerLevel().ordinal()) {
            return;
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(SimpleDateFormat.getDateTimeInstance().format(System.currentTimeMillis()));
        strBuf.append(",");
        if (severity != null) {
            strBuf.append(" " + severity.getName());
        }
        if ((str = this.inferCaller()) != null) {
            strBuf.append(" [" + str[0] + "]");
            strBuf.append(" [" + str[1] + "]: ");
        }
        if (message instanceof Throwable) {
            Throwable err = (Throwable)message;
            strBuf.append(err.getMessage());
            for (int i = 0; i < err.getStackTrace().length; ++i) {
                strBuf.append(System.getProperty("line.separator"));
                strBuf.append(err.getStackTrace()[i].toString());
            }
        } else {
            strBuf.append(message);
        }
        System.err.println(strBuf.toString());
    }

    private String[] inferCaller() {
        StackTraceElement frame;
        String cname;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals(this.getClass().getName()); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(this.getClass().getName())) {
                String[] str = new String[]{cname, frame.getMethodName()};
                return str;
            }
            ++ix;
        }
        return null;
    }

    @Override
    public void log(Object message) {
        this.log(JNativeLogger.SEVERITY.INFO, message);
    }
}

