/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.com.typebrowser.business;

import java.util.List;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.com.interfaces.IDispatch;
import org.xvolks.jnative.com.interfaces.ITypeInfo;
import org.xvolks.jnative.com.interfaces.structures.FUNCDESC;
import org.xvolks.jnative.com.interfaces.structures.TYPEATTR;
import org.xvolks.jnative.com.interfaces.structures.VARDESC;
import org.xvolks.jnative.com.typebrowser.business.description.FunctionDescription;
import org.xvolks.jnative.com.typebrowser.business.description.IDispatchDescription;
import org.xvolks.jnative.com.typebrowser.business.description.ParameterDescription;
import org.xvolks.jnative.com.typebrowser.business.description.VariableDescription;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.NativeMemoryBlock;
import org.xvolks.jnative.util.constants.COM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COMIntrospector {
    static IDispatch currentIDispatch;

    public static IDispatchDescription introspectIDispatch(IDispatch idispatch) throws NativeException, IllegalAccessException {
        int ppTInfo;
        currentIDispatch = idispatch;
        IDispatchDescription description = new IDispatchDescription(idispatch.getProgId());
        try {
            ppTInfo = idispatch.getTypeInfo(0, 2048);
        }
        catch (Exception e) {
            e.printStackTrace();
            ppTInfo = idispatch.getTypeInfo(0, 0);
        }
        JNative.getLogger().log(JNativeLogger.SEVERITY.TRACE, String.format("ITypeInfo pointer is %08x", ppTInfo));
        ITypeInfo iTypeInfo = new ITypeInfo(ppTInfo);
        TYPEATTR typeattr = iTypeInfo.GetTypeAttr();
        JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Version of " + idispatch.getProgId() + " : " + typeattr.getWMajorVerNum() + "." + typeattr.getWMinorVerNum());
        if (typeattr != null) {
            int i;
            if (typeattr.getCFuncs() > 0) {
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "Functions for " + idispatch.getProgId() + " :");
            }
            for (i = 0; i < typeattr.getCFuncs(); ++i) {
                FUNCDESC funcDesc = iTypeInfo.GetFuncDesc(i);
                description.getFunctionDescriptions().add(COMIntrospector.introspectFunction(iTypeInfo, funcDesc));
                funcDesc.dispose();
            }
            for (i = 0; i < typeattr.getCVars(); ++i) {
                VARDESC varDesc = iTypeInfo.GetVarDesc(i);
                description.getVariableDescriptions().add(COMIntrospector.introspectVariable(iTypeInfo, varDesc));
                varDesc.dispose();
            }
        }
        typeattr.dispose();
        iTypeInfo.release();
        return description;
    }

    private static FunctionDescription introspectFunction(ITypeInfo iTypeInfo, FUNCDESC desc) throws NativeException, IllegalAccessException {
        ITypeInfo.Documentation doc = iTypeInfo.GetDocumentation(desc.getMemid());
        List<String> names = iTypeInfo.GetNames(desc.getMemid(), desc.getCParams() + 1);
        FunctionDescription description = names.size() > 0 ? new FunctionDescription(names.get(0), doc, desc) : new FunctionDescription("##Anonymous", doc, desc);
        JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, desc.getInvkind().toString() + " " + description.getName());
        Pointer pElemDesc = new Pointer(new NativeMemoryBlock(desc.getLprgelemdescParam(), 16 * desc.getCParams()));
        for (int j = 0; j < desc.getCParams(); ++j) {
            COMIntrospector.introspectParameter(j, desc, names, description, pElemDesc);
        }
        description.setReturnType(desc.getElemDesc_typeDesc_desc_vt());
        if (description.getReturnType() == 26) {
            Pointer pRetType = new Pointer(new NativeMemoryBlock(desc.getElemDesc_typeDesc_desc_union() + 4, 2));
            description.setReturnType(pRetType.getAsShort(0));
        }
        JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "\tValeur de retour " + COM.getTypeName(description.getReturnType()));
        return description;
    }

    private static VariableDescription introspectVariable(ITypeInfo iTypeInfo, VARDESC desc) throws NativeException, IllegalAccessException {
        int paramIndex = desc.getMemid();
        ITypeInfo.Documentation documentation = iTypeInfo.GetDocumentation(paramIndex);
        String name = documentation.getName();
        int type = desc.getElemdescVar_tdesc_vt();
        if (type == 26) {
            Pointer pArgType1 = new Pointer(new NativeMemoryBlock(desc.getElemdescVar_tdesc_union() + 16 * paramIndex, 4));
            type = new Pointer(new NativeMemoryBlock(pArgType1.getAsInt(0) + 4, 2)).getAsShort(0);
            type |= 0x4000;
        }
        VariableDescription variableDescription = new VariableDescription(name, documentation, desc);
        JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "PROPERTY Type " + COM.getTypeName(type) + ", Flags " + desc.getWVarFlags() + ", Name " + name);
        return variableDescription;
    }

    private static void introspectParameter(int paramIndex, FUNCDESC desc, List<String> names, FunctionDescription description, Pointer pElemDesc) throws NativeException {
        short varType = pElemDesc.getAsShort(16 * paramIndex + 4);
        if (varType == 26) {
            Pointer pArgType1 = new Pointer(new NativeMemoryBlock(desc.getLprgelemdescParam() + 16 * paramIndex, 4));
            varType = new Pointer(new NativeMemoryBlock(pArgType1.getAsInt(0) + 4, 2)).getAsShort(0);
            varType = (short)(varType | 0x4000);
        }
        String name = names.size() > paramIndex + 1 ? names.get(paramIndex + 1) : "###Anonymous";
        Pointer pFlag = new Pointer(new NativeMemoryBlock(desc.getLprgelemdescParam() + paramIndex * 16 + 8 + 4, 2));
        ParameterDescription parameterDescription = new ParameterDescription(name, varType, pFlag.getAsShort(0));
        description.getParameters().add(parameterDescription);
        JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "\tType " + COM.getTypeName(parameterDescription.getType()) + ", Flags " + parameterDescription.getFlags() + ", Name " + name);
    }
}

