/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.com.interfaces;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.com.interfaces.IUnknown;
import org.xvolks.jnative.com.utils.COMActuator;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.util.constants.COM;
import org.xvolks.jnative.util.constants.WinError;
import org.xvolks.jnative.util.ole.Ole32;
import org.xvolks.jnative.util.windows.structures.GUID;

public class IDispatch
extends IUnknown
implements Runnable {
    public static final GUID IIDIDispatch = new GUID("{00020400-0000-0000-c000-000000000046}");
    private Thread dispatchThread;
    private Object initedLock = new Object();
    private boolean disposed = false;
    private boolean messagePumpingStarted = false;
    private Object loopMutex = new Object();
    private Throwable initThrowable = null;
    private final String clsid;
    private final String iid;
    private String progId;

    private native long GetIDsOfNames(String var1, int var2) throws IllegalArgumentException;

    private native long GetTypeInfo(int var1, int var2) throws NativeException, IllegalArgumentException;

    public int getIDsOfNames(String name, int cNames) {
        int id = (int)this.GetIDsOfNames(name, cNames);
        return id;
    }

    public int getTypeInfo(int iTInfo, int lcid) throws IllegalArgumentException, NativeException {
        return (int)this.GetTypeInfo(iTInfo, lcid);
    }

    protected IDispatch(GUID iid, IUnknown parent, int iidAddress) throws Throwable {
        super(iidAddress);
        this.progId = null;
        this.clsid = null;
        this.iid = iid.toString();
        this.dispatchThread = new Thread(this);
        this.dispatchThread.setDaemon(true);
    }

    public IDispatch(GUID clsId, GUID iid) throws Throwable {
        this(clsId, iid.toString());
    }

    public IDispatch(GUID clsId, GUID iid, Thread dispatchThread, HWND hWnd) throws Throwable {
        this(clsId, iid.toString(), dispatchThread, hWnd);
    }

    public IDispatch(GUID clsId, String iid) throws Throwable {
        this(clsId, iid, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDispatch(final GUID clsId, final String iid, final Thread dispatchThread, HWND hWnd) throws Throwable {
        this.iid = iid;
        this.clsid = clsId.toString();
        if (dispatchThread == null) {
            this.dispatchThread = new Thread(this);
            this.dispatchThread.setDaemon(true);
            Object object = this.initedLock;
            synchronized (object) {
                try {
                    this.getLogger().debug("Starting IDispatch thread");
                    this.dispatchThread.setName("IDispatchThread-" + this.dispatchThread.getId());
                    this.dispatchThread.start();
                    this.initedLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.initThrowable != null) {
                throw this.initThrowable;
            }
        } else {
            this.setHWnd((Integer)hWnd.getValue());
            JNative.getLogger().log("About to syncExec to create Instance using window " + hWnd.getValue());
            long id = dispatchThread.getId();
            this.setOwnerThreadId((int)id);
            COMActuator.syncExecute(this, new Runnable(){

                public void run() {
                    IDispatch.this.dispatchThread = Thread.currentThread();
                    IDispatch.this.getLogger().log(dispatchThread.getName());
                    try {
                        if (WinError.SUCCEEDED(Ole32.CoInitialize())) {
                            Pointer pointer = Ole32.CoCreateInstance(clsId, null, Ole32.CLSCTX_ALL, new GUID(iid));
                            IDispatch.this.setPIUnknown(pointer.getAsInt(0));
                        }
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    catch (NativeException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        this.getLogger().debug("testing SyncExec");
        COMActuator.syncExecute(this, new Runnable(){

            public void run() {
                IDispatch.this.getLogger().debug("Java code executed in syncExec");
            }
        });
        this.getLogger().debug("syncExec is working great.");
    }

    public IDispatch(String progId) throws Throwable {
        this(progId, IIDIDispatch.toString());
    }

    public IDispatch(String progId, GUID iid, Thread dispatchThread, HWND hwnd) throws Throwable {
        this(IDispatch.getClassID(progId), iid.toString(), dispatchThread, hwnd);
        this.progId = progId;
    }

    public IDispatch(String progId, GUID iid) throws Throwable {
        this(progId, iid.toString());
    }

    public IDispatch(String progId, String iid) throws Throwable {
        this(IDispatch.getClassID(progId), iid, null, null);
        this.progId = progId;
    }

    public String getIid() {
        return this.iid;
    }

    public String getProgId() {
        return this.progId;
    }

    protected static GUID getClassID(String clientName) throws NativeException, IllegalAccessException {
        GUID guid = Ole32.CLSIDFromProgID(clientName);
        if (guid == null && (guid = Ole32.CLSIDFromString(clientName)) == null) {
            throw new IllegalArgumentException("Illegal progId : " + clientName);
        }
        return guid;
    }

    public Object getProperty(int dispIdMember) {
        return this.invoke(dispIdMember, COM.DISPATCH_TYPE.DISPATCH_PROPERTYGET, null);
    }

    public void setProperty(int dispIdMember, Object value) {
        this.invoke(dispIdMember, COM.DISPATCH_TYPE.DISPATCH_PROPERTYPUT, new Object[]{value});
    }

    public Object invoke(int dispIdMember, Object[] params) {
        return this.invoke(dispIdMember, COM.DISPATCH_TYPE.DISPATCH_METHOD, params);
    }

    public Object invoke(int dispIdMember, COM.DISPATCH_TYPE wFlags, Object[] params) {
        return COMActuator.invoke(this, dispIdMember, wFlags.getValue(), params);
    }

    public Object syncExec(Runnable r) {
        return COMActuator.syncExecute(this, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                COMActuator.dispose(IDispatch.this);
            }
        });
        if (this.clsid == null || this.iid == null) {
            this.initThrowable = new NullPointerException("clsid NOR iid cannot be null !!!");
        } else {
            try {
                this.getLogger().debug(String.format("Calling comNewInstance(%s, %s)", this.clsid, this.iid));
                COMActuator.initCOMObject(this, this.clsid, this.iid);
                this.addRef();
                this.getLogger().debug("comNewInstance() succeeded");
            }
            catch (Throwable t) {
                this.getLogger().debug("comNewInstance() failed " + t.toString());
                this.initThrowable = t;
            }
        }
        Object object = this.initedLock;
        synchronized (object) {
            this.initedLock.notify();
        }
        if (this.initThrowable == null) {
            this.doMessagePump();
        }
    }

    protected void beforeMessagePump() {
    }

    protected void afterMessagePump() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doMessagePump() {
        block16: {
            if (this.clsid == null || this.iid == null) {
                return;
            }
            boolean doLoop = false;
            Object object = this.loopMutex;
            synchronized (object) {
                if (!this.messagePumpingStarted) {
                    this.messagePumpingStarted = true;
                    doLoop = true;
                }
            }
            if (doLoop) {
                try {
                    this.beforeMessagePump();
                }
                catch (Throwable t) {
                    this.getLogger().error("Error in beforeMessagePump(). Exiting IDispatch Thread.", t);
                    return;
                }
                COMActuator.doMessagePump(this);
                Object var5_6 = null;
                try {
                    this.afterMessagePump();
                }
                catch (Throwable t2) {
                    this.getLogger().warn("Error in afterMessagePump().", t2);
                }
                break block16;
                {
                    catch (Throwable t) {
                        this.getLogger().error("Error in message pumping native loop", t);
                        Object var5_7 = null;
                        try {
                            this.afterMessagePump();
                        }
                        catch (Throwable t2) {
                            this.getLogger().warn("Error in afterMessagePump().", t2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    try {
                        this.afterMessagePump();
                    }
                    catch (Throwable t2) {
                        this.getLogger().warn("Error in afterMessagePump().", t2);
                    }
                    throw throwable;
                }
            }
        }
    }

    protected synchronized void exitMessagePump() {
        if (this.progId == null || this.iid == null) {
            return;
        }
        if (this.messagePumpingStarted) {
            COMActuator.exitMessagePump(this);
            this.messagePumpingStarted = false;
        }
    }

    public synchronized void dispose() {
        if (this.progId == null || this.iid == null) {
            return;
        }
        if (!this.disposed) {
            COMActuator.dispose(this);
            this.exitMessagePump();
            try {
                this.release();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.disposed = true;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

