/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.com;

import org.xvolks.jnative.com.IEventsListener;
import org.xvolks.jnative.com.interfaces.IDispatch;
import org.xvolks.jnative.com.utils.Logger;

public abstract class AbstractEventsProxy
implements IEventsListener {
    private int eventCookie;
    private Logger logger;
    private String sinkIID;
    private boolean disposed = false;
    private IDispatch iDispatch;

    private native AbstractEventsProxy comNewInstance(int var1, String var2) throws Exception;

    private native void comDispose() throws Exception;

    protected void setEventCookie(int eventCookie) {
        this.eventCookie = eventCookie;
    }

    protected int getEventCookie() {
        return this.eventCookie;
    }

    protected String getSinkIID() {
        return this.sinkIID;
    }

    protected int getPIUnknown() {
        return this.iDispatch.getPIUnknown();
    }

    public AbstractEventsProxy(IDispatch iDispatch, String sinkIID) throws Exception {
        this.iDispatch = iDispatch;
        this.eventCookie = 0;
        this.logger = Logger.getInstance(this.getClass().getSimpleName());
        this.sinkIID = sinkIID;
        iDispatch.syncExec(new ComNewInstanceTask(iDispatch, this.sinkIID));
    }

    public synchronized void dispose() {
        if (!this.disposed) {
            try {
                this.iDispatch.syncExec(new ComDisposeTask(this.iDispatch, this.sinkIID));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.disposed = true;
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    private class ComDisposeTask
    extends ComTasks {
        public ComDisposeTask(IDispatch iDispatch, String sinkIID) {
            super(iDispatch, sinkIID);
        }

        public void run() {
            try {
                AbstractEventsProxy.this.comDispose();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private class ComNewInstanceTask
    extends ComTasks {
        public ComNewInstanceTask(IDispatch iDispatch, String sinkIID) {
            super(iDispatch, sinkIID);
        }

        public void run() {
            try {
                AbstractEventsProxy.this.comNewInstance(this.iDispatch.getPIUnknown(), this.sinkIID);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private abstract class ComTasks
    implements Runnable {
        protected String sinkIID;
        protected IDispatch iDispatch;

        public ComTasks(IDispatch iDispatch, String sinkIID) {
            this.iDispatch = iDispatch;
            this.sinkIID = sinkIID;
        }

        public abstract void run();
    }
}

