/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import junit.framework.TestCase;
import org.python.indexer.AstCache;
import org.python.indexer.Def;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Ref;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class TestBase
extends TestCase {
    protected static final String TEST_SOURCE_DIR = System.getProperties().getProperty("python.test.source.dir") + "/org/python/indexer/";
    protected static final String TEST_DATA_DIR = TEST_SOURCE_DIR + "data/";
    protected static final String TEST_LIB_DIR = System.getProperties().getProperty("python.home") + "/Lib/";
    protected Indexer idx;

    protected void setUp() throws Exception {
        this.idx = new Indexer();
        this.idx.enableAggressiveAssertions(true);
        this.idx.setProjectDir(TEST_DATA_DIR);
        AstCache.get().clearDiskCache();
        AstCache.get().clear();
    }

    protected void includeStandardLibrary() throws Exception {
        this.idx.addPath(TEST_LIB_DIR);
    }

    protected String abspath(String file) {
        return this.getTestFilePath(file);
    }

    protected String getTestFilePath(String file) {
        return TEST_DATA_DIR + file;
    }

    protected String getSource(String file) throws Exception {
        String line;
        String path = this.getTestFilePath(file);
        StringBuilder sb = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
        while ((line = in.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        in.close();
        return sb.toString();
    }

    protected String makeModule(String ... lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    protected String index(String filename, String ... lines) throws Exception {
        String src = this.makeModule(lines);
        this.idx.loadString(filename, src);
        this.idx.ready();
        return src;
    }

    protected int nthIndexOf(String s, String find, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int index = -1;
        for (int i = 0; i < n; ++i) {
            if ((index = s.indexOf(find, index == -1 ? 0 : index + 1)) != -1) continue;
            throw new IllegalArgumentException();
        }
        return index;
    }

    public void testHandleExceptionLoggingNulls() throws Exception {
        try {
            this.idx.enableAggressiveAssertions(false);
            this.idx.getLogger().setLevel(Level.OFF);
            this.idx.handleException(null, new Exception());
            this.idx.handleException("oops", null);
        }
        catch (Throwable t) {
            TestBase.fail("should not have thrown: " + t);
        }
    }

    public void testDataFileFindable() throws Exception {
        TestBase.assertTrue("Test file not found", new File(TEST_DATA_DIR).exists());
    }

    public void testLoadDataFile() throws Exception {
        String path = this.abspath("test-load.txt");
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
        TestBase.assertEquals(in.readLine().trim(), "hello");
        in.close();
    }

    public void testGetSource() throws Exception {
        String src = this.getSource("testsrc.txt");
        TestBase.assertEquals("one\ntwo\n\nthree\n", src);
    }

    public void testStringModule() throws Exception {
        this.idx.loadString("test-string-module.py", this.makeModule("def foo():", "  pass"));
        this.idx.ready();
        this.assertFunctionBinding("test-string-module.foo");
    }

    public void testNthIndexOf() throws Exception {
        String s = "ab a b ab a\nb aab";
        TestBase.assertEquals(0, this.nthIndexOf(s, "ab", 1));
        TestBase.assertEquals(7, this.nthIndexOf(s, "ab", 2));
        TestBase.assertEquals(15, this.nthIndexOf(s, "ab", 3));
        try {
            TestBase.assertEquals(-1, this.nthIndexOf(s, "ab", 0));
            TestBase.assertTrue(false);
        }
        catch (IllegalArgumentException ix) {
            TestBase.assertTrue(true);
        }
        try {
            TestBase.assertEquals(-1, this.nthIndexOf(s, "ab", 4));
            TestBase.assertTrue(false);
        }
        catch (IllegalArgumentException ix) {
            TestBase.assertTrue(true);
        }
    }

    public void testIndexerDefaults() throws Exception {
        this.includeStandardLibrary();
        TestBase.assertEquals("wrong project dir", TEST_DATA_DIR, this.idx.projDir);
        TestBase.assertEquals("unexpected load path entries", 1, this.idx.path.size());
        TestBase.assertEquals(TEST_LIB_DIR, this.idx.path.get(0));
    }

    public String buildIndex(String ... files) throws Exception {
        for (String f : files) {
            this.idx.loadFile(this.abspath(f));
        }
        this.idx.ready();
        return this.getSource(files[0]);
    }

    public NBinding getBinding(String qname) throws Exception {
        NBinding b = this.idx.lookupQname(qname);
        TestBase.assertNotNull("no binding found for " + qname, b);
        return b;
    }

    public NBinding assertBinding(String qname, NBinding.Kind kind) throws Exception {
        NBinding b = this.getBinding(qname);
        TestBase.assertEquals((Object)kind, (Object)b.getKind());
        return b;
    }

    public void assertNoBinding(String qname) throws Exception {
        NBinding b = this.idx.lookupQname(qname);
        TestBase.assertNull("Should not have found binding for " + qname, b);
    }

    public NBinding assertAttributeBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.ATTRIBUTE);
    }

    public NBinding assertBuiltinBinding(String qname) throws Exception {
        NBinding b = this.getBinding(qname);
        TestBase.assertTrue(b.isBuiltin());
        return b;
    }

    public NBinding assertClassBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.CLASS);
    }

    public NBinding assertConstructorBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.CONSTRUCTOR);
    }

    public NBinding assertFunctionBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.FUNCTION);
    }

    public NBinding assertMethodBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.METHOD);
    }

    public NBinding assertModuleBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.MODULE);
    }

    public NBinding assertScopeBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.SCOPE);
    }

    public NBinding assertVariableBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.VARIABLE);
    }

    public NBinding assertParamBinding(String qname) throws Exception {
        return this.assertBinding(qname, NBinding.Kind.PARAMETER);
    }

    public void assertStaticSynthetic(NBinding b) {
        TestBase.assertTrue(b.isStatic());
        TestBase.assertTrue(b.isSynthetic());
    }

    public Def getDefinition(String qname, int offset, int length) throws Exception {
        NBinding b = this.getBinding(qname);
        TestBase.assertNotNull(b.getDefs());
        for (Def def : b.getDefs()) {
            if (offset != def.start() || length != def.end() - def.start()) continue;
            return def;
        }
        return null;
    }

    public void assertDefinition(String qname, int offset, int length) throws Exception {
        Def def = this.getDefinition(qname, offset, length);
        if (def == null) {
            TestBase.fail("No definition for " + qname + " at " + offset + " of len " + length);
        }
    }

    public void assertNoDefinition(String msg, String qname, int pos, int len) throws Exception {
        Def def = this.getDefinition(qname, pos, len);
        TestBase.assertNull(msg, def);
    }

    public void assertDefinition(String qname, int offset) throws Exception {
        String[] names = qname.split("[.&@]");
        this.assertDefinition(qname, offset, names[names.length - 1].length());
    }

    public void assertDefinition(String qname, String name, int offset) throws Exception {
        this.assertDefinition(qname, offset, name.length());
    }

    public Ref getRefOrNull(String qname, int offset, int length) throws Exception {
        NBinding b = this.getBinding(qname);
        TestBase.assertNotNull("Null refs list for " + qname, b.getRefs());
        for (Ref ref : b.getRefs()) {
            if (offset != ref.start() || length != ref.length()) continue;
            return ref;
        }
        return null;
    }

    public Ref getRefOrFail(String qname, int offset, int length) throws Exception {
        Ref ref = this.getRefOrNull(qname, offset, length);
        TestBase.assertNotNull("No reference to " + qname + " at offset " + offset + " of length " + length, ref);
        return ref;
    }

    public void assertReference(String qname, int offset, int length) throws Exception {
        TestBase.assertTrue(this.getRefOrFail(qname, offset, length).isRef());
    }

    public void assertReference(String qname, int offset, String refname) throws Exception {
        this.assertReference(qname, offset, refname.length());
    }

    public void assertReference(String qname, int offset) throws Exception {
        String[] names = qname.split("[.&@]");
        this.assertReference(qname, offset, names[names.length - 1]);
    }

    public void assertNoReference(String msg, String qname, int pos, int len) throws Exception {
        TestBase.assertNull(msg, this.getRefOrNull(qname, pos, len));
    }

    public void assertCall(String qname, int offset, int length) throws Exception {
        TestBase.assertTrue(this.getRefOrFail(qname, offset, length).isCall());
    }

    public void assertCall(String qname, int offset, String refname) throws Exception {
        this.assertCall(qname, offset, refname.length());
    }

    public void assertCall(String qname, int offset) throws Exception {
        String[] names = qname.split("[.&@]");
        this.assertCall(qname, offset, names[names.length - 1]);
    }

    public void assertConstructed(String qname, int offset, int length) throws Exception {
        TestBase.assertTrue(this.getRefOrFail(qname, offset, length).isNew());
    }

    public void assertConstructed(String qname, int offset, String refname) throws Exception {
        this.assertConstructed(qname, offset, refname.length());
    }

    public void assertConstructed(String qname, int offset) throws Exception {
        String[] names = qname.split("[.&@]");
        this.assertConstructed(qname, offset, names[names.length - 1]);
    }

    public NType getTypeBinding(String typeQname) throws Exception {
        NType type = this.idx.lookupQnameType(typeQname);
        TestBase.assertNotNull("No recorded type for " + typeQname, type);
        return type;
    }

    public NBinding assertBindingType(String bindingQname, String typeQname) throws Exception {
        NBinding b = this.getBinding(bindingQname);
        NType expected = this.getTypeBinding(typeQname);
        TestBase.assertEquals("Wrong binding type", expected, NUnknownType.follow(b.getType()));
        return b;
    }

    public NBinding assertBindingType(String bindingQname, Class type) throws Exception {
        NBinding b = this.getBinding(bindingQname);
        NType btype = NUnknownType.follow(b.getType());
        TestBase.assertTrue("Wrong type: expected " + type + " but was " + btype, type.isInstance(btype));
        return b;
    }

    public void assertListType(String bindingQname) throws Exception {
        this.assertListType(bindingQname, null);
    }

    public void assertListType(String bindingQname, String eltTypeQname) throws Exception {
        NBinding b = this.getBinding(bindingQname);
        NType btype = b.followType();
        TestBase.assertTrue(btype.isListType());
        if (eltTypeQname != null) {
            NType eltType = this.getTypeBinding(eltTypeQname);
            TestBase.assertEquals(eltType, NUnknownType.follow(btype.asListType().getElementType()));
        }
    }

    public void assertStringType(String bindingQname) throws Exception {
        this.assertBindingType(bindingQname, "__builtin__.str");
    }

    public void assertNumType(String bindingQname) throws Exception {
        this.assertBindingType(bindingQname, "__builtin__.float");
    }

    public void assertInstanceType(String bindingQname, String classQname) throws Exception {
        this.assertBindingType(bindingQname, classQname);
    }
}

