/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import junit.framework.TestCase;
import org.python.core.PySystemState;
import org.python.posix.util.Platform;

public class PySystemStateTest
extends TestCase {
    public void testGetJarFileNameFromURL() throws Exception {
        PySystemStateTest.assertNull(PySystemState.getJarFileNameFromURL(null));
        String urlString = "jar:file:/some_dir/some.jar!/a/package/with/A.class";
        URL url = new URL(urlString);
        PySystemStateTest.assertEquals("/some_dir/some.jar", PySystemState.getJarFileNameFromURL(url));
        urlString = "jar:file:/some%20dir/some.jar!/a/package/with/A.class";
        url = new URL(urlString);
        PySystemStateTest.assertEquals("/some dir/some.jar", PySystemState.getJarFileNameFromURL(url));
        urlString = "jar:file:/some+dir/some.jar!/a/package/with/A.class";
        url = new URL(urlString);
        PySystemStateTest.assertEquals("/some+dir/some.jar", PySystemState.getJarFileNameFromURL(url));
    }

    public void testGetJarFileNameFromURL_jboss() throws Exception {
        String protocol = "vfszip";
        String host = "";
        int port = -1;
        TestJBossURLStreamHandler handler = new TestJBossURLStreamHandler();
        if (Platform.IS_WINDOWS) {
            String file = "/C:/some_dir/some.jar/org/python/core/PySystemState.class";
            URL url = new URL("vfszip", "", -1, file, handler);
            PySystemStateTest.assertEquals("vfszip:/C:/some_dir/some.jar/org/python/core/PySystemState.class", url.toString());
            PySystemStateTest.assertEquals("C:/some_dir/some.jar", PySystemState.getJarFileNameFromURL(url));
            file = "/C:/some%20dir/some.jar/org/python/core/PySystemState.class";
            url = new URL("vfszip", "", -1, file, handler);
            PySystemStateTest.assertEquals("vfszip:/C:/some%20dir/some.jar/org/python/core/PySystemState.class", url.toString());
            PySystemStateTest.assertEquals("C:/some dir/some.jar", PySystemState.getJarFileNameFromURL(url));
            file = "/C:/some+dir/some.jar/org/python/core/PySystemState.class";
            url = new URL("vfszip", "", -1, file, handler);
            PySystemStateTest.assertEquals("vfszip:/C:/some+dir/some.jar/org/python/core/PySystemState.class", url.toString());
            PySystemStateTest.assertEquals("C:/some+dir/some.jar", PySystemState.getJarFileNameFromURL(url));
        } else {
            String file = "/some_dir/some.jar/org/python/core/PySystemState.class";
            URL url = new URL("vfszip", "", -1, file, handler);
            PySystemStateTest.assertEquals("vfszip:/some_dir/some.jar/org/python/core/PySystemState.class", url.toString());
            PySystemStateTest.assertEquals("/some_dir/some.jar", PySystemState.getJarFileNameFromURL(url));
            file = "/some%20dir/some.jar/org/python/core/PySystemState.class";
            url = new URL("vfszip", "", -1, file, handler);
            PySystemStateTest.assertEquals("vfszip:/some%20dir/some.jar/org/python/core/PySystemState.class", url.toString());
            PySystemStateTest.assertEquals("/some dir/some.jar", PySystemState.getJarFileNameFromURL(url));
            file = "/some+dir/some.jar/org/python/core/PySystemState.class";
            url = new URL("vfszip", "", -1, file, handler);
            PySystemStateTest.assertEquals("vfszip:/some+dir/some.jar/org/python/core/PySystemState.class", url.toString());
            PySystemStateTest.assertEquals("/some+dir/some.jar", PySystemState.getJarFileNameFromURL(url));
        }
    }

    protected static class TestJBossURLStreamHandler
    extends URLStreamHandler {
        protected TestJBossURLStreamHandler() {
        }

        protected URLConnection openConnection(URL u) throws IOException {
            throw new RuntimeException("unexpected call to openConnection " + u.toString());
        }
    }
}

