/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.statements;

import org.junit.runners.model.Statement;

public class FailOnTimeout
extends Statement {
    private Statement fNext;
    private final long fTimeout;
    private boolean fFinished = false;
    private Throwable fThrown = null;

    public FailOnTimeout(Statement next, long timeout) {
        this.fNext = next;
        this.fTimeout = timeout;
    }

    public void evaluate() throws Throwable {
        Thread thread2 = new Thread(){

            public void run() {
                try {
                    FailOnTimeout.this.fNext.evaluate();
                    FailOnTimeout.this.fFinished = true;
                }
                catch (Throwable e) {
                    FailOnTimeout.this.fThrown = e;
                }
            }
        };
        thread2.start();
        thread2.join(this.fTimeout);
        if (this.fFinished) {
            return;
        }
        if (this.fThrown != null) {
            throw this.fThrown;
        }
        Exception exception = new Exception(String.format("test timed out after %d milliseconds", this.fTimeout));
        exception.setStackTrace(thread2.getStackTrace());
        throw exception;
    }
}

