/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.unit;

import java.awt.AWTException;
import java.awt.Robot;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bwapi.unit.BwapiTestInformation;
import org.bwapi.unit.model.BroodwarButton;
import org.bwapi.unit.model.BroodwarGameType;
import org.bwapi.unit.model.BroodwarMap;
import org.bwapi.unit.model.BroodwarPlayer;
import org.junit.Assert;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.misc.basicStructures.LRECT;
import org.xvolks.jnative.util.User32;

final class BwapiTestUtils {
    static final Robot ROBOT;
    static final float DELAY_MULTIPLIER = 1.0f;
    static Pattern pidPattern;

    static {
        try {
            ROBOT = new Robot();
        }
        catch (AWTException e) {
            throw new ExceptionInInitializerError(e);
        }
        pidPattern = Pattern.compile("Starcraft[^\\s]*\\s+(\\d+).*");
    }

    static void delay(int ms) throws Exception {
        Thread.sleep((int)((float)ms * 1.0f));
    }

    static void waitForButton(HWND wnd, BroodwarButton button, int timeout) throws Exception {
        LRECT wndRect = new LRECT();
        int currCount = 0;
        do {
            BwapiTestUtils.delay(700);
        } while (currCount < timeout && !User32.GetWindowRect(wnd, wndRect));
    }

    static void waitForAndClickButton(HWND wnd, BroodwarButton button) throws Exception {
        BwapiTestUtils.waitForButton(wnd, button, 2000);
        BwapiTestUtils.relativeClick(wnd, button.getX(), button.getY(), 16);
    }

    static void relativeMove(HWND wnd, int x, int y) throws Exception {
        LRECT wndRect = new LRECT();
        int delayCount = 0;
        while (!User32.GetWindowRect(wnd, wndRect) && delayCount++ < 300) {
            BwapiTestUtils.delay(100);
        }
        int clickX = wndRect.getLeft() + x;
        int clickY = wndRect.getTop() + y;
        ROBOT.mouseMove(clickX, clickY);
    }

    static void relativeClick(HWND wnd, int x, int y, int buttonMask) throws Exception {
        BwapiTestUtils.relativeMove(wnd, x, y);
        ROBOT.mousePress(buttonMask);
        ROBOT.mouseRelease(buttonMask);
    }

    static HWND loadChaosLauncher(String chaosLauncherFolder, AtomicReference<Process> process) throws Exception {
        File chaosLauncher = new File(String.valueOf(chaosLauncherFolder) + File.separator + "Chaoslauncher - MultiInstance.exe");
        Assert.assertTrue("Cannot find Chaoslauncher - MultiInstance.exe", chaosLauncher.exists());
        ProcessBuilder builder = new ProcessBuilder(chaosLauncher.getAbsolutePath());
        builder.directory(new File(chaosLauncherFolder));
        process.set(builder.start());
        BwapiTestUtils.delay(200);
        HWND chaosWnd = User32.FindWindow("TChaoslauncherForm", "Chaoslauncher");
        Assert.assertNotNull("Unable to locate launched Chaoslauncher process", chaosWnd);
        User32.SetActiveWindow(chaosWnd);
        return chaosWnd;
    }

    static HWND loadStarcraft(String chaosLauncherFolder, AtomicReference<Process> chaosProcess) {
        try {
            HWND chaosWnd = BwapiTestUtils.loadChaosLauncher(chaosLauncherFolder, chaosProcess);
            BwapiTestUtils.delay(1800);
            BwapiTestUtils.relativeClick(chaosWnd, 25, 360, 16);
            BwapiTestUtils.delay(700);
            HWND scWnd = BwapiTestUtils.getStarcraftWindow();
            Assert.assertNotNull("Unable to locate StarCraft window", scWnd);
            BwapiTestUtils.delay(100);
            User32.SetActiveWindow(scWnd);
            return scWnd;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static HWND getStarcraftWindow() throws Exception {
        return User32.FindWindow("SWarClass", "Brood War");
    }

    static void killStarcraft() throws Exception {
        Runtime.getRuntime().exec("taskkill /F /IM Starcraft_Multiinstance.exe");
        Runtime.getRuntime().exec("taskkill /F /IM \"Chaoslauncher - Multiinstance.exe\"");
    }

    static void killSpecificStarcraft(int pid) throws Exception {
        Runtime.getRuntime().exec("taskkill /F /PID " + pid);
    }

    static String getMapDirectory(String starcraftFolder) {
        return String.valueOf(starcraftFolder) + "/Maps/Broodwar";
    }

    static void createMapFileDirectory(File path) {
        if (!path.exists()) {
            path.mkdir();
        }
    }

    static void deleteMapsInDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].getName().endsWith(".scx") || files[i].getName().endsWith(".scm")) {
                    files[i].delete();
                }
                ++i;
            }
        }
    }

    static void selectMap(HWND scWnd, String starcraftFolder, BroodwarMap map) throws Exception {
        BwapiTestUtils.makeLocalMapCopy(starcraftFolder, map);
        int fileCount = new File(String.valueOf(starcraftFolder) + "/Maps/Broodwar").list().length;
        int i = 0;
        while (i < fileCount) {
            BwapiTestUtils.relativeClick(scWnd, 345, 182, 16);
            ++i;
        }
        BwapiTestUtils.relativeClick(scWnd, 90, 169, 16);
        BwapiTestUtils.delay(50);
        BwapiTestUtils.relativeClick(scWnd, 90, 169, 16);
        BwapiTestUtils.delay(100);
        BwapiTestUtils.relativeClick(scWnd, 90, 189, 16);
        BwapiTestUtils.delay(100);
    }

    public static void makeLocalMapCopy(String starcraftFolder, BroodwarMap map) throws FileNotFoundException, IOException {
        Assert.assertTrue("Map name must end with .scx or .scm", map.getName().endsWith(".scx") || map.getName().endsWith(".scm"));
        File dir = new File(BwapiTestUtils.getMapDirectory(starcraftFolder));
        BwapiTestUtils.deleteMapsInDirectory(dir);
        InputStream stream = map.open();
        OutputStream writer = null;
        try {
            int bytesRead;
            writer = new FileOutputStream(String.valueOf(dir.getAbsolutePath()) + "/" + map.getName());
            byte[] buffer = new byte[4096];
            while ((bytesRead = stream.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static void selectGameType(HWND scWnd, BroodwarGameType type) throws Exception {
        BwapiTestUtils.relativeMove(scWnd, 345, 300);
        BwapiTestUtils.delay(100);
        ROBOT.mousePress(16);
        BwapiTestUtils.delay(100);
        BwapiTestUtils.relativeMove(scWnd, 345, type.getY());
        BwapiTestUtils.delay(100);
        ROBOT.mouseRelease(16);
        BwapiTestUtils.delay(100);
    }

    static void setupPlayers(HWND scWnd, BroodwarPlayer[] players) throws Exception {
        if (players == null || players.length == 0) {
            return;
        }
        Assert.assertTrue("Must have at least two players", players.length > 1);
        int playerX = 176;
        int yInit = 354;
        int raceX = 336;
        int yDiff = 19;
        int i = 0;
        while (i < 8) {
            if (i >= players.length) {
                BwapiTestUtils.relativeMove(scWnd, playerX, yInit + yDiff * i);
                ROBOT.mousePress(16);
                BwapiTestUtils.delay(100);
                if (i != 7) {
                    BwapiTestUtils.relativeMove(scWnd, playerX, yInit + yDiff * i + 17);
                } else {
                    BwapiTestUtils.relativeMove(scWnd, playerX, yInit + yDiff * i - 37);
                }
                BwapiTestUtils.delay(100);
                ROBOT.mouseRelease(16);
                BwapiTestUtils.delay(100);
            } else {
                BwapiTestUtils.relativeMove(scWnd, raceX, yInit + yDiff * i);
                ROBOT.mousePress(16);
                BwapiTestUtils.delay(100);
                if (i < 5) {
                    BwapiTestUtils.relativeMove(scWnd, raceX, yInit + yDiff * i + 17 * (players[i].getRace().ordinal() + 1));
                } else {
                    BwapiTestUtils.relativeMove(scWnd, raceX, yInit + yDiff * i - 17 * (3 - players[i].getRace().ordinal() + 1));
                }
                BwapiTestUtils.delay(100);
                ROBOT.mouseRelease(16);
                BwapiTestUtils.delay(100);
            }
            ++i;
        }
    }

    static int getStarcraftPID(int ... exclusions) throws Exception {
        ArrayList<Integer> excl = new ArrayList<Integer>();
        int[] nArray = exclusions;
        int n = exclusions.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            excl.add(e);
            ++n2;
        }
        Process p = Runtime.getRuntime().exec("tasklist");
        BufferedReader out = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = out.readLine();
        while (line != null) {
            int pid;
            Matcher m = pidPattern.matcher(line);
            if (m.matches() && !excl.contains(pid = Integer.parseInt(m.group(1)))) {
                out.close();
                return pid;
            }
            line = out.readLine();
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(BwapiTestUtils.getStarcraftPID(2416));
        BwapiTestUtils.killSpecificStarcraft(2968);
    }

    static void writeUDPIniFile(String starcraftFolder, String relativeMapFilename, BroodwarPlayer player, BroodwarGameType type, String relativeReplayFilename, boolean host) {
        try {
            File dir = new File(starcraftFolder, "bwapi-data");
            File file = new File(dir, "bwapi.ini");
            if (file.exists()) {
                file.delete();
            }
            PrintWriter out = new PrintWriter(file);
            out.println("[ai]");
            out.println("ai = bwapi-data\\AI\\ClientModule.dll, bwapi-data\\AI\\ClientModule.dll");
            out.println();
            out.println("[auto_menu]");
            out.println("auto_menu = LAN");
            out.println("lan_mode = Local PC (UDP)");
            out.println("auto_restart = OFF");
            out.println("race = " + (Object)((Object)player.getRace()));
            if (host) {
                out.println("map = " + relativeMapFilename);
                out.println("game_type = " + (Object)((Object)type));
                out.println("save_replay = " + relativeReplayFilename);
            }
            out.println();
            out.println("[config]");
            out.println("logging = OFF");
            out.println();
            out.println("[starcraft]");
            out.println("sound = ON");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private BwapiTestUtils() {
    }

    public static void writeSinglePlayerIniFile(BwapiTestInformation testInformation, String bwapiReplayFile) {
        try {
            File dir = new File(testInformation.getStarcraftFolder(), "bwapi-data");
            File file = new File(dir, "bwapi.ini");
            if (file.exists()) {
                file.delete();
            }
            PrintWriter out = new PrintWriter(file);
            out.println("[ai]");
            out.println("ai_dll = bwapi-data\\AI\\ClientModule.dll");
            int i = 1;
            while (i <= 8) {
                out.println("ai_dll_" + i + " = bwapi-data\\AI\\ClientModule.dll");
                ++i;
            }
            out.println();
            out.println("[auto_menu]");
            out.println("auto_menu = SINGLE_PLAYER");
            File mapdir = new File(BwapiTestUtils.getMapDirectory(testInformation.getStarcraftFolder()));
            String relativeMapFilename = String.valueOf(mapdir.getAbsolutePath()) + "/" + testInformation.getMap().getName();
            out.println("map = " + relativeMapFilename);
            int numEnemies = 0;
            BroodwarPlayer[] broodwarPlayerArray = testInformation.getPlayers();
            int n = broodwarPlayerArray.length;
            int n2 = 0;
            while (n2 < n) {
                BroodwarPlayer p = broodwarPlayerArray[n2];
                if (p.isMe()) {
                    out.println("race = " + (Object)((Object)p.getRace()));
                } else {
                    if (numEnemies == 0) {
                        out.println("enemy_race = " + (Object)((Object)p.getRace()));
                    }
                    out.println("enemy_race_" + ++numEnemies + " = " + (Object)((Object)p.getRace()));
                }
                ++n2;
            }
            out.println("enemy_count = " + numEnemies);
            out.println("game_type = " + (Object)((Object)testInformation.getGameType()));
            out.println("save_replay = " + bwapiReplayFile);
            out.println();
            out.println("[config]");
            out.println("logging = OFF");
            out.println();
            out.println("[starcraft]");
            out.println("sound = ON");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

