/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.unit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bwapi.proxy.ProxyBot;
import org.bwapi.proxy.ProxyBotFactory;
import org.bwapi.proxy.ProxyServer;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.util.Pair;
import org.bwapi.unit.BwapiTestInformation;
import org.bwapi.unit.BwapiTestUtils;
import org.bwapi.unit.model.BroodwarButton;
import org.junit.Assert;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.util.User32;

public class BwapiTestCase {
    private static final String BWAPI_REPLAY_FILE = "maps\\replays\\BWAPI_LastReplay.rep";
    private static final String REPLAY_FILE = "maps\\replays\\LastReplay.rep";
    static Pattern pattern = Pattern.compile("Supply: (\\d+)/\\d+");

    private static void startStarcraft(BwapiTestInformation testInformation, AtomicReference<Process> chaosProcess) {
        Assert.assertNotNull("testInformation must be set in base class", testInformation);
        BwapiTestUtils.createMapFileDirectory(new File(BwapiTestUtils.getMapDirectory(testInformation.getStarcraftFolder())));
        HWND scWnd = BwapiTestUtils.loadStarcraft(testInformation.getChaosLauncherFolder(), chaosProcess);
        try {
            BwapiTestUtils.waitForAndClickButton(scWnd, BroodwarButton.SINGLE_PLAYER);
            BwapiTestUtils.waitForAndClickButton(scWnd, BroodwarButton.EXPANSION_PACK);
            BwapiTestUtils.waitForAndClickButton(scWnd, BroodwarButton.ID_OK);
            BwapiTestUtils.delay(1000);
            BwapiTestUtils.waitForAndClickButton(scWnd, BroodwarButton.PLAY_CUSTOM);
            BwapiTestUtils.delay(1000);
            BwapiTestUtils.selectMap(scWnd, testInformation.getStarcraftFolder(), testInformation.getMap());
            BwapiTestUtils.selectGameType(scWnd, testInformation.getGameType());
            BwapiTestUtils.setupPlayers(scWnd, testInformation.getPlayers());
            BwapiTestUtils.relativeClick(scWnd, BroodwarButton.ID_OK.getX(), BroodwarButton.ID_OK.getY(), 16);
            BwapiTestUtils.delay(1000);
            BwapiTestUtils.relativeClick(scWnd, BroodwarButton.ID_OK.getX(), BroodwarButton.ID_OK.getY(), 16);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void startStarcraftFancyStyle(BwapiTestInformation testInformation, AtomicReference<Process> chaosProcess) {
        Assert.assertNotNull("testInformation must be set in base class", testInformation);
        BwapiTestUtils.createMapFileDirectory(new File(BwapiTestUtils.getMapDirectory(testInformation.getStarcraftFolder())));
        try {
            BwapiTestUtils.makeLocalMapCopy(testInformation.getStarcraftFolder(), testInformation.getMap());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        BwapiTestUtils.writeSinglePlayerIniFile(testInformation, BWAPI_REPLAY_FILE);
        BwapiTestUtils.loadStarcraft(testInformation.getChaosLauncherFolder(), chaosProcess);
    }

    private static void stopStarcraft() throws Exception {
        BwapiTestUtils.killStarcraft();
    }

    protected static void executeBotVsBot(BwapiTestInformation info1, BwapiTestInformation info2, File outputDir, boolean fast) throws Exception {
        boolean p1Won;
        boolean shouldFinish;
        AtomicReference<Object> chaosProcess = new AtomicReference<Object>(null);
        File fastFile = new File(info1.getStarcraftFolder(), "superfast");
        if (fast && !fastFile.exists()) {
            System.out.println("Creating " + fastFile.getPath());
            fastFile.createNewFile();
        }
        if (!fast && fastFile.exists()) {
            System.out.println("Deleting " + fastFile.getPath());
            fastFile.delete();
        }
        File output1 = new File(outputDir, "bot1-heartbeat.txt");
        File output2 = new File(outputDir, "bot2-heartbeat.txt");
        Pair<Integer, Integer> pids = BwapiTestCase.startDoubleStarcraft(info1, info2, chaosProcess);
        int lastUpdate1 = -1;
        int lastUpdate2 = -1;
        int numFailedChecks1 = 0;
        int numFailedChecks2 = 0;
        int numTimeSpikes1 = 0;
        int numTimeSpikes2 = 0;
        int numFrame0Spikes1 = 0;
        int numFrame0Spikes2 = 0;
        do {
            File copy;
            int newTime;
            String line;
            BufferedReader bufferedReader;
            BwapiTestUtils.delay(7000);
            boolean done = false;
            if (output1.exists()) {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(output1)));
                line = bufferedReader.readLine();
                if (line != null) {
                    newTime = Integer.parseInt(line.split(" ")[2]);
                    bufferedReader.close();
                    if (newTime <= lastUpdate1) {
                        if (newTime > 0 && ++numTimeSpikes1 >= 3) {
                            done = true;
                        } else if (newTime == 0 && ++numFrame0Spikes1 >= 10) {
                            done = true;
                        }
                    } else {
                        copy = new File(outputDir, "bot1-frame-" + newTime + ".txt");
                        Runtime.getRuntime().exec("cmd.exe /c copy " + output1.getPath() + " " + copy.getPath());
                    }
                    lastUpdate1 = newTime;
                } else {
                    bufferedReader.close();
                }
            } else {
                ++numFailedChecks1;
            }
            if (output2.exists()) {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(output2)));
                line = bufferedReader.readLine();
                if (line != null) {
                    newTime = Integer.parseInt(line.split(" ")[2]);
                    bufferedReader.close();
                    if (newTime <= lastUpdate2) {
                        if (newTime > 0 && ++numTimeSpikes2 >= 3) {
                            done = true;
                        } else if (newTime == 0 && ++numFrame0Spikes2 >= 10) {
                            done = true;
                        }
                    } else {
                        copy = new File(outputDir, "bot2-frame-" + newTime + ".txt");
                        Runtime.getRuntime().exec("cmd.exe /c copy " + output2.getPath() + " " + copy.getPath());
                    }
                    lastUpdate2 = newTime;
                } else {
                    bufferedReader.close();
                }
            } else {
                ++numFailedChecks2;
            }
            shouldFinish = false;
            p1Won = true;
            if (done) {
                System.out.println("Game ended!");
                p1Won = BwapiTestCase.declareWinner(output1, output2);
                shouldFinish = true;
            }
            if (lastUpdate1 >= 45000) {
                System.out.println("Game is going on too long!");
                p1Won = BwapiTestCase.declareWinner(output1, output2);
                shouldFinish = true;
            }
            if (numFailedChecks1 >= 20) {
                System.out.println("No hearbeat from Bot1!");
                p1Won = false;
                shouldFinish = true;
            }
            if (numFailedChecks2 < 20) continue;
            System.out.println("No heartbeat from Bot2!");
            p1Won = true;
            shouldFinish = true;
        } while (!shouldFinish);
        BwapiTestUtils.killSpecificStarcraft(p1Won ? pids.getSecond() : pids.getFirst());
        BwapiTestUtils.delay(3000);
        BwapiTestCase.stopStarcraft();
    }

    private static boolean declareWinner(File output1, File output2) throws IOException {
        int worse;
        int supply1 = BwapiTestCase.getSupply(output1);
        int supply2 = BwapiTestCase.getSupply(output2);
        if (supply1 < 0 || supply2 < 0) {
            System.out.println("Error getting final supply values!");
            return false;
        }
        int better = Math.max(supply1, supply2);
        if (better - (worse = Math.min(supply1, supply2)) >= 100 || better >= 100 && worse <= 40 || better >= 20 && worse <= 4 || better > 0 && worse == 0) {
            boolean p1Won = supply1 > supply2;
            String winner = p1Won ? "bot1" : "bot2";
            System.out.println(String.valueOf(winner) + " is declared the winner!");
            return p1Won;
        }
        System.out.println("Too close to call!");
        return false;
    }

    private static int getSupply(File output) throws IOException {
        Matcher m;
        if (!output.exists()) {
            return -1;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(output)));
        int supply = -1;
        String line = bufferedReader.readLine();
        if (line != null && (line = bufferedReader.readLine()) != null && (m = pattern.matcher(line)).matches()) {
            supply = Integer.parseInt(m.group(1));
        }
        bufferedReader.close();
        return supply;
    }

    protected static void executeSinglePlayerGame(BwapiTestInformation info, File outputDir, boolean fast) throws Exception {
        boolean shouldFinish;
        AtomicReference<Object> chaosProcess = new AtomicReference<Object>(null);
        File fastFile = new File(info.getStarcraftFolder(), "superfast");
        if (fast && !fastFile.exists()) {
            System.out.println("Creating " + fastFile.getPath());
            fastFile.createNewFile();
        }
        if (!fast && fastFile.exists()) {
            fastFile.delete();
        }
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        File output = new File(outputDir, "heartbeat.txt");
        BwapiTestCase.startStarcraftFancyStyle(info, chaosProcess);
        int lastUpdate1 = -1;
        int numFailedChecks1 = 0;
        int numTimeSpikes1 = 0;
        int numFrame0Spikes1 = 0;
        do {
            BwapiTestUtils.delay(7000);
            boolean done = false;
            if (output.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(output)));
                String line = bufferedReader.readLine();
                if (line != null) {
                    int newTime = Integer.parseInt(line.split(" ")[2]);
                    bufferedReader.close();
                    if (newTime <= lastUpdate1) {
                        if (newTime > 0 && ++numTimeSpikes1 >= 3) {
                            done = true;
                        } else if (newTime == 0 && ++numFrame0Spikes1 >= 20) {
                            done = true;
                        }
                    } else {
                        File copy = new File(outputDir, "frame-" + newTime + ".txt");
                        Runtime.getRuntime().exec("cmd.exe /c copy " + output.getPath() + " " + copy.getPath());
                    }
                    lastUpdate1 = newTime;
                } else {
                    bufferedReader.close();
                }
            } else {
                ++numFailedChecks1;
            }
            shouldFinish = false;
            if (done) {
                System.out.println("Game ended!");
                shouldFinish = true;
            }
            if (numFailedChecks1 < 10) continue;
            System.out.println("No hearbeat from Bot1!");
            shouldFinish = true;
        } while (!shouldFinish);
        BwapiTestCase.stopStarcraft();
        File replaySave = new File(outputDir, "match.rep");
        String lastReplay = String.valueOf(info.getStarcraftFolder()) + "\\" + REPLAY_FILE;
        String cmd = "cmd.exe /c copy \"" + lastReplay + "\" \"" + replaySave.getPath() + "\"";
        System.out.println("Running " + cmd);
        Runtime.getRuntime().exec(cmd);
    }

    private static void dumpStreamToFile(File outFile, InputStream inputStream) throws FileNotFoundException, IOException {
        PrintWriter out = new PrintWriter(outFile);
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        String line = in.readLine();
        while (line != null) {
            out.println(line);
            line = in.readLine();
        }
        in.close();
        out.close();
    }

    private static Pair<Integer, Integer> startDoubleStarcraft(BwapiTestInformation info1, BwapiTestInformation info2, AtomicReference<Process> chaosProcess) throws FileNotFoundException, IOException, Exception, NativeException, IllegalAccessException {
        try {
            BwapiTestUtils.killStarcraft();
            BwapiTestUtils.delay(500);
            BwapiTestUtils.createMapFileDirectory(new File(BwapiTestUtils.getMapDirectory(info1.getStarcraftFolder())));
            BwapiTestUtils.makeLocalMapCopy(info1.getStarcraftFolder(), info1.getMap());
            BwapiTestUtils.delay(1000);
            File dir = new File("maps/Broodwar");
            String relativeMapFilename = String.valueOf(dir.getAbsolutePath()) + "\\" + info1.getMap().getName();
            BwapiTestUtils.writeUDPIniFile(info1.getStarcraftFolder(), relativeMapFilename, info1.getPlayers()[0], info1.getGameType(), BWAPI_REPLAY_FILE, true);
            HWND scWnd1 = BwapiTestUtils.loadStarcraft(info1.getChaosLauncherFolder(), chaosProcess);
            BwapiTestUtils.delay(3000);
            BwapiTestUtils.relativeClick(scWnd1, BroodwarButton.ID_OK.getX(), BroodwarButton.ID_OK.getY(), 16);
            BwapiTestUtils.delay(1000);
            int pid1 = BwapiTestUtils.getStarcraftPID(new int[0]);
            BwapiTestUtils.writeUDPIniFile(info2.getStarcraftFolder(), null, info2.getPlayers()[0], info2.getGameType(), BWAPI_REPLAY_FILE, false);
            BwapiTestUtils.loadStarcraft(info2.getChaosLauncherFolder(), chaosProcess);
            BwapiTestUtils.delay(5000);
            int pid2 = BwapiTestUtils.getStarcraftPID(pid1);
            User32.SetForegroundWindow(scWnd1);
            BwapiTestUtils.delay(500);
            BwapiTestUtils.relativeClick(scWnd1, BroodwarButton.ID_OK.getX(), BroodwarButton.ID_OK.getY(), 16);
            return Pair.makePair(pid1, pid2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static void execute(final BwapiTestInformation testInformation) throws Exception {
        final ReentrantLock lock = new ReentrantLock();
        final Condition cond = lock.newCondition();
        final AtomicReference<Object> throwable = new AtomicReference<Object>(null);
        AtomicReference<Object> chaosProcess = new AtomicReference<Object>(null);
        final AtomicReference<Boolean> done = new AtomicReference<Boolean>(false);
        try {
            Thread t;
            block10: {
                ProxyBotFactory f = new ProxyBotFactory(){

                    @Override
                    public ProxyBot getBot(Game g) {
                        try {
                            ProxyBot inner = testInformation.getFactory().getBot(g);
                            return new WrapperBot(lock, cond, done, throwable, inner);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                t = new Thread(new ProxyServer(f, ProxyServer.extractPort("1"), null));
                t.start();
                BwapiTestCase.startStarcraft(testInformation, chaosProcess);
                lock.lock();
                try {
                    try {
                        while (!done.get().booleanValue()) {
                            cond.await();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        lock.unlock();
                        break block10;
                    }
                }
                catch (Throwable throwable2) {
                    lock.unlock();
                    throw throwable2;
                }
                lock.unlock();
            }
            t.interrupt();
            if (throwable.get() != null) {
                ((Throwable)throwable.get()).printStackTrace();
                throw new RuntimeException("Failure during execution", throwable.get());
            }
        }
        finally {
            BwapiTestCase.stopStarcraft();
        }
    }

    public static class WrapperBot
    implements ProxyBot {
        private final Condition cond;
        private final AtomicReference<Throwable> throwable;
        private final AtomicReference<Boolean> done;
        private final ProxyBot bot;
        private final Lock lock;

        public WrapperBot(Lock lock, Condition cond, AtomicReference<Boolean> done, AtomicReference<Throwable> throwable, ProxyBot bot) {
            this.cond = cond;
            this.throwable = throwable;
            this.bot = bot;
            this.done = done;
            this.lock = lock;
            lock.lock();
        }

        @Override
        public void onEnd(boolean isWinnerFlag) {
            try {
                this.bot.onEnd(isWinnerFlag);
            }
            catch (Throwable e) {
                this.throwable.set(e);
                this.done.set(true);
                this.cond.signalAll();
                this.lock.unlock();
                throw new RuntimeException("Caught an exception during test: ", e);
            }
            this.done.set(true);
            this.cond.signalAll();
            this.lock.unlock();
        }

        @Override
        public void onFrame() {
            try {
                this.bot.onFrame();
            }
            catch (Throwable e) {
                this.throwable.set(e);
                this.done.set(true);
                this.cond.signalAll();
                this.lock.unlock();
                throw new RuntimeException("Caught an exception during test: ", e);
            }
        }

        @Override
        public void onNukeDetect(Position position) {
            try {
                this.bot.onNukeDetect(position);
            }
            catch (Throwable e) {
                this.throwable.set(e);
                this.done.set(true);
                this.cond.signalAll();
                this.lock.unlock();
                throw new RuntimeException("Caught an exception during test: ", e);
            }
        }

        @Override
        public void onPlayerLeft(Player player) {
            try {
                this.bot.onPlayerLeft(player);
            }
            catch (Throwable e) {
                this.throwable.set(e);
                this.done.set(true);
                this.cond.signalAll();
                this.lock.unlock();
                throw new RuntimeException("Caught an exception during test: ", e);
            }
        }

        @Override
        public void onReceiveText(Player player, String text) {
            try {
                this.bot.onReceiveText(player, text);
            }
            catch (Throwable e) {
                this.throwable.set(e);
                this.done.set(true);
                this.cond.signalAll();
                this.lock.unlock();
                throw new RuntimeException("Caught an exception during test: ", e);
            }
        }

        @Override
        public void onSendText(String text) {
            try {
                this.bot.onSendText(text);
            }
            catch (Throwable e) {
                this.throwable.set(e);
                this.done.set(true);
                this.cond.signalAll();
                this.lock.unlock();
                throw new RuntimeException("Caught an exception during test: ", e);
            }
        }

        @Override
        public void onStart() {
            try {
                this.bot.onStart();
            }
            catch (Throwable e) {
                this.throwable.set(e);
                this.done.set(true);
                this.cond.signalAll();
                this.lock.unlock();
                throw new RuntimeException("Caught an exception during test: ", e);
            }
        }

        @Override
        public void onDroppedConnection() {
            this.done.set(true);
            this.cond.signalAll();
            this.lock.unlock();
        }

        @Override
        public void onUnitCreate(ROUnit unit) {
            try {
                this.bot.onUnitCreate(unit);
            }
            catch (Throwable e) {
                this.throwable.set(e);
                this.done.set(true);
                this.cond.signalAll();
                this.lock.unlock();
                throw new RuntimeException("Caught an exception during test: ", e);
            }
        }

        @Override
        public void onUnitDestroy(ROUnit unit) {
            try {
                this.bot.onUnitDestroy(unit);
            }
            catch (Throwable e) {
                this.throwable.set(e);
                this.done.set(true);
                this.cond.signalAll();
                this.lock.unlock();
                throw new RuntimeException("Caught an exception during test: ", e);
            }
        }

        @Override
        public void onUnitHide(ROUnit unit) {
            try {
                this.bot.onUnitHide(unit);
            }
            catch (Throwable e) {
                this.throwable.set(e);
                this.done.set(true);
                this.cond.signalAll();
                this.lock.unlock();
                throw new RuntimeException("Caught an exception during test: ", e);
            }
        }

        @Override
        public void onUnitMorph(ROUnit unit) {
            try {
                this.bot.onUnitMorph(unit);
            }
            catch (Throwable e) {
                this.throwable.set(e);
                this.done.set(true);
                this.cond.signalAll();
                this.lock.unlock();
                throw new RuntimeException("Caught an exception during test: ", e);
            }
        }

        @Override
        public void onUnitRenegade(ROUnit unit) {
            try {
                this.bot.onUnitRenegade(unit);
            }
            catch (Throwable e) {
                this.throwable.set(e);
                this.done.set(true);
                this.cond.signalAll();
                this.lock.unlock();
                throw new RuntimeException("Caught an exception during test: ", e);
            }
        }

        @Override
        public void onUnitShow(ROUnit unit) {
            try {
                this.bot.onUnitShow(unit);
            }
            catch (Throwable e) {
                this.throwable.set(e);
                this.done.set(true);
                this.cond.signalAll();
                this.lock.unlock();
                throw new RuntimeException("Caught an exception during test: ", e);
            }
        }
    }
}

