/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.model.Race;
import org.bwapi.proxy.model.UnitType;

public class UpgradeType {
    protected int id;
    protected static List<GameMessages.UpgradeTypeData> data;
    public static final UpgradeType TERRAN_INFANTRY_ARMOR;
    public static final UpgradeType TERRAN_VEHICLE_PLATING;
    public static final UpgradeType TERRAN_SHIP_PLATING;
    public static final UpgradeType ZERG_CARAPACE;
    public static final UpgradeType ZERG_FLYER_CARAPACE;
    public static final UpgradeType PROTOSS_ARMOR;
    public static final UpgradeType PROTOSS_PLATING;
    public static final UpgradeType TERRAN_INFANTRY_WEAPONS;
    public static final UpgradeType TERRAN_VEHICLE_WEAPONS;
    public static final UpgradeType TERRAN_SHIP_WEAPONS;
    public static final UpgradeType ZERG_MELEE_ATTACKS;
    public static final UpgradeType ZERG_MISSILE_ATTACKS;
    public static final UpgradeType ZERG_FLYER_ATTACKS;
    public static final UpgradeType PROTOSS_GROUND_WEAPONS;
    public static final UpgradeType PROTOSS_AIR_WEAPONS;
    public static final UpgradeType PROTOSS_PLASMA_SHIELDS;
    public static final UpgradeType U_238_SHELLS;
    public static final UpgradeType ION_THRUSTERS;
    public static final UpgradeType TITAN_REACTOR;
    public static final UpgradeType OCULAR_IMPLANTS;
    public static final UpgradeType MOEBIUS_REACTOR;
    public static final UpgradeType APOLLO_REACTOR;
    public static final UpgradeType COLOSSUS_REACTOR;
    public static final UpgradeType VENTRAL_SACS;
    public static final UpgradeType ANTENNAE;
    public static final UpgradeType PNEUMATIZED_CARAPACE;
    public static final UpgradeType METABOLIC_BOOST;
    public static final UpgradeType ADRENAL_GLANDS;
    public static final UpgradeType MUSCULAR_AUGMENTS;
    public static final UpgradeType GROOVED_SPINES;
    public static final UpgradeType GAMETE_MEIOSIS;
    public static final UpgradeType METASYNAPTIC_NODE;
    public static final UpgradeType SINGULARITY_CHARGE;
    public static final UpgradeType LEG_ENHANCEMENTS;
    public static final UpgradeType SCARAB_DAMAGE;
    public static final UpgradeType REAVER_CAPACITY;
    public static final UpgradeType GRAVITIC_DRIVE;
    public static final UpgradeType SENSOR_ARRAY;
    public static final UpgradeType GRAVITIC_BOOSTERS;
    public static final UpgradeType KHAYDARIN_AMULET;
    public static final UpgradeType APIAL_SENSORS;
    public static final UpgradeType GRAVITIC_THRUSTERS;
    public static final UpgradeType CARRIER_CAPACITY;
    public static final UpgradeType KHAYDARIN_CORE;
    public static final UpgradeType ARGUS_JEWEL;
    public static final UpgradeType ARGUS_TALISMAN;
    public static final UpgradeType CADUCEUS_REACTOR;
    public static final UpgradeType CHITINOUS_PLATING;
    public static final UpgradeType ANABOLIC_SYNTHESIS;
    public static final UpgradeType CHARON_BOOSTER;
    public static final UpgradeType NONE;
    public static final UpgradeType UNKNOWN;
    protected static final Map<String, UpgradeType> gNamesToUpgradeTypes;
    protected static final Set<UpgradeType> gAllUpgradeTypes;
    protected static final UpgradeType[] gIdsToUpgradeTypes;

    static {
        TERRAN_INFANTRY_ARMOR = new UpgradeType(0);
        TERRAN_VEHICLE_PLATING = new UpgradeType(1);
        TERRAN_SHIP_PLATING = new UpgradeType(2);
        ZERG_CARAPACE = new UpgradeType(3);
        ZERG_FLYER_CARAPACE = new UpgradeType(4);
        PROTOSS_ARMOR = new UpgradeType(5);
        PROTOSS_PLATING = new UpgradeType(6);
        TERRAN_INFANTRY_WEAPONS = new UpgradeType(7);
        TERRAN_VEHICLE_WEAPONS = new UpgradeType(8);
        TERRAN_SHIP_WEAPONS = new UpgradeType(9);
        ZERG_MELEE_ATTACKS = new UpgradeType(10);
        ZERG_MISSILE_ATTACKS = new UpgradeType(11);
        ZERG_FLYER_ATTACKS = new UpgradeType(12);
        PROTOSS_GROUND_WEAPONS = new UpgradeType(13);
        PROTOSS_AIR_WEAPONS = new UpgradeType(14);
        PROTOSS_PLASMA_SHIELDS = new UpgradeType(15);
        U_238_SHELLS = new UpgradeType(16);
        ION_THRUSTERS = new UpgradeType(17);
        TITAN_REACTOR = new UpgradeType(19);
        OCULAR_IMPLANTS = new UpgradeType(20);
        MOEBIUS_REACTOR = new UpgradeType(21);
        APOLLO_REACTOR = new UpgradeType(22);
        COLOSSUS_REACTOR = new UpgradeType(23);
        VENTRAL_SACS = new UpgradeType(24);
        ANTENNAE = new UpgradeType(25);
        PNEUMATIZED_CARAPACE = new UpgradeType(26);
        METABOLIC_BOOST = new UpgradeType(27);
        ADRENAL_GLANDS = new UpgradeType(28);
        MUSCULAR_AUGMENTS = new UpgradeType(29);
        GROOVED_SPINES = new UpgradeType(30);
        GAMETE_MEIOSIS = new UpgradeType(31);
        METASYNAPTIC_NODE = new UpgradeType(32);
        SINGULARITY_CHARGE = new UpgradeType(33);
        LEG_ENHANCEMENTS = new UpgradeType(34);
        SCARAB_DAMAGE = new UpgradeType(35);
        REAVER_CAPACITY = new UpgradeType(36);
        GRAVITIC_DRIVE = new UpgradeType(37);
        SENSOR_ARRAY = new UpgradeType(38);
        GRAVITIC_BOOSTERS = new UpgradeType(39);
        KHAYDARIN_AMULET = new UpgradeType(40);
        APIAL_SENSORS = new UpgradeType(41);
        GRAVITIC_THRUSTERS = new UpgradeType(42);
        CARRIER_CAPACITY = new UpgradeType(43);
        KHAYDARIN_CORE = new UpgradeType(44);
        ARGUS_JEWEL = new UpgradeType(47);
        ARGUS_TALISMAN = new UpgradeType(49);
        CADUCEUS_REACTOR = new UpgradeType(51);
        CHITINOUS_PLATING = new UpgradeType(52);
        ANABOLIC_SYNTHESIS = new UpgradeType(53);
        CHARON_BOOSTER = new UpgradeType(54);
        NONE = new UpgradeType(61);
        UNKNOWN = new UpgradeType(62);
        gNamesToUpgradeTypes = new HashMap<String, UpgradeType>();
        HashSet<UpgradeType> allUpgradeTypes = new HashSet<UpgradeType>();
        gIdsToUpgradeTypes = new UpgradeType[63];
        gNamesToUpgradeTypes.put("Terran Infantry Armor", TERRAN_INFANTRY_ARMOR);
        allUpgradeTypes.add(TERRAN_INFANTRY_ARMOR);
        UpgradeType.gIdsToUpgradeTypes[0] = TERRAN_INFANTRY_ARMOR;
        gNamesToUpgradeTypes.put("Terran Vehicle Plating", TERRAN_VEHICLE_PLATING);
        allUpgradeTypes.add(TERRAN_VEHICLE_PLATING);
        UpgradeType.gIdsToUpgradeTypes[1] = TERRAN_VEHICLE_PLATING;
        gNamesToUpgradeTypes.put("Terran Ship Plating", TERRAN_SHIP_PLATING);
        allUpgradeTypes.add(TERRAN_SHIP_PLATING);
        UpgradeType.gIdsToUpgradeTypes[2] = TERRAN_SHIP_PLATING;
        gNamesToUpgradeTypes.put("Zerg Carapace", ZERG_CARAPACE);
        allUpgradeTypes.add(ZERG_CARAPACE);
        UpgradeType.gIdsToUpgradeTypes[3] = ZERG_CARAPACE;
        gNamesToUpgradeTypes.put("Zerg Flyer Carapace", ZERG_FLYER_CARAPACE);
        allUpgradeTypes.add(ZERG_FLYER_CARAPACE);
        UpgradeType.gIdsToUpgradeTypes[4] = ZERG_FLYER_CARAPACE;
        gNamesToUpgradeTypes.put("Protoss Armor", PROTOSS_ARMOR);
        allUpgradeTypes.add(PROTOSS_ARMOR);
        UpgradeType.gIdsToUpgradeTypes[5] = PROTOSS_ARMOR;
        gNamesToUpgradeTypes.put("Protoss Plating", PROTOSS_PLATING);
        allUpgradeTypes.add(PROTOSS_PLATING);
        UpgradeType.gIdsToUpgradeTypes[6] = PROTOSS_PLATING;
        gNamesToUpgradeTypes.put("Terran Infantry Weapons", TERRAN_INFANTRY_WEAPONS);
        allUpgradeTypes.add(TERRAN_INFANTRY_WEAPONS);
        UpgradeType.gIdsToUpgradeTypes[7] = TERRAN_INFANTRY_WEAPONS;
        gNamesToUpgradeTypes.put("Terran Vehicle Weapons", TERRAN_VEHICLE_WEAPONS);
        allUpgradeTypes.add(TERRAN_VEHICLE_WEAPONS);
        UpgradeType.gIdsToUpgradeTypes[8] = TERRAN_VEHICLE_WEAPONS;
        gNamesToUpgradeTypes.put("Terran Ship Weapons", TERRAN_SHIP_WEAPONS);
        allUpgradeTypes.add(TERRAN_SHIP_WEAPONS);
        UpgradeType.gIdsToUpgradeTypes[9] = TERRAN_SHIP_WEAPONS;
        gNamesToUpgradeTypes.put("Zerg Melee Attacks", ZERG_MELEE_ATTACKS);
        allUpgradeTypes.add(ZERG_MELEE_ATTACKS);
        UpgradeType.gIdsToUpgradeTypes[10] = ZERG_MELEE_ATTACKS;
        gNamesToUpgradeTypes.put("Zerg Missile Attacks", ZERG_MISSILE_ATTACKS);
        allUpgradeTypes.add(ZERG_MISSILE_ATTACKS);
        UpgradeType.gIdsToUpgradeTypes[11] = ZERG_MISSILE_ATTACKS;
        gNamesToUpgradeTypes.put("Zerg Flyer Attacks", ZERG_FLYER_ATTACKS);
        allUpgradeTypes.add(ZERG_FLYER_ATTACKS);
        UpgradeType.gIdsToUpgradeTypes[12] = ZERG_FLYER_ATTACKS;
        gNamesToUpgradeTypes.put("Protoss Ground Weapons", PROTOSS_GROUND_WEAPONS);
        allUpgradeTypes.add(PROTOSS_GROUND_WEAPONS);
        UpgradeType.gIdsToUpgradeTypes[13] = PROTOSS_GROUND_WEAPONS;
        gNamesToUpgradeTypes.put("Protoss Air Weapons", PROTOSS_AIR_WEAPONS);
        allUpgradeTypes.add(PROTOSS_AIR_WEAPONS);
        UpgradeType.gIdsToUpgradeTypes[14] = PROTOSS_AIR_WEAPONS;
        gNamesToUpgradeTypes.put("Protoss Plasma Shields", PROTOSS_PLASMA_SHIELDS);
        allUpgradeTypes.add(PROTOSS_PLASMA_SHIELDS);
        UpgradeType.gIdsToUpgradeTypes[15] = PROTOSS_PLASMA_SHIELDS;
        gNamesToUpgradeTypes.put("U-238 Shells", U_238_SHELLS);
        allUpgradeTypes.add(U_238_SHELLS);
        UpgradeType.gIdsToUpgradeTypes[16] = U_238_SHELLS;
        gNamesToUpgradeTypes.put("Ion Thrusters", ION_THRUSTERS);
        allUpgradeTypes.add(ION_THRUSTERS);
        UpgradeType.gIdsToUpgradeTypes[17] = ION_THRUSTERS;
        gNamesToUpgradeTypes.put("Titan Reactor", TITAN_REACTOR);
        allUpgradeTypes.add(TITAN_REACTOR);
        UpgradeType.gIdsToUpgradeTypes[19] = TITAN_REACTOR;
        gNamesToUpgradeTypes.put("Ocular Implants", OCULAR_IMPLANTS);
        allUpgradeTypes.add(OCULAR_IMPLANTS);
        UpgradeType.gIdsToUpgradeTypes[20] = OCULAR_IMPLANTS;
        gNamesToUpgradeTypes.put("Moebius Reactor", MOEBIUS_REACTOR);
        allUpgradeTypes.add(MOEBIUS_REACTOR);
        UpgradeType.gIdsToUpgradeTypes[21] = MOEBIUS_REACTOR;
        gNamesToUpgradeTypes.put("Apollo Reactor", APOLLO_REACTOR);
        allUpgradeTypes.add(APOLLO_REACTOR);
        UpgradeType.gIdsToUpgradeTypes[22] = APOLLO_REACTOR;
        gNamesToUpgradeTypes.put("Colossus Reactor", COLOSSUS_REACTOR);
        allUpgradeTypes.add(COLOSSUS_REACTOR);
        UpgradeType.gIdsToUpgradeTypes[23] = COLOSSUS_REACTOR;
        gNamesToUpgradeTypes.put("Ventral Sacs", VENTRAL_SACS);
        allUpgradeTypes.add(VENTRAL_SACS);
        UpgradeType.gIdsToUpgradeTypes[24] = VENTRAL_SACS;
        gNamesToUpgradeTypes.put("Antennae", ANTENNAE);
        allUpgradeTypes.add(ANTENNAE);
        UpgradeType.gIdsToUpgradeTypes[25] = ANTENNAE;
        gNamesToUpgradeTypes.put("Pneumatized Carapace", PNEUMATIZED_CARAPACE);
        allUpgradeTypes.add(PNEUMATIZED_CARAPACE);
        UpgradeType.gIdsToUpgradeTypes[26] = PNEUMATIZED_CARAPACE;
        gNamesToUpgradeTypes.put("Metabolic Boost", METABOLIC_BOOST);
        allUpgradeTypes.add(METABOLIC_BOOST);
        UpgradeType.gIdsToUpgradeTypes[27] = METABOLIC_BOOST;
        gNamesToUpgradeTypes.put("Adrenal Glands", ADRENAL_GLANDS);
        allUpgradeTypes.add(ADRENAL_GLANDS);
        UpgradeType.gIdsToUpgradeTypes[28] = ADRENAL_GLANDS;
        gNamesToUpgradeTypes.put("Muscular Augments", MUSCULAR_AUGMENTS);
        allUpgradeTypes.add(MUSCULAR_AUGMENTS);
        UpgradeType.gIdsToUpgradeTypes[29] = MUSCULAR_AUGMENTS;
        gNamesToUpgradeTypes.put("Grooved Spines", GROOVED_SPINES);
        allUpgradeTypes.add(GROOVED_SPINES);
        UpgradeType.gIdsToUpgradeTypes[30] = GROOVED_SPINES;
        gNamesToUpgradeTypes.put("Gamete Meiosis", GAMETE_MEIOSIS);
        allUpgradeTypes.add(GAMETE_MEIOSIS);
        UpgradeType.gIdsToUpgradeTypes[31] = GAMETE_MEIOSIS;
        gNamesToUpgradeTypes.put("Metasynaptic Node", METASYNAPTIC_NODE);
        allUpgradeTypes.add(METASYNAPTIC_NODE);
        UpgradeType.gIdsToUpgradeTypes[32] = METASYNAPTIC_NODE;
        gNamesToUpgradeTypes.put("Singularity Charge", SINGULARITY_CHARGE);
        allUpgradeTypes.add(SINGULARITY_CHARGE);
        UpgradeType.gIdsToUpgradeTypes[33] = SINGULARITY_CHARGE;
        gNamesToUpgradeTypes.put("Leg Enhancements", LEG_ENHANCEMENTS);
        allUpgradeTypes.add(LEG_ENHANCEMENTS);
        UpgradeType.gIdsToUpgradeTypes[34] = LEG_ENHANCEMENTS;
        gNamesToUpgradeTypes.put("Scarab Damage", SCARAB_DAMAGE);
        allUpgradeTypes.add(SCARAB_DAMAGE);
        UpgradeType.gIdsToUpgradeTypes[35] = SCARAB_DAMAGE;
        gNamesToUpgradeTypes.put("Reaver Capacity", REAVER_CAPACITY);
        allUpgradeTypes.add(REAVER_CAPACITY);
        UpgradeType.gIdsToUpgradeTypes[36] = REAVER_CAPACITY;
        gNamesToUpgradeTypes.put("Gravitic Drive", GRAVITIC_DRIVE);
        allUpgradeTypes.add(GRAVITIC_DRIVE);
        UpgradeType.gIdsToUpgradeTypes[37] = GRAVITIC_DRIVE;
        gNamesToUpgradeTypes.put("Sensor Array", SENSOR_ARRAY);
        allUpgradeTypes.add(SENSOR_ARRAY);
        UpgradeType.gIdsToUpgradeTypes[38] = SENSOR_ARRAY;
        gNamesToUpgradeTypes.put("Gravitic Boosters", GRAVITIC_BOOSTERS);
        allUpgradeTypes.add(GRAVITIC_BOOSTERS);
        UpgradeType.gIdsToUpgradeTypes[39] = GRAVITIC_BOOSTERS;
        gNamesToUpgradeTypes.put("Khaydarin Amulet", KHAYDARIN_AMULET);
        allUpgradeTypes.add(KHAYDARIN_AMULET);
        UpgradeType.gIdsToUpgradeTypes[40] = KHAYDARIN_AMULET;
        gNamesToUpgradeTypes.put("Apial Sensors", APIAL_SENSORS);
        allUpgradeTypes.add(APIAL_SENSORS);
        UpgradeType.gIdsToUpgradeTypes[41] = APIAL_SENSORS;
        gNamesToUpgradeTypes.put("Gravitic Thrusters", GRAVITIC_THRUSTERS);
        allUpgradeTypes.add(GRAVITIC_THRUSTERS);
        UpgradeType.gIdsToUpgradeTypes[42] = GRAVITIC_THRUSTERS;
        gNamesToUpgradeTypes.put("Carrier Capacity", CARRIER_CAPACITY);
        allUpgradeTypes.add(CARRIER_CAPACITY);
        UpgradeType.gIdsToUpgradeTypes[43] = CARRIER_CAPACITY;
        gNamesToUpgradeTypes.put("Khaydarin Core", KHAYDARIN_CORE);
        allUpgradeTypes.add(KHAYDARIN_CORE);
        UpgradeType.gIdsToUpgradeTypes[44] = KHAYDARIN_CORE;
        gNamesToUpgradeTypes.put("Argus Jewel", ARGUS_JEWEL);
        allUpgradeTypes.add(ARGUS_JEWEL);
        UpgradeType.gIdsToUpgradeTypes[47] = ARGUS_JEWEL;
        gNamesToUpgradeTypes.put("Argus Talisman", ARGUS_TALISMAN);
        allUpgradeTypes.add(ARGUS_TALISMAN);
        UpgradeType.gIdsToUpgradeTypes[49] = ARGUS_TALISMAN;
        gNamesToUpgradeTypes.put("Caduceus Reactor", CADUCEUS_REACTOR);
        allUpgradeTypes.add(CADUCEUS_REACTOR);
        UpgradeType.gIdsToUpgradeTypes[51] = CADUCEUS_REACTOR;
        gNamesToUpgradeTypes.put("Chitinous Plating", CHITINOUS_PLATING);
        allUpgradeTypes.add(CHITINOUS_PLATING);
        UpgradeType.gIdsToUpgradeTypes[52] = CHITINOUS_PLATING;
        gNamesToUpgradeTypes.put("Anabolic Synthesis", ANABOLIC_SYNTHESIS);
        allUpgradeTypes.add(ANABOLIC_SYNTHESIS);
        UpgradeType.gIdsToUpgradeTypes[53] = ANABOLIC_SYNTHESIS;
        gNamesToUpgradeTypes.put("Charon Booster", CHARON_BOOSTER);
        allUpgradeTypes.add(CHARON_BOOSTER);
        UpgradeType.gIdsToUpgradeTypes[54] = CHARON_BOOSTER;
        gNamesToUpgradeTypes.put("None", NONE);
        allUpgradeTypes.add(NONE);
        UpgradeType.gIdsToUpgradeTypes[61] = NONE;
        gNamesToUpgradeTypes.put("Unknown", UNKNOWN);
        allUpgradeTypes.add(UNKNOWN);
        UpgradeType.gIdsToUpgradeTypes[62] = UNKNOWN;
        gAllUpgradeTypes = Collections.unmodifiableSet(allUpgradeTypes);
    }

    UpgradeType(int id) {
        this.id = id;
    }

    UpgradeType(GameMessages.UpgradeType upgrade) {
        this(upgrade.getId());
    }

    static void setUpgrades(List<GameMessages.UpgradeTypeData> _data) {
        data = new ArrayList<GameMessages.UpgradeTypeData>(_data);
    }

    private GameMessages.UpgradeTypeData getData() {
        return data.get(this.getID());
    }

    public final int getID() {
        return this.id;
    }

    public String getName() {
        return this.getData().getName();
    }

    public Race getRace() {
        return new Race(this.getData().getRace());
    }

    public int mineralPriceBase() {
        return this.getData().getMineralPriceBase();
    }

    public int mineralPriceFactor() {
        return this.getData().getMineralPriceFactor();
    }

    public int gasPriceBase() {
        return this.getData().getGasPriceBase();
    }

    public int gasPriceFactor() {
        return this.getData().getGasPriceFactor();
    }

    public int upgradeTimeBase() {
        return this.getData().getUpgradeTimeBase();
    }

    public int upgradeTimeFactor() {
        return this.getData().getUpgradeTimeFactor();
    }

    public int maxRepeats() {
        return this.getData().getMaxRepeats();
    }

    public UnitType whatUpgrades() {
        return new UnitType(this.getData().getWhatUpgrades());
    }

    public Set<UnitType> whatUses() {
        HashSet<UnitType> ret = new HashSet<UnitType>();
        for (GameMessages.UnitType t : this.getData().getWhatUsesList()) {
            ret.add(new UnitType(t));
        }
        return ret;
    }

    public static final UpgradeType getUpgradeType(String name) {
        return gNamesToUpgradeTypes.get(name);
    }

    public static final Set<UpgradeType> allUpgradeTypes() {
        return gAllUpgradeTypes;
    }

    static final UpgradeType getUpgradeTypeFromId(int id) {
        return gIdsToUpgradeTypes[id];
    }

    static final int getMaxIdPlusOne() {
        return gIdsToUpgradeTypes.length;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this instanceof UpgradeType) {
            UpgradeType other = (UpgradeType)object;
            return this.id == other.id;
        }
        return false;
    }

    public final int hashCode() {
        return this.id;
    }

    GameMessages.UpgradeType getTypeMessage() {
        return GameMessages.UpgradeType.newBuilder().setId(this.id).build();
    }
}

