/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Race;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.UnitSizeType;
import org.bwapi.proxy.model.UpgradeType;
import org.bwapi.proxy.model.WeaponType;

public final class UnitType {
    protected int id;
    protected static final Map<String, UnitType> unitTypesByName = new HashMap<String, UnitType>();
    protected static final Set<UnitType> gAllUnitTypes;
    protected static final UnitType[] unitTypesById;
    protected static List<GameMessages.UnitTypeData> data;
    public static final UnitType TERRAN_MARINE;
    public static final UnitType TERRAN_GHOST;
    public static final UnitType TERRAN_VULTURE;
    public static final UnitType TERRAN_GOLIATH;
    public static final UnitType TERRAN_SIEGE_TANK_TANK_MODE;
    public static final UnitType TERRAN_SCV;
    public static final UnitType TERRAN_WRAITH;
    public static final UnitType TERRAN_SCIENCE_VESSEL;
    public static final UnitType TERRAN_DROPSHIP;
    public static final UnitType TERRAN_BATTLECRUISER;
    public static final UnitType TERRAN_VULTURE_SPIDER_MINE;
    public static final UnitType TERRAN_NUCLEAR_MISSILE;
    public static final UnitType TERRAN_SIEGE_TANK_SIEGE_MODE;
    public static final UnitType TERRAN_FIREBAT;
    public static final UnitType SPELL_SCANNER_SWEEP;
    public static final UnitType TERRAN_MEDIC;
    public static final UnitType ZERG_LARVA;
    public static final UnitType ZERG_EGG;
    public static final UnitType ZERG_ZERGLING;
    public static final UnitType ZERG_HYDRALISK;
    public static final UnitType ZERG_ULTRALISK;
    public static final UnitType ZERG_BROODLING;
    public static final UnitType ZERG_DRONE;
    public static final UnitType ZERG_OVERLORD;
    public static final UnitType ZERG_MUTALISK;
    public static final UnitType ZERG_GUARDIAN;
    public static final UnitType ZERG_QUEEN;
    public static final UnitType ZERG_DEFILER;
    public static final UnitType ZERG_SCOURGE;
    public static final UnitType ZERG_INFESTED_TERRAN;
    public static final UnitType TERRAN_VALKYRIE;
    public static final UnitType ZERG_COCOON;
    public static final UnitType PROTOSS_CORSAIR;
    public static final UnitType PROTOSS_DARK_TEMPLAR;
    public static final UnitType ZERG_DEVOURER;
    public static final UnitType PROTOSS_DARK_ARCHON;
    public static final UnitType PROTOSS_PROBE;
    public static final UnitType PROTOSS_ZEALOT;
    public static final UnitType PROTOSS_DRAGOON;
    public static final UnitType PROTOSS_HIGH_TEMPLAR;
    public static final UnitType PROTOSS_ARCHON;
    public static final UnitType PROTOSS_SHUTTLE;
    public static final UnitType PROTOSS_SCOUT;
    public static final UnitType PROTOSS_ARBITER;
    public static final UnitType PROTOSS_CARRIER;
    public static final UnitType PROTOSS_INTERCEPTOR;
    public static final UnitType PROTOSS_REAVER;
    public static final UnitType PROTOSS_OBSERVER;
    public static final UnitType PROTOSS_SCARAB;
    public static final UnitType CRITTER_RHYNADON;
    public static final UnitType CRITTER_BENGALAAS;
    public static final UnitType CRITTER_SCANTID;
    public static final UnitType CRITTER_KAKARU;
    public static final UnitType CRITTER_RAGNASAUR;
    public static final UnitType CRITTER_URSADON;
    public static final UnitType ZERG_LURKER_EGG;
    public static final UnitType ZERG_LURKER;
    public static final UnitType SPELL_DISRUPTION_WEB;
    public static final UnitType TERRAN_COMMAND_CENTER;
    public static final UnitType TERRAN_COMSAT_STATION;
    public static final UnitType TERRAN_NUCLEAR_SILO;
    public static final UnitType TERRAN_SUPPLY_DEPOT;
    public static final UnitType TERRAN_REFINERY;
    public static final UnitType TERRAN_BARRACKS;
    public static final UnitType TERRAN_ACADEMY;
    public static final UnitType TERRAN_FACTORY;
    public static final UnitType TERRAN_STARPORT;
    public static final UnitType TERRAN_CONTROL_TOWER;
    public static final UnitType TERRAN_SCIENCE_FACILITY;
    public static final UnitType TERRAN_COVERT_OPS;
    public static final UnitType TERRAN_PHYSICS_LAB;
    public static final UnitType TERRAN_MACHINE_SHOP;
    public static final UnitType TERRAN_ENGINEERING_BAY;
    public static final UnitType TERRAN_ARMORY;
    public static final UnitType TERRAN_MISSILE_TURRET;
    public static final UnitType TERRAN_BUNKER;
    public static final UnitType SPECIAL_CRASHED_NORAD_II;
    public static final UnitType SPECIAL_ION_CANNON;
    public static final UnitType ZERG_INFESTED_COMMAND_CENTER;
    public static final UnitType ZERG_HATCHERY;
    public static final UnitType ZERG_LAIR;
    public static final UnitType ZERG_HIVE;
    public static final UnitType ZERG_NYDUS_CANAL;
    public static final UnitType ZERG_HYDRALISK_DEN;
    public static final UnitType ZERG_DEFILER_MOUND;
    public static final UnitType ZERG_GREATER_SPIRE;
    public static final UnitType ZERG_QUEENS_NEST;
    public static final UnitType ZERG_EVOLUTION_CHAMBER;
    public static final UnitType ZERG_ULTRALISK_CAVERN;
    public static final UnitType ZERG_SPIRE;
    public static final UnitType ZERG_SPAWNING_POOL;
    public static final UnitType ZERG_CREEP_COLONY;
    public static final UnitType ZERG_SPORE_COLONY;
    public static final UnitType ZERG_SUNKEN_COLONY;
    public static final UnitType SPECIAL_OVERMIND_WITH_SHELL;
    public static final UnitType SPECIAL_OVERMIND;
    public static final UnitType ZERG_EXTRACTOR;
    public static final UnitType SPECIAL_MATURE_CHRYSALIS;
    public static final UnitType SPECIAL_CEREBRATE;
    public static final UnitType SPECIAL_CEREBRATE_DAGGOTH;
    public static final UnitType PROTOSS_NEXUS;
    public static final UnitType PROTOSS_ROBOTICS_FACILITY;
    public static final UnitType PROTOSS_PYLON;
    public static final UnitType PROTOSS_ASSIMILATOR;
    public static final UnitType PROTOSS_OBSERVATORY;
    public static final UnitType PROTOSS_GATEWAY;
    public static final UnitType PROTOSS_PHOTON_CANNON;
    public static final UnitType PROTOSS_CITADEL_OF_ADUN;
    public static final UnitType PROTOSS_CYBERNETICS_CORE;
    public static final UnitType PROTOSS_TEMPLAR_ARCHIVES;
    public static final UnitType PROTOSS_FORGE;
    public static final UnitType PROTOSS_STARGATE;
    public static final UnitType SPECIAL_STASIS_CELL_PRISON;
    public static final UnitType PROTOSS_FLEET_BEACON;
    public static final UnitType PROTOSS_ARBITER_TRIBUNAL;
    public static final UnitType PROTOSS_ROBOTICS_SUPPORT_BAY;
    public static final UnitType PROTOSS_SHIELD_BATTERY;
    public static final UnitType SPECIAL_KHAYDARIN_CRYSTAL_FORM;
    public static final UnitType SPECIAL_PROTOSS_TEMPLE;
    public static final UnitType SPECIAL_XEL_NAGA_TEMPLE;
    public static final UnitType RESOURCE_MINERAL_FIELD;
    public static final UnitType RESOURCE_VESPENE_GEYSER;
    public static final UnitType SPECIAL_WARP_GATE;
    public static final UnitType SPECIAL_PSI_DISRUPTER;
    public static final UnitType SPECIAL_POWER_GENERATOR;
    public static final UnitType SPECIAL_OVERMIND_COCOON;
    public static final UnitType SPELL_DARK_SWARM;
    public static final UnitType NONE;
    public static final UnitType UNKNOWN;

    static {
        TERRAN_MARINE = new UnitType(0);
        TERRAN_GHOST = new UnitType(1);
        TERRAN_VULTURE = new UnitType(2);
        TERRAN_GOLIATH = new UnitType(3);
        TERRAN_SIEGE_TANK_TANK_MODE = new UnitType(5);
        TERRAN_SCV = new UnitType(7);
        TERRAN_WRAITH = new UnitType(8);
        TERRAN_SCIENCE_VESSEL = new UnitType(9);
        TERRAN_DROPSHIP = new UnitType(11);
        TERRAN_BATTLECRUISER = new UnitType(12);
        TERRAN_VULTURE_SPIDER_MINE = new UnitType(13);
        TERRAN_NUCLEAR_MISSILE = new UnitType(14);
        TERRAN_SIEGE_TANK_SIEGE_MODE = new UnitType(30);
        TERRAN_FIREBAT = new UnitType(32);
        SPELL_SCANNER_SWEEP = new UnitType(33);
        TERRAN_MEDIC = new UnitType(34);
        ZERG_LARVA = new UnitType(35);
        ZERG_EGG = new UnitType(36);
        ZERG_ZERGLING = new UnitType(37);
        ZERG_HYDRALISK = new UnitType(38);
        ZERG_ULTRALISK = new UnitType(39);
        ZERG_BROODLING = new UnitType(40);
        ZERG_DRONE = new UnitType(41);
        ZERG_OVERLORD = new UnitType(42);
        ZERG_MUTALISK = new UnitType(43);
        ZERG_GUARDIAN = new UnitType(44);
        ZERG_QUEEN = new UnitType(45);
        ZERG_DEFILER = new UnitType(46);
        ZERG_SCOURGE = new UnitType(47);
        ZERG_INFESTED_TERRAN = new UnitType(50);
        TERRAN_VALKYRIE = new UnitType(58);
        ZERG_COCOON = new UnitType(59);
        PROTOSS_CORSAIR = new UnitType(60);
        PROTOSS_DARK_TEMPLAR = new UnitType(61);
        ZERG_DEVOURER = new UnitType(62);
        PROTOSS_DARK_ARCHON = new UnitType(63);
        PROTOSS_PROBE = new UnitType(64);
        PROTOSS_ZEALOT = new UnitType(65);
        PROTOSS_DRAGOON = new UnitType(66);
        PROTOSS_HIGH_TEMPLAR = new UnitType(67);
        PROTOSS_ARCHON = new UnitType(68);
        PROTOSS_SHUTTLE = new UnitType(69);
        PROTOSS_SCOUT = new UnitType(70);
        PROTOSS_ARBITER = new UnitType(71);
        PROTOSS_CARRIER = new UnitType(72);
        PROTOSS_INTERCEPTOR = new UnitType(73);
        PROTOSS_REAVER = new UnitType(83);
        PROTOSS_OBSERVER = new UnitType(84);
        PROTOSS_SCARAB = new UnitType(85);
        CRITTER_RHYNADON = new UnitType(89);
        CRITTER_BENGALAAS = new UnitType(90);
        CRITTER_SCANTID = new UnitType(93);
        CRITTER_KAKARU = new UnitType(94);
        CRITTER_RAGNASAUR = new UnitType(95);
        CRITTER_URSADON = new UnitType(96);
        ZERG_LURKER_EGG = new UnitType(97);
        ZERG_LURKER = new UnitType(103);
        SPELL_DISRUPTION_WEB = new UnitType(105);
        TERRAN_COMMAND_CENTER = new UnitType(106);
        TERRAN_COMSAT_STATION = new UnitType(107);
        TERRAN_NUCLEAR_SILO = new UnitType(108);
        TERRAN_SUPPLY_DEPOT = new UnitType(109);
        TERRAN_REFINERY = new UnitType(110);
        TERRAN_BARRACKS = new UnitType(111);
        TERRAN_ACADEMY = new UnitType(112);
        TERRAN_FACTORY = new UnitType(113);
        TERRAN_STARPORT = new UnitType(114);
        TERRAN_CONTROL_TOWER = new UnitType(115);
        TERRAN_SCIENCE_FACILITY = new UnitType(116);
        TERRAN_COVERT_OPS = new UnitType(117);
        TERRAN_PHYSICS_LAB = new UnitType(118);
        TERRAN_MACHINE_SHOP = new UnitType(120);
        TERRAN_ENGINEERING_BAY = new UnitType(122);
        TERRAN_ARMORY = new UnitType(123);
        TERRAN_MISSILE_TURRET = new UnitType(124);
        TERRAN_BUNKER = new UnitType(125);
        SPECIAL_CRASHED_NORAD_II = new UnitType(126);
        SPECIAL_ION_CANNON = new UnitType(127);
        ZERG_INFESTED_COMMAND_CENTER = new UnitType(130);
        ZERG_HATCHERY = new UnitType(131);
        ZERG_LAIR = new UnitType(132);
        ZERG_HIVE = new UnitType(133);
        ZERG_NYDUS_CANAL = new UnitType(134);
        ZERG_HYDRALISK_DEN = new UnitType(135);
        ZERG_DEFILER_MOUND = new UnitType(136);
        ZERG_GREATER_SPIRE = new UnitType(137);
        ZERG_QUEENS_NEST = new UnitType(138);
        ZERG_EVOLUTION_CHAMBER = new UnitType(139);
        ZERG_ULTRALISK_CAVERN = new UnitType(140);
        ZERG_SPIRE = new UnitType(141);
        ZERG_SPAWNING_POOL = new UnitType(142);
        ZERG_CREEP_COLONY = new UnitType(143);
        ZERG_SPORE_COLONY = new UnitType(144);
        ZERG_SUNKEN_COLONY = new UnitType(146);
        SPECIAL_OVERMIND_WITH_SHELL = new UnitType(147);
        SPECIAL_OVERMIND = new UnitType(148);
        ZERG_EXTRACTOR = new UnitType(149);
        SPECIAL_MATURE_CHRYSALIS = new UnitType(150);
        SPECIAL_CEREBRATE = new UnitType(151);
        SPECIAL_CEREBRATE_DAGGOTH = new UnitType(152);
        PROTOSS_NEXUS = new UnitType(154);
        PROTOSS_ROBOTICS_FACILITY = new UnitType(155);
        PROTOSS_PYLON = new UnitType(156);
        PROTOSS_ASSIMILATOR = new UnitType(157);
        PROTOSS_OBSERVATORY = new UnitType(159);
        PROTOSS_GATEWAY = new UnitType(160);
        PROTOSS_PHOTON_CANNON = new UnitType(162);
        PROTOSS_CITADEL_OF_ADUN = new UnitType(163);
        PROTOSS_CYBERNETICS_CORE = new UnitType(164);
        PROTOSS_TEMPLAR_ARCHIVES = new UnitType(165);
        PROTOSS_FORGE = new UnitType(166);
        PROTOSS_STARGATE = new UnitType(167);
        SPECIAL_STASIS_CELL_PRISON = new UnitType(168);
        PROTOSS_FLEET_BEACON = new UnitType(169);
        PROTOSS_ARBITER_TRIBUNAL = new UnitType(170);
        PROTOSS_ROBOTICS_SUPPORT_BAY = new UnitType(171);
        PROTOSS_SHIELD_BATTERY = new UnitType(172);
        SPECIAL_KHAYDARIN_CRYSTAL_FORM = new UnitType(173);
        SPECIAL_PROTOSS_TEMPLE = new UnitType(174);
        SPECIAL_XEL_NAGA_TEMPLE = new UnitType(175);
        RESOURCE_MINERAL_FIELD = new UnitType(176);
        RESOURCE_VESPENE_GEYSER = new UnitType(188);
        SPECIAL_WARP_GATE = new UnitType(189);
        SPECIAL_PSI_DISRUPTER = new UnitType(190);
        SPECIAL_POWER_GENERATOR = new UnitType(200);
        SPECIAL_OVERMIND_COCOON = new UnitType(201);
        SPELL_DARK_SWARM = new UnitType(202);
        NONE = new UnitType(228);
        UNKNOWN = new UnitType(233);
        HashSet<UnitType> allUnitTypes = new HashSet<UnitType>();
        unitTypesById = new UnitType[234];
        unitTypesByName.put("Terran Marine", TERRAN_MARINE);
        allUnitTypes.add(TERRAN_MARINE);
        UnitType.unitTypesById[0] = TERRAN_MARINE;
        unitTypesByName.put("Terran Ghost", TERRAN_GHOST);
        allUnitTypes.add(TERRAN_GHOST);
        UnitType.unitTypesById[1] = TERRAN_GHOST;
        unitTypesByName.put("Terran Vulture", TERRAN_VULTURE);
        allUnitTypes.add(TERRAN_VULTURE);
        UnitType.unitTypesById[2] = TERRAN_VULTURE;
        unitTypesByName.put("Terran Goliath", TERRAN_GOLIATH);
        allUnitTypes.add(TERRAN_GOLIATH);
        UnitType.unitTypesById[3] = TERRAN_GOLIATH;
        unitTypesByName.put("Terran Siege Tank Tank Mode", TERRAN_SIEGE_TANK_TANK_MODE);
        allUnitTypes.add(TERRAN_SIEGE_TANK_TANK_MODE);
        UnitType.unitTypesById[5] = TERRAN_SIEGE_TANK_TANK_MODE;
        unitTypesByName.put("Terran SCV", TERRAN_SCV);
        allUnitTypes.add(TERRAN_SCV);
        UnitType.unitTypesById[7] = TERRAN_SCV;
        unitTypesByName.put("Terran Wraith", TERRAN_WRAITH);
        allUnitTypes.add(TERRAN_WRAITH);
        UnitType.unitTypesById[8] = TERRAN_WRAITH;
        unitTypesByName.put("Terran Science Vessel", TERRAN_SCIENCE_VESSEL);
        allUnitTypes.add(TERRAN_SCIENCE_VESSEL);
        UnitType.unitTypesById[9] = TERRAN_SCIENCE_VESSEL;
        unitTypesByName.put("Terran Dropship", TERRAN_DROPSHIP);
        allUnitTypes.add(TERRAN_DROPSHIP);
        UnitType.unitTypesById[11] = TERRAN_DROPSHIP;
        unitTypesByName.put("Terran Battlecruiser", TERRAN_BATTLECRUISER);
        allUnitTypes.add(TERRAN_BATTLECRUISER);
        UnitType.unitTypesById[12] = TERRAN_BATTLECRUISER;
        unitTypesByName.put("Terran Vulture Spider Mine", TERRAN_VULTURE_SPIDER_MINE);
        allUnitTypes.add(TERRAN_VULTURE_SPIDER_MINE);
        UnitType.unitTypesById[13] = TERRAN_VULTURE_SPIDER_MINE;
        unitTypesByName.put("Terran Nuclear Missile", TERRAN_NUCLEAR_MISSILE);
        allUnitTypes.add(TERRAN_NUCLEAR_MISSILE);
        UnitType.unitTypesById[14] = TERRAN_NUCLEAR_MISSILE;
        unitTypesByName.put("Terran Siege Tank Siege Mode", TERRAN_SIEGE_TANK_SIEGE_MODE);
        allUnitTypes.add(TERRAN_SIEGE_TANK_SIEGE_MODE);
        UnitType.unitTypesById[30] = TERRAN_SIEGE_TANK_SIEGE_MODE;
        unitTypesByName.put("Terran Firebat", TERRAN_FIREBAT);
        allUnitTypes.add(TERRAN_FIREBAT);
        UnitType.unitTypesById[32] = TERRAN_FIREBAT;
        unitTypesByName.put("Spell Scanner Sweep", SPELL_SCANNER_SWEEP);
        allUnitTypes.add(SPELL_SCANNER_SWEEP);
        UnitType.unitTypesById[33] = SPELL_SCANNER_SWEEP;
        unitTypesByName.put("Terran Medic", TERRAN_MEDIC);
        allUnitTypes.add(TERRAN_MEDIC);
        UnitType.unitTypesById[34] = TERRAN_MEDIC;
        unitTypesByName.put("Zerg Larva", ZERG_LARVA);
        allUnitTypes.add(ZERG_LARVA);
        UnitType.unitTypesById[35] = ZERG_LARVA;
        unitTypesByName.put("Zerg Egg", ZERG_EGG);
        allUnitTypes.add(ZERG_EGG);
        UnitType.unitTypesById[36] = ZERG_EGG;
        unitTypesByName.put("Zerg Zergling", ZERG_ZERGLING);
        allUnitTypes.add(ZERG_ZERGLING);
        UnitType.unitTypesById[37] = ZERG_ZERGLING;
        unitTypesByName.put("Zerg Hydralisk", ZERG_HYDRALISK);
        allUnitTypes.add(ZERG_HYDRALISK);
        UnitType.unitTypesById[38] = ZERG_HYDRALISK;
        unitTypesByName.put("Zerg Ultralisk", ZERG_ULTRALISK);
        allUnitTypes.add(ZERG_ULTRALISK);
        UnitType.unitTypesById[39] = ZERG_ULTRALISK;
        unitTypesByName.put("Zerg Broodling", ZERG_BROODLING);
        allUnitTypes.add(ZERG_BROODLING);
        UnitType.unitTypesById[40] = ZERG_BROODLING;
        unitTypesByName.put("Zerg Drone", ZERG_DRONE);
        allUnitTypes.add(ZERG_DRONE);
        UnitType.unitTypesById[41] = ZERG_DRONE;
        unitTypesByName.put("Zerg Overlord", ZERG_OVERLORD);
        allUnitTypes.add(ZERG_OVERLORD);
        UnitType.unitTypesById[42] = ZERG_OVERLORD;
        unitTypesByName.put("Zerg Mutalisk", ZERG_MUTALISK);
        allUnitTypes.add(ZERG_MUTALISK);
        UnitType.unitTypesById[43] = ZERG_MUTALISK;
        unitTypesByName.put("Zerg Guardian", ZERG_GUARDIAN);
        allUnitTypes.add(ZERG_GUARDIAN);
        UnitType.unitTypesById[44] = ZERG_GUARDIAN;
        unitTypesByName.put("Zerg Queen", ZERG_QUEEN);
        allUnitTypes.add(ZERG_QUEEN);
        UnitType.unitTypesById[45] = ZERG_QUEEN;
        unitTypesByName.put("Zerg Defiler", ZERG_DEFILER);
        allUnitTypes.add(ZERG_DEFILER);
        UnitType.unitTypesById[46] = ZERG_DEFILER;
        unitTypesByName.put("Zerg Scourge", ZERG_SCOURGE);
        allUnitTypes.add(ZERG_SCOURGE);
        UnitType.unitTypesById[47] = ZERG_SCOURGE;
        unitTypesByName.put("Zerg Infested Terran", ZERG_INFESTED_TERRAN);
        allUnitTypes.add(ZERG_INFESTED_TERRAN);
        UnitType.unitTypesById[50] = ZERG_INFESTED_TERRAN;
        unitTypesByName.put("Terran Valkyrie", TERRAN_VALKYRIE);
        allUnitTypes.add(TERRAN_VALKYRIE);
        UnitType.unitTypesById[58] = TERRAN_VALKYRIE;
        unitTypesByName.put("Zerg Cocoon", ZERG_COCOON);
        allUnitTypes.add(ZERG_COCOON);
        UnitType.unitTypesById[59] = ZERG_COCOON;
        unitTypesByName.put("Protoss Corsair", PROTOSS_CORSAIR);
        allUnitTypes.add(PROTOSS_CORSAIR);
        UnitType.unitTypesById[60] = PROTOSS_CORSAIR;
        unitTypesByName.put("Protoss Dark Templar", PROTOSS_DARK_TEMPLAR);
        allUnitTypes.add(PROTOSS_DARK_TEMPLAR);
        UnitType.unitTypesById[61] = PROTOSS_DARK_TEMPLAR;
        unitTypesByName.put("Zerg Devourer", ZERG_DEVOURER);
        allUnitTypes.add(ZERG_DEVOURER);
        UnitType.unitTypesById[62] = ZERG_DEVOURER;
        unitTypesByName.put("Protoss Dark Archon", PROTOSS_DARK_ARCHON);
        allUnitTypes.add(PROTOSS_DARK_ARCHON);
        UnitType.unitTypesById[63] = PROTOSS_DARK_ARCHON;
        unitTypesByName.put("Protoss Probe", PROTOSS_PROBE);
        allUnitTypes.add(PROTOSS_PROBE);
        UnitType.unitTypesById[64] = PROTOSS_PROBE;
        unitTypesByName.put("Protoss Zealot", PROTOSS_ZEALOT);
        allUnitTypes.add(PROTOSS_ZEALOT);
        UnitType.unitTypesById[65] = PROTOSS_ZEALOT;
        unitTypesByName.put("Protoss Dragoon", PROTOSS_DRAGOON);
        allUnitTypes.add(PROTOSS_DRAGOON);
        UnitType.unitTypesById[66] = PROTOSS_DRAGOON;
        unitTypesByName.put("Protoss High Templar", PROTOSS_HIGH_TEMPLAR);
        allUnitTypes.add(PROTOSS_HIGH_TEMPLAR);
        UnitType.unitTypesById[67] = PROTOSS_HIGH_TEMPLAR;
        unitTypesByName.put("Protoss Archon", PROTOSS_ARCHON);
        allUnitTypes.add(PROTOSS_ARCHON);
        UnitType.unitTypesById[68] = PROTOSS_ARCHON;
        unitTypesByName.put("Protoss Shuttle", PROTOSS_SHUTTLE);
        allUnitTypes.add(PROTOSS_SHUTTLE);
        UnitType.unitTypesById[69] = PROTOSS_SHUTTLE;
        unitTypesByName.put("Protoss Scout", PROTOSS_SCOUT);
        allUnitTypes.add(PROTOSS_SCOUT);
        UnitType.unitTypesById[70] = PROTOSS_SCOUT;
        unitTypesByName.put("Protoss Arbiter", PROTOSS_ARBITER);
        allUnitTypes.add(PROTOSS_ARBITER);
        UnitType.unitTypesById[71] = PROTOSS_ARBITER;
        unitTypesByName.put("Protoss Carrier", PROTOSS_CARRIER);
        allUnitTypes.add(PROTOSS_CARRIER);
        UnitType.unitTypesById[72] = PROTOSS_CARRIER;
        unitTypesByName.put("Protoss Interceptor", PROTOSS_INTERCEPTOR);
        allUnitTypes.add(PROTOSS_INTERCEPTOR);
        UnitType.unitTypesById[73] = PROTOSS_INTERCEPTOR;
        unitTypesByName.put("Protoss Reaver", PROTOSS_REAVER);
        allUnitTypes.add(PROTOSS_REAVER);
        UnitType.unitTypesById[83] = PROTOSS_REAVER;
        unitTypesByName.put("Protoss Observer", PROTOSS_OBSERVER);
        allUnitTypes.add(PROTOSS_OBSERVER);
        UnitType.unitTypesById[84] = PROTOSS_OBSERVER;
        unitTypesByName.put("Protoss Scarab", PROTOSS_SCARAB);
        allUnitTypes.add(PROTOSS_SCARAB);
        UnitType.unitTypesById[85] = PROTOSS_SCARAB;
        unitTypesByName.put("Critter Rhynadon", CRITTER_RHYNADON);
        allUnitTypes.add(CRITTER_RHYNADON);
        UnitType.unitTypesById[89] = CRITTER_RHYNADON;
        unitTypesByName.put("Critter Bengalaas", CRITTER_BENGALAAS);
        allUnitTypes.add(CRITTER_BENGALAAS);
        UnitType.unitTypesById[90] = CRITTER_BENGALAAS;
        unitTypesByName.put("Critter Scantid", CRITTER_SCANTID);
        allUnitTypes.add(CRITTER_SCANTID);
        UnitType.unitTypesById[93] = CRITTER_SCANTID;
        unitTypesByName.put("Critter Kakaru", CRITTER_KAKARU);
        allUnitTypes.add(CRITTER_KAKARU);
        UnitType.unitTypesById[94] = CRITTER_KAKARU;
        unitTypesByName.put("Critter Ragnasaur", CRITTER_RAGNASAUR);
        allUnitTypes.add(CRITTER_RAGNASAUR);
        UnitType.unitTypesById[95] = CRITTER_RAGNASAUR;
        unitTypesByName.put("Critter Ursadon", CRITTER_URSADON);
        allUnitTypes.add(CRITTER_URSADON);
        UnitType.unitTypesById[96] = CRITTER_URSADON;
        unitTypesByName.put("Zerg Lurker Egg", ZERG_LURKER_EGG);
        allUnitTypes.add(ZERG_LURKER_EGG);
        UnitType.unitTypesById[97] = ZERG_LURKER_EGG;
        unitTypesByName.put("Zerg Lurker", ZERG_LURKER);
        allUnitTypes.add(ZERG_LURKER);
        UnitType.unitTypesById[103] = ZERG_LURKER;
        unitTypesByName.put("Spell Disruption Web", SPELL_DISRUPTION_WEB);
        allUnitTypes.add(SPELL_DISRUPTION_WEB);
        UnitType.unitTypesById[105] = SPELL_DISRUPTION_WEB;
        unitTypesByName.put("Terran Command Center", TERRAN_COMMAND_CENTER);
        allUnitTypes.add(TERRAN_COMMAND_CENTER);
        UnitType.unitTypesById[106] = TERRAN_COMMAND_CENTER;
        unitTypesByName.put("Terran Comsat Station", TERRAN_COMSAT_STATION);
        allUnitTypes.add(TERRAN_COMSAT_STATION);
        UnitType.unitTypesById[107] = TERRAN_COMSAT_STATION;
        unitTypesByName.put("Terran Nuclear Silo", TERRAN_NUCLEAR_SILO);
        allUnitTypes.add(TERRAN_NUCLEAR_SILO);
        UnitType.unitTypesById[108] = TERRAN_NUCLEAR_SILO;
        unitTypesByName.put("Terran Supply Depot", TERRAN_SUPPLY_DEPOT);
        allUnitTypes.add(TERRAN_SUPPLY_DEPOT);
        UnitType.unitTypesById[109] = TERRAN_SUPPLY_DEPOT;
        unitTypesByName.put("Terran Refinery", TERRAN_REFINERY);
        allUnitTypes.add(TERRAN_REFINERY);
        UnitType.unitTypesById[110] = TERRAN_REFINERY;
        unitTypesByName.put("Terran Barracks", TERRAN_BARRACKS);
        allUnitTypes.add(TERRAN_BARRACKS);
        UnitType.unitTypesById[111] = TERRAN_BARRACKS;
        unitTypesByName.put("Terran Academy", TERRAN_ACADEMY);
        allUnitTypes.add(TERRAN_ACADEMY);
        UnitType.unitTypesById[112] = TERRAN_ACADEMY;
        unitTypesByName.put("Terran Factory", TERRAN_FACTORY);
        allUnitTypes.add(TERRAN_FACTORY);
        UnitType.unitTypesById[113] = TERRAN_FACTORY;
        unitTypesByName.put("Terran Starport", TERRAN_STARPORT);
        allUnitTypes.add(TERRAN_STARPORT);
        UnitType.unitTypesById[114] = TERRAN_STARPORT;
        unitTypesByName.put("Terran Control Tower", TERRAN_CONTROL_TOWER);
        allUnitTypes.add(TERRAN_CONTROL_TOWER);
        UnitType.unitTypesById[115] = TERRAN_CONTROL_TOWER;
        unitTypesByName.put("Terran Science Facility", TERRAN_SCIENCE_FACILITY);
        allUnitTypes.add(TERRAN_SCIENCE_FACILITY);
        UnitType.unitTypesById[116] = TERRAN_SCIENCE_FACILITY;
        unitTypesByName.put("Terran Covert Ops", TERRAN_COVERT_OPS);
        allUnitTypes.add(TERRAN_COVERT_OPS);
        UnitType.unitTypesById[117] = TERRAN_COVERT_OPS;
        unitTypesByName.put("Terran Physics Lab", TERRAN_PHYSICS_LAB);
        allUnitTypes.add(TERRAN_PHYSICS_LAB);
        UnitType.unitTypesById[118] = TERRAN_PHYSICS_LAB;
        unitTypesByName.put("Terran Machine Shop", TERRAN_MACHINE_SHOP);
        allUnitTypes.add(TERRAN_MACHINE_SHOP);
        UnitType.unitTypesById[120] = TERRAN_MACHINE_SHOP;
        unitTypesByName.put("Terran Engineering Bay", TERRAN_ENGINEERING_BAY);
        allUnitTypes.add(TERRAN_ENGINEERING_BAY);
        UnitType.unitTypesById[122] = TERRAN_ENGINEERING_BAY;
        unitTypesByName.put("Terran Armory", TERRAN_ARMORY);
        allUnitTypes.add(TERRAN_ARMORY);
        UnitType.unitTypesById[123] = TERRAN_ARMORY;
        unitTypesByName.put("Terran Missile Turret", TERRAN_MISSILE_TURRET);
        allUnitTypes.add(TERRAN_MISSILE_TURRET);
        UnitType.unitTypesById[124] = TERRAN_MISSILE_TURRET;
        unitTypesByName.put("Terran Bunker", TERRAN_BUNKER);
        allUnitTypes.add(TERRAN_BUNKER);
        UnitType.unitTypesById[125] = TERRAN_BUNKER;
        unitTypesByName.put("Special Crashed Norad II", SPECIAL_CRASHED_NORAD_II);
        allUnitTypes.add(SPECIAL_CRASHED_NORAD_II);
        UnitType.unitTypesById[126] = SPECIAL_CRASHED_NORAD_II;
        unitTypesByName.put("Special Ion Cannon", SPECIAL_ION_CANNON);
        allUnitTypes.add(SPECIAL_ION_CANNON);
        UnitType.unitTypesById[127] = SPECIAL_ION_CANNON;
        unitTypesByName.put("Zerg Infested Command Center", ZERG_INFESTED_COMMAND_CENTER);
        allUnitTypes.add(ZERG_INFESTED_COMMAND_CENTER);
        UnitType.unitTypesById[130] = ZERG_INFESTED_COMMAND_CENTER;
        unitTypesByName.put("Zerg Hatchery", ZERG_HATCHERY);
        allUnitTypes.add(ZERG_HATCHERY);
        UnitType.unitTypesById[131] = ZERG_HATCHERY;
        unitTypesByName.put("Zerg Lair", ZERG_LAIR);
        allUnitTypes.add(ZERG_LAIR);
        UnitType.unitTypesById[132] = ZERG_LAIR;
        unitTypesByName.put("Zerg Hive", ZERG_HIVE);
        allUnitTypes.add(ZERG_HIVE);
        UnitType.unitTypesById[133] = ZERG_HIVE;
        unitTypesByName.put("Zerg Nydus Canal", ZERG_NYDUS_CANAL);
        allUnitTypes.add(ZERG_NYDUS_CANAL);
        UnitType.unitTypesById[134] = ZERG_NYDUS_CANAL;
        unitTypesByName.put("Zerg Hydralisk Den", ZERG_HYDRALISK_DEN);
        allUnitTypes.add(ZERG_HYDRALISK_DEN);
        UnitType.unitTypesById[135] = ZERG_HYDRALISK_DEN;
        unitTypesByName.put("Zerg Defiler Mound", ZERG_DEFILER_MOUND);
        allUnitTypes.add(ZERG_DEFILER_MOUND);
        UnitType.unitTypesById[136] = ZERG_DEFILER_MOUND;
        unitTypesByName.put("Zerg Greater Spire", ZERG_GREATER_SPIRE);
        allUnitTypes.add(ZERG_GREATER_SPIRE);
        UnitType.unitTypesById[137] = ZERG_GREATER_SPIRE;
        unitTypesByName.put("Zerg Queens Nest", ZERG_QUEENS_NEST);
        allUnitTypes.add(ZERG_QUEENS_NEST);
        UnitType.unitTypesById[138] = ZERG_QUEENS_NEST;
        unitTypesByName.put("Zerg Evolution Chamber", ZERG_EVOLUTION_CHAMBER);
        allUnitTypes.add(ZERG_EVOLUTION_CHAMBER);
        UnitType.unitTypesById[139] = ZERG_EVOLUTION_CHAMBER;
        unitTypesByName.put("Zerg Ultralisk Cavern", ZERG_ULTRALISK_CAVERN);
        allUnitTypes.add(ZERG_ULTRALISK_CAVERN);
        UnitType.unitTypesById[140] = ZERG_ULTRALISK_CAVERN;
        unitTypesByName.put("Zerg Spire", ZERG_SPIRE);
        allUnitTypes.add(ZERG_SPIRE);
        UnitType.unitTypesById[141] = ZERG_SPIRE;
        unitTypesByName.put("Zerg Spawning Pool", ZERG_SPAWNING_POOL);
        allUnitTypes.add(ZERG_SPAWNING_POOL);
        UnitType.unitTypesById[142] = ZERG_SPAWNING_POOL;
        unitTypesByName.put("Zerg Creep Colony", ZERG_CREEP_COLONY);
        allUnitTypes.add(ZERG_CREEP_COLONY);
        UnitType.unitTypesById[143] = ZERG_CREEP_COLONY;
        unitTypesByName.put("Zerg Spore Colony", ZERG_SPORE_COLONY);
        allUnitTypes.add(ZERG_SPORE_COLONY);
        UnitType.unitTypesById[144] = ZERG_SPORE_COLONY;
        unitTypesByName.put("Zerg Sunken Colony", ZERG_SUNKEN_COLONY);
        allUnitTypes.add(ZERG_SUNKEN_COLONY);
        UnitType.unitTypesById[146] = ZERG_SUNKEN_COLONY;
        unitTypesByName.put("Special Overmind With Shell", SPECIAL_OVERMIND_WITH_SHELL);
        allUnitTypes.add(SPECIAL_OVERMIND_WITH_SHELL);
        UnitType.unitTypesById[147] = SPECIAL_OVERMIND_WITH_SHELL;
        unitTypesByName.put("Special Overmind", SPECIAL_OVERMIND);
        allUnitTypes.add(SPECIAL_OVERMIND);
        UnitType.unitTypesById[148] = SPECIAL_OVERMIND;
        unitTypesByName.put("Zerg Extractor", ZERG_EXTRACTOR);
        allUnitTypes.add(ZERG_EXTRACTOR);
        UnitType.unitTypesById[149] = ZERG_EXTRACTOR;
        unitTypesByName.put("Special Mature Chrysalis", SPECIAL_MATURE_CHRYSALIS);
        allUnitTypes.add(SPECIAL_MATURE_CHRYSALIS);
        UnitType.unitTypesById[150] = SPECIAL_MATURE_CHRYSALIS;
        unitTypesByName.put("Special Cerebrate", SPECIAL_CEREBRATE);
        allUnitTypes.add(SPECIAL_CEREBRATE);
        UnitType.unitTypesById[151] = SPECIAL_CEREBRATE;
        unitTypesByName.put("Special Cerebrate Daggoth", SPECIAL_CEREBRATE_DAGGOTH);
        allUnitTypes.add(SPECIAL_CEREBRATE_DAGGOTH);
        UnitType.unitTypesById[152] = SPECIAL_CEREBRATE_DAGGOTH;
        unitTypesByName.put("Protoss Nexus", PROTOSS_NEXUS);
        allUnitTypes.add(PROTOSS_NEXUS);
        UnitType.unitTypesById[154] = PROTOSS_NEXUS;
        unitTypesByName.put("Protoss Robotics Facility", PROTOSS_ROBOTICS_FACILITY);
        allUnitTypes.add(PROTOSS_ROBOTICS_FACILITY);
        UnitType.unitTypesById[155] = PROTOSS_ROBOTICS_FACILITY;
        unitTypesByName.put("Protoss Pylon", PROTOSS_PYLON);
        allUnitTypes.add(PROTOSS_PYLON);
        UnitType.unitTypesById[156] = PROTOSS_PYLON;
        unitTypesByName.put("Protoss Assimilator", PROTOSS_ASSIMILATOR);
        allUnitTypes.add(PROTOSS_ASSIMILATOR);
        UnitType.unitTypesById[157] = PROTOSS_ASSIMILATOR;
        unitTypesByName.put("Protoss Observatory", PROTOSS_OBSERVATORY);
        allUnitTypes.add(PROTOSS_OBSERVATORY);
        UnitType.unitTypesById[159] = PROTOSS_OBSERVATORY;
        unitTypesByName.put("Protoss Gateway", PROTOSS_GATEWAY);
        allUnitTypes.add(PROTOSS_GATEWAY);
        UnitType.unitTypesById[160] = PROTOSS_GATEWAY;
        unitTypesByName.put("Protoss Photon Cannon", PROTOSS_PHOTON_CANNON);
        allUnitTypes.add(PROTOSS_PHOTON_CANNON);
        UnitType.unitTypesById[162] = PROTOSS_PHOTON_CANNON;
        unitTypesByName.put("Protoss Citadel of Adun", PROTOSS_CITADEL_OF_ADUN);
        allUnitTypes.add(PROTOSS_CITADEL_OF_ADUN);
        UnitType.unitTypesById[163] = PROTOSS_CITADEL_OF_ADUN;
        unitTypesByName.put("Protoss Cybernetics Core", PROTOSS_CYBERNETICS_CORE);
        allUnitTypes.add(PROTOSS_CYBERNETICS_CORE);
        UnitType.unitTypesById[164] = PROTOSS_CYBERNETICS_CORE;
        unitTypesByName.put("Protoss Templar Archives", PROTOSS_TEMPLAR_ARCHIVES);
        allUnitTypes.add(PROTOSS_TEMPLAR_ARCHIVES);
        UnitType.unitTypesById[165] = PROTOSS_TEMPLAR_ARCHIVES;
        unitTypesByName.put("Protoss Forge", PROTOSS_FORGE);
        allUnitTypes.add(PROTOSS_FORGE);
        UnitType.unitTypesById[166] = PROTOSS_FORGE;
        unitTypesByName.put("Protoss Stargate", PROTOSS_STARGATE);
        allUnitTypes.add(PROTOSS_STARGATE);
        UnitType.unitTypesById[167] = PROTOSS_STARGATE;
        unitTypesByName.put("Special Stasis Cell Prison", SPECIAL_STASIS_CELL_PRISON);
        allUnitTypes.add(SPECIAL_STASIS_CELL_PRISON);
        UnitType.unitTypesById[168] = SPECIAL_STASIS_CELL_PRISON;
        unitTypesByName.put("Protoss Fleet Beacon", PROTOSS_FLEET_BEACON);
        allUnitTypes.add(PROTOSS_FLEET_BEACON);
        UnitType.unitTypesById[169] = PROTOSS_FLEET_BEACON;
        unitTypesByName.put("Protoss Arbiter Tribunal", PROTOSS_ARBITER_TRIBUNAL);
        allUnitTypes.add(PROTOSS_ARBITER_TRIBUNAL);
        UnitType.unitTypesById[170] = PROTOSS_ARBITER_TRIBUNAL;
        unitTypesByName.put("Protoss Robotics Support Bay", PROTOSS_ROBOTICS_SUPPORT_BAY);
        allUnitTypes.add(PROTOSS_ROBOTICS_SUPPORT_BAY);
        UnitType.unitTypesById[171] = PROTOSS_ROBOTICS_SUPPORT_BAY;
        unitTypesByName.put("Protoss Shield Battery", PROTOSS_SHIELD_BATTERY);
        allUnitTypes.add(PROTOSS_SHIELD_BATTERY);
        UnitType.unitTypesById[172] = PROTOSS_SHIELD_BATTERY;
        unitTypesByName.put("Special Khaydarin Crystal Form", SPECIAL_KHAYDARIN_CRYSTAL_FORM);
        allUnitTypes.add(SPECIAL_KHAYDARIN_CRYSTAL_FORM);
        UnitType.unitTypesById[173] = SPECIAL_KHAYDARIN_CRYSTAL_FORM;
        unitTypesByName.put("Special Protoss Temple", SPECIAL_PROTOSS_TEMPLE);
        allUnitTypes.add(SPECIAL_PROTOSS_TEMPLE);
        UnitType.unitTypesById[174] = SPECIAL_PROTOSS_TEMPLE;
        unitTypesByName.put("Special XelNaga Temple", SPECIAL_XEL_NAGA_TEMPLE);
        allUnitTypes.add(SPECIAL_XEL_NAGA_TEMPLE);
        UnitType.unitTypesById[175] = SPECIAL_XEL_NAGA_TEMPLE;
        unitTypesByName.put("Resource Mineral Field", RESOURCE_MINERAL_FIELD);
        allUnitTypes.add(RESOURCE_MINERAL_FIELD);
        UnitType.unitTypesById[176] = RESOURCE_MINERAL_FIELD;
        unitTypesByName.put("Resource Vespene Geyser", RESOURCE_VESPENE_GEYSER);
        allUnitTypes.add(RESOURCE_VESPENE_GEYSER);
        UnitType.unitTypesById[188] = RESOURCE_VESPENE_GEYSER;
        unitTypesByName.put("Special Warp Gate", SPECIAL_WARP_GATE);
        allUnitTypes.add(SPECIAL_WARP_GATE);
        UnitType.unitTypesById[189] = SPECIAL_WARP_GATE;
        unitTypesByName.put("Special Psi Disrupter", SPECIAL_PSI_DISRUPTER);
        allUnitTypes.add(SPECIAL_PSI_DISRUPTER);
        UnitType.unitTypesById[190] = SPECIAL_PSI_DISRUPTER;
        unitTypesByName.put("Special Power Generator", SPECIAL_POWER_GENERATOR);
        allUnitTypes.add(SPECIAL_POWER_GENERATOR);
        UnitType.unitTypesById[200] = SPECIAL_POWER_GENERATOR;
        unitTypesByName.put("Special Overmind Cocoon", SPECIAL_OVERMIND_COCOON);
        allUnitTypes.add(SPECIAL_OVERMIND_COCOON);
        UnitType.unitTypesById[201] = SPECIAL_OVERMIND_COCOON;
        unitTypesByName.put("Spell Dark Swarm", SPELL_DARK_SWARM);
        allUnitTypes.add(SPELL_DARK_SWARM);
        UnitType.unitTypesById[202] = SPELL_DARK_SWARM;
        unitTypesByName.put("None", NONE);
        allUnitTypes.add(NONE);
        UnitType.unitTypesById[228] = NONE;
        unitTypesByName.put("Unknown", UNKNOWN);
        allUnitTypes.add(UNKNOWN);
        UnitType.unitTypesById[233] = UNKNOWN;
        gAllUnitTypes = Collections.unmodifiableSet(allUnitTypes);
    }

    public String toString() {
        return "UnitType [" + this.getName() + "]";
    }

    protected UnitType(int id) {
        this.id = id;
    }

    protected UnitType(GameMessages.UnitType type) {
        this.id = type.getId();
    }

    public final int getID() {
        return this.id;
    }

    private GameMessages.UnitTypeData getData() {
        return data.get(this.getID());
    }

    public String getName() {
        return this.getData().getName();
    }

    public String getSubLabel() {
        return this.getData().getSublabel();
    }

    public Race getRace() {
        this.getData();
        this.getData().getRace();
        this.getData().getRace().getNumber();
        return Race.getRaceFromId(this.getData().getRace().getNumber());
    }

    public Map.Entry<UnitType, Integer> whatBuilds() {
        final UnitType type = new UnitType(this.getData().getWhatBuildsType().getId());
        final int n = this.getData().getWhatBuildsNumber();
        return new Map.Entry<UnitType, Integer>(){

            @Override
            public UnitType getKey() {
                return type;
            }

            @Override
            public Integer getValue() {
                return n;
            }

            @Override
            public Integer setValue(Integer arg0) {
                throw new UnsupportedOperationException("Can't set this value.");
            }
        };
    }

    public Map<UnitType, Integer> requiredUnits() {
        HashMap<UnitType, Integer> ret = new HashMap<UnitType, Integer>();
        for (GameMessages.UnitTypeIntPair pair : this.getData().getRequiredUnitsList()) {
            UnitType type = new UnitType(pair.getType());
            int n = pair.getCount();
            ret.put(type, n);
        }
        return ret;
    }

    public TechType requiredTech() {
        return new TechType(this.getData().getRequiredTech());
    }

    public Set<TechType> abilities() {
        HashSet<TechType> techs = new HashSet<TechType>();
        for (GameMessages.TechType t : this.getData().getAbilitiesList()) {
            techs.add(new TechType(t));
        }
        return techs;
    }

    public Set<UpgradeType> upgrades() {
        HashSet<UpgradeType> techs = new HashSet<UpgradeType>();
        for (GameMessages.UpgradeType t : this.getData().getUpgradesList()) {
            techs.add(new UpgradeType(t));
        }
        return techs;
    }

    public UpgradeType armorUpgrade() {
        return new UpgradeType(this.getData().getArmorUpgrade());
    }

    public int maxHitPoints() {
        return this.getData().getMaxHitPoints();
    }

    public int maxShields() {
        return this.getData().getMaxShields();
    }

    public int maxEnergy() {
        return this.getData().getMaxEnergy();
    }

    public int armor() {
        return this.getData().getArmor();
    }

    public int mineralPrice() {
        return this.getData().getMineralPrice();
    }

    public int gasPrice() {
        return this.getData().getGasPrice();
    }

    public int buildTime() {
        return this.getData().getBuildTime();
    }

    public int supplyRequired() {
        return this.getData().getSupplyRequired();
    }

    public int supplyProvided() {
        return this.getData().getSupplyProvided();
    }

    public int spaceRequired() {
        return this.getData().getSpaceRequired();
    }

    public int spaceProvided() {
        return this.getData().getSpaceProvided();
    }

    public int buildScore() {
        return this.getData().getBuildScore();
    }

    public int destroyScore() {
        return this.getData().getDestroyScore();
    }

    public UnitSizeType size() {
        return UnitSizeType.values()[this.getData().getSize().getNumber()];
    }

    public int tileWidth() {
        return this.getData().getTileWidth();
    }

    public int tileHeight() {
        return this.getData().getTileHeight();
    }

    public int dimensionLeft() {
        return this.getData().getDimensionLeft();
    }

    public int dimensionUp() {
        return this.getData().getDimensionUp();
    }

    public int dimensionRight() {
        return this.getData().getDimensionRight();
    }

    public int dimensionDown() {
        return this.getData().getDimensionDown();
    }

    public int seekRange() {
        return this.getData().getSeekRange();
    }

    public int sightRange() {
        return this.getData().getSightRange();
    }

    public WeaponType groundWeapon() {
        return new WeaponType(this.getData().getGroundWeapon());
    }

    public int maxGroundHits() {
        return this.getData().getMaxGroundHits();
    }

    public WeaponType airWeapon() {
        return new WeaponType(this.getData().getAirWeapon());
    }

    public int maxAirHits() {
        return this.getData().getMaxAirHits();
    }

    public double topSpeed() {
        return this.getData().getTopSpeed();
    }

    public int acceleration() {
        return this.getData().getAcceleration();
    }

    public int haltDistance() {
        return this.getData().getHaltDistance();
    }

    public int turnRadius() {
        return this.getData().getTurnRadius();
    }

    public boolean canProduce() {
        return this.getData().getCanProduce();
    }

    public boolean canAttack() {
        return this.getData().getCanAttack();
    }

    public boolean canMove() {
        return this.getData().getCanMove();
    }

    public boolean isFlyer() {
        return this.getData().getIsFlyer();
    }

    public boolean regeneratesHP() {
        return this.getData().getRegeneratesHP();
    }

    public boolean isSpellcaster() {
        return this.getData().getIsSpellcaster();
    }

    public boolean hasPermanentCloak() {
        return this.getData().getHasPermanentCloak();
    }

    public boolean isInvincible() {
        return this.getData().getIsInvincible();
    }

    public boolean isOrganic() {
        return this.getData().getIsOrganic();
    }

    public boolean isMechanical() {
        return this.getData().getIsMechanical();
    }

    public boolean isRobotic() {
        return this.getData().getIsRobotic();
    }

    public boolean isDetector() {
        return this.getData().getIsDetector();
    }

    public boolean isResourceContainer() {
        return this.getData().getIsResourceContainer();
    }

    public boolean isResourceDepot() {
        return this.getData().getIsResourceDepot();
    }

    public boolean isRefinery() {
        return this.getData().getIsRefinery();
    }

    public boolean isWorker() {
        return this.getData().getIsWorker();
    }

    public boolean requiresPsi() {
        return this.getData().getRequiresPsi();
    }

    public boolean requiresCreep() {
        return this.getData().getRequiresCreep();
    }

    public boolean isTwoUnitsInOneEgg() {
        return this.getData().getIsTwoUnitsInOneEgg();
    }

    public boolean isBurrowable() {
        return this.getData().getIsBurrowable();
    }

    public boolean isCloakable() {
        return this.getData().getIsCloakable();
    }

    public boolean isBuilding() {
        return this.getData().getIsBuilding();
    }

    public boolean isAddon() {
        return this.getData().getIsAddon();
    }

    public boolean isFlyingBuilding() {
        return this.getData().getIsFlyingBuilding();
    }

    public boolean isNeutral() {
        return this.getData().getIsNeutral();
    }

    public boolean hasAirAreaOfEffectAttack() {
        return this.equals(PROTOSS_HIGH_TEMPLAR) || this.equals(PROTOSS_CORSAIR) || this.equals(PROTOSS_ARCHON) || this.equals(PROTOSS_DARK_ARCHON) || this.equals(ZERG_DEFILER) || this.equals(ZERG_QUEEN) || this.equals(TERRAN_SCIENCE_VESSEL) || this.equals(TERRAN_VALKYRIE);
    }

    public boolean hasGroundAreaOfEffectAttack() {
        return this.equals(PROTOSS_HIGH_TEMPLAR) || this.equals(PROTOSS_REAVER) || this.equals(PROTOSS_ARCHON) || this.equals(PROTOSS_DARK_ARCHON) || this.equals(ZERG_DEFILER) || this.equals(ZERG_QUEEN) || this.equals(ZERG_LURKER) || this.equals(ZERG_INFESTED_TERRAN) || this.equals(TERRAN_SCIENCE_VESSEL) || this.equals(TERRAN_SIEGE_TANK_SIEGE_MODE);
    }

    public double diagonalLength() {
        double halfWidth = Math.max(this.dimensionLeft(), this.dimensionRight());
        double halfHeight = Math.max(this.dimensionUp(), this.dimensionDown());
        return Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
    }

    WeaponType pickWeapon(boolean vsAir) {
        return vsAir ? this.airWeapon() : this.groundWeapon();
    }

    public static UnitType myWorkerType() {
        return Game.getInstance().self().getRace().getWorker();
    }

    static void setUnitTypes(List<GameMessages.UnitTypeData> _data) {
        data = new ArrayList<GameMessages.UnitTypeData>(_data);
    }

    public static final UnitType getUnitType(String name) {
        return unitTypesByName.get(name);
    }

    public static final Set<UnitType> allUnitTypes() {
        return gAllUnitTypes;
    }

    static final UnitType getUnitTypeFromId(int id) {
        return unitTypesById[id];
    }

    static final int getMaxIdPlusOne() {
        return unitTypesById.length;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this instanceof UnitType) {
            UnitType other = (UnitType)object;
            return this.id == other.id;
        }
        return false;
    }

    public final int hashCode() {
        return this.id;
    }

    GameMessages.UnitType getTypeMessage() {
        return GameMessages.UnitType.newBuilder().setId(this.id).build();
    }

    public boolean isProducedFromMorphOrder() {
        return this.getRace().getID() == Race.ZERG.getID() && (!this.isBuilding() || this.equals(ZERG_GREATER_SPIRE) || this.equals(ZERG_LAIR) || this.equals(ZERG_HIVE)) && this.getID() != ZERG_LARVA.getID() && this.getID() != ZERG_EGG.getID() && this.getID() != ZERG_LURKER_EGG.getID() && this.getID() != ZERG_COCOON.getID() && this.getID() != ZERG_EXTRACTOR.getID() && this.getID() != ZERG_INFESTED_COMMAND_CENTER.getID() && this.getID() != ZERG_INFESTED_TERRAN.getID() && this.getID() != ZERG_BROODLING.getID();
    }

    public boolean canHaveAddon() {
        return this.getID() == TERRAN_COMMAND_CENTER.getID() || this.getID() == TERRAN_FACTORY.getID() || this.getID() == TERRAN_STARPORT.getID() || this.getID() == TERRAN_SCIENCE_FACILITY.getID();
    }
}

