/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum UnitSizeType {
    INDEPENDENT(0, "Independent"),
    SMALL(1, "Small"),
    MEDIUM(2, "Medium"),
    LARGE(3, "Large"),
    NONE(4, "None"),
    UNKNOWN(5, "Unknown");

    private int id;
    private String name;
    protected static final Map<String, UnitSizeType> gNamesToUnitSizeTypes;
    protected static final Set<UnitSizeType> gAllUnitSizeTypes;
    protected static final UnitSizeType[] gIdsToUnitSizeTypes;

    static {
        gNamesToUnitSizeTypes = new HashMap<String, UnitSizeType>();
        HashSet<UnitSizeType> allUnitSizeTypes = new HashSet<UnitSizeType>();
        gIdsToUnitSizeTypes = new UnitSizeType[6];
        gNamesToUnitSizeTypes.put("Independent", INDEPENDENT);
        allUnitSizeTypes.add(INDEPENDENT);
        UnitSizeType.gIdsToUnitSizeTypes[0] = INDEPENDENT;
        gNamesToUnitSizeTypes.put("Small", SMALL);
        allUnitSizeTypes.add(SMALL);
        UnitSizeType.gIdsToUnitSizeTypes[1] = SMALL;
        gNamesToUnitSizeTypes.put("Medium", MEDIUM);
        allUnitSizeTypes.add(MEDIUM);
        UnitSizeType.gIdsToUnitSizeTypes[2] = MEDIUM;
        gNamesToUnitSizeTypes.put("Large", LARGE);
        allUnitSizeTypes.add(LARGE);
        UnitSizeType.gIdsToUnitSizeTypes[3] = LARGE;
        gNamesToUnitSizeTypes.put("None", NONE);
        allUnitSizeTypes.add(NONE);
        UnitSizeType.gIdsToUnitSizeTypes[4] = NONE;
        gNamesToUnitSizeTypes.put("Unknown", UNKNOWN);
        allUnitSizeTypes.add(UNKNOWN);
        UnitSizeType.gIdsToUnitSizeTypes[5] = UNKNOWN;
        gAllUnitSizeTypes = Collections.unmodifiableSet(allUnitSizeTypes);
    }

    private UnitSizeType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public final int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static final UnitSizeType getUnitSizeType(String name) {
        return gNamesToUnitSizeTypes.get(name);
    }

    public static final Set<UnitSizeType> allUnitSizeTypes() {
        return gAllUnitSizeTypes;
    }

    static final UnitSizeType getUnitSizeTypeFromId(int id) {
        return gIdsToUnitSizeTypes[id];
    }

    static final int getMaxIdPlusOne() {
        return gIdsToUnitSizeTypes.length;
    }
}

