/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Unit;

class UnitManager {
    private Map<Integer, GameMessages.Unit> unitMessages = new HashMap<Integer, GameMessages.Unit>();
    private Map<Integer, GameMessages.Unit> initialUnitMessages = new HashMap<Integer, GameMessages.Unit>();
    private Map<Integer, GameMessages.Unit> previousUnitMessages = new HashMap<Integer, GameMessages.Unit>();
    private Set<Unit> allUnits = new HashSet<Unit>();

    UnitManager() {
    }

    protected void setUnitMessage(int id, GameMessages.Unit message) {
        if (!this.initialUnitMessages.containsKey(id)) {
            this.initialUnitMessages.put(id, message);
        }
        if (this.unitMessages.containsKey(id)) {
            this.previousUnitMessages.put(id, this.unitMessages.get(id));
        }
        this.unitMessages.put(id, message);
    }

    protected void clearUnits() {
        this.allUnits.clear();
    }

    protected void addUnit(Unit u) {
        this.allUnits.add(u);
    }

    public GameMessages.Unit getMessage(int id) {
        return this.unitMessages.get(id);
    }

    public GameMessages.Unit getInitialMessage(int id) {
        return this.initialUnitMessages.get(id);
    }

    public GameMessages.Unit getPreviousMessage(int id) {
        return this.previousUnitMessages.get(id);
    }

    public Set<? extends ROUnit> getAllUnits() {
        return new HashSet<Unit>(this.allUnits);
    }
}

