/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bwapi.proxy.messages.Commands;
import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.model.CommandValidator;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Order;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.model.UpgradeType;
import org.bwapi.proxy.model.WeaponType;

public class Unit
implements ROUnit {
    private final Game g = Game.getInstance();
    private final int id;
    private final CommandValidator validator;
    private final GameMessages.Unit fixedMessage;

    public Unit(int id) {
        this.id = id;
        this.validator = this.g.getInvalidator();
        this.fixedMessage = null;
    }

    public Unit(int id, CommandValidator validator) {
        this.id = id;
        this.validator = validator;
        this.fixedMessage = null;
    }

    private Unit(int id, GameMessages.Unit fixedMessage) {
        this.id = id;
        this.validator = this.g.getInvalidator();
        this.fixedMessage = fixedMessage;
    }

    public Unit commandableUnit(CommandValidator validator) {
        return new Unit(this.id, validator);
    }

    private GameMessages.Unit getMessage() {
        if (this.fixedMessage != null) {
            return this.fixedMessage;
        }
        return this.g.unitManager.getMessage(this.id);
    }

    private GameMessages.Unit getInitialMessage() {
        return this.g.unitManager.getInitialMessage(this.id);
    }

    private GameMessages.Unit getPreviousMessage() {
        if (this.fixedMessage != null) {
            return null;
        }
        return this.g.unitManager.getPreviousMessage(this.id);
    }

    @Override
    public GameMessages.UnitId toMessage() {
        GameMessages.UnitId.Builder b = GameMessages.UnitId.newBuilder();
        b.setId(this.id);
        return b.build();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ROUnit)) {
            return false;
        }
        ROUnit u = (ROUnit)obj;
        return this.id == u.getID();
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "Unit [" + this.getType().getName() + " " + this.id + "]";
    }

    @Override
    public ROUnit getPreviousUnitData() {
        if (this.getPreviousMessage() == null) {
            return null;
        }
        return new Unit(this.id, this.getPreviousMessage());
    }

    private List<UnitType> buildUnitTypeList(List<GameMessages.UnitType> list) {
        ArrayList<UnitType> newList = new ArrayList<UnitType>(list.size());
        for (GameMessages.UnitType t : list) {
            newList.add(UnitType.getUnitTypeFromId(t.getId()));
        }
        return newList;
    }

    private Set<? extends ROUnit> buildUnitSet(List<GameMessages.UnitId> list) {
        HashSet<Unit> set = new HashSet<Unit>();
        for (GameMessages.UnitId u : list) {
            set.add(new Unit(u.getId()));
        }
        return set;
    }

    @Override
    public int getID() {
        return this.id;
    }

    public void attackMove(Position position) {
        if (!this.validator.canAttackMove(this, position)) {
            throw new RuntimeException("Invalid attackMove command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.attackMove);
        b.setPos(position.getMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void attack(ROUnit nearest) {
        this.attackUnit(nearest);
    }

    public void attackUnit(ROUnit nearest) {
        if (!this.validator.canAttackUnit(this, nearest)) {
            throw new RuntimeException("Invalid attackUnit command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.attackUnit);
        b.setTarget(nearest.toMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void build(TilePosition position, UnitType type) {
        if (!this.validator.canBuild(this, position, type)) {
            throw new RuntimeException("Invalid build command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.build);
        b.setTilePos(position.getMessage());
        b.setUnitType(type.getTypeMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void buildAddon(UnitType type) {
        if (!this.validator.canBuildAddon(this, type)) {
            throw new RuntimeException("Invalid buildAddon command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.buildAddon);
        b.setUnitType(type.getTypeMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void burrow() {
        if (!this.validator.canBurrow(this)) {
            throw new RuntimeException("Invalid burrow command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.burrow);
        this.g.commandManager.addCommand(b.build());
    }

    public void cancelAddon() {
        if (!this.validator.canCancelAddon(this)) {
            throw new RuntimeException("Invalid cancelAddon command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.cancelAddon);
        this.g.commandManager.addCommand(b.build());
    }

    public void cancelConstruction() {
        if (!this.validator.canCancelConstruction(this)) {
            throw new RuntimeException("Invalid cancelConstruction command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.cancelConstruction);
        this.g.commandManager.addCommand(b.build());
    }

    public void cancelMorph() {
        if (!this.validator.canCancelMorph(this)) {
            throw new RuntimeException("Invalid cancelMorph command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.cancelMorph);
        this.g.commandManager.addCommand(b.build());
    }

    public void cancelResearch() {
        if (!this.validator.canCancelResearch(this)) {
            throw new RuntimeException("Invalid cancelResearch command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.cancelResearch);
        this.g.commandManager.addCommand(b.build());
    }

    public void cancelTrain() {
        if (!this.validator.canCancelTrain(this)) {
            throw new RuntimeException("Invalid cancelTrain command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.cancelTrain);
        this.g.commandManager.addCommand(b.build());
    }

    public void cancelTrain(int slot) {
        if (!this.validator.canCancelTrain(this, slot)) {
            throw new RuntimeException("Invalid cancelTrain command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.cancelTrainSlot);
        b.setSlot(slot);
        this.g.commandManager.addCommand(b.build());
    }

    public void cancelUpgrade() {
        if (!this.validator.canCancelUpgrade(this)) {
            throw new RuntimeException("Invalid cancelUpgrade command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.cancelUpgrade);
        this.g.commandManager.addCommand(b.build());
    }

    public void cloak() {
        if (!this.validator.canCloak(this)) {
            throw new RuntimeException("Invalid cloak command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.cloak);
        this.g.commandManager.addCommand(b.build());
    }

    public void decloak() {
        if (!this.validator.canDecloak(this)) {
            throw new RuntimeException("Invalid decloak command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.decloak);
        this.g.commandManager.addCommand(b.build());
    }

    public void follow(ROUnit target) {
        if (!this.validator.canFollow(this, target)) {
            throw new RuntimeException("Invalid follow command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.follow);
        b.setTarget(target.toMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void haltConstruction() {
        if (!this.validator.canHaltConstruction(this)) {
            throw new RuntimeException("Invalid haltConstruction command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.haltConstruction);
        this.g.commandManager.addCommand(b.build());
    }

    public void holdPosition() {
        if (!this.validator.canHoldPosition(this)) {
            throw new RuntimeException("Invalid holdPosition command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.holdPosition);
        this.g.commandManager.addCommand(b.build());
    }

    public void land(TilePosition position) {
        if (!this.validator.canLand(this, position)) {
            throw new RuntimeException("Invalid land command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.land);
        b.setTilePos(position.getMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void lift() {
        if (!this.validator.canLift(this)) {
            throw new RuntimeException("Invalid lift command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.lift);
        this.g.commandManager.addCommand(b.build());
    }

    public void load(ROUnit target) {
        if (!this.validator.canLoad(this, target)) {
            throw new RuntimeException("Invalid load command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.load);
        b.setTarget(target.toMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void morph(UnitType type) {
        if (!this.validator.canMorph(this, type)) {
            throw new RuntimeException("Invalid morph command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.morph);
        b.setUnitType(type.getTypeMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void patrol(Position position) {
        if (!this.validator.canPatrol(this, position)) {
            throw new RuntimeException("Invalid patrol command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.patrol);
        b.setPos(position.getMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void repair(ROUnit target) {
        if (!this.validator.canRepair(this, target)) {
            throw new RuntimeException("Invalid repair command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.repair);
        b.setTarget(target.toMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void research(TechType tech) {
        if (!this.validator.canResearch(this, tech)) {
            throw new RuntimeException("Invalid research command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.research);
        b.setTechType(tech.getTypeMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void rightClick(Position position) {
        if (!this.validator.canRightClick((ROUnit)this, position)) {
            throw new RuntimeException("Invalid rightClick command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.rightClick);
        b.setPos(position.getMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void rightClick(TilePosition position) {
        this.rightClick(new Position(position));
    }

    public void move(TilePosition position) {
        this.move(new Position(position));
    }

    public void move(Position position) {
        this.rightClick(position);
    }

    public void rightClick(ROUnit target) {
        if (!this.validator.canRightClick((ROUnit)this, target)) {
            throw new RuntimeException("Invalid rightClick command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.rightClickUnit);
        b.setTarget(target.toMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void setRallyPosition(Position target) {
        if (!this.validator.canSetRallyPosition(this, target)) {
            throw new RuntimeException("Invalid setRallyPosition command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.setRallyPosition);
        b.setPos(target.getMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void setRallyUnit(ROUnit target) {
        if (!this.validator.canSetRallyUnit(this, target)) {
            throw new RuntimeException("Invalid setRallyUnit command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.setRallyUnit);
        b.setTarget(target.toMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void siege() {
        if (!this.validator.canSiege(this)) {
            throw new RuntimeException("Invalid siege command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.siege);
        this.g.commandManager.addCommand(b.build());
    }

    public void stop() {
        if (!this.validator.canStop(this)) {
            throw new RuntimeException("Invalid stop command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.stop);
        this.g.commandManager.addCommand(b.build());
    }

    public void train(UnitType type) {
        if (!this.validator.canTrain(this, type)) {
            throw new RuntimeException("Invalid train command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.train);
        b.setUnitType(type.getTypeMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void unburrow() {
        if (!this.validator.canUnburrow(this)) {
            throw new RuntimeException("Invalid unburrow command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.unburrow);
        this.g.commandManager.addCommand(b.build());
    }

    public void unload(ROUnit target) {
        if (!this.validator.canUnload(this, target)) {
            throw new RuntimeException("Invalid unload command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.unload);
        b.setTarget(target.toMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void unloadAll() {
        if (!this.validator.canUnloadAll(this)) {
            throw new RuntimeException("Invalid unloadAll command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.unloadAll);
        this.g.commandManager.addCommand(b.build());
    }

    public void unloadAll(Position position) {
        if (!this.validator.canUnloadAll(this, position)) {
            throw new RuntimeException("Invalid unloadAll command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.unloadAllPosition);
        b.setPos(position.getMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void unsiege() {
        if (!this.validator.canUnsiege(this)) {
            throw new RuntimeException("Invalid unsiege command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.unsiege);
        this.g.commandManager.addCommand(b.build());
    }

    public void upgrade(UpgradeType upgrade) {
        if (!this.validator.canUpgrade(this, upgrade)) {
            throw new RuntimeException("Invalid upgrade command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.upgrade);
        b.setUpgradeType(upgrade.getTypeMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void useTech(TechType tech) {
        if (!this.validator.canUseTech(this, tech)) {
            throw new RuntimeException("Invalid useTech command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.useTech);
        b.setTechType(tech.getTypeMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void useTech(TechType tech, Position position) {
        if (!this.validator.canUseTech((ROUnit)this, tech, position)) {
            throw new RuntimeException("Invalid useTech command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.useTechPosition);
        b.setTechType(tech.getTypeMessage());
        b.setPos(position.getMessage());
        this.g.commandManager.addCommand(b.build());
    }

    public void useTech(TechType tech, ROUnit target) {
        if (!this.validator.canUseTech((ROUnit)this, tech, target)) {
            throw new RuntimeException("Invalid useTech command on " + this);
        }
        Commands.Command.Builder b = Commands.Command.newBuilder();
        b.setSelf(this.toMessage());
        b.setType(Commands.CommandType.useTechTarget);
        b.setTechType(tech.getTypeMessage());
        b.setTarget(target.toMessage());
        this.g.commandManager.addCommand(b.build());
    }

    @Override
    public boolean exists() {
        return this.getMessage() == null ? false : this.getMessage().getExists();
    }

    @Override
    public ROUnit getAddon() {
        return this.getMessage() == null ? null : (this.getMessage().hasAddon() ? new Unit(this.getMessage().getAddon().getId()) : null);
    }

    @Override
    public int getAirWeaponCooldown() {
        return this.getMessage() == null ? 0 : this.getMessage().getAirWeaponCooldown();
    }

    @Override
    public int getArmor() {
        return this.getMessage() == null ? 0 : this.getType().armor() + this.getPlayer().getUpgradeLevel(this.getType().armorUpgrade());
    }

    @Override
    public double getAngle() {
        return this.getMessage() == null ? 0.0 : this.getMessage().getAngle();
    }

    @Override
    public ROUnit getBuildUnit() {
        return this.getMessage() != null && this.getMessage().hasBuildUnit() ? new Unit(this.getMessage().getBuildUnit().getId()) : null;
    }

    @Override
    public ROUnit getCarrier() {
        return this.getMessage() != null && this.getMessage().hasCarrier() ? new Unit(this.getMessage().getCarrier().getId()) : null;
    }

    @Override
    public int getDefenseMatrixPoints() {
        return this.getMessage() == null ? 0 : this.getMessage().getDefenseMatrixPoints();
    }

    @Override
    public int getDefenseMatrixTimer() {
        return this.getMessage() == null ? 0 : this.getMessage().getDefenseMatrixTimer();
    }

    @Override
    public double getDistance(Position target) {
        if (this.getLastKnownPosition().equals(Position.INVALID)) {
            return 0.0;
        }
        return this.getLastKnownPosition().getDistance(target);
    }

    @Override
    public double getCenterDistance(ROUnit target) {
        if (this.getLastKnownPosition().equals(Position.INVALID)) {
            return 0.0;
        }
        return this.getLastKnownPosition().getDistance(target.getLastKnownPosition());
    }

    @Override
    public int getDistance(ROUnit target) {
        double result;
        if (target == this) {
            return 0;
        }
        Position thisPos = this.getLastKnownPosition();
        Position targetPos = target.getLastKnownPosition();
        if (thisPos.y() - this.getType().dimensionUp() <= targetPos.y() + target.getType().dimensionDown() && thisPos.y() + this.getType().dimensionDown() >= targetPos.y() - target.getType().dimensionUp()) {
            result = thisPos.x() > targetPos.x() ? (double)(thisPos.x() - this.getType().dimensionLeft() - targetPos.x() - target.getType().dimensionRight()) : (double)(targetPos.x() - target.getType().dimensionRight() - thisPos.x() - this.getType().dimensionLeft());
        }
        if (thisPos.x() - this.getType().dimensionLeft() <= targetPos.x() + target.getType().dimensionRight() && thisPos.x() + this.getType().dimensionRight() >= targetPos.x() - target.getType().dimensionLeft()) {
            result = thisPos.y() > targetPos.y() ? (double)(thisPos.y() - this.getType().dimensionUp() - targetPos.y() - target.getType().dimensionDown()) : (double)(targetPos.y() - target.getType().dimensionDown() - thisPos.y() - this.getType().dimensionUp());
        }
        result = thisPos.x() > targetPos.x() ? (thisPos.y() > targetPos.y() ? new Position(thisPos.x() - this.getType().dimensionLeft(), thisPos.y() - this.getType().dimensionUp()).getDistance(new Position(targetPos.x() + target.getType().dimensionRight(), targetPos.y() + target.getType().dimensionDown())) : new Position(thisPos.x() - this.getType().dimensionLeft(), thisPos.y() + this.getType().dimensionDown()).getDistance(new Position(targetPos.x() + target.getType().dimensionRight(), targetPos.y() - target.getType().dimensionUp()))) : (thisPos.y() > targetPos.y() ? new Position(thisPos.x() + this.getType().dimensionRight(), thisPos.y() - this.getType().dimensionUp()).getDistance(new Position(targetPos.x() - target.getType().dimensionLeft(), targetPos.y() + target.getType().dimensionDown())) : new Position(thisPos.x() + this.getType().dimensionRight(), thisPos.y() + this.getType().dimensionDown()).getDistance(new Position(targetPos.x() - target.getType().dimensionLeft(), targetPos.y() - target.getType().dimensionUp())));
        if (result > 0.0) {
            return (int)result;
        }
        return 0;
    }

    @Override
    public int getEnergy() {
        return this.getMessage() == null ? 0 : this.getMessage().getEnergy();
    }

    @Override
    public int getEnsnareTimer() {
        return this.getMessage() == null ? 0 : this.getMessage().getEnsnareTimer();
    }

    @Override
    public int getGroundWeaponCooldown() {
        return this.getMessage() == null ? 0 : this.getMessage().getGroundWeaponCooldown();
    }

    @Override
    public int getHitPoints() {
        return this.getMessage() == null ? 0 : this.getMessage().getHitPoints();
    }

    @Override
    public int getInitialHitPoints() {
        return this.getInitialMessage() == null ? 0 : this.getInitialMessage().getInitialHitPoints();
    }

    @Override
    public Position getInitialPosition() {
        if (this.getInitialMessage() == null) {
            return Position.INVALID;
        }
        return new Position(this.getInitialMessage().getInitialPosition());
    }

    @Override
    public int getInitialResources() {
        return this.getInitialMessage() == null ? 0 : this.getInitialMessage().getInitialResources();
    }

    @Override
    public TilePosition getInitialTilePosition() {
        if (this.getInitialMessage() == null) {
            return TilePosition.INVALID;
        }
        return new TilePosition(this.getInitialMessage().getInitialTilePosition());
    }

    @Override
    public UnitType getInitialType() {
        if (this.getInitialMessage() == null) {
            return UnitType.UNKNOWN;
        }
        return UnitType.getUnitTypeFromId(this.getInitialMessage().getInitialType().getId());
    }

    @Override
    public int getInterceptorCount() {
        return this.getMessage() == null ? 0 : this.getMessage().getInterceptorCount();
    }

    @Override
    public Set<? extends ROUnit> getInterceptors() {
        if (this.getMessage() == null) {
            return new HashSet();
        }
        return this.buildUnitSet(this.getMessage().getInterceptorsList());
    }

    @Override
    public int getIrradiateTimer() {
        return this.getMessage() == null ? 0 : this.getMessage().getIrradiateTimer();
    }

    @Override
    public int getKillCount() {
        return this.getMessage() == null ? 0 : this.getMessage().getKillCount();
    }

    @Override
    public Set<? extends ROUnit> getLoadedUnits() {
        if (this.getMessage() == null) {
            return new HashSet();
        }
        return this.buildUnitSet(this.getMessage().getLoadedUnitsList());
    }

    @Override
    public int getLockdownTimer() {
        return this.getMessage() == null ? 0 : this.getMessage().getLockdownTimer();
    }

    @Override
    public int getMaelstromTimer() {
        return this.getMessage() == null ? 0 : this.getMessage().getMaelstromTimer();
    }

    @Override
    public ROUnit getNydusExit() {
        return this.getMessage() != null && this.getMessage().hasNydusExit() ? new Unit(this.getMessage().getNydusExit().getId()) : null;
    }

    @Override
    public Order getOrder() {
        return this.getMessage() == null ? Order.UNKNOWN : Order.getOrderFromId(this.getMessage().getOrder());
    }

    @Override
    public Unit getOrderTarget() {
        return this.getMessage() == null ? null : (this.getMessage().hasOrderTarget() ? new Unit(this.getMessage().getOrderTarget().getId()) : null);
    }

    @Override
    public int getOrderTimer() {
        return this.getMessage() == null ? 0 : this.getMessage().getOrderTimer();
    }

    @Override
    public int getPlagueTimer() {
        return this.getMessage() == null ? 0 : this.getMessage().getPlagueTimer();
    }

    @Override
    public Player getPlayer() {
        return this.getMessage() != null ? this.g.playerManager.getPlayer(this.getMessage().getPlayer()) : (this.getPreviousMessage() == null ? null : this.g.playerManager.getPlayer(this.getPreviousMessage().getPlayer()));
    }

    @Override
    public Position getPosition() {
        if (this.getMessage() == null) {
            return Position.INVALID;
        }
        return new Position(this.getMessage().getPosition());
    }

    @Override
    public Position getRallyPosition() {
        if (this.getMessage() == null) {
            return Position.INVALID;
        }
        return new Position(this.getMessage().getRallyPosition());
    }

    @Override
    public Unit getRallyUnit() {
        if (this.getMessage() == null) {
            return null;
        }
        return this.getMessage().hasRallyUnit() ? new Unit(this.getMessage().getRallyUnit().getId()) : null;
    }

    @Override
    public int getRemainingBuildTime() {
        return this.getMessage() == null ? 0 : this.getMessage().getRemainingBuildTime();
    }

    @Override
    public int getRemainingResearchTime() {
        return this.getMessage() == null ? 0 : this.getMessage().getRemainingResearchTime();
    }

    @Override
    public int getRemainingTrainTime() {
        return this.getMessage() == null ? 0 : this.getMessage().getRemainingTrainTime();
    }

    @Override
    public int getRemainingUpgradeTime() {
        return this.getMessage() == null ? 0 : this.getMessage().getRemainingUpgradeTime();
    }

    @Override
    public int getRemoveTimer() {
        return this.getMessage() == null ? 0 : this.getMessage().getRemoveTimer();
    }

    @Override
    public int getResources() {
        return this.getMessage() == null ? 0 : this.getMessage().getResources();
    }

    @Override
    public int getScarabCount() {
        return this.getMessage() == null ? 0 : this.getMessage().getScarabCount();
    }

    @Override
    public Order getSecondaryOrder() {
        return this.getMessage() == null ? Order.UNKNOWN : Order.getOrderFromId(this.getMessage().getSecondaryOrder());
    }

    @Override
    public int getShields() {
        return this.getMessage() == null ? 0 : this.getMessage().getShields();
    }

    @Override
    public int getSpellCooldown() {
        return this.getMessage() == null ? 0 : this.getMessage().getSpellCooldown();
    }

    @Override
    public int getSpiderMineCount() {
        return this.getMessage() == null ? 0 : this.getMessage().getSpiderMineCount();
    }

    @Override
    public int getStasisTimer() {
        return this.getMessage() == null ? 0 : this.getMessage().getStasisTimer();
    }

    @Override
    public int getStimTimer() {
        return this.getMessage() == null ? 0 : this.getMessage().getStimTimer();
    }

    @Override
    public Unit getTarget() {
        return this.getMessage() == null ? null : (this.getMessage().hasTarget() ? new Unit(this.getMessage().getTarget().getId()) : null);
    }

    @Override
    public Position getTargetPosition() {
        if (this.getMessage() == null) {
            return Position.INVALID;
        }
        return new Position(this.getMessage().getTargetPosition());
    }

    @Override
    public TechType getTech() {
        return this.getMessage() == null ? TechType.UNKNOWN : TechType.getTechTypeFromId(this.getMessage().getTech());
    }

    @Override
    public TilePosition getTilePosition() {
        if (this.getMessage() == null) {
            return TilePosition.INVALID;
        }
        return new TilePosition(this.getMessage().getTilePosition());
    }

    @Override
    public List<UnitType> getTrainingQueue() {
        if (this.getMessage() == null) {
            return new ArrayList<UnitType>();
        }
        return this.buildUnitTypeList(this.getMessage().getTrainingQueueList());
    }

    @Override
    public Unit getTransport() {
        return this.getMessage() == null ? null : (this.getMessage().hasTransport() ? new Unit(this.getMessage().getTransport().getId()) : null);
    }

    @Override
    public UnitType getType() {
        return this.getMessage() == null ? (this.getPreviousMessage() == null ? UnitType.UNKNOWN : UnitType.getUnitTypeFromId(this.getPreviousMessage().getType().getId())) : UnitType.getUnitTypeFromId(this.getMessage().getType().getId());
    }

    public UnitType getBuildType() {
        return this.getMessage() == null ? (this.getPreviousMessage() == null || !this.getPreviousMessage().hasBuildType() ? UnitType.UNKNOWN : UnitType.getUnitTypeFromId(this.getPreviousMessage().getBuildType().getId())) : (this.getMessage().hasBuildType() ? UnitType.getUnitTypeFromId(this.getMessage().getType().getId()) : UnitType.UNKNOWN);
    }

    @Override
    public UpgradeType getUpgrade() {
        return this.getMessage() == null ? UpgradeType.UNKNOWN : UpgradeType.getUpgradeTypeFromId(this.getMessage().getUpgrade());
    }

    @Override
    public int getUpgradeLevel(UpgradeType upgrade) {
        return this.getMessage() == null ? 0 : this.getPlayer().getUpgradeLevel(upgrade);
    }

    @Override
    public double getVelocityX() {
        return this.getMessage() == null ? 0.0 : this.getMessage().getVelocityX();
    }

    @Override
    public double getVelocityY() {
        return this.getMessage() == null ? 0.0 : this.getMessage().getVelocityY();
    }

    @Override
    public boolean isAccelerating() {
        return this.getMessage() == null ? false : this.getMessage().getAccelerating();
    }

    @Override
    public boolean isAttacking() {
        return this.getMessage() == null ? false : this.getMessage().getAttacking();
    }

    public boolean isAttackFrame() {
        return this.getMessage() == null ? false : this.getMessage().getAttacking();
    }

    @Override
    public boolean isBeingConstructed() {
        return this.getMessage() == null ? false : this.getMessage().getBeingConstructed();
    }

    @Override
    public boolean isBeingGathered() {
        return this.getMessage() == null ? false : this.getMessage().getBeingGathered();
    }

    @Override
    public boolean isBeingHealed() {
        return this.getMessage() == null ? false : this.getMessage().getBeingHealed();
    }

    @Override
    public boolean isBlind() {
        return this.getMessage() == null ? false : this.getMessage().getBlind();
    }

    @Override
    public boolean isBraking() {
        return this.getMessage() == null ? false : this.getMessage().getBraking();
    }

    @Override
    public boolean isBurrowed() {
        return this.getMessage() == null ? false : this.getMessage().getBurrowed();
    }

    @Override
    public boolean isCarryingGas() {
        return this.getMessage() == null ? false : this.getMessage().getCarryingGas();
    }

    @Override
    public boolean isCarryingMinerals() {
        return this.getMessage() == null ? false : this.getMessage().getCarryingMinerals();
    }

    @Override
    public boolean isCloaked() {
        return this.getMessage() == null ? false : this.getMessage().getCloaked();
    }

    @Override
    public boolean isCompleted() {
        return this.getMessage() == null ? false : this.getMessage().getCompleted();
    }

    @Override
    public boolean isConstructing() {
        return this.getMessage() == null ? false : this.getMessage().getConstructing();
    }

    @Override
    public boolean isDetected() {
        return this.getMessage() == null ? false : this.getMessage().getDetected();
    }

    @Override
    public boolean isDefenseMatrixed() {
        return this.getMessage() == null ? false : this.getMessage().getDefenseMatrixed();
    }

    @Override
    public boolean isEnsnared() {
        return this.getMessage() == null ? false : this.getMessage().getEnsnared();
    }

    @Override
    public boolean isFollowing() {
        return this.getMessage() == null ? false : this.getMessage().getFollowing();
    }

    @Override
    public boolean isGatheringGas() {
        return this.getMessage() == null ? false : this.getMessage().getGatheringGas();
    }

    @Override
    public boolean isGatheringMinerals() {
        return this.getMessage() == null ? false : this.getMessage().getGatheringMinerals();
    }

    @Override
    public boolean isHallucination() {
        return this.getMessage() == null ? false : this.getMessage().getHallucination();
    }

    @Override
    public boolean isIdle() {
        return this.getMessage() == null ? false : this.getMessage().getIdle();
    }

    @Override
    public boolean isIrradiated() {
        return this.getMessage() == null ? false : this.getMessage().getIrradiated();
    }

    @Override
    public boolean isLifted() {
        return this.getMessage() == null ? false : this.getMessage().getLifted();
    }

    @Override
    public boolean isLoaded() {
        return this.getMessage() == null ? false : this.getMessage().getLoaded();
    }

    @Override
    public boolean isLockedDown() {
        return this.getMessage() == null ? false : this.getMessage().getLockedDown();
    }

    @Override
    public boolean isMaelstrommed() {
        return this.getMessage() == null ? false : this.getMessage().getMaelstrommed();
    }

    @Override
    public boolean isMorphing() {
        return this.getMessage() == null ? false : this.getMessage().getMorphing();
    }

    @Override
    public boolean isMoving() {
        return this.getMessage() == null ? false : this.getMessage().getMoving();
    }

    @Override
    public boolean isParasited() {
        return this.getMessage() == null ? false : this.getMessage().getParasited();
    }

    @Override
    public boolean isPatrolling() {
        return this.getMessage() == null ? false : this.getMessage().getPatrolling();
    }

    @Override
    public boolean isPlagued() {
        return this.getMessage() == null ? false : this.getMessage().getPlagued();
    }

    @Override
    public boolean isRepairing() {
        return this.getMessage() == null ? false : this.getMessage().getRepairing();
    }

    @Override
    public boolean isResearching() {
        return this.getMessage() == null ? false : this.getMessage().getResearching();
    }

    @Override
    public boolean isSelected() {
        return this.getMessage() == null ? false : this.getMessage().getSelected();
    }

    @Override
    public boolean isSieged() {
        return this.getMessage() == null ? false : this.getMessage().getSieged();
    }

    @Override
    public boolean isStartingAttack() {
        return this.getMessage() == null ? false : this.getMessage().getStartingAttack();
    }

    @Override
    public boolean isStasised() {
        return this.getMessage() == null ? false : this.getMessage().getStasised();
    }

    @Override
    public boolean isStimmed() {
        return this.getMessage() == null ? false : this.getMessage().getStimmed();
    }

    @Override
    public boolean isStuck() {
        return this.getMessage() == null ? false : this.getMessage().getStuck();
    }

    @Override
    public boolean isTraining() {
        return this.getMessage() == null ? false : this.getMessage().getTraining();
    }

    @Override
    public boolean isUnderStorm() {
        return this.getMessage() == null ? false : this.getMessage().getUnderStorm();
    }

    @Override
    public boolean isUnderAttack() {
        return this.getMessage() == null ? false : this.getMessage().getUnderAttack();
    }

    @Override
    public boolean isUnderDarkSwarm() {
        return this.getMessage() == null ? false : this.getMessage().getUnderDarkSwarm();
    }

    @Override
    public boolean isUnpowered() {
        return this.getMessage() == null ? false : this.getMessage().getUnpowered();
    }

    @Override
    public boolean isUpgrading() {
        return this.getMessage() == null ? false : this.getMessage().getUpgrading();
    }

    @Override
    public boolean isVisible() {
        return this.getMessage() == null ? false : this.getMessage().getVisible();
    }

    @Override
    public boolean canAttack(ROUnit target) {
        if (this.getAttackRange(target) > 0) {
            return true;
        }
        WeaponType w = target.isFlying() ? this.getType().airWeapon() : this.getType().groundWeapon();
        return !w.equals(WeaponType.NONE);
    }

    @Override
    public boolean canCloak() {
        return this.getPlayer().canCloak(this.getType());
    }

    @Override
    public int getAirRange() {
        return this.getRange(true);
    }

    @Override
    public int getAirWeaponDamage() {
        return this.getPlayer() == null || this.getType() == null ? 0 : this.getPlayer().getWeaponDamage(this.getType().airWeapon());
    }

    @Override
    public int getAttackRange(ROUnit target) {
        return target.isFlying() ? this.getAirRange() : this.getGroundRange();
    }

    @Override
    public double getDamagePerShot(ROUnit target) {
        return this.getPlayer().getDamagePerShot(this.getType().pickWeapon(target.isFlying()), target.getType(), target.getPlayer());
    }

    @Override
    public double getDamagePerShot(boolean vsAir) {
        return this.getPlayer().getDamagePerShot(this.getType().pickWeapon(vsAir));
    }

    @Override
    public double getDps(boolean vsAir) {
        if (this.getType().isBuilding() && (this.isUnpowered() || !this.wasCompleted())) {
            return 0.0;
        }
        if (this.getType().equals(UnitType.TERRAN_BUNKER) && this.getPlayer().equals(Game.getInstance().self())) {
            double total = 0.0;
            for (ROUnit rOUnit : this.getLoadedUnits()) {
                total += rOUnit.getDps(vsAir);
            }
            return total;
        }
        if (this.getType().equals(UnitType.PROTOSS_CARRIER)) {
            return (double)this.getInterceptorCount() * this.getPlayer().getDps(UnitType.PROTOSS_INTERCEPTOR, vsAir);
        }
        double dps = this.getPlayer().getDps(this.getType(), vsAir);
        if (this.isStimmed()) {
            dps *= 2.0;
        }
        return dps;
    }

    @Override
    public double getDps(ROUnit target) {
        if (this.getType().isBuilding() && (this.isUnpowered() || !this.wasCompleted())) {
            return 0.0;
        }
        if (this.getType().equals(UnitType.TERRAN_BUNKER) && this.getPlayer().equals(Game.getInstance().self())) {
            double total = 0.0;
            for (ROUnit rOUnit : this.getLoadedUnits()) {
                total += rOUnit.getDps(target);
            }
            return total;
        }
        if (this.getType().equals(UnitType.PROTOSS_CARRIER)) {
            return (double)this.getInterceptorCount() * this.getPlayer().getDps(UnitType.PROTOSS_INTERCEPTOR, target);
        }
        double dps = this.getPlayer().getDps(this.getType(), target);
        if (this.isStimmed()) {
            dps *= 2.0;
        }
        return dps;
    }

    @Override
    public int getGroundRange() {
        return this.getRange(false);
    }

    @Override
    public int getGroundWeaponDamage() {
        return this.getPlayer() == null || this.getType() == null ? 0 : this.getPlayer().getWeaponDamage(this.getType().groundWeapon());
    }

    @Override
    public int getLastKnownHitPoints() {
        int hp = this.getHitPoints();
        if (hp > 0) {
            return hp;
        }
        if (this.getPreviousMessage() == null) {
            return 0;
        }
        return this.getPreviousUnitData().getHitPoints();
    }

    @Override
    public Position getLastKnownPosition() {
        Position current = this.getPosition();
        if (!current.equals(Position.INVALID)) {
            return current;
        }
        if (this.getPreviousMessage() == null) {
            return Position.INVALID;
        }
        return this.getPreviousUnitData().getPosition();
    }

    @Override
    public int getLastKnownResources() {
        int r = this.getResources();
        if (r > 0) {
            return r;
        }
        if (this.getPreviousMessage() == null) {
            return 0;
        }
        return this.getPreviousUnitData().getResources();
    }

    @Override
    public int getLastKnownShields() {
        int hp = this.getShields();
        if (hp > 0) {
            return hp;
        }
        if (this.getPreviousMessage() == null) {
            return 0;
        }
        return this.getPreviousUnitData().getShields();
    }

    @Override
    public TilePosition getLastKnownTilePosition() {
        TilePosition current = this.getTilePosition();
        if (!current.equals(TilePosition.INVALID)) {
            return current;
        }
        if (this.getPreviousMessage() == null) {
            return TilePosition.INVALID;
        }
        return this.getPreviousUnitData().getTilePosition();
    }

    @Override
    public int getShieldUpgradeLevel() {
        return this.getMessage() == null ? 0 : this.getPlayer().getUpgradeLevel(UpgradeType.PROTOSS_PLASMA_SHIELDS);
    }

    @Override
    public boolean isFlying() {
        return this.getType().isFlyer() || this.getType().isFlyingBuilding() && (this.isVisible() && this.isLifted() || !this.isVisible() && this.getPreviousUnitData().isLifted());
    }

    @Override
    public boolean isInRange(ROUnit target) {
        if (!this.canAttack(target)) {
            return false;
        }
        return this.getDistance(target) <= this.getAttackRange(target);
    }

    @Override
    public boolean isStopped() {
        int o = this.getOrder().getID();
        return o == Order.PLAYER_GUARD.getID() || o == Order.CARRIER_HOLD_POSITION.getID() || o == Order.REAVER_HOLD_POSITION.getID() || o == Order.HOLD_POSITION.getID() || o == Order.GUARD.getID() || o == Order.GUARD_POST.getID() || o == Order.NONE.getID() || o == Order.NOTHING.getID() || o == Order.NOTHING_3.getID() || o == Order.STOP.getID();
    }

    @Override
    public boolean isTargetable() {
        if (this.isVisible()) {
            return this.isDetected() || !this.isCloaked() && !this.isBurrowed();
        }
        return false;
    }

    @Override
    public boolean wasCompleted() {
        return this.getMessage() == null ? (this.getPreviousMessage() == null ? false : this.getPreviousMessage().getCompleted()) : this.getMessage().getCompleted();
    }

    private int getBunkerRange(boolean vsAir) {
        Player p = this.getPlayer();
        if (!p.equals(Game.getInstance().self())) {
            return p.getWeaponRange(WeaponType.GAUSS_RIFLE) + 32;
        }
        return this.getMaxBunkerRange(this.getLoadedUnits(), vsAir);
    }

    private int getMaxBunkerRange(Set<? extends ROUnit> loadedUnits, boolean vsAir) {
        int max = 0;
        for (ROUnit rOUnit : loadedUnits) {
            if (rOUnit.getType().equals(UnitType.TERRAN_SCV)) continue;
            max = Math.max(max, (vsAir ? rOUnit.getAirRange() : rOUnit.getGroundRange()) + 32);
        }
        return max;
    }

    private int getRange(boolean vsAir) {
        if (this.getType().equals(UnitType.TERRAN_BUNKER)) {
            return this.getBunkerRange(vsAir);
        }
        if (this.getType().equals(UnitType.PROTOSS_CARRIER)) {
            return 384;
        }
        return this.getPlayer().getWeaponRange(this.getType().pickWeapon(vsAir));
    }

    public boolean canMake(UnitType type) {
        return Game.getInstance().canMake(this, type);
    }

    public boolean canBuildHere(TilePosition tilePosition, UnitType type) {
        return Game.getInstance().canBuildHere(this, tilePosition, type);
    }

    public boolean canUpgrade(UpgradeType type) {
        return Game.getInstance().canUpgrade(this, type);
    }

    @Override
    public Set<TilePosition> getBuildTilePositions() {
        if (this.getType() == null) {
            return Collections.emptySet();
        }
        return TilePosition.getTilePositions(this.getLastKnownTilePosition(), this.getType().tileWidth(), this.getType().tileHeight());
    }

    @Override
    public TilePosition getAddonTilePosition() {
        return this.getLastKnownTilePosition().add(4, 1);
    }
}

