/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.bwapi.proxy.messages.BasicTypes;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.util.Pair;

public final class TilePosition
implements Serializable {
    private static final long serialVersionUID = 9089209349409016589L;
    public static final TilePosition INVALID = new TilePosition(-1, -1);
    private final int x;
    private final int y;

    public String toString() {
        return "TilePosition [x=" + this.x + ", y=" + this.y + "]";
    }

    public TilePosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public TilePosition(Position p) {
        this(p.x() / 32, p.y() / 32);
    }

    TilePosition(BasicTypes.TilePosition message) {
        this(message.getX(), message.getY());
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public double getLength() {
        if (this.equals(INVALID)) {
            return 0.0;
        }
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public TilePosition subtract(TilePosition pos) {
        if (this.equals(INVALID) || pos.equals(INVALID)) {
            return INVALID;
        }
        return new TilePosition(this.x - pos.x, this.y - pos.y);
    }

    public TilePosition subtract(int xx, int yy) {
        if (this.equals(INVALID)) {
            return INVALID;
        }
        return new TilePosition(this.x - xx, this.y - yy);
    }

    public TilePosition add(TilePosition pos) {
        if (this.equals(INVALID) || pos.equals(INVALID)) {
            return INVALID;
        }
        return new TilePosition(this.x + pos.x, this.y + pos.y);
    }

    public TilePosition add(int xx, int yy) {
        if (this.equals(INVALID)) {
            return INVALID;
        }
        return new TilePosition(this.x + xx, this.y + yy);
    }

    public double getDistance(TilePosition pos) {
        return this.subtract(pos).getLength();
    }

    public double manhattanDistance(TilePosition pos) {
        return Math.abs(this.x - pos.x) + Math.abs(this.y - pos.y);
    }

    public double getDistance(Position pos) {
        return this.getDistance(new TilePosition(pos));
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TilePosition)) {
            return false;
        }
        TilePosition other = (TilePosition)obj;
        return other.x == this.x && other.y == this.y;
    }

    public int hashCode() {
        return this.x * 293 + this.y;
    }

    BasicTypes.TilePosition getMessage() {
        BasicTypes.TilePosition.Builder b = BasicTypes.TilePosition.newBuilder();
        b.setX(this.x);
        b.setY(this.y);
        return b.build();
    }

    public static Set<TilePosition> getTilePositions(TilePosition upperLeftCorner, int width, int height) {
        HashSet<TilePosition> tilePositions = new HashSet<TilePosition>();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                tilePositions.add(new TilePosition(upperLeftCorner.x() + x, upperLeftCorner.y() + y));
                ++x;
            }
            ++y;
        }
        return tilePositions;
    }

    public static Pair<TilePosition, TilePosition> selectNearestPositions(Set<TilePosition> tilePositions1, Set<TilePosition> tilePositions2) {
        double nearestDistance = Double.POSITIVE_INFINITY;
        TilePosition nearestTilePosition1 = null;
        TilePosition nearestTilePosition2 = null;
        for (TilePosition tilePosition1 : tilePositions1) {
            for (TilePosition tilePosition2 : tilePositions2) {
                double distance = tilePosition1.getDistance(tilePosition2);
                if (!(distance < nearestDistance)) continue;
                nearestDistance = distance;
                nearestTilePosition1 = tilePosition1;
                nearestTilePosition2 = tilePosition2;
            }
        }
        return Pair.makePair(nearestTilePosition1, nearestTilePosition2);
    }
}

