/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.model.Race;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.model.WeaponType;

public class TechType {
    protected int id;
    protected static final Map<String, TechType> gNamesToTechTypes = new HashMap<String, TechType>();
    protected static final Set<TechType> gAllTechTypes;
    protected static final TechType[] gIdsToTechTypes;
    protected static List<GameMessages.TechTypeData> data;
    public static final TechType STIM_PACKS;
    public static final TechType LOCKDOWN;
    public static final TechType EMP_SHOCKWAVE;
    public static final TechType SPIDER_MINES;
    public static final TechType SCANNER_SWEEP;
    public static final TechType TANK_SIEGE_MODE;
    public static final TechType DEFENSIVE_MATRIX;
    public static final TechType IRRADIATE;
    public static final TechType YAMATO_GUN;
    public static final TechType CLOAKING_FIELD;
    public static final TechType PERSONNEL_CLOAKING;
    public static final TechType BURROWING;
    public static final TechType INFESTATION;
    public static final TechType SPAWN_BROODLINGS;
    public static final TechType DARK_SWARM;
    public static final TechType PLAGUE;
    public static final TechType CONSUME;
    public static final TechType ENSNARE;
    public static final TechType PARASITE;
    public static final TechType PSIONIC_STORM;
    public static final TechType HALLUCINATION;
    public static final TechType RECALL;
    public static final TechType STASIS_FIELD;
    public static final TechType ARCHON_WARP;
    public static final TechType RESTORATION;
    public static final TechType DISRUPTION_WEB;
    public static final TechType MIND_CONTROL;
    public static final TechType DARK_ARCHON_MELD;
    public static final TechType FEEDBACK;
    public static final TechType OPTICAL_FLARE;
    public static final TechType MAELSTROM;
    public static final TechType LURKER_ASPECT;
    public static final TechType HEALING;
    public static final TechType NONE;
    public static final TechType UNKNOWN;
    public static final TechType NUCLEAR_STRIKE;

    static {
        STIM_PACKS = new TechType(0);
        LOCKDOWN = new TechType(1);
        EMP_SHOCKWAVE = new TechType(2);
        SPIDER_MINES = new TechType(3);
        SCANNER_SWEEP = new TechType(4);
        TANK_SIEGE_MODE = new TechType(5);
        DEFENSIVE_MATRIX = new TechType(6);
        IRRADIATE = new TechType(7);
        YAMATO_GUN = new TechType(8);
        CLOAKING_FIELD = new TechType(9);
        PERSONNEL_CLOAKING = new TechType(10);
        BURROWING = new TechType(11);
        INFESTATION = new TechType(12);
        SPAWN_BROODLINGS = new TechType(13);
        DARK_SWARM = new TechType(14);
        PLAGUE = new TechType(15);
        CONSUME = new TechType(16);
        ENSNARE = new TechType(17);
        PARASITE = new TechType(18);
        PSIONIC_STORM = new TechType(19);
        HALLUCINATION = new TechType(20);
        RECALL = new TechType(21);
        STASIS_FIELD = new TechType(22);
        ARCHON_WARP = new TechType(23);
        RESTORATION = new TechType(24);
        DISRUPTION_WEB = new TechType(25);
        MIND_CONTROL = new TechType(27);
        DARK_ARCHON_MELD = new TechType(28);
        FEEDBACK = new TechType(29);
        OPTICAL_FLARE = new TechType(30);
        MAELSTROM = new TechType(31);
        LURKER_ASPECT = new TechType(32);
        HEALING = new TechType(34);
        NONE = new TechType(44);
        UNKNOWN = new TechType(45);
        NUCLEAR_STRIKE = new TechType(46);
        HashSet<TechType> allTechTypes = new HashSet<TechType>();
        gIdsToTechTypes = new TechType[47];
        gNamesToTechTypes.put("Stim Packs", STIM_PACKS);
        allTechTypes.add(STIM_PACKS);
        TechType.gIdsToTechTypes[0] = STIM_PACKS;
        gNamesToTechTypes.put("Lockdown", LOCKDOWN);
        allTechTypes.add(LOCKDOWN);
        TechType.gIdsToTechTypes[1] = LOCKDOWN;
        gNamesToTechTypes.put("EMP Shockwave", EMP_SHOCKWAVE);
        allTechTypes.add(EMP_SHOCKWAVE);
        TechType.gIdsToTechTypes[2] = EMP_SHOCKWAVE;
        gNamesToTechTypes.put("Spider Mines", SPIDER_MINES);
        allTechTypes.add(SPIDER_MINES);
        TechType.gIdsToTechTypes[3] = SPIDER_MINES;
        gNamesToTechTypes.put("Scanner Sweep", SCANNER_SWEEP);
        allTechTypes.add(SCANNER_SWEEP);
        TechType.gIdsToTechTypes[4] = SCANNER_SWEEP;
        gNamesToTechTypes.put("Tank Siege Mode", TANK_SIEGE_MODE);
        allTechTypes.add(TANK_SIEGE_MODE);
        TechType.gIdsToTechTypes[5] = TANK_SIEGE_MODE;
        gNamesToTechTypes.put("Defensive Matrix", DEFENSIVE_MATRIX);
        allTechTypes.add(DEFENSIVE_MATRIX);
        TechType.gIdsToTechTypes[6] = DEFENSIVE_MATRIX;
        gNamesToTechTypes.put("Irradiate", IRRADIATE);
        allTechTypes.add(IRRADIATE);
        TechType.gIdsToTechTypes[7] = IRRADIATE;
        gNamesToTechTypes.put("Yamato Gun", YAMATO_GUN);
        allTechTypes.add(YAMATO_GUN);
        TechType.gIdsToTechTypes[8] = YAMATO_GUN;
        gNamesToTechTypes.put("Cloaking Field", CLOAKING_FIELD);
        allTechTypes.add(CLOAKING_FIELD);
        TechType.gIdsToTechTypes[9] = CLOAKING_FIELD;
        gNamesToTechTypes.put("Personnel Cloaking", PERSONNEL_CLOAKING);
        allTechTypes.add(PERSONNEL_CLOAKING);
        TechType.gIdsToTechTypes[10] = PERSONNEL_CLOAKING;
        gNamesToTechTypes.put("Burrowing", BURROWING);
        allTechTypes.add(BURROWING);
        TechType.gIdsToTechTypes[11] = BURROWING;
        gNamesToTechTypes.put("Infestation", INFESTATION);
        allTechTypes.add(INFESTATION);
        TechType.gIdsToTechTypes[12] = INFESTATION;
        gNamesToTechTypes.put("Spawn Broodlings", SPAWN_BROODLINGS);
        allTechTypes.add(SPAWN_BROODLINGS);
        TechType.gIdsToTechTypes[13] = SPAWN_BROODLINGS;
        gNamesToTechTypes.put("Dark Swarm", DARK_SWARM);
        allTechTypes.add(DARK_SWARM);
        TechType.gIdsToTechTypes[14] = DARK_SWARM;
        gNamesToTechTypes.put("Plague", PLAGUE);
        allTechTypes.add(PLAGUE);
        TechType.gIdsToTechTypes[15] = PLAGUE;
        gNamesToTechTypes.put("Consume", CONSUME);
        allTechTypes.add(CONSUME);
        TechType.gIdsToTechTypes[16] = CONSUME;
        gNamesToTechTypes.put("Ensnare", ENSNARE);
        allTechTypes.add(ENSNARE);
        TechType.gIdsToTechTypes[17] = ENSNARE;
        gNamesToTechTypes.put("Parasite", PARASITE);
        allTechTypes.add(PARASITE);
        TechType.gIdsToTechTypes[18] = PARASITE;
        gNamesToTechTypes.put("Psionic Storm", PSIONIC_STORM);
        allTechTypes.add(PSIONIC_STORM);
        TechType.gIdsToTechTypes[19] = PSIONIC_STORM;
        gNamesToTechTypes.put("Hallucination", HALLUCINATION);
        allTechTypes.add(HALLUCINATION);
        TechType.gIdsToTechTypes[20] = HALLUCINATION;
        gNamesToTechTypes.put("Recall", RECALL);
        allTechTypes.add(RECALL);
        TechType.gIdsToTechTypes[21] = RECALL;
        gNamesToTechTypes.put("Stasis Field", STASIS_FIELD);
        allTechTypes.add(STASIS_FIELD);
        TechType.gIdsToTechTypes[22] = STASIS_FIELD;
        gNamesToTechTypes.put("Archon Warp", ARCHON_WARP);
        allTechTypes.add(ARCHON_WARP);
        TechType.gIdsToTechTypes[23] = ARCHON_WARP;
        gNamesToTechTypes.put("Restoration", RESTORATION);
        allTechTypes.add(RESTORATION);
        TechType.gIdsToTechTypes[24] = RESTORATION;
        gNamesToTechTypes.put("Disruption Web", DISRUPTION_WEB);
        allTechTypes.add(DISRUPTION_WEB);
        TechType.gIdsToTechTypes[25] = DISRUPTION_WEB;
        gNamesToTechTypes.put("Mind Control", MIND_CONTROL);
        allTechTypes.add(MIND_CONTROL);
        TechType.gIdsToTechTypes[27] = MIND_CONTROL;
        gNamesToTechTypes.put("Dark Archon Meld", DARK_ARCHON_MELD);
        allTechTypes.add(DARK_ARCHON_MELD);
        TechType.gIdsToTechTypes[28] = DARK_ARCHON_MELD;
        gNamesToTechTypes.put("Feedback", FEEDBACK);
        allTechTypes.add(FEEDBACK);
        TechType.gIdsToTechTypes[29] = FEEDBACK;
        gNamesToTechTypes.put("Optical Flare", OPTICAL_FLARE);
        allTechTypes.add(OPTICAL_FLARE);
        TechType.gIdsToTechTypes[30] = OPTICAL_FLARE;
        gNamesToTechTypes.put("Maelstrom", MAELSTROM);
        allTechTypes.add(MAELSTROM);
        TechType.gIdsToTechTypes[31] = MAELSTROM;
        gNamesToTechTypes.put("Lurker Aspect", LURKER_ASPECT);
        allTechTypes.add(LURKER_ASPECT);
        TechType.gIdsToTechTypes[32] = LURKER_ASPECT;
        gNamesToTechTypes.put("Healing", HEALING);
        allTechTypes.add(HEALING);
        TechType.gIdsToTechTypes[34] = HEALING;
        gNamesToTechTypes.put("None", NONE);
        allTechTypes.add(NONE);
        TechType.gIdsToTechTypes[44] = NONE;
        gNamesToTechTypes.put("Unknown", UNKNOWN);
        allTechTypes.add(UNKNOWN);
        TechType.gIdsToTechTypes[45] = UNKNOWN;
        gNamesToTechTypes.put("Nuclear Strike", NUCLEAR_STRIKE);
        allTechTypes.add(NUCLEAR_STRIKE);
        TechType.gIdsToTechTypes[46] = NUCLEAR_STRIKE;
        gAllTechTypes = Collections.unmodifiableSet(allTechTypes);
    }

    protected TechType(int id) {
        this.id = id;
    }

    protected TechType(GameMessages.TechType type) {
        this(type.getId());
    }

    public final int getID() {
        return this.id;
    }

    private GameMessages.TechTypeData getData() {
        return data.get(this.id);
    }

    public String getName() {
        return this.getData().getName();
    }

    public Race getRace() {
        return Race.getRaceFromId(this.getData().getRace().getNumber());
    }

    public int mineralPrice() {
        return this.getData().getMineralPrice();
    }

    public int gasPrice() {
        return this.getData().getGasPrice();
    }

    public int energyUsed() {
        return this.getData().getEnergyUsed();
    }

    public UnitType whatResearches() {
        return UnitType.getUnitTypeFromId(this.getData().getWhatResearches().getId());
    }

    public WeaponType getWeapon() {
        return WeaponType.getWeaponTypeFromId(this.getData().getWeapon().getId());
    }

    public Set<UnitType> whatUses() {
        HashSet<UnitType> r = new HashSet<UnitType>();
        for (GameMessages.UnitType u : this.getData().getWhatUsesList()) {
            r.add(UnitType.getUnitTypeFromId(u.getId()));
        }
        return r;
    }

    static void setTechTypes(List<GameMessages.TechTypeData> _data) {
        data = new ArrayList<GameMessages.TechTypeData>(_data);
    }

    public static final TechType getTechType(String name) {
        return gNamesToTechTypes.get(name);
    }

    public static final Set<TechType> allTechTypes() {
        return gAllTechTypes;
    }

    static final TechType getTechTypeFromId(int id) {
        return gIdsToTechTypes[id];
    }

    static final int getMaxIdPlusOne() {
        return gIdsToTechTypes.length;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this instanceof TechType) {
            TechType other = (TechType)object;
            return this.id == other.id;
        }
        return false;
    }

    public final int hashCode() {
        return this.id;
    }

    GameMessages.TechType getTypeMessage() {
        return GameMessages.TechType.newBuilder().setId(this.id).build();
    }
}

