/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.Set;
import org.bwapi.proxy.messages.TerrainMessages;
import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Chokepoint;
import org.bwapi.proxy.model.Polygon;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.TilePosition;

public class Region {
    final int id;
    private final Polygon polygon;
    private Bwta bwta;
    private TerrainMessages.Region region;

    Region(TerrainMessages.Region region, Bwta bwta) {
        this.id = region.getId();
        this.polygon = new Polygon(region.getPolygon());
        this.bwta = bwta;
        this.region = region;
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public Position getCenter() {
        return this.polygon.getCenter();
    }

    public Set<Chokepoint> getChokepoints() {
        return Bwta.wrap(this.bwta.chokepointsList, this.region.getChokepointsList());
    }

    public Set<BaseLocation> getBaseLocations() {
        return Bwta.wrap(this.bwta.baselocationsList, this.region.getBaseLocationsList());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Region other = (Region)obj;
        return this.id == other.id;
    }

    public boolean contains(TilePosition tp) {
        return this.getPolygon().isInside(new Position(tp));
    }

    public boolean contains(Position tp) {
        return this.getPolygon().isInside(tp);
    }
}

