/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.model.UnitType;

public class Race {
    private GameMessages.Race id;
    public static final Race ZERG = new Race(GameMessages.Race.Zerg);
    public static final Race TERRAN = new Race(GameMessages.Race.Terran);
    public static final Race PROTOSS = new Race(GameMessages.Race.Protoss);
    public static final Race OTHER = new Race(GameMessages.Race.Other);
    public static final Race NONE = new Race(GameMessages.Race.None);
    public static final Race UNKNOWN = new Race(GameMessages.Race.Unknown);
    protected static final Map<String, Race> gNamesToRaces = new HashMap<String, Race>();
    protected static final Set<Race> gAllRaces;
    protected static final Race[] gIdsToRaces;
    protected static List<GameMessages.RaceData> data;

    static {
        HashSet<Race> allRaces = new HashSet<Race>();
        gIdsToRaces = new Race[7];
        gNamesToRaces.put("Zerg", ZERG);
        allRaces.add(ZERG);
        Race.gIdsToRaces[0] = ZERG;
        gNamesToRaces.put("Terran", TERRAN);
        allRaces.add(TERRAN);
        Race.gIdsToRaces[1] = TERRAN;
        gNamesToRaces.put("Protoss", PROTOSS);
        allRaces.add(PROTOSS);
        Race.gIdsToRaces[2] = PROTOSS;
        gNamesToRaces.put("Other", OTHER);
        allRaces.add(OTHER);
        Race.gIdsToRaces[4] = OTHER;
        gNamesToRaces.put("None", NONE);
        allRaces.add(NONE);
        Race.gIdsToRaces[5] = NONE;
        gNamesToRaces.put("Unknown", UNKNOWN);
        allRaces.add(UNKNOWN);
        Race.gIdsToRaces[6] = UNKNOWN;
        gAllRaces = Collections.unmodifiableSet(allRaces);
    }

    protected Race(GameMessages.Race id) {
        this.id = id;
    }

    public final int getID() {
        return this.id.getNumber();
    }

    public String getName() {
        return this.getData().getName();
    }

    public UnitType getWorker() {
        return UnitType.getUnitTypeFromId(this.getData().getWorker().getId());
    }

    private GameMessages.RaceData getData() {
        return data.get(this.id.getNumber());
    }

    public UnitType getCenter() {
        return UnitType.getUnitTypeFromId(this.getData().getCenter().getId());
    }

    public UnitType getRefinery() {
        return UnitType.getUnitTypeFromId(this.getData().getRefinery().getId());
    }

    public UnitType getTransport() {
        return UnitType.getUnitTypeFromId(this.getData().getTransport().getId());
    }

    public UnitType getSupplyProvider() {
        return UnitType.getUnitTypeFromId(this.getData().getSupplyProvider().getId());
    }

    static void setRaces(List<GameMessages.RaceData> _data) {
        data = new ArrayList<GameMessages.RaceData>(_data);
    }

    public static final Race getRace(String name) {
        return gNamesToRaces.get(name);
    }

    public static final Set<Race> allRaces() {
        return gAllRaces;
    }

    static final Race getRaceFromId(int id) {
        return gIdsToRaces[id];
    }

    static final int getMaxIdPlusOne() {
        return gIdsToRaces.length;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this instanceof Race) {
            Race other = (Race)object;
            return this.id == other.id;
        }
        return false;
    }

    public final int hashCode() {
        return this.id.getNumber();
    }
}

