/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.io.Serializable;
import org.bwapi.proxy.messages.BasicTypes;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.util.Pair;

public final class Position
implements Serializable {
    private static final long serialVersionUID = 2449678418666308671L;
    public static final Position INVALID = new Position(-1, -1);
    private final int x;
    private final int y;

    public Position(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Position(TilePosition tp) {
        this(tp.x() * 32, tp.y() * 32);
    }

    Position(BasicTypes.Position message) {
        this(message.getX(), message.getY());
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public double getLength() {
        if (this.equals(INVALID)) {
            return 0.0;
        }
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Position subtract(Position pos) {
        if (this.equals(INVALID) || pos.equals(INVALID)) {
            return INVALID;
        }
        return new Position(this.x - pos.x, this.y - pos.y);
    }

    public Position add(Position pos) {
        if (this.equals(INVALID) || pos.equals(INVALID)) {
            return INVALID;
        }
        return new Position(this.x + pos.x, this.y + pos.y);
    }

    public Position add(int x, int y) {
        if (this.equals(INVALID)) {
            return INVALID;
        }
        return new Position(this.x + x, this.y + y);
    }

    public double getDistance(Position pos) {
        return this.subtract(pos).getLength();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Position)) {
            return false;
        }
        Position other = (Position)obj;
        return other.x == this.x && other.y == this.y;
    }

    public int hashCode() {
        return this.x * 3571 + this.y;
    }

    public String toString() {
        return "[x=" + this.x + ", y=" + this.y + "]";
    }

    public BasicTypes.Position getMessage() {
        BasicTypes.Position.Builder b = BasicTypes.Position.newBuilder();
        b.setX(this.x);
        b.setY(this.y);
        return b.build();
    }

    public static Position centerOfTile(TilePosition tp) {
        return new Position(tp.x() * 32 + 16, tp.y() * 32 + 16);
    }

    public static Position midPoint(Pair<Position, Position> pair) {
        return new Position((pair.getFirst().x + pair.getSecond().x) / 2, (pair.getFirst().y + pair.getSecond().y) / 2);
    }
}

