/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bwapi.proxy.messages.BasicTypes;
import org.bwapi.proxy.messages.TerrainMessages;
import org.bwapi.proxy.model.Position;

public class Polygon
implements Iterable<Position> {
    private List<Polygon> holes;
    private List<Position> vertices;
    private double perimeter;
    private Position center;
    private double area;

    Polygon(TerrainMessages.Polygon polygon) {
        this.holes = new ArrayList<Polygon>();
        for (TerrainMessages.Polygon polygon2 : polygon.getHolesList()) {
            this.holes.add(new Polygon(polygon2));
        }
        this.vertices = new ArrayList<Position>();
        for (BasicTypes.Position position : polygon.getVerticesList()) {
            this.vertices.add(new Position(position));
        }
        this.perimeter = polygon.getPerimeter();
        this.center = new Position(polygon.getCenter());
        this.area = polygon.getArea();
    }

    public Polygon(List<Position> vertices, List<Polygon> holes, double perimeter, Position center, double area) {
        this.holes = holes;
        this.vertices = vertices;
        this.perimeter = perimeter;
        this.center = center;
        this.area = area;
    }

    public Polygon(List<Position> vertices) {
        this.vertices = vertices;
        this.holes = Collections.emptyList();
        this.perimeter = this.calculatePerimeter();
        this.area = this.calculateArea();
        this.center = this.calculateCenter(this.area);
    }

    public double getArea() {
        return this.area;
    }

    public Position getCenter() {
        return this.center;
    }

    public double getPerimeter() {
        return this.perimeter;
    }

    public List<Position> getVertices() {
        return this.vertices;
    }

    public List<Polygon> getHoles() {
        return this.holes;
    }

    @Override
    public Iterator<Position> iterator() {
        return this.vertices.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.area);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.center == null ? 0 : this.center.hashCode());
        result = 31 * result + (this.holes == null ? 0 : this.holes.hashCode());
        temp = Double.doubleToLongBits(this.perimeter);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.vertices == null ? 0 : this.vertices.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polygon other = (Polygon)obj;
        if (Double.doubleToLongBits(this.area) != Double.doubleToLongBits(other.area)) {
            return false;
        }
        if (this.center == null ? other.center != null : !this.center.equals(other.center)) {
            return false;
        }
        if (this.holes == null ? other.holes != null : !this.holes.equals(other.holes)) {
            return false;
        }
        if (Double.doubleToLongBits(this.perimeter) != Double.doubleToLongBits(other.perimeter)) {
            return false;
        }
        return !(this.vertices == null ? other.vertices != null : !this.vertices.equals(other.vertices));
    }

    public boolean isInside(Position pt) {
        if (!this.point_is_inside(pt)) {
            return false;
        }
        for (Polygon p : this.holes) {
            if (!p.point_is_inside(pt)) continue;
            return false;
        }
        return true;
    }

    public Position getNearestPoint(Position p) {
        double x3 = p.x();
        double y3 = p.y();
        Position minp = null;
        int j = 1;
        double mind2 = -1.0;
        int i = 0;
        while (i < this.vertices.size()) {
            double y2;
            j = (i + 1) % this.vertices.size();
            double x1 = this.vertices.get(i).x();
            double y1 = this.vertices.get(i).y();
            double x2 = this.vertices.get(j).x();
            double u = ((x3 - x1) * (x2 - x1) + (y3 - y1) * ((y2 = (double)this.vertices.get(j).y()) - y1)) / ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            if (u < 0.0) {
                u = 0.0;
            }
            if (u > 1.0) {
                u = 1.0;
            }
            double x = x1 + u * (x2 - x1);
            double y = y1 + u * (y2 - y1);
            double d2 = (x - x3) * (x - x3) + (y - y3) * (y - y3);
            if (mind2 < 0.0 || d2 < mind2) {
                mind2 = d2;
                minp = new Position((int)x, (int)y);
            }
            ++i;
        }
        for (Polygon hole : this.getHoles()) {
            Position hnp = hole.getNearestPoint(p);
            if (!(hnp.getDistance(p) < minp.getDistance(p))) continue;
            minp = hnp;
        }
        return minp;
    }

    private boolean point_is_inside(Position pt) {
        boolean c = false;
        int nvert = this.vertices.size();
        int i = 0;
        int j = nvert - 1;
        while (i < nvert) {
            Position vi = this.vertices.get(i);
            Position vj = this.vertices.get(j);
            double viy = vi.y();
            double vix = vi.x();
            double vjx = vj.x();
            double vjy = vj.y();
            if (viy > (double)pt.y() != vjy > (double)pt.y() && (double)pt.x() < (vjx - vix) * ((double)pt.y() - viy) / (vjy - viy) + vix) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    public static void main(String[] args) {
        Position p;
        Position[] square_v = new Position[]{new Position(0, 0), new Position(100, 0), new Position(100, 100), new Position(0, 100)};
        Position[] small_square_v = new Position[]{new Position(25, 25), new Position(75, 25), new Position(75, 75), new Position(25, 75)};
        Polygon square = new Polygon(Arrays.asList(square_v), Collections.<Polygon>emptyList(), 0.0, new Position(0, 0), 0.0);
        Polygon smallSquare = new Polygon(Arrays.asList(small_square_v), Collections.<Polygon>emptyList(), 0.0, new Position(0, 0), 0.0);
        Polygon holeSquare = new Polygon(Arrays.asList(square_v), Collections.singletonList(smallSquare), 0.0, new Position(0, 0), 0.0);
        Position[] test_points = new Position[]{new Position(50, 50), new Position(50, 80), new Position(20, 20), new Position(0, 0), new Position(100, 100), new Position(25, 25), new Position(1, 50), new Position(22, 74), new Position(0, 50), new Position(100, 50), new Position(-4, 10)};
        System.out.println("square");
        Position[] positionArray = test_points;
        int n = test_points.length;
        int n2 = 0;
        while (n2 < n) {
            p = positionArray[n2];
            System.out.println(p + " " + square.isInside(p));
            ++n2;
        }
        System.out.println("small square");
        positionArray = test_points;
        n = test_points.length;
        n2 = 0;
        while (n2 < n) {
            p = positionArray[n2];
            System.out.println(p + " " + smallSquare.isInside(p));
            ++n2;
        }
        System.out.println("hole square");
        positionArray = test_points;
        n = test_points.length;
        n2 = 0;
        while (n2 < n) {
            p = positionArray[n2];
            System.out.println(p + " " + holeSquare.isInside(p));
            ++n2;
        }
    }

    private double calculatePerimeter() {
        if (this.vertices.size() < 2) {
            return 0.0;
        }
        double p = 0.0;
        int i = 0;
        while (i + 1 < this.vertices.size()) {
            p += this.vertices.get(i).getDistance(this.vertices.get(i + 1));
            ++i;
        }
        return p += this.vertices.get(this.vertices.size() - 1).getDistance(this.vertices.get(0));
    }

    double calculateArea() {
        if (this.vertices.size() < 3) {
            return 0.0;
        }
        double a = 0.0;
        int i = 0;
        while (i + 1 < this.vertices.size()) {
            a += (double)this.vertices.get(i).x() * (double)this.vertices.get(i + 1).y() - (double)this.vertices.get(i + 1).x() * (double)this.vertices.get(i).y();
            ++i;
        }
        a += (double)(this.vertices.get(this.vertices.size() - 1).x() * this.vertices.get(0).y() - this.vertices.get(0).x() * this.vertices.get(this.vertices.size() - 1).y());
        a /= 2.0;
        a = Math.abs(a);
        return a;
    }

    Position calculateCenter(double area) {
        double a = area;
        double cx = 0.0;
        double cy = 0.0;
        int i = 0;
        int j = 1;
        while (i < this.vertices.size()) {
            if (j == this.vertices.size()) {
                j = 0;
            }
            double temp = (double)this.vertices.get(i).x() * (double)this.vertices.get(j).y() - (double)this.vertices.get(j).x() * (double)this.vertices.get(i).y();
            cx += (double)(this.vertices.get(i).x() + this.vertices.get(j).x()) * temp;
            cy += (double)(this.vertices.get(i).y() + this.vertices.get(j).y()) * temp;
            ++i;
            ++j;
        }
        return new Position((int)(cx /= 6.0 * a), (int)(cy /= 6.0 * a));
    }
}

