/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.model.DamageType;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Race;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitSizeType;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.model.UpgradeType;
import org.bwapi.proxy.model.WeaponType;

public class Player {
    private final Game g = Game.getInstance();
    private final int id;
    private GameMessages.Player message;
    private Set<Unit> units;
    private Map<Player, PlayerStatus> stances;
    private TilePosition startLocation;
    private Map<UnitType, Integer> allUnitCount;
    private Map<UnitType, Integer> completedUnitCount;
    private Map<UnitType, Integer> incompleteUnitCount;
    private Map<UnitType, Integer> deadUnitCount;
    private Map<UnitType, Integer> killedUnitCount;
    private int[] upgradeLevels;
    private boolean[] researchedTechs;
    private boolean[] researching;
    private boolean[] upgrading;
    protected static Map<UnitType, Position> gUnitTypesToVisibilityOffset = new HashMap<UnitType, Position>();

    static {
        gUnitTypesToVisibilityOffset.put(UnitType.PROTOSS_DARK_TEMPLAR, new Position(0, -9));
        gUnitTypesToVisibilityOffset.put(UnitType.PROTOSS_DRAGOON, new Position(-1, -1));
        gUnitTypesToVisibilityOffset.put(UnitType.PROTOSS_HIGH_TEMPLAR, new Position(0, -4));
        gUnitTypesToVisibilityOffset.put(UnitType.PROTOSS_ZEALOT, new Position(0, -8));
        gUnitTypesToVisibilityOffset.put(UnitType.TERRAN_BATTLECRUISER, new Position(-3, -3));
        gUnitTypesToVisibilityOffset.put(UnitType.TERRAN_DROPSHIP, new Position(0, -2));
        gUnitTypesToVisibilityOffset.put(UnitType.TERRAN_FIREBAT, new Position(0, -7));
        gUnitTypesToVisibilityOffset.put(UnitType.TERRAN_GHOST, new Position(0, -1));
        gUnitTypesToVisibilityOffset.put(UnitType.TERRAN_MARINE, new Position(0, -1));
        gUnitTypesToVisibilityOffset.put(UnitType.TERRAN_MEDIC, new Position(0, -1));
        gUnitTypesToVisibilityOffset.put(UnitType.TERRAN_SCIENCE_VESSEL, new Position(0, 8));
        gUnitTypesToVisibilityOffset.put(UnitType.TERRAN_VULTURE_SPIDER_MINE, new Position(-1, -1));
        gUnitTypesToVisibilityOffset.put(UnitType.TERRAN_VALKYRIE, new Position(-1, -9));
        gUnitTypesToVisibilityOffset.put(UnitType.ZERG_HYDRALISK, new Position(0, -1));
        gUnitTypesToVisibilityOffset.put(UnitType.ZERG_INFESTED_TERRAN, new Position(0, -1));
        gUnitTypesToVisibilityOffset.put(UnitType.ZERG_LURKER, new Position(-1, -1));
        gUnitTypesToVisibilityOffset.put(UnitType.ZERG_ZERGLING, new Position(0, -4));
    }

    Player(int id) {
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Player)) {
            return false;
        }
        Player p = (Player)obj;
        return this.id == p.id;
    }

    public int hashCode() {
        return this.id;
    }

    void setMessage(GameMessages.Player message) {
        this.message = message;
        this.units = null;
        this.stances = null;
        this.startLocation = null;
        this.allUnitCount = null;
        this.completedUnitCount = null;
        this.incompleteUnitCount = null;
        this.deadUnitCount = null;
        this.killedUnitCount = null;
        this.upgradeLevels = null;
        this.researchedTechs = null;
        this.researching = null;
        this.upgrading = null;
    }

    private void checkUpgrading() {
        if (this.upgrading == null) {
            this.upgrading = this.upgradeBoolArray(this.message.getUpgradingList());
        }
    }

    private void checkResearching() {
        if (this.researching == null) {
            this.researching = this.techTypeBoolArray(this.message.getResearchingList());
        }
    }

    private void checkResearchedTechs() {
        if (this.researchedTechs == null) {
            this.researchedTechs = this.techTypeBoolArray(this.message.getResearchedTechsList());
        }
    }

    private void checkUpgradeLevels() {
        if (this.upgradeLevels == null) {
            this.upgradeLevels = this.upgradeIntArray(this.message.getUpgradeLevelsList());
        }
    }

    private void checkKilledUnitCount() {
        if (this.killedUnitCount == null) {
            this.killedUnitCount = this.buildUnitTypeCountsFromMessages(this.message.getKilledUnitCountList());
        }
    }

    private void checkDeadUnitCount() {
        if (this.deadUnitCount == null) {
            this.deadUnitCount = this.buildUnitTypeCountsFromMessages(this.message.getDeadUnitCountList());
        }
    }

    private void checkIncompleteUnitCount() {
        if (this.incompleteUnitCount == null) {
            this.incompleteUnitCount = this.buildUnitTypeCountsFromMessages(this.message.getIncompleteUnitCountList());
        }
    }

    private void checkCompletedUnitCount() {
        if (this.completedUnitCount == null) {
            this.completedUnitCount = this.buildUnitTypeCountsFromMessages(this.message.getCompletedUnitCountList());
        }
    }

    private void checkAllUnitCount() {
        if (this.allUnitCount == null) {
            this.allUnitCount = this.buildUnitTypeCountsFromMessages(this.message.getAllUnitCountList());
        }
    }

    private void checkStartLocation() {
        if (this.startLocation == null) {
            this.startLocation = new TilePosition(this.message.getStartLocation());
        }
    }

    private void checkUnits() {
        if (this.units == null) {
            this.units = this.buildUnitSet(this.message.getUnitsList());
        }
    }

    private void checkStances() {
        if (this.stances == null) {
            this.stances = this.buildPlayerMap(this.message.getStancesList());
        }
    }

    private Set<Unit> buildUnitSet(List<GameMessages.UnitId> list) {
        HashSet<Unit> set = new HashSet<Unit>();
        for (GameMessages.UnitId u : list) {
            set.add(new Unit(u.getId()));
        }
        return set;
    }

    private Map<Player, PlayerStatus> buildPlayerMap(List<GameMessages.PlayerStatus> list) {
        HashMap<Player, PlayerStatus> map = new HashMap<Player, PlayerStatus>(8);
        for (GameMessages.PlayerStatus status : list) {
            map.put(this.g.playerManager.getPlayer(status.getId()), this.getStatus(status.getStance()));
        }
        return map;
    }

    private PlayerStatus getStatus(GameMessages.PlayerStance stance) {
        switch (stance) {
            case Neutral: {
                return PlayerStatus.Neutral;
            }
            case Ally: {
                return PlayerStatus.Ally;
            }
            case Enemy: {
                return PlayerStatus.Enemy;
            }
        }
        return PlayerStatus.Unknown;
    }

    private Map<UnitType, Integer> buildUnitTypeCountsFromMessages(List<GameMessages.UnitTypeIntPair> list) {
        HashMap<UnitType, Integer> map = new HashMap<UnitType, Integer>();
        for (GameMessages.UnitTypeIntPair pair : list) {
            UnitType key = UnitType.getUnitTypeFromId(pair.getType().getId());
            map.put(key, pair.getCount());
        }
        return map;
    }

    private int[] upgradeIntArray(List<GameMessages.UpgradeLevel> list) {
        int[] a = new int[UpgradeType.getMaxIdPlusOne()];
        for (GameMessages.UpgradeLevel ul : list) {
            a[ul.getType().getId()] = ul.getLevel();
        }
        return a;
    }

    private boolean[] upgradeBoolArray(List<GameMessages.UpgradeType> list) {
        boolean[] a = new boolean[UpgradeType.getMaxIdPlusOne()];
        for (GameMessages.UpgradeType ut : list) {
            a[ut.getId()] = true;
        }
        return a;
    }

    private boolean[] techTypeBoolArray(List<GameMessages.TechType> list) {
        boolean[] a = new boolean[TechType.getMaxIdPlusOne()];
        for (GameMessages.TechType tt : list) {
            a[tt.getId()] = true;
        }
        return a;
    }

    public int allUnitCount(UnitType unit) {
        this.checkAllUnitCount();
        Integer rv = this.allUnitCount.get(unit);
        return rv == null ? 0 : rv;
    }

    public int completedUnitCount(UnitType unit) {
        this.checkCompletedUnitCount();
        Integer rv = this.completedUnitCount.get(unit);
        return rv == null ? 0 : rv;
    }

    public int cumulativeGas() {
        return this.message.getCumulativeGas();
    }

    public int cumulativeMinerals() {
        return this.message.getCumulativeMinerals();
    }

    public int deadUnitCount(UnitType unit) {
        this.checkDeadUnitCount();
        Integer rv = this.deadUnitCount.get(unit);
        return rv == null ? 0 : rv;
    }

    public int gas() {
        return this.message.getGas();
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.message.getName();
    }

    public Race getRace() {
        return Race.getRaceFromId(this.message.getRace().getNumber());
    }

    public TilePosition getStartLocation() {
        this.checkStartLocation();
        return this.startLocation;
    }

    public Set<? extends ROUnit> getUnits() {
        this.checkUnits();
        return this.units;
    }

    public int getUpgradeLevel(UpgradeType upgrade) {
        this.checkUpgradeLevels();
        return this.upgradeLevels[upgrade.getID()];
    }

    public boolean hasResearched(TechType tech) {
        this.checkResearchedTechs();
        return this.researchedTechs[tech.getID()];
    }

    public int incompleteUnitCount(UnitType unit) {
        this.checkIncompleteUnitCount();
        Integer count = this.incompleteUnitCount.get(unit);
        return count == null ? 0 : count;
    }

    public boolean isAlly(Player player) {
        this.checkStances();
        return this.stances.containsKey(player) && this.stances.get(player).equals((Object)PlayerStatus.Ally);
    }

    public boolean isEnemy(Player player) {
        this.checkStances();
        return this.stances.containsKey(player) && this.stances.get(player).equals((Object)PlayerStatus.Enemy);
    }

    public boolean isNeutral() {
        return this.message.getNeutral();
    }

    public boolean isResearching(TechType tech) {
        this.checkResearching();
        return this.researching[tech.getID()];
    }

    public boolean isUpgrading(UpgradeType upgrade) {
        this.checkUpgrading();
        return this.upgrading[upgrade.getID()];
    }

    public int killedUnitCount(UnitType unit) {
        this.checkKilledUnitCount();
        return this.killedUnitCount.get(unit);
    }

    public boolean leftGame() {
        return this.message.getLeftGame();
    }

    public int minerals() {
        return this.message.getMinerals();
    }

    public int supplyTotal() {
        return this.message.getSupplyTotal();
    }

    public int supplyUsed() {
        return this.message.getSupplyUsed();
    }

    boolean isSelf() {
        return this.message.getSelf();
    }

    public boolean isVictorious() {
        return this.message.getVictorious();
    }

    public boolean isDefeated() {
        return this.message.getDefeated();
    }

    public boolean canCloak(UnitType type) {
        if (type.isBuilding()) {
            return false;
        }
        if (type.equals(UnitType.ZERG_LURKER) || type.equals(UnitType.PROTOSS_DARK_TEMPLAR) || type.equals(UnitType.PROTOSS_OBSERVER)) {
            return true;
        }
        if (this.hasResearched(TechType.BURROWING) && (type.equals(UnitType.ZERG_DRONE) || type.equals(UnitType.ZERG_ZERGLING) || type.equals(UnitType.ZERG_HYDRALISK) || type.equals(UnitType.ZERG_DEFILER))) {
            return true;
        }
        if (this.hasResearched(TechType.CLOAKING_FIELD) && type.equals(UnitType.TERRAN_WRAITH)) {
            return true;
        }
        return this.hasResearched(TechType.PERSONNEL_CLOAKING) && type.equals(UnitType.TERRAN_GHOST);
    }

    public double getDamagePerShot(WeaponType weapon) {
        return this.getDamagePerShot(weapon, null);
    }

    public double getDamagePerShot(WeaponType weapon, ROUnit target) {
        if (target == null) {
            return this.getDamagePerShot(weapon, null, 0.0);
        }
        double armor = target.getShields() > 0 ? target.getShieldUpgradeLevel() : target.getArmor();
        return this.getDamagePerShot(weapon, target.getType(), armor);
    }

    public double getDamagePerShot(WeaponType weapon, UnitType targetType, Player targetPlayer) {
        double armor = targetType.armor() + targetPlayer.getUpgradeLevel(targetType.armorUpgrade());
        if (targetType.getRace().equals(Race.PROTOSS)) {
            armor *= (double)targetType.maxHitPoints();
            armor += (double)(targetType.maxShields() * targetPlayer.getUpgradeLevel(UpgradeType.PROTOSS_PLASMA_SHIELDS));
            double weight = targetType.maxShields() + targetType.maxHitPoints();
            armor /= weight;
        }
        if (targetType.equals(UnitType.ZERG_ULTRALISK) && targetPlayer.getUpgradeLevel(UpgradeType.CHITINOUS_PLATING) > 0) {
            armor += 2.0;
        }
        return this.getDamagePerShot(weapon, targetType, armor);
    }

    private double getDamagePerShot(WeaponType weapon, UnitType targetType, double armor) {
        int weaponDamage = this.getWeaponDamage(weapon);
        double damageTypeMultiplier = targetType == null ? 1.0 : Player.getDamageMultiplier(weapon.damageType(), targetType.size());
        double damagePerShot = ((double)weaponDamage - armor) * damageTypeMultiplier;
        return damagePerShot;
    }

    public double getDps(WeaponType weapon) {
        return this.getDps(null, null, weapon);
    }

    public double getDps(UnitType shooterType, ROUnit target) {
        return this.getDps(shooterType, target, shooterType.pickWeapon(target.isFlying()));
    }

    public double getDps(UnitType shooterType, boolean vsAir) {
        return this.getDps(shooterType, null, shooterType.pickWeapon(vsAir));
    }

    private double getDps(UnitType shooterType, ROUnit target, WeaponType w) {
        if (shooterType != null && shooterType.equals(UnitType.TERRAN_BUNKER)) {
            return 4.0 * this.getDps(UnitType.TERRAN_MARINE, target, w);
        }
        double damagePerShot = this.getDamagePerShot(w, target);
        int cooldown = w.equals(WeaponType.PULSE_CANNON) ? 37 : w.damageCooldown();
        double shotsPerSecond = 24.0 / (double)cooldown;
        if (shooterType != null && (shooterType.equals(UnitType.ZERG_SCOURGE) || shooterType.equals(UnitType.ZERG_INFESTED_TERRAN))) {
            shotsPerSecond = 0.1;
        }
        return damagePerShot * shotsPerSecond;
    }

    public int getWeaponDamage(WeaponType weapon) {
        return weapon.damageAmount() + weapon.damageBonus() * this.getUpgradeLevel(weapon.upgradeType());
    }

    public int getWeaponRange(WeaponType weapon) {
        int range = weapon.maxRange();
        if (weapon.equals(WeaponType.GAUSS_RIFLE) && this.getUpgradeLevel(UpgradeType.U_238_SHELLS) > 0) {
            range += 32;
        }
        if (weapon.equals(WeaponType.PHASE_DISRUPTOR) && this.getUpgradeLevel(UpgradeType.SINGULARITY_CHARGE) > 0) {
            range += 64;
        }
        if (weapon.equals(WeaponType.NEEDLE_SPINES) && this.getUpgradeLevel(UpgradeType.GROOVED_SPINES) > 0) {
            range += 32;
        }
        if (weapon.equals(WeaponType.HELLFIRE_MISSILE_PACK) && this.getUpgradeLevel(UpgradeType.CHARON_BOOSTER) > 0) {
            range += 96;
        }
        return range;
    }

    private static double getDamageMultiplier(DamageType damageType, UnitSizeType size) {
        if (damageType.equals((Object)DamageType.CONCUSSIVE)) {
            if (size.equals((Object)UnitSizeType.LARGE)) {
                return 0.25;
            }
            if (size.equals((Object)UnitSizeType.MEDIUM)) {
                return 0.5;
            }
        }
        if (damageType.equals((Object)DamageType.EXPLOSIVE)) {
            if (size.equals((Object)UnitSizeType.SMALL)) {
                return 0.5;
            }
            if (size.equals((Object)UnitSizeType.MEDIUM)) {
                return 0.75;
            }
        }
        return 1.0;
    }

    public boolean canSeeUnitAtPosition(UnitType type, Position pos) {
        TilePosition tilePosition = new TilePosition(pos);
        if (type.isBuilding()) {
            int buildDeltaX = 0;
            while (buildDeltaX < type.tileWidth()) {
                int buildDeltaY = 0;
                while (buildDeltaY < type.tileHeight()) {
                    if (Game.getInstance().isVisible(tilePosition.x() + buildDeltaX, tilePosition.y() + buildDeltaY)) {
                        return true;
                    }
                    ++buildDeltaY;
                }
                ++buildDeltaX;
            }
            return false;
        }
        int dimensionOriginX = pos.x() - type.dimensionLeft();
        int dimensionOriginY = pos.y() - type.dimensionUp();
        int adjustedDimensionOriginX = dimensionOriginX;
        int adjustedDimensionOriginY = dimensionOriginY;
        Position visibilityOffset = gUnitTypesToVisibilityOffset.get(type);
        if (visibilityOffset != null) {
            adjustedDimensionOriginX += visibilityOffset.x();
            adjustedDimensionOriginY += visibilityOffset.y();
        }
        int dimensionRightOfOrigin = type.dimensionLeft() + type.dimensionRight();
        int dimensionDownOfOrigin = type.dimensionUp() + type.dimensionDown();
        int dimensionRightOfOriginInBuildTiles = dimensionRightOfOrigin / 32;
        int dimensionDownOfOriginInBuildTiles = dimensionDownOfOrigin / 32;
        int buildTileLeft = (int)Math.floor((double)adjustedDimensionOriginX / 32.0);
        int buildTileTop = (int)Math.floor((double)adjustedDimensionOriginY / 32.0);
        int buildTileRight = (int)Math.floor((double)(adjustedDimensionOriginX + dimensionRightOfOriginInBuildTiles * 32) / 32.0);
        int buildTileBottom = (int)Math.floor(((double)adjustedDimensionOriginY + (double)dimensionDownOfOriginInBuildTiles * 32.0) / 32.0);
        int buildTileX = buildTileLeft;
        while (buildTileX <= buildTileRight) {
            int buildTileY = buildTileTop;
            while (buildTileY <= buildTileBottom) {
                if (Game.getInstance().isVisible(buildTileX, buildTileY)) {
                    return true;
                }
                ++buildTileY;
            }
            ++buildTileX;
        }
        return false;
    }

    private static enum PlayerStatus {
        Neutral,
        Ally,
        Enemy,
        Unknown;

    }
}

