/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bwapi.proxy.messages.BasicTypes;
import org.bwapi.proxy.messages.DrawCommands;
import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.messages.Messages;
import org.bwapi.proxy.model.Bullet;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.CommandManager;
import org.bwapi.proxy.model.CommandValidator;
import org.bwapi.proxy.model.CoordinateType;
import org.bwapi.proxy.model.Flag;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.PlayerManager;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Race;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitManager;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.model.UpgradeType;
import org.bwapi.proxy.model.WeaponType;

public class Game {
    public static final int TILE_SIZE = 32;
    protected static Game game = new Game();
    protected CommandValidator invalidator = new CommandValidator.Invalidator();
    protected CommandValidator defaultValidator = new CommandValidator.DefaultValidator(this);
    protected UnitManager unitManager;
    protected PlayerManager playerManager;
    protected CommandManager commandManager;
    Set<? extends ROUnit> staticMinerals;
    Set<? extends ROUnit> staticGeysers;
    Set<? extends ROUnit> staticNeutralUnits;
    Set<TilePosition> startLocations = new HashSet<TilePosition>();
    private Set<Bullet> bullets = new HashSet<Bullet>();
    int mapWidth;
    int mapHeight;
    String mapFilename;
    String mapName;
    String mapHash;
    boolean[][] walkable;
    boolean[][] buildable;
    int[][] groundHeight;
    boolean[][] visible;
    boolean[][] explored;
    boolean[][] hasCreep;
    boolean[][] hadCreep;
    private Messages.FrameMessage currentFrameData;
    Set<? extends ROUnit> selectedUnits;
    private Player self;
    private Set<Unit>[][] unitsOnTile;
    private Set<Unit> pylons;
    private Set<Unit> geysers;
    private Set<Unit> minerals;
    private Set<Unit> neutralUnits;
    private boolean drawing = true;

    public boolean isDrawing() {
        return this.drawing;
    }

    private boolean[][] unpackBitmask(List<Integer> list, int dim1, int dim2) {
        boolean[][] res = new boolean[dim1][dim2];
        Iterator<Integer> it = list.iterator();
        int bit = 0;
        int field = 0;
        int x = 0;
        while (x < dim1) {
            int y = 0;
            while (y < dim2) {
                if (bit == 0) {
                    field = it.next();
                }
                boolean bl = res[x][y] = (1 << bit & field) != 0;
                if (++bit == 32) {
                    bit = 0;
                }
                ++y;
            }
            ++x;
        }
        return res;
    }

    private Set<? extends ROUnit> buildUnitSet(List<GameMessages.UnitId> list) {
        HashSet<Unit> set = new HashSet<Unit>();
        for (GameMessages.UnitId u : list) {
            set.add(new Unit(u.getId()));
        }
        return set;
    }

    public static Game getInstance() {
        return game;
    }

    public void init() {
        this.unitManager = new UnitManager();
        this.playerManager = new PlayerManager();
        this.commandManager = new CommandManager();
    }

    public Set<Player> getPlayers() {
        return this.playerManager.getAllPlayers();
    }

    public Set<? extends ROUnit> getAllUnits() {
        return this.unitManager.getAllUnits();
    }

    public Set<? extends ROUnit> unitsOnTile(int x, int y) {
        if (x < 0 || y < 0 || x >= this.mapWidth || y >= this.mapHeight) {
            return Collections.emptySet();
        }
        return this.unitsOnTile[x][y] == null ? Collections.emptySet() : this.unitsOnTile[x][y];
    }

    public Set<? extends ROUnit> unitsOnTile(TilePosition pos) {
        return this.unitsOnTile(pos.x(), pos.y());
    }

    public Set<? extends ROUnit> getGeysers() {
        return this.geysers;
    }

    public Set<? extends ROUnit> getMinerals() {
        return this.minerals;
    }

    public Set<? extends ROUnit> getNeutralUnits() {
        return this.neutralUnits;
    }

    public Set<TilePosition> getStartLocations() {
        return this.startLocations;
    }

    public Set<? extends ROUnit> getStaticMinerals() {
        return this.staticMinerals;
    }

    public Set<? extends ROUnit> getStaticGeysers() {
        return this.staticGeysers;
    }

    public Set<? extends ROUnit> getStaticNeutralUnits() {
        return this.staticNeutralUnits;
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public String getMapName() {
        return this.mapName;
    }

    public String getMapHash() {
        return this.mapHash;
    }

    public int getLatency() {
        return this.currentFrameData.getLatency();
    }

    public int getFrameCount() {
        return this.currentFrameData == null ? 0 : this.currentFrameData.getFrameCount();
    }

    public int getMouseX() {
        return this.currentFrameData.getMouseX();
    }

    public int getMouseY() {
        return this.currentFrameData.getMouseY();
    }

    public int getScreenX() {
        return this.currentFrameData.getScreenX();
    }

    public int getScreenY() {
        return this.currentFrameData.getScreenY();
    }

    public int getGroundHeight(int x, int y) {
        if (x >= 0 && y >= 0 && y < this.mapHeight * 4 && x < this.mapWidth * 4) {
            return this.groundHeight[x][y];
        }
        return -1;
    }

    public boolean isWalkable(int x, int y) {
        return x >= 0 && y >= 0 && y < this.mapHeight * 4 && x < this.mapWidth * 4 && this.walkable[x][y];
    }

    public boolean isBuildable(int x, int y) {
        return x >= 0 && y >= 0 && y < this.mapHeight && x < this.mapWidth && this.buildable[x][y];
    }

    public boolean isVisible(int x, int y) {
        return x >= 0 && y >= 0 && y < this.mapHeight && x < this.mapWidth && this.visible[x][y];
    }

    public boolean isVisible(TilePosition pos) {
        return this.isVisible(pos.x(), pos.y());
    }

    public boolean isExplored(int x, int y) {
        return x >= 0 && y >= 0 && y < this.mapHeight && x < this.mapWidth && this.explored[x][y];
    }

    public boolean isExplored(TilePosition here) {
        return this.isExplored(here.x(), here.y());
    }

    public boolean hasCreep(int x, int y) {
        return x >= 0 && y >= 0 && y < this.mapHeight && x < this.mapWidth && this.hasCreep[x][y];
    }

    public boolean hadCreep(int x, int y) {
        return x >= 0 && y >= 0 && y < this.mapHeight && x < this.mapWidth && this.hadCreep[x][y];
    }

    public static void readStaticGameDataFromFile(String filename) {
        try {
            FileInputStream input = new FileInputStream("resources/staticGameData.bin");
            GameMessages.StaticGameData data = ((GameMessages.StaticGameData.Builder)GameMessages.StaticGameData.newBuilder().mergeFrom(input)).build();
            UnitType.setUnitTypes(Game.pad(data.getUnitTypesList()));
            WeaponType.setWeapons(Game.pad(data.getWeaponsList()));
            UpgradeType.setUpgrades(Game.pad(data.getUpgradesList()));
            TechType.setTechTypes(Game.pad(data.getTechsList()));
            Race.setRaces(data.getRacesList());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void readStaticGameData(GameMessages.StaticGameData data) {
        this.staticMinerals = this.buildUnitSet(data.getStaticMineralsList());
        this.staticGeysers = this.buildUnitSet(data.getStaticGeysersList());
        this.staticNeutralUnits = this.buildUnitSet(data.getStaticNeutralUnitsList());
        this.mapWidth = data.getMapWidth();
        this.mapHeight = data.getMapHeight();
        this.mapFilename = data.getMapFilename();
        this.mapName = data.getMapName();
        this.mapHash = data.getMapHash();
        this.walkable = this.unpackBitmask(data.getWalkableList(), this.mapWidth * 4, this.mapHeight * 4);
        this.buildable = this.unpackBitmask(data.getBuildableList(), this.mapWidth, this.mapHeight);
        this.groundHeight = new int[this.mapWidth * 4][this.mapHeight * 4];
        int i = 0;
        int x = 0;
        while (x < this.mapWidth * 4) {
            int y = 0;
            while (y < this.mapHeight * 4) {
                this.groundHeight[x][y] = data.getGroundHeight(i++);
                ++y;
            }
            ++x;
        }
        for (BasicTypes.TilePosition start : data.getStartLocationsList()) {
            this.startLocations.add(new TilePosition(start));
        }
        UnitType.setUnitTypes(Game.pad(data.getUnitTypesList()));
        WeaponType.setWeapons(Game.pad(data.getWeaponsList()));
        UpgradeType.setUpgrades(Game.pad(data.getUpgradesList()));
        TechType.setTechTypes(Game.pad(data.getTechsList()));
        Race.setRaces(data.getRacesList());
    }

    private static <T> List<T> pad(List<T> data) {
        if (data.size() == 0) {
            return data;
        }
        ArrayList result = new ArrayList();
        ArrayList<T> r2 = new ArrayList<T>(data);
        try {
            final Method m = data.get(0).getClass().getMethod("getId", new Class[0]);
            Collections.sort(r2, new Comparator<T>(){

                @Override
                public int compare(T arg0, T arg1) {
                    try {
                        int id0 = (Integer)m.invoke(arg0, new Object[0]);
                        return id0 - (Integer)m.invoke(arg1, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("My reflection skills are not what I thought they were.", e);
                    }
                }
            });
            for (Object d : r2) {
                int id = (Integer)m.invoke(d, new Object[0]);
                while (id > result.size()) {
                    result.add(null);
                }
                result.add(d);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("I am not good at reflection.", e);
        }
        return result;
    }

    public void readFrameMessage(Messages.FrameMessage message) {
        this.currentFrameData = message;
        for (GameMessages.Player p : message.getPlayersList()) {
            this.playerManager.getPlayer(p.getId()).setMessage(p);
            if (!p.hasSelf() || !p.getSelf()) continue;
            this.self = this.playerManager.getPlayer(p.getId());
        }
        this.unitsOnTile = new Set[this.mapWidth][this.mapHeight];
        this.pylons = new HashSet<Unit>();
        this.minerals = new HashSet<Unit>();
        this.geysers = new HashSet<Unit>();
        this.neutralUnits = new HashSet<Unit>();
        Set<? extends ROUnit> unitsToWipe = this.unitManager.getAllUnits();
        this.unitManager.clearUnits();
        for (GameMessages.Unit unit : message.getUnitsList()) {
            this.unitManager.setUnitMessage(unit.getTheID().getId(), unit);
            Unit u = new Unit(unit.getTheID().getId());
            this.unitManager.addUnit(u);
            for (TilePosition tilePosition : u.getBuildTilePositions()) {
                if (tilePosition.x() < 0 || u.getTilePosition().x() >= this.mapWidth || u.getTilePosition().y() >= this.mapHeight) continue;
                if (this.unitsOnTile[tilePosition.x()][tilePosition.y()] == null) {
                    this.unitsOnTile[tilePosition.x()][tilePosition.y()] = new HashSet<Unit>();
                }
                this.unitsOnTile[tilePosition.x()][tilePosition.y()].add(u);
            }
            if (u.getType() != null) {
                if (u.getType().getID() == UnitType.PROTOSS_PYLON.getID() && u.isCompleted() && u.getPlayer() != null && u.getPlayer().equals(this.self)) {
                    this.pylons.add(u);
                } else if (u.getType().getID() == UnitType.RESOURCE_MINERAL_FIELD.getID()) {
                    this.minerals.add(u);
                } else if (u.getType().getID() == UnitType.RESOURCE_VESPENE_GEYSER.getID()) {
                    this.geysers.add(u);
                }
            }
            if (u.getPlayer() == null || !u.getPlayer().isNeutral()) continue;
            this.neutralUnits.add(u);
        }
        unitsToWipe.removeAll(this.unitManager.getAllUnits());
        for (ROUnit rOUnit : unitsToWipe) {
            this.unitManager.setUnitMessage(rOUnit.getID(), null);
        }
        this.bullets = new HashSet<Bullet>();
        for (GameMessages.Bullet bullet : message.getBulletsList()) {
            this.bullets.add(new Bullet(bullet));
        }
        this.visible = this.unpackBitmask(message.getDynamicTerrainInfo().getIsVisibleList(), this.mapWidth, this.mapHeight);
        this.explored = this.unpackBitmask(message.getDynamicTerrainInfo().getIsExploredList(), this.mapWidth, this.mapHeight);
        this.hadCreep = this.hasCreep;
        this.hasCreep = this.unpackBitmask(message.getDynamicTerrainInfo().getHasCreepList(), this.mapWidth, this.mapHeight);
        this.hadCreep = this.handleHiddenCreep(this.hadCreep);
        this.selectedUnits = this.buildUnitSet(message.getSelectedUnitsList());
    }

    private boolean[][] handleHiddenCreep(boolean[][] hadCreep) {
        if (hadCreep == null) {
            return this.hasCreep;
        }
        int x = 0;
        while (x < this.mapWidth) {
            int y = 0;
            while (y < this.mapHeight) {
                if (this.visible[x][y]) {
                    hadCreep[x][y] = this.hasCreep[x][y];
                }
                ++y;
            }
            ++x;
        }
        return hadCreep;
    }

    public Player getPlayer(int id) {
        return this.playerManager.getPlayer(id);
    }

    public Messages.FrameCommands.Builder flushCommands() {
        return this.commandManager.flushCommands();
    }

    public void drawText(CoordinateType ctype, int x, int y, String text) {
        DrawCommands.DrawCommand cmd = DrawCommands.DrawCommand.newBuilder().setCoordinateType(ctype.getMessage()).addCoordinates(x).addCoordinates(y).setText(text).setShape(DrawCommands.ShapeType.text).build();
        Game.getInstance().commandManager.addDrawCommand(cmd);
    }

    public void drawText(CoordinateType ctype, Position pos, String text) {
        this.drawText(ctype, pos.x(), pos.y(), text);
    }

    public void drawTextMap(int x, int y, String text) {
        this.drawText(CoordinateType.MAP, x, y, text);
    }

    public void drawTextMap(Position p, String text) {
        this.drawText(CoordinateType.MAP, p, text);
    }

    public void drawTextMouse(int x, int y, String text) {
        this.drawText(CoordinateType.MOUSE, x, y, text);
    }

    public void drawTextMouse(Position p, String text) {
        this.drawText(CoordinateType.MOUSE, p, text);
    }

    public void drawTextScreen(int x, int y, String text) {
        this.drawText(CoordinateType.SCREEN, x, y, text);
    }

    public void drawTextScreen(Position p, String text) {
        this.drawText(CoordinateType.SCREEN, p, text);
    }

    public void drawBox(CoordinateType ctype, int left, int top, int right, int bottom, Color color, boolean isSolid) {
        DrawCommands.DrawCommand cmd = DrawCommands.DrawCommand.newBuilder().setCoordinateType(ctype.getMessage()).addCoordinates(left).addCoordinates(top).addCoordinates(right).addCoordinates(bottom).setColor(color.getMessage()).setIsSolid(isSolid).setShape(DrawCommands.ShapeType.box).build();
        Game.getInstance().commandManager.addDrawCommand(cmd);
    }

    public void drawBox(CoordinateType ctype, Position topLeft, Position bottomRight, Color color, boolean isSolid) {
        this.drawBox(ctype, topLeft.x(), topLeft.y(), bottomRight.x(), bottomRight.y(), color, isSolid);
    }

    public void drawBoxMap(int left, int top, int right, int bottom, Color color, boolean isSolid) {
        this.drawBox(CoordinateType.MAP, left, top, right, bottom, color, isSolid);
    }

    public void drawBoxMouse(int left, int top, int right, int bottom, Color color, boolean isSolid) {
        this.drawBox(CoordinateType.MOUSE, left, top, right, bottom, color, isSolid);
    }

    public void drawBoxScreen(int left, int top, int right, int bottom, Color color, boolean isSolid) {
        this.drawBox(CoordinateType.SCREEN, left, top, right, bottom, color, isSolid);
    }

    public void drawTriangle(CoordinateType ctype, int ax, int ay, int bx, int by, int cx, int cy, Color color, boolean isSolid) {
        DrawCommands.DrawCommand cmd = DrawCommands.DrawCommand.newBuilder().setCoordinateType(ctype.getMessage()).addCoordinates(ax).addCoordinates(ay).addCoordinates(bx).addCoordinates(by).addCoordinates(cx).addCoordinates(cy).setColor(color.getMessage()).setIsSolid(isSolid).setShape(DrawCommands.ShapeType.triangle).build();
        Game.getInstance().commandManager.addDrawCommand(cmd);
    }

    public void drawTriangleMap(int ax, int ay, int bx, int by, int cx, int cy, Color color, boolean isSolid) {
        this.drawTriangle(CoordinateType.MAP, ax, ay, bx, by, cx, cy, color, isSolid);
    }

    public void drawTriangleMouse(int ax, int ay, int bx, int by, int cx, int cy, Color color, boolean isSolid) {
        this.drawTriangle(CoordinateType.MOUSE, ax, ay, bx, by, cx, cy, color, isSolid);
    }

    public void drawTriangleScreen(int ax, int ay, int bx, int by, int cx, int cy, Color color, boolean isSolid) {
        this.drawTriangle(CoordinateType.SCREEN, ax, ay, bx, by, cx, cy, color, isSolid);
    }

    public void drawCircle(CoordinateType ctype, int x, int y, int radius, Color color, boolean isSolid) {
        DrawCommands.DrawCommand cmd = DrawCommands.DrawCommand.newBuilder().setCoordinateType(ctype.getMessage()).addCoordinates(x).addCoordinates(y).addCoordinates(radius).setColor(color.getMessage()).setShape(DrawCommands.ShapeType.circle).setIsSolid(isSolid).build();
        Game.getInstance().commandManager.addDrawCommand(cmd);
    }

    public void drawCircle(CoordinateType ctype, Position p, int radius, Color color, boolean isSolid) {
        this.drawCircle(ctype, p.x(), p.y(), radius, color, isSolid);
    }

    public void drawCircleMap(int x, int y, int radius, Color color, boolean isSolid) {
        this.drawCircle(CoordinateType.MAP, x, y, radius, color, isSolid);
    }

    public void drawCircleMap(Position position, int rad, Color color, boolean fill) {
        this.drawCircleMap(position.x(), position.y(), rad, color, fill);
    }

    public void drawCircleMouse(int x, int y, int radius, Color color, boolean isSolid) {
        this.drawCircle(CoordinateType.MOUSE, x, y, radius, color, isSolid);
    }

    public void drawCircleScreen(int x, int y, int radius, Color color, boolean isSolid) {
        this.drawCircle(CoordinateType.SCREEN, x, y, radius, color, isSolid);
    }

    public void drawEllipse(CoordinateType ctype, Position p, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse(ctype, p.x(), p.y(), xrad, yrad, color, isSolid);
    }

    public void drawEllipse(CoordinateType ctype, int x, int y, int xrad, int yrad, Color color, boolean isSolid) {
        DrawCommands.DrawCommand cmd = DrawCommands.DrawCommand.newBuilder().setCoordinateType(ctype.getMessage()).addCoordinates(x).addCoordinates(y).addCoordinates(xrad).addCoordinates(yrad).setColor(color.getMessage()).setShape(DrawCommands.ShapeType.ellipse).setIsSolid(isSolid).build();
        Game.getInstance().commandManager.addDrawCommand(cmd);
    }

    public void drawEllipseMap(int x, int y, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse(CoordinateType.MAP, x, y, xrad, yrad, color, isSolid);
    }

    public void drawEllipseMouse(int x, int y, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse(CoordinateType.MOUSE, x, y, xrad, yrad, color, isSolid);
    }

    public void drawEllipseScreen(int x, int y, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse(CoordinateType.SCREEN, x, y, xrad, yrad, color, isSolid);
    }

    public void drawDot(CoordinateType ctype, int x, int y, Color color) {
        DrawCommands.DrawCommand cmd = DrawCommands.DrawCommand.newBuilder().setCoordinateType(ctype.getMessage()).addCoordinates(x).addCoordinates(y).setColor(color.getMessage()).setShape(DrawCommands.ShapeType.dot).build();
        Game.getInstance().commandManager.addDrawCommand(cmd);
    }

    public void drawDot(CoordinateType ctype, Position p, Color color) {
        this.drawDot(ctype, p.x(), p.y(), color);
    }

    public void drawDotMap(int x, int y, Color color) {
        this.drawDot(CoordinateType.MAP, x, y, color);
    }

    public void drawDotMouse(int x, int y, Color color) {
        this.drawDot(CoordinateType.MOUSE, x, y, color);
    }

    public void drawDotScreen(int x, int y, Color color) {
        this.drawDot(CoordinateType.SCREEN, x, y, color);
    }

    public void drawLine(CoordinateType ctype, int x1, int y1, int x2, int y2, Color color) {
        DrawCommands.DrawCommand cmd = DrawCommands.DrawCommand.newBuilder().setCoordinateType(ctype.getMessage()).addCoordinates(x1).addCoordinates(y1).addCoordinates(x2).addCoordinates(y2).setColor(color.getMessage()).setShape(DrawCommands.ShapeType.line).build();
        Game.getInstance().commandManager.addDrawCommand(cmd);
    }

    public void drawLine(CoordinateType ctype, Position p1, Position p2, Color color) {
        this.drawLine(ctype, p1.x(), p1.y(), p2.x(), p2.y(), color);
    }

    public void drawLineMap(Position p1, Position p2, Color color) {
        this.drawLine(CoordinateType.MAP, p1.x(), p1.y(), p2.x(), p2.y(), color);
    }

    public void drawLineMap(int x1, int y1, int x2, int y2, Color color) {
        this.drawLine(CoordinateType.MAP, x1, y1, x2, y2, color);
    }

    public void drawLineMouse(Position p1, Position p2, Color color) {
        this.drawLine(CoordinateType.MOUSE, p1.x(), p1.y(), p2.x(), p2.y(), color);
    }

    public void drawLineMouse(int x1, int y1, int x2, int y2, Color color) {
        this.drawLine(CoordinateType.MOUSE, x1, y1, x2, y2, color);
    }

    public void drawLineScreen(int x1, int y1, int x2, int y2, Color color) {
        this.drawLine(CoordinateType.SCREEN, x1, y1, x2, y2, color);
    }

    public void drawLineScreen(Position p1, Position p2, Color color) {
        this.drawLine(CoordinateType.SCREEN, p1.x(), p1.y(), p2.x(), p2.y(), color);
    }

    public void setScreenPosition(int x, int y) {
        this.commandManager.setScreenPosition(x, y);
    }

    public void setScreenPosition(Position p) {
        this.commandManager.setScreenPosition(p.x(), p.y());
    }

    public void printf(String message, Object ... formats) {
        this.commandManager.printfQueue.add(String.format(message, formats));
    }

    public int mapHeight() {
        return this.mapHeight;
    }

    public int mapWidth() {
        return this.mapWidth;
    }

    public void setLocalSpeed(int speed) {
        this.commandManager.setGameSpeed(speed);
    }

    public Set<? extends ROUnit> getSelectedUnits() {
        return this.selectedUnits;
    }

    public Player self() {
        return this.self;
    }

    public void enableFlag(Flag flag) {
        this.commandManager.addFlag(flag.getMessage());
    }

    /*
     * WARNING - void declaration
     */
    public boolean canBuildHere(Unit builder, TilePosition position, UnitType type) {
        int y;
        void var9_11;
        void var8_21;
        if (position.x() < 0 || position.y() < 0) {
            return false;
        }
        int width = type.tileWidth();
        int height = type.tileHeight();
        int upperX = position.x() + width;
        int upperY = position.y() + height;
        if (upperX > Game.getInstance().mapWidth()) {
            return false;
        }
        if (upperY >= Game.getInstance().mapHeight()) {
            return false;
        }
        if (upperY == Game.getInstance().mapHeight() - 1) {
            if (position.x() < 5) {
                return false;
            }
            if (upperX > Game.getInstance().mapWidth() - 5) {
                return false;
            }
        }
        if (type.isRefinery()) {
            for (ROUnit rOUnit : Game.getInstance().getStaticGeysers()) {
                if (!rOUnit.getLastKnownTilePosition().equals(position)) continue;
                return rOUnit.getType().equals(UnitType.RESOURCE_VESPENE_GEYSER);
            }
            return false;
        }
        int n = position.x();
        while (var8_21 < upperX) {
            int n2 = position.y();
            while (n2 < upperY) {
                if (!this.isBuildable((int)var8_21, n2) || !this.isVisible((int)var8_21, n2)) {
                    return false;
                }
                ++n2;
            }
            ++var8_21;
        }
        HashSet<ROUnit> hashSet = new HashSet<ROUnit>();
        int n3 = position.x();
        while (var9_11 < upperX) {
            y = position.y();
            while (y < upperY) {
                hashSet.clear();
                for (ROUnit rOUnit : this.unitsOnTile((int)var9_11, y)) {
                    if (rOUnit.getType().isFlyer() || rOUnit.isLifted()) continue;
                    hashSet.add(rOUnit);
                    if (hashSet.size() <= 1) continue;
                    return false;
                }
                if (!hashSet.isEmpty()) {
                    ROUnit rOUnit = (ROUnit)hashSet.iterator().next();
                    if (builder == null || builder.getID() != rOUnit.getID()) {
                        return false;
                    }
                }
                ++y;
            }
            ++var9_11;
        }
        if (type.getRace().getID() == Race.ZERG.getID()) {
            if (!type.isResourceDepot()) {
                void var9_13;
                int n4 = position.x();
                while (var9_13 < upperX) {
                    y = position.y();
                    while (y < upperY) {
                        if (!this.hasCreep((int)var9_13, y)) {
                            return false;
                        }
                        ++y;
                    }
                    ++var9_13;
                }
            }
        } else {
            void var9_15;
            int n5 = position.x();
            while (var9_15 < upperX) {
                y = position.y();
                while (y < upperY) {
                    if (this.hasCreep((int)var9_15, y)) {
                        return false;
                    }
                    ++y;
                }
                ++var9_15;
            }
        }
        if (type.requiresPsi()) {
            return this.hasPower(position.x(), position.y(), width, height);
        }
        if (type.isResourceDepot()) {
            for (ROUnit rOUnit : this.getMinerals()) {
                if (rOUnit.getInitialTilePosition().x() <= position.x() - 5 || rOUnit.getInitialTilePosition().y() <= position.y() - 4 || rOUnit.getInitialTilePosition().x() >= position.x() + 7 || rOUnit.getInitialTilePosition().y() >= position.y() + 6) continue;
                return false;
            }
            for (ROUnit rOUnit : this.getStaticGeysers()) {
                if (rOUnit.getInitialTilePosition().x() <= position.x() - 7 || rOUnit.getInitialTilePosition().y() <= position.y() - 5 || rOUnit.getInitialTilePosition().x() >= position.x() + 7 || rOUnit.getInitialTilePosition().y() >= position.y() + 6) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canUpgrade(Unit unit, UpgradeType type) {
        if (this.self() == null) {
            return false;
        }
        if (unit != null) {
            if (unit.getPlayer() != this.self()) {
                return false;
            }
            if (unit.getType() != type.whatUpgrades()) {
                return false;
            }
        }
        if (this.self().getUpgradeLevel(type) >= type.maxRepeats()) {
            return false;
        }
        if (this.self().minerals() < type.mineralPriceBase() + type.mineralPriceFactor() * this.self().getUpgradeLevel(type)) {
            return false;
        }
        return this.self().gas() >= type.gasPriceBase() + type.gasPriceFactor() * this.self().getUpgradeLevel(type);
    }

    public boolean canResearch(Unit unit, TechType type) {
        if (this.self() == null) {
            return false;
        }
        if (unit != null) {
            if (unit.getPlayer() != this.self()) {
                return false;
            }
            if (unit.getType() != type.whatResearches()) {
                return false;
            }
        }
        if (this.self().hasResearched(type)) {
            return false;
        }
        if (this.self().minerals() < type.mineralPrice()) {
            return false;
        }
        return this.self().gas() >= type.gasPrice();
    }

    public boolean canMake(Unit builder, UnitType type) {
        if (this.self() == null) {
            return false;
        }
        if (builder != null) {
            int max_amt;
            if (builder.getPlayer() != this.self()) {
                return false;
            }
            if (!builder.getType().equals(type.whatBuilds().getKey())) {
                return false;
            }
            if (builder.getType() == UnitType.PROTOSS_CARRIER) {
                max_amt = 4;
                if (this.self().getUpgradeLevel(UpgradeType.CARRIER_CAPACITY) > 0) {
                    max_amt += 4;
                }
                if (builder.getInterceptorCount() + builder.getTrainingQueue().size() >= max_amt) {
                    return false;
                }
            }
            if (builder.getType() == UnitType.PROTOSS_REAVER) {
                max_amt = 5;
                if (this.self().getUpgradeLevel(UpgradeType.REAVER_CAPACITY) > 0) {
                    max_amt += 5;
                }
                if (builder.getScarabCount() + builder.getTrainingQueue().size() >= max_amt) {
                    return false;
                }
            }
        }
        if (this.self().minerals() < type.mineralPrice()) {
            return false;
        }
        if (this.self().gas() < type.gasPrice()) {
            return false;
        }
        if (type.supplyRequired() > 0 && this.self().supplyTotal() < this.self().supplyUsed() + type.supplyRequired() - type.whatBuilds().getKey().supplyRequired()) {
            return false;
        }
        UnitType addon = UnitType.NONE;
        for (Map.Entry<UnitType, Integer> i : type.requiredUnits().entrySet()) {
            if (!i.getKey().isAddon()) continue;
            addon = i.getKey();
        }
        for (Map.Entry<UnitType, Integer> i : type.requiredUnits().entrySet()) {
            boolean pass = false;
            if (this.self().completedUnitCount(i.getKey()) >= i.getValue()) {
                pass = true;
            }
            if (i.getKey().equals(UnitType.ZERG_HATCHERY)) {
                if (this.self().completedUnitCount(UnitType.ZERG_LAIR) >= i.getValue()) {
                    pass = true;
                }
                if (this.self().completedUnitCount(UnitType.ZERG_HIVE) >= i.getValue()) {
                    pass = true;
                }
            }
            if (i.getKey().equals(UnitType.ZERG_SPIRE) && this.self().completedUnitCount(UnitType.ZERG_GREATER_SPIRE) >= i.getValue()) {
                pass = true;
            }
            if (i.getKey().equals(UnitType.ZERG_LAIR) && this.self().completedUnitCount(UnitType.ZERG_HIVE) >= i.getValue()) {
                pass = true;
            }
            if (pass) continue;
            return false;
        }
        if (!type.requiredTech().equals(TechType.NONE) && !this.self().hasResearched(type.requiredTech())) {
            return false;
        }
        return builder == null || addon == UnitType.NONE || !addon.whatBuilds().getKey().equals(type.whatBuilds().getKey()) || builder.getAddon() != null && builder.getAddon().getType() == addon;
    }

    public boolean hasPower(int x, int y, int tileWidth, int tileHeight) {
        if (!(tileWidth == 2 && tileHeight == 2 || tileWidth == 3 && tileHeight == 2 || tileWidth == 4 && tileHeight == 3)) {
            return false;
        }
        if (tileWidth == 4) {
            ++x;
        }
        block8: for (Unit i : this.pylons) {
            int px = i.getTilePosition().x();
            int py = i.getTilePosition().y();
            int bx = x - px + 7;
            int by = y - py + 4;
            if (bx < 0 || by < 0 || bx > 14 || by > 8) continue;
            switch (by) {
                case 0: {
                    if (bx < 1 || bx > 12) continue block8;
                    return true;
                }
                case 1: {
                    if (bx > 13) break;
                    return true;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return true;
                }
                case 6: {
                    if (bx <= 13) {
                        return true;
                    }
                }
                case 7: {
                    if (bx >= 1 && bx <= 12) {
                        return true;
                    }
                }
                case 8: {
                    if (bx < 4 || bx > 9) continue block8;
                    return true;
                }
            }
        }
        return false;
    }

    public Set<Bullet> getAllBullets() {
        return this.bullets;
    }

    public void setDrawing(boolean master) {
        this.drawing = master;
    }

    public CommandValidator getInvalidator() {
        return this.invalidator;
    }

    public CommandValidator getDefaultValidator() {
        return this.defaultValidator;
    }
}

