/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum ExplosionType {
    NONE(0, "None"),
    NORMAL(1, "Normal"),
    RADIAL_SPLASH(2, "Radial Splash"),
    ENEMY_SPLASH(3, "Enemy Splash"),
    LOCKDOWN(4, "Lockdown"),
    NUCLEAR_MISSILE(5, "Nuclear Missile"),
    PARASITE(6, "Parasite"),
    BROODLINGS(7, "Broodlings"),
    EMP_SHOCKWAVE(8, "EMP Shockwave"),
    IRRADIATE(9, "Irradiate"),
    ENSNARE(10, "Ensnare"),
    PLAGUE(11, "Plague"),
    STASIS_FIELD(12, "Stasis Field"),
    DARK_SWARM(13, "Dark Swarm"),
    CONSUME(14, "Consume"),
    YAMATO_GUN(15, "Yamato Gun"),
    RESTORATION(16, "Restoration"),
    DISRUPTION_WEB(17, "Disruption Web"),
    CORROSIVE_ACID(18, "Corrosive Acid"),
    MIND_CONTROL(19, "Mind Control"),
    FEEDBACK(20, "Feedback"),
    OPTICAL_FLARE(21, "Optical Flare"),
    MAELSTROM(22, "Maelstrom"),
    UNUSED(23, "UNUSED"),
    AIR_SPLASH(24, "Air Splash"),
    UNKNOWN(25, "Unknown");

    protected int id;
    private String name;
    protected static final Map<String, ExplosionType> gNamesToExplosionTypes;
    protected static final Set<ExplosionType> gAllExplosionTypes;
    protected static final ExplosionType[] gIdsToExplosionTypes;

    static {
        gNamesToExplosionTypes = new HashMap<String, ExplosionType>();
        HashSet<ExplosionType> allExplosionTypes = new HashSet<ExplosionType>();
        gIdsToExplosionTypes = new ExplosionType[26];
        gNamesToExplosionTypes.put("None", NONE);
        allExplosionTypes.add(NONE);
        ExplosionType.gIdsToExplosionTypes[0] = NONE;
        gNamesToExplosionTypes.put("Normal", NORMAL);
        allExplosionTypes.add(NORMAL);
        ExplosionType.gIdsToExplosionTypes[1] = NORMAL;
        gNamesToExplosionTypes.put("Radial Splash", RADIAL_SPLASH);
        allExplosionTypes.add(RADIAL_SPLASH);
        ExplosionType.gIdsToExplosionTypes[2] = RADIAL_SPLASH;
        gNamesToExplosionTypes.put("Enemy Splash", ENEMY_SPLASH);
        allExplosionTypes.add(ENEMY_SPLASH);
        ExplosionType.gIdsToExplosionTypes[3] = ENEMY_SPLASH;
        gNamesToExplosionTypes.put("Lockdown", LOCKDOWN);
        allExplosionTypes.add(LOCKDOWN);
        ExplosionType.gIdsToExplosionTypes[4] = LOCKDOWN;
        gNamesToExplosionTypes.put("Nuclear Missile", NUCLEAR_MISSILE);
        allExplosionTypes.add(NUCLEAR_MISSILE);
        ExplosionType.gIdsToExplosionTypes[5] = NUCLEAR_MISSILE;
        gNamesToExplosionTypes.put("Parasite", PARASITE);
        allExplosionTypes.add(PARASITE);
        ExplosionType.gIdsToExplosionTypes[6] = PARASITE;
        gNamesToExplosionTypes.put("Broodlings", BROODLINGS);
        allExplosionTypes.add(BROODLINGS);
        ExplosionType.gIdsToExplosionTypes[7] = BROODLINGS;
        gNamesToExplosionTypes.put("EMP Shockwave", EMP_SHOCKWAVE);
        allExplosionTypes.add(EMP_SHOCKWAVE);
        ExplosionType.gIdsToExplosionTypes[8] = EMP_SHOCKWAVE;
        gNamesToExplosionTypes.put("Irradiate", IRRADIATE);
        allExplosionTypes.add(IRRADIATE);
        ExplosionType.gIdsToExplosionTypes[9] = IRRADIATE;
        gNamesToExplosionTypes.put("Ensnare", ENSNARE);
        allExplosionTypes.add(ENSNARE);
        ExplosionType.gIdsToExplosionTypes[10] = ENSNARE;
        gNamesToExplosionTypes.put("Plague", PLAGUE);
        allExplosionTypes.add(PLAGUE);
        ExplosionType.gIdsToExplosionTypes[11] = PLAGUE;
        gNamesToExplosionTypes.put("Stasis Field", STASIS_FIELD);
        allExplosionTypes.add(STASIS_FIELD);
        ExplosionType.gIdsToExplosionTypes[12] = STASIS_FIELD;
        gNamesToExplosionTypes.put("Dark Swarm", DARK_SWARM);
        allExplosionTypes.add(DARK_SWARM);
        ExplosionType.gIdsToExplosionTypes[13] = DARK_SWARM;
        gNamesToExplosionTypes.put("Consume", CONSUME);
        allExplosionTypes.add(CONSUME);
        ExplosionType.gIdsToExplosionTypes[14] = CONSUME;
        gNamesToExplosionTypes.put("Yamato Gun", YAMATO_GUN);
        allExplosionTypes.add(YAMATO_GUN);
        ExplosionType.gIdsToExplosionTypes[15] = YAMATO_GUN;
        gNamesToExplosionTypes.put("Restoration", RESTORATION);
        allExplosionTypes.add(RESTORATION);
        ExplosionType.gIdsToExplosionTypes[16] = RESTORATION;
        gNamesToExplosionTypes.put("Disruption Web", DISRUPTION_WEB);
        allExplosionTypes.add(DISRUPTION_WEB);
        ExplosionType.gIdsToExplosionTypes[17] = DISRUPTION_WEB;
        gNamesToExplosionTypes.put("Corrosive Acid", CORROSIVE_ACID);
        allExplosionTypes.add(CORROSIVE_ACID);
        ExplosionType.gIdsToExplosionTypes[18] = CORROSIVE_ACID;
        gNamesToExplosionTypes.put("Mind Control", MIND_CONTROL);
        allExplosionTypes.add(MIND_CONTROL);
        ExplosionType.gIdsToExplosionTypes[19] = MIND_CONTROL;
        gNamesToExplosionTypes.put("Feedback", FEEDBACK);
        allExplosionTypes.add(FEEDBACK);
        ExplosionType.gIdsToExplosionTypes[20] = FEEDBACK;
        gNamesToExplosionTypes.put("Optical Flare", OPTICAL_FLARE);
        allExplosionTypes.add(OPTICAL_FLARE);
        ExplosionType.gIdsToExplosionTypes[21] = OPTICAL_FLARE;
        gNamesToExplosionTypes.put("Maelstrom", MAELSTROM);
        allExplosionTypes.add(MAELSTROM);
        ExplosionType.gIdsToExplosionTypes[22] = MAELSTROM;
        gNamesToExplosionTypes.put("Air Splash", AIR_SPLASH);
        allExplosionTypes.add(AIR_SPLASH);
        ExplosionType.gIdsToExplosionTypes[24] = AIR_SPLASH;
        gNamesToExplosionTypes.put("Unknown", UNKNOWN);
        allExplosionTypes.add(UNKNOWN);
        ExplosionType.gIdsToExplosionTypes[25] = UNKNOWN;
        gAllExplosionTypes = Collections.unmodifiableSet(allExplosionTypes);
    }

    private ExplosionType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public final int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static final ExplosionType getExplosionType(String name) {
        return gNamesToExplosionTypes.get(name);
    }

    public static final Set<ExplosionType> allExplosionTypes() {
        return gAllExplosionTypes;
    }

    static final ExplosionType getExplosionTypeFromId(int id) {
        return gIdsToExplosionTypes[id];
    }

    static final int getMaxIdPlusOne() {
        return gIdsToExplosionTypes.length;
    }
}

