/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum DamageType {
    INDEPENDENT(0, "Independent"),
    EXPLOSIVE(1, "Explosive"),
    CONCUSSIVE(2, "Concussive"),
    NORMAL(3, "Normal"),
    IGNORE_ARMOR(4, "Ignore Armor"),
    NONE(5, "None"),
    UNKNOWN(6, "Unknown");

    protected int id;
    protected String name;
    protected static final Map<String, DamageType> gNamesToDamageTypes;
    protected static final Set<DamageType> gAllDamageTypes;
    protected static final DamageType[] gIdsToDamageTypes;

    static {
        gNamesToDamageTypes = new HashMap<String, DamageType>();
        HashSet<DamageType> allDamageTypes = new HashSet<DamageType>();
        gIdsToDamageTypes = new DamageType[7];
        gNamesToDamageTypes.put("Independent", INDEPENDENT);
        allDamageTypes.add(INDEPENDENT);
        DamageType.gIdsToDamageTypes[0] = INDEPENDENT;
        gNamesToDamageTypes.put("Explosive", EXPLOSIVE);
        allDamageTypes.add(EXPLOSIVE);
        DamageType.gIdsToDamageTypes[1] = EXPLOSIVE;
        gNamesToDamageTypes.put("Concussive", CONCUSSIVE);
        allDamageTypes.add(CONCUSSIVE);
        DamageType.gIdsToDamageTypes[2] = CONCUSSIVE;
        gNamesToDamageTypes.put("Normal", NORMAL);
        allDamageTypes.add(NORMAL);
        DamageType.gIdsToDamageTypes[3] = NORMAL;
        gNamesToDamageTypes.put("Ignore Armor", IGNORE_ARMOR);
        allDamageTypes.add(IGNORE_ARMOR);
        DamageType.gIdsToDamageTypes[4] = IGNORE_ARMOR;
        gNamesToDamageTypes.put("None", NONE);
        allDamageTypes.add(NONE);
        DamageType.gIdsToDamageTypes[5] = NONE;
        gNamesToDamageTypes.put("Unknown", UNKNOWN);
        allDamageTypes.add(UNKNOWN);
        DamageType.gIdsToDamageTypes[6] = UNKNOWN;
        gAllDamageTypes = Collections.unmodifiableSet(allDamageTypes);
    }

    private DamageType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public final int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static final DamageType getDamageType(String name) {
        return gNamesToDamageTypes.get(name);
    }

    public static final Set<DamageType> allDamageTypes() {
        return gAllDamageTypes;
    }

    static final DamageType getDamageTypeFromId(int id) {
        return gIdsToDamageTypes[id];
    }
}

