/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.model.UpgradeType;

public interface CommandValidator {
    public boolean canAttackMove(ROUnit var1, Position var2);

    public boolean canAttackUnit(ROUnit var1, ROUnit var2);

    public boolean canBuild(ROUnit var1, TilePosition var2, UnitType var3);

    public boolean canBuildAddon(ROUnit var1, UnitType var2);

    public boolean canBurrow(ROUnit var1);

    public boolean canCancelAddon(ROUnit var1);

    public boolean canCancelConstruction(ROUnit var1);

    public boolean canCancelMorph(ROUnit var1);

    public boolean canCancelResearch(ROUnit var1);

    public boolean canCancelTrain(ROUnit var1);

    public boolean canCancelTrain(ROUnit var1, int var2);

    public boolean canCancelUpgrade(ROUnit var1);

    public boolean canCloak(ROUnit var1);

    public boolean canDecloak(ROUnit var1);

    public boolean canFollow(ROUnit var1, ROUnit var2);

    public boolean canHaltConstruction(ROUnit var1);

    public boolean canHoldPosition(ROUnit var1);

    public boolean canLand(ROUnit var1, TilePosition var2);

    public boolean canLift(ROUnit var1);

    public boolean canLoad(ROUnit var1, ROUnit var2);

    public boolean canMorph(ROUnit var1, UnitType var2);

    public boolean canPatrol(ROUnit var1, Position var2);

    public boolean canRepair(ROUnit var1, ROUnit var2);

    public boolean canResearch(ROUnit var1, TechType var2);

    public boolean canRightClick(ROUnit var1, Position var2);

    public boolean canRightClick(ROUnit var1, ROUnit var2);

    public boolean canSetRallyPosition(ROUnit var1, Position var2);

    public boolean canSetRallyUnit(ROUnit var1, ROUnit var2);

    public boolean canSiege(ROUnit var1);

    public boolean canStop(ROUnit var1);

    public boolean canTrain(ROUnit var1, UnitType var2);

    public boolean canUnburrow(ROUnit var1);

    public boolean canUnload(ROUnit var1, ROUnit var2);

    public boolean canUnloadAll(ROUnit var1);

    public boolean canUnloadAll(ROUnit var1, Position var2);

    public boolean canUnsiege(ROUnit var1);

    public boolean canUpgrade(ROUnit var1, UpgradeType var2);

    public boolean canUseTech(ROUnit var1, TechType var2);

    public boolean canUseTech(ROUnit var1, TechType var2, Position var3);

    public boolean canUseTech(ROUnit var1, TechType var2, ROUnit var3);

    public static class DefaultValidator
    implements CommandValidator {
        private final Game g;

        public DefaultValidator(Game g) {
            this.g = g;
        }

        private boolean canIssueCommand(ROUnit self) {
            return self.getPlayer().equals(this.g.self());
        }

        @Override
        public boolean canAttackMove(ROUnit self, Position position) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canAttackUnit(ROUnit self, ROUnit target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canBuild(ROUnit self, TilePosition position, UnitType type) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canBuildAddon(ROUnit self, UnitType type) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canBurrow(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCancelAddon(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCancelConstruction(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCancelMorph(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCancelResearch(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCancelTrain(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCancelTrain(ROUnit self, int slot) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCancelUpgrade(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCloak(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canDecloak(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canFollow(ROUnit self, ROUnit target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canHaltConstruction(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canHoldPosition(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canLand(ROUnit self, TilePosition position) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canLift(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canLoad(ROUnit self, ROUnit target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canMorph(ROUnit self, UnitType type) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canPatrol(ROUnit self, Position position) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canRepair(ROUnit self, ROUnit target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canResearch(ROUnit self, TechType tech) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canRightClick(ROUnit self, Position position) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canRightClick(ROUnit self, ROUnit target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canSetRallyPosition(ROUnit self, Position target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canSetRallyUnit(ROUnit self, ROUnit target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canSiege(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canStop(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canTrain(ROUnit self, UnitType type) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUnburrow(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUnload(ROUnit self, ROUnit target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUnloadAll(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUnloadAll(ROUnit self, Position position) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUnsiege(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUpgrade(ROUnit self, UpgradeType upgrade) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUseTech(ROUnit self, TechType tech) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUseTech(ROUnit self, TechType tech, Position position) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUseTech(ROUnit self, TechType tech, ROUnit target) {
            return this.canIssueCommand(self);
        }
    }

    public static class Invalidator
    implements CommandValidator {
        private boolean canIssueCommand(ROUnit self) {
            return false;
        }

        @Override
        public boolean canAttackMove(ROUnit self, Position position) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canAttackUnit(ROUnit self, ROUnit target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canBuild(ROUnit self, TilePosition position, UnitType type) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canBuildAddon(ROUnit self, UnitType type) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canBurrow(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCancelAddon(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCancelConstruction(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCancelMorph(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCancelResearch(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCancelTrain(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCancelTrain(ROUnit self, int slot) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCancelUpgrade(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canCloak(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canDecloak(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canFollow(ROUnit self, ROUnit target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canHaltConstruction(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canHoldPosition(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canLand(ROUnit self, TilePosition position) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canLift(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canLoad(ROUnit self, ROUnit target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canMorph(ROUnit self, UnitType type) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canPatrol(ROUnit self, Position position) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canRepair(ROUnit self, ROUnit target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canResearch(ROUnit self, TechType tech) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canRightClick(ROUnit self, Position position) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canRightClick(ROUnit self, ROUnit target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canSetRallyPosition(ROUnit self, Position target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canSetRallyUnit(ROUnit self, ROUnit target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canSiege(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canStop(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canTrain(ROUnit self, UnitType type) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUnburrow(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUnload(ROUnit self, ROUnit target) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUnloadAll(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUnloadAll(ROUnit self, Position position) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUnsiege(ROUnit self) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUpgrade(ROUnit self, UpgradeType upgrade) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUseTech(ROUnit self, TechType tech) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUseTech(ROUnit self, TechType tech, Position position) {
            return this.canIssueCommand(self);
        }

        @Override
        public boolean canUseTech(ROUnit self, TechType tech, ROUnit target) {
            return this.canIssueCommand(self);
        }
    }
}

