/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.LinkedList;
import java.util.Queue;
import org.bwapi.proxy.messages.BasicTypes;
import org.bwapi.proxy.messages.Commands;
import org.bwapi.proxy.messages.DrawCommands;
import org.bwapi.proxy.messages.Messages;
import org.bwapi.proxy.model.Game;

class CommandManager {
    Queue<Commands.Command> commandQueue = new LinkedList<Commands.Command>();
    Queue<DrawCommands.DrawCommand> drawCommandQueue = new LinkedList<DrawCommands.DrawCommand>();
    Queue<String> sendTextQueue = new LinkedList<String>();
    Queue<String> printfQueue = new LinkedList<String>();
    Queue<Messages.Flag> flagQueue = new LinkedList<Messages.Flag>();
    private boolean changedGameSpeed = false;
    private int newGameSpeed;
    private BasicTypes.Position screenPosition;

    CommandManager() {
    }

    void addCommand(Commands.Command c) {
        this.commandQueue.add(c);
    }

    void addDrawCommand(DrawCommands.DrawCommand c) {
        this.drawCommandQueue.add(c);
    }

    void setGameSpeed(int speed) {
        this.newGameSpeed = speed;
        this.changedGameSpeed = true;
    }

    void addSendText(String text) {
        this.sendTextQueue.add(text);
    }

    void addPrintf(String printf) {
        this.printfQueue.add(printf);
    }

    void addFlag(Messages.Flag f) {
        this.flagQueue.add(f);
    }

    Messages.FrameCommands.Builder flushCommands() {
        Messages.FrameCommands.Builder b = Messages.FrameCommands.newBuilder();
        b.addAllCommands(this.commandQueue);
        this.commandQueue.clear();
        if (this.changedGameSpeed) {
            b.setGameSpeed(this.newGameSpeed);
            this.changedGameSpeed = false;
        }
        b.addAllSendText(this.sendTextQueue);
        this.sendTextQueue.clear();
        b.addAllPrintf(this.printfQueue);
        this.printfQueue.clear();
        b.addAllFlags(this.flagQueue);
        this.flagQueue.clear();
        if (Game.getInstance().isDrawing()) {
            b.addAllDrawCommands(this.drawCommandQueue);
        }
        this.drawCommandQueue.clear();
        if (this.screenPosition != null) {
            b.setScreenPosition(this.screenPosition);
            this.screenPosition = null;
        }
        return b;
    }

    public void setScreenPosition(int x, int y) {
        this.screenPosition = BasicTypes.Position.newBuilder().setX(x).setY(y).build();
    }
}

