/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.ArrayList;
import org.bwapi.proxy.messages.DrawCommands;

public final class Color {
    private static final int NUM_COLORS = 256;
    private static final int[] palette;
    public static final Color BLACK;
    public static final Color BLUE;
    public static final Color CYAN;
    public static final Color GREEN;
    public static final Color GREY;
    public static final Color ORANGE;
    public static final Color PURPLE;
    public static final Color RED;
    public static final Color WHITE;
    public static final Color YELLOW;
    private static final ArrayList<Integer>[][][] cell;
    private final int id;

    static {
        int[] nArray = new int[256];
        nArray[14] = 0x3A003A;
        nArray[15] = 0x190019;
        nArray[16] = 2892824;
        nArray[17] = 4727828;
        nArray[18] = 6040596;
        nArray[19] = 7352340;
        nArray[20] = 6831140;
        nArray[21] = 8142872;
        nArray[22] = 7883820;
        nArray[23] = 0xA80808;
        nArray[24] = 9196592;
        nArray[25] = 8675396;
        nArray[26] = 10507292;
        nArray[27] = 12864536;
        nArray[28] = 12347428;
        nArray[29] = 11825212;
        nArray[30] = 13657120;
        nArray[31] = 14455860;
        nArray[32] = 14718036;
        nArray[33] = 15516756;
        nArray[34] = 3425320;
        nArray[35] = 4222012;
        nArray[36] = 4746320;
        nArray[37] = 5013584;
        nArray[38] = 5278812;
        nArray[39] = 6070392;
        nArray[40] = 24;
        nArray[41] = 4148;
        nArray[42] = 2128;
        nArray[43] = 2372680;
        nArray[44] = 3162196;
        nArray[45] = 1324156;
        nArray[46] = 3427436;
        nArray[47] = 4216948;
        nArray[48] = 4745356;
        nArray[49] = 28828;
        nArray[50] = 5800100;
        nArray[51] = 4221140;
        nArray[52] = 1617080;
        nArray[53] = 2368764;
        nArray[54] = 6591676;
        nArray[55] = 7383244;
        nArray[56] = 9224408;
        nArray[57] = 9755892;
        nArray[58] = 11328744;
        nArray[59] = 0xACFCFC;
        nArray[60] = 0xCCF8F8;
        nArray[61] = 0xFCFC00;
        nArray[62] = 16049296;
        nArray[63] = 0xFCFCC0;
        nArray[64] = 789516;
        nArray[65] = 1578000;
        nArray[66] = 1842208;
        nArray[67] = 2631728;
        nArray[68] = 3682340;
        nArray[69] = 3685444;
        nArray[70] = 4997168;
        nArray[71] = 0x4C4C4C;
        nArray[72] = 6049856;
        nArray[73] = 0x585858;
        nArray[74] = 0x686868;
        nArray[75] = 7898220;
        nArray[76] = 6853740;
        nArray[77] = 7644284;
        nArray[78] = 9999500;
        nArray[79] = 9484436;
        nArray[80] = 10011816;
        nArray[81] = 0xB0B0B0;
        nArray[82] = 11324592;
        nArray[83] = 12894396;
        nArray[84] = 13426896;
        nArray[85] = 0xF0F0F0;
        nArray[86] = 1839112;
        nArray[87] = 2627596;
        nArray[88] = 3411976;
        nArray[89] = 3416076;
        nArray[90] = 3674144;
        nArray[91] = 3418144;
        nArray[92] = 4469768;
        nArray[93] = 4730904;
        nArray[94] = 0x600000;
        nArray[95] = 5515296;
        nArray[96] = 5259284;
        nArray[97] = 6050836;
        nArray[98] = 0x840404;
        nArray[99] = 6835252;
        nArray[100] = 8140848;
        nArray[101] = 7365664;
        nArray[102] = 8147024;
        nArray[103] = 10761244;
        nArray[104] = 9726976;
        nArray[105] = 9985088;
        nArray[106] = 9207860;
        nArray[107] = 9991252;
        nArray[108] = 12080196;
        nArray[109] = 11571224;
        nArray[110] = 11564124;
        nArray[111] = 0xF40404;
        nArray[112] = 13138004;
        nArray[113] = 16541780;
        nArray[114] = 14722180;
        nArray[115] = 16553064;
        nArray[116] = 0xFCCC2C;
        nArray[117] = 1113112;
        nArray[118] = 786464;
        nArray[119] = 0x1C1C2C;
        nArray[120] = 0x24244C;
        nArray[121] = 2632808;
        nArray[122] = 2896004;
        nArray[123] = 2103480;
        nArray[124] = 3423404;
        nArray[125] = 6842516;
        nArray[126] = 6590716;
        nArray[127] = 8170748;
        nArray[128] = 58620;
        nArray[129] = 10260544;
        nArray[130] = 11048020;
        nArray[131] = 12362844;
        nArray[132] = 13416544;
        nArray[133] = 15259776;
        nArray[134] = 15516848;
        nArray[135] = 16579640;
        nArray[136] = 0xFCFC7C;
        nArray[137] = 16579748;
        nArray[138] = 526344;
        nArray[139] = 0x101010;
        nArray[140] = 0x181818;
        nArray[141] = 0x282828;
        nArray[142] = 0x343434;
        nArray[143] = 4996152;
        nArray[144] = 0x444444;
        nArray[145] = 0x484858;
        nArray[146] = 0x585868;
        nArray[147] = 7628856;
        nArray[148] = 7890012;
        nArray[149] = 6316156;
        nArray[150] = 0x847474;
        nArray[151] = 8684700;
        nArray[152] = 11308156;
        nArray[153] = 11311252;
        nArray[154] = 9474232;
        nArray[155] = 0xB8B8E8;
        nArray[156] = 16288788;
        nArray[157] = 1070140;
        nArray[158] = 2134128;
        nArray[159] = 2929812;
        nArray[160] = 270436;
        nArray[161] = 4725840;
        nArray[162] = 537752;
        nArray[163] = 6828152;
        nArray[164] = 8929436;
        nArray[165] = 805068;
        nArray[166] = 12367924;
        nArray[167] = 0xDCDC3C;
        nArray[168] = 0x100000;
        nArray[169] = 0x240000;
        nArray[170] = 0x340000;
        nArray[171] = 0x480000;
        nArray[172] = 6297604;
        nArray[173] = 9185288;
        nArray[174] = 0xC81818;
        nArray[175] = 14691372;
        nArray[176] = 15212576;
        nArray[177] = 15224852;
        nArray[178] = 16523296;
        nArray[179] = 15235108;
        nArray[180] = 16297020;
        nArray[181] = 5120;
        nArray[182] = 10240;
        nArray[183] = 17408;
        nArray[184] = 25600;
        nArray[185] = 557064;
        nArray[186] = 2398244;
        nArray[187] = 0x3C9C3C;
        nArray[188] = 5812312;
        nArray[189] = 0x68B868;
        nArray[190] = 8438912;
        nArray[191] = 0x94D494;
        nArray[192] = 791588;
        nArray[193] = 2374756;
        nArray[194] = 3166340;
        nArray[195] = 3693716;
        nArray[196] = 4748468;
        nArray[197] = 5539012;
        nArray[198] = 6329556;
        nArray[199] = 7910636;
        nArray[200] = 1314824;
        nArray[201] = 1577996;
        nArray[202] = 2370572;
        nArray[203] = 0x101018;
        nArray[204] = 1315872;
        nArray[205] = 2894912;
        nArray[206] = 4476008;
        nArray[207] = 263172;
        nArray[208] = 1841168;
        nArray[209] = 2104340;
        nArray[210] = 2367516;
        nArray[211] = 3155996;
        nArray[212] = 4208684;
        nArray[213] = 5523512;
        nArray[214] = 6839372;
        nArray[215] = 9469028;
        nArray[216] = 2629652;
        nArray[217] = 3155988;
        nArray[218] = 3419160;
        nArray[219] = 3681308;
        nArray[220] = 3944476;
        nArray[221] = 4470820;
        nArray[222] = 5522480;
        nArray[223] = 790532;
        nArray[224] = 1316868;
        nArray[225] = 1580040;
        nArray[226] = 1843208;
        nArray[227] = 2106380;
        nArray[228] = 2896912;
        nArray[229] = 3423248;
        nArray[230] = 4212752;
        nArray[231] = 0x202030;
        nArray[232] = 2631740;
        nArray[233] = 3159112;
        nArray[234] = 0x141414;
        nArray[235] = 2103324;
        nArray[236] = 2629656;
        nArray[237] = 2366500;
        nArray[238] = 0x282424;
        nArray[239] = 3157036;
        nArray[240] = 3943476;
        nArray[241] = 0x3C383C;
        nArray[242] = 4734000;
        nArray[243] = 0x443440;
        nArray[244] = 5258312;
        nArray[245] = 6049844;
        nArray[246] = 0x2323FF;
        nArray[247] = 0x2323FF;
        nArray[255] = 0xFFFFFF;
        palette = nArray;
        BLACK = new Color(0);
        BLUE = new Color(246);
        CYAN = new Color(128);
        GREEN = new Color(117);
        GREY = new Color(74);
        ORANGE = new Color(179);
        PURPLE = new Color(163);
        RED = new Color(111);
        WHITE = new Color(255);
        YELLOW = new Color(61);
        cell = new ArrayList[8][8][8];
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 8) {
                int k = 0;
                while (k < 8) {
                    Color.cell[i][j][k] = new ArrayList();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 256) {
            int redCell = palette[i] >>> 21 & 7;
            int greenCell = palette[i] >>> 13 & 7;
            int blueCell = palette[i] >>> 5 & 7;
            cell[redCell][greenCell][blueCell].add(i);
            ++i;
        }
    }

    public Color(int id) {
        this.id = id;
    }

    public Color(int red, int green, int blue) {
        int redCell = red >>> 5;
        int greenCell = green >>> 5;
        int blueCell = blue >>> 5;
        int redCellS = Math.max(redCell - 1, 0);
        int redCellF = Math.min(redCell + 1, 7);
        int greenCellS = Math.max(greenCell - 1, 0);
        int greenCellF = Math.min(greenCell + 1, 7);
        int blueCellS = Math.max(blueCell - 1, 0);
        int blueCellF = Math.min(blueCell + 1, 7);
        int min_dist = 196608;
        int best_id = -1;
        int rc = redCellS;
        while (rc <= redCellF) {
            int gc2 = greenCellS;
            while (gc2 <= greenCellF) {
                int bc = blueCellS;
                while (bc <= blueCellF) {
                    ArrayList<Integer> intList = cell[rc][gc2][bc];
                    int i = 0;
                    while (i < intList.size()) {
                        int iblue;
                        int igreen;
                        int id = intList.get(i);
                        int ired = palette[id] >>> 16 & 0xFF;
                        int distance = (red - ired) * (red - ired) + (green - (igreen = palette[id] >>> 8 & 0xFF)) * (green - igreen) + (blue - (iblue = palette[id] >>> 0 & 0xFF)) * (blue - iblue);
                        if (distance < min_dist) {
                            min_dist = distance;
                            best_id = id;
                        }
                        ++i;
                    }
                    ++bc;
                }
                ++gc2;
            }
            ++rc;
        }
        if (best_id == -1) {
            min_dist = 196608;
            best_id = -1;
            int id = 0;
            while (id < 255) {
                int ired = palette[id] >>> 16 & 0xFF;
                int igreen = palette[id] >>> 8 & 0xFF;
                int iblue = palette[id] >>> 0 & 0xFF;
                int distance = (red - ired) * (red - ired) + (green - igreen) * (green - igreen) + (blue - iblue) * (blue - iblue);
                if (distance < min_dist) {
                    min_dist = distance;
                    best_id = id;
                }
                ++id;
            }
        }
        this.id = best_id;
    }

    public final int getID() {
        return this.id;
    }

    public final int red() {
        return palette[this.id] >>> 16 & 0xFF;
    }

    public final int green() {
        return palette[this.id] >>> 8 & 0xFF;
    }

    public final int blue() {
        return palette[this.id] & 0xFF;
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Color)) {
            return false;
        }
        Color c = (Color)obj;
        return this.id == c.id;
    }

    public final int hashCode() {
        return this.id;
    }

    DrawCommands.Color getMessage() {
        DrawCommands.Color.Builder b = DrawCommands.Color.newBuilder();
        b.setId(this.id);
        return b.build();
    }
}

