/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bwapi.proxy.messages.TerrainMessages;
import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Chokepoint;
import org.bwapi.proxy.model.Polygon;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;

public class Bwta {
    private static Bwta instance = new Bwta();
    private Set<Region> regions = new HashSet<Region>();
    private Set<Chokepoint> chokepoints = new HashSet<Chokepoint>();
    private Set<BaseLocation> baselocations = new HashSet<BaseLocation>();
    private Set<Polygon> unwalkablePolygons = new HashSet<Polygon>();
    private Set<BaseLocation> startLocations = new HashSet<BaseLocation>();
    private boolean analyzed = false;
    List<Region> regionsList = new ArrayList<Region>();
    List<Chokepoint> chokepointsList = new ArrayList<Chokepoint>();
    List<BaseLocation> baselocationsList = new ArrayList<BaseLocation>();
    List<Polygon> unwalkablePolygonsList = new ArrayList<Polygon>();

    private Bwta() {
    }

    public static Bwta getInstance() {
        return instance;
    }

    public boolean isAnalyzed() {
        return this.analyzed;
    }

    public Set<Region> getRegions() {
        return this.regions;
    }

    public Set<Chokepoint> getChokepoints() {
        return this.chokepoints;
    }

    public Set<BaseLocation> getBaseLocations() {
        return this.baselocations;
    }

    public Set<Polygon> getUnwalkablePolygons() {
        return this.unwalkablePolygons;
    }

    public void setTerrainData(TerrainMessages.StaticTerrainInfo data) {
        Object bl;
        this.analyzed = true;
        for (TerrainMessages.Region region : data.getRegionsList()) {
            Region r = new Region(region, this);
            this.regions.add(r);
            this.regionsList.add(r);
        }
        Collections.sort(this.regionsList, new Comparator<Region>(){

            @Override
            public int compare(Region arg0, Region arg1) {
                return arg0.id - arg1.id;
            }
        });
        for (TerrainMessages.BaseLocation baseLocation : data.getBaseLocationsList()) {
            bl = new BaseLocation(baseLocation, this);
            this.baselocations.add((BaseLocation)bl);
            this.baselocationsList.add((BaseLocation)bl);
        }
        Collections.sort(this.baselocationsList, new Comparator<BaseLocation>(){

            @Override
            public int compare(BaseLocation arg0, BaseLocation arg1) {
                return arg0.id - arg1.id;
            }
        });
        for (TerrainMessages.Polygon polygon : data.getUnwalkablePolygonList()) {
            bl = new Polygon(polygon);
            this.unwalkablePolygons.add((Polygon)bl);
        }
        for (TerrainMessages.Chokepoint chokepoint : data.getChokepointsList()) {
            bl = new Chokepoint(chokepoint, this);
            this.chokepoints.add((Chokepoint)bl);
            this.chokepointsList.add((Chokepoint)bl);
        }
        Collections.sort(this.chokepointsList, new Comparator<Chokepoint>(){

            @Override
            public int compare(Chokepoint arg0, Chokepoint arg1) {
                return arg0.id - arg1.id;
            }
        });
        Iterator<Object> iterator = data.getStartLocationsList().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.startLocations.add(this.baselocationsList.get(n));
        }
    }

    public Set<BaseLocation> getStartLocations() {
        return this.startLocations;
    }

    static <C> Set<C> wrap(List<C> chokepointsList, List<Integer> ind) {
        HashSet<C> ret = new HashSet<C>();
        for (int i : ind) {
            ret.add(chokepointsList.get(i));
        }
        return ret;
    }

    public BaseLocation getNearestBaseLocation(TilePosition pos) {
        double minDistance = Double.MAX_VALUE;
        BaseLocation best = null;
        for (BaseLocation l : this.baselocations) {
            double d = pos.getDistance(l.getTilePosition());
            if (!(d < minDistance)) continue;
            best = l;
            minDistance = d;
        }
        return best;
    }
}

