/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy.model;

import java.util.HashSet;
import java.util.Set;
import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.messages.TerrainMessages;
import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;

public class BaseLocation {
    private TerrainMessages.BaseLocation loc;
    final int id;
    private Bwta bwta;

    public BaseLocation(TerrainMessages.BaseLocation loc, Bwta bwta) {
        this.loc = loc;
        this.bwta = bwta;
        this.id = loc.getId();
    }

    public Position getPosition() {
        return new Position(this.loc.getPosition());
    }

    public TilePosition getTilePosition() {
        return new TilePosition(this.loc.getTilePosition());
    }

    public Region getRegion() {
        return this.bwta.regionsList.get(this.loc.getRegion());
    }

    public int minerals() {
        return this.loc.getNumMinerals();
    }

    public int gas() {
        return this.loc.getNumGas();
    }

    public Set<? extends ROUnit> getMinerals() {
        HashSet<Unit> minerals = new HashSet<Unit>();
        for (GameMessages.UnitId u : this.loc.getMineralsList()) {
            minerals.add(new Unit(u.getId()));
        }
        return minerals;
    }

    public Set<? extends ROUnit> getStaticMinerals() {
        HashSet<Unit> minerals = new HashSet<Unit>();
        for (GameMessages.UnitId u : this.loc.getStaticMineralsList()) {
            minerals.add(new Unit(u.getId()));
        }
        return minerals;
    }

    public Set<? extends ROUnit> getGeysers() {
        HashSet<Unit> geysers = new HashSet<Unit>();
        for (GameMessages.UnitId u : this.loc.getGeysersList()) {
            geysers.add(new Unit(u.getId()));
        }
        return geysers;
    }

    public boolean isIsland() {
        return this.loc.getIsland();
    }

    public boolean isMineralOnly() {
        return this.loc.getMineralOnly();
    }

    public boolean isStartLocation() {
        return this.loc.getStartLocation();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.loc.getId();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseLocation other = (BaseLocation)obj;
        return other.loc.getId() == this.loc.getId();
    }
}

