/*
 * Decompiled with CFR 0.152.
 */
package org.bwapi.proxy;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Message;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bwapi.proxy.ProxyBot;
import org.bwapi.proxy.ProxyBotFactory;
import org.bwapi.proxy.messages.BasicTypes;
import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.messages.Messages;
import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.util.Pair;

public class ProxyServer
implements Runnable {
    public static final int PORT_BASE = 12345;
    private final ProxyBotFactory factory;
    private final int port;
    private final String heartbeatFilename;
    private int myCurrentFrameNum = 0;
    private final Set<Integer> myPreviousVisibleUnitIds = new HashSet<Integer>();
    private final Set<Integer> myCurrentVisibleUnitIds = new HashSet<Integer>();

    public ProxyServer(ProxyBotFactory factory, int port, String heartbeatFilename) {
        this.port = port;
        this.factory = factory;
        this.heartbeatFilename = heartbeatFilename;
    }

    public static void main(String[] args) {
        ProxyBotFactory factory = ProxyServer.getFactory(args);
        int port = ProxyServer.extractPort(args.length > 0 ? args[0] : null);
        String heartbeatFilename = args.length > 1 ? args[1] : null;
        new ProxyServer(factory, port, heartbeatFilename).run();
    }

    public static int extractPort(String arg) {
        int port = 12345;
        if (arg != null) {
            int extra = Integer.parseInt(arg);
            port = extra < 16 ? (port += extra) : extra;
        }
        return port;
    }

    private static ProxyBotFactory getFactory(String[] args) {
        if (args.length == 0) {
            throw new RuntimeException("Need to specify a ProxyBotFactory class as a command-line argument!");
        }
        try {
            return (ProxyBotFactory)Class.forName(args[0]).newInstance();
        }
        catch (Exception e) {
            System.out.println("Could not instantiate an object of class " + args[0]);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        block19: {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(this.port);
                serverSocket.setSoTimeout(2000);
                while (!Thread.interrupted()) {
                    System.out.println("Waiting for client connection");
                    while (!Thread.interrupted()) {
                        try {
                            Socket clientSocket = serverSocket.accept();
                            System.out.println(clientSocket.isConnected());
                            System.out.println("Client connected");
                            this.runGame(clientSocket);
                            return;
                        }
                        catch (SocketTimeoutException clientSocket) {
                            try {
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break block19;
                        }
                    }
                }
            }
            finally {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private <T> T readMessage(InputStream input, AbstractMessage.Builder<?> b) throws IOException {
        b.mergeDelimitedFrom(input);
        return (T)b.build();
    }

    byte[] intToBytes(int i) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(i);
        return bb.array();
    }

    private void writeMessage(OutputStream output, Message m) throws IOException {
        output.write(this.intToBytes(m.getSerializedSize()));
        m.writeTo(output);
        output.flush();
    }

    private void runGame(Socket socket) {
        long frameRead = 0L;
        long frameProcess = 0L;
        long frameWrite = 0L;
        long between = 0L;
        double frameSize = 0.0;
        double responseSize = 0.0;
        long onFrameTime = 0L;
        ProxyBot bot = null;
        try {
            long start = System.currentTimeMillis();
            BufferedInputStream input = new BufferedInputStream(socket.getInputStream(), 51200);
            BufferedOutputStream output = new BufferedOutputStream(socket.getOutputStream(), 51200);
            GameMessages.StaticGameData data = (GameMessages.StaticGameData)this.readMessage(input, GameMessages.StaticGameData.newBuilder());
            this.myPreviousVisibleUnitIds.clear();
            this.myCurrentVisibleUnitIds.clear();
            this.myCurrentFrameNum = 0;
            start = System.currentTimeMillis();
            Game g = Game.getInstance();
            g.init();
            g.readStaticGameData(data);
            start = System.currentTimeMillis();
            this.writeMessage(output, BasicTypes.BoxedBoolean.newBuilder().setIsWinner(false).build());
            start = System.currentTimeMillis();
            String botName = null;
            String botCode = null;
            boolean won = false;
            while (!Thread.interrupted()) {
                block21: {
                    between += System.currentTimeMillis() - start;
                    start = System.currentTimeMillis();
                    Messages.FrameMessage frame = (Messages.FrameMessage)this.readMessage(input, Messages.FrameMessage.newBuilder());
                    frameSize += (double)frame.getSerializedSize() / 1024.0;
                    frameRead += System.currentTimeMillis() - start;
                    start = System.currentTimeMillis();
                    if (frame.hasTerrainInfo()) {
                        Bwta.getInstance().setTerrainData(frame.getTerrainInfo());
                    }
                    g.readFrameMessage(frame);
                    frameProcess += System.currentTimeMillis() - start;
                    start = System.currentTimeMillis();
                    if (bot == null) {
                        bot = this.factory.getBot(g);
                        Pair<String, String> pair = this.inferBotName(bot.getClass());
                        if (pair != null) {
                            botName = pair.getFirst();
                            botCode = pair.getSecond();
                        }
                        bot.onStart();
                    }
                    this.processCallbacks(frame, bot, g);
                    if (frame.getGameover()) {
                        won = frame.hasIsWinner() && frame.getIsWinner();
                        bot.onEnd(won);
                        break;
                    }
                    bot.onFrame();
                    if (this.heartbeatFilename != null && this.myCurrentFrameNum % 100 == 0) {
                        PrintWriter pw = null;
                        try {
                            try {
                                pw = new PrintWriter(this.heartbeatFilename);
                                Player p = g.self();
                                pw.println("Frame number: " + this.myCurrentFrameNum);
                                pw.println("Supply: " + p.supplyUsed() + "/" + p.supplyTotal());
                                HashSet<UnitType> types = new HashSet<UnitType>();
                                for (ROUnit rOUnit : p.getUnits()) {
                                    UnitType type = rOUnit.getType();
                                    if (types.contains(type)) continue;
                                    types.add(type);
                                    pw.println(String.valueOf(type.getName()) + ": " + p.allUnitCount(type));
                                }
                            }
                            catch (Exception e) {
                                System.out.println("Couldn't write game status to file " + this.heartbeatFilename);
                                if (pw != null) {
                                    pw.close();
                                }
                                break block21;
                            }
                        }
                        catch (Throwable throwable) {
                            if (pw != null) {
                                pw.close();
                            }
                            throw throwable;
                        }
                        if (pw != null) {
                            pw.close();
                        }
                    }
                }
                onFrameTime += System.currentTimeMillis() - start;
                start = System.currentTimeMillis();
                Messages.FrameCommands.Builder cb = g.flushCommands();
                if (botName != null) {
                    cb.setBotName(botName);
                    cb.setBotCode(botCode);
                }
                Messages.FrameCommands commands = cb.build();
                this.writeMessage(output, commands);
                responseSize += (double)commands.getSerializedSize() / 1024.0;
                frameWrite += System.currentTimeMillis() - start;
                ((OutputStream)output).flush();
                ++this.myCurrentFrameNum;
                start = System.currentTimeMillis();
            }
            if (Thread.interrupted()) {
                System.out.println("Thread Interrupted.");
                return;
            }
            bot = null;
            System.out.println("Game Ended");
        }
        catch (SocketException e) {
            System.out.println("StarCraft has disconnected");
            if (bot != null) {
                bot.onDroppedConnection();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Pair<String, String> inferBotName(Class<?> clss) {
        InputStream strm = clss.getResourceAsStream("/proxy-info.txt");
        if (strm == null) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(strm));
            String name = reader.readLine().trim();
            String code = reader.readLine().trim();
            strm.close();
            return Pair.makePair(name, code);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void processCallbacks(Messages.FrameMessage frame, ProxyBot bot, Game g) {
        for (String sentText : frame.getSentTextList()) {
            bot.onSendText(sentText);
        }
        for (Messages.PlayerText pt : frame.getReceivedTextsList()) {
            bot.onReceiveText(g.getPlayer(pt.getPlayer()), pt.getText());
        }
        Iterator<Object> iterator = frame.getLeftplayersList().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            bot.onPlayerLeft(g.getPlayer(id));
        }
        this.processUnitCallbacksByProxy(frame, bot, g);
        if (frame.hasNukeDetect()) {
            bot.onNukeDetect(new Position(frame.getNukeDetect().getX(), frame.getNukeDetect().getY()));
        }
    }

    private void processUnitCallbacksByProxy(Messages.FrameMessage frame, ProxyBot bot, Game game) {
        for (GameMessages.UnitId u : frame.getCreatedUnitsList()) {
            bot.onUnitCreate(new Unit(u.getId()));
        }
        for (GameMessages.UnitId u : frame.getShownUnitsList()) {
            bot.onUnitShow(new Unit(u.getId()));
        }
        for (GameMessages.UnitId u : frame.getRenegadedUnitsList()) {
            bot.onUnitRenegade(new Unit(u.getId()));
        }
        for (GameMessages.UnitId u : frame.getMorphedUnitsList()) {
            bot.onUnitMorph(new Unit(u.getId()));
        }
        for (GameMessages.UnitId u : frame.getHiddenUnitsList()) {
            bot.onUnitHide(new Unit(u.getId()));
        }
        for (GameMessages.UnitId u : frame.getDestroyedUnitsList()) {
            bot.onUnitDestroy(new Unit(u.getId()));
        }
    }
}

