/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.starcraft.util;

import java.util.Set;
import org.bwapi.proxy.model.Position;

public class Vector {
    public static final Vector ZERO = new Vector(0.0, 0.0);
    public static final Vector[] ALLDIRS = new Vector[]{new Vector(-1.0, -1.0), new Vector(-1.0, 0.0), new Vector(-1.0, 1.0), new Vector(0.0, -1.0), new Vector(0.0, 0.0), new Vector(0.0, 1.0), new Vector(1.0, -1.0), new Vector(1.0, 0.0), new Vector(1.0, 1.0)};
    public double dx;
    public double dy;

    public Vector(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public Vector(Position pos) {
        this.dx = pos.x();
        this.dy = pos.y();
    }

    public Vector(Position from, Position to) {
        this.dx = to.x() - from.x();
        this.dy = to.y() - from.y();
    }

    public Vector rotateCCWInPlace(double angle) {
        double tmpdx = Math.cos(angle) * this.dx - Math.sin(angle) * this.dy;
        this.dy = Math.sin(angle) * this.dx + Math.cos(angle) * this.dy;
        this.dx = tmpdx;
        return this;
    }

    public Vector rotateCCW(double angle) {
        return new Vector(Math.cos(angle) * this.dx - Math.sin(angle) * this.dy, Math.sin(angle) * this.dx + Math.cos(angle) * this.dy);
    }

    public Vector extendToward(Vector other, double scale) {
        return other.sub(this).normalize(scale).add(this);
    }

    public double distanceTo(Position p) {
        return this.distanceTo(p.x(), p.y());
    }

    public double length() {
        return Math.sqrt(this.dx * this.dx + this.dy * this.dy);
    }

    public double distanceTo(Vector other) {
        return this.distanceTo(other.dx, other.dy);
    }

    public double distanceTo(double x, double y) {
        return Math.sqrt((this.dx - x) * (this.dx - x) + (this.dy - y) * (this.dy - y));
    }

    public Position toPosition() {
        return new Position((int)this.dx, (int)this.dy);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector v = (Vector)obj;
        return v.dx == this.dx && v.dy == this.dy;
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.dx) * 31L + Double.doubleToLongBits(this.dy));
    }

    public Vector add(Vector v) {
        return new Vector(this.dx + v.dx, this.dy + v.dy);
    }

    public Vector addInPlace(Vector v) {
        this.dx += v.dx;
        this.dy += v.dy;
        return this;
    }

    public Vector sub(Vector v) {
        return new Vector(this.dx - v.dx, this.dy - v.dy);
    }

    public double dot(Vector v) {
        return this.dx * v.dx + this.dy * v.dy;
    }

    public double crossProduct(Vector v) {
        return this.dx * v.dy - this.dy * v.dx;
    }

    public Position addTo(Position p) {
        return new Position(p.x() + (int)this.dx, p.y() + (int)this.dy);
    }

    public Vector normalize() {
        return this.normalize(1.0);
    }

    public Vector normalize(double alpha) {
        double sum = this.dx * this.dx + this.dy * this.dy;
        double scale = sum <= 0.0 ? 0.0 : alpha / Math.sqrt(sum);
        return this.scalePositive(scale);
    }

    public static Vector diff(Position source, Position target) {
        return new Vector(target.x() - source.x(), target.y() - source.y());
    }

    public Vector scalePositive(double scale) {
        if (scale > 0.0) {
            return new Vector(this.dx * scale, this.dy * scale);
        }
        return ZERO;
    }

    public Vector scale(double scale) {
        return new Vector(this.dx * scale, this.dy * scale);
    }

    public Vector scaleInPlace(double scale) {
        this.dx *= scale;
        this.dy *= scale;
        return this;
    }

    public double getAngle() {
        return Math.atan2(this.dy, this.dx);
    }

    public String toString() {
        return "x: " + this.dx + " y: " + this.dy;
    }

    public static Vector ClosestPointOnLineSegment(Vector a, Vector b, Vector test) {
        Vector c = test.sub(a);
        Vector v = b.sub(a).normalize();
        double d = b.sub(a).length();
        double t = v.dot(c);
        if (t < 0.0) {
            return a;
        }
        if (t > d) {
            return b;
        }
        v = v.scale(t);
        v = a.add(v);
        return v;
    }

    public static double PointToLineSegmentDistance(Vector a, Vector b, Vector test) {
        return Vector.ClosestPointOnLineSegment(a, b, test).distanceTo(test);
    }

    public double norm() {
        return Math.sqrt(this.dx * this.dx + this.dy * this.dy);
    }

    public static double closestDistance(Vector vector, Set<Vector> potentialTargets) {
        double ret = Double.MAX_VALUE;
        for (Vector v : potentialTargets) {
            ret = Math.min(ret, v.distanceTo(vector));
        }
        return ret;
    }
}

